/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.core.fileservice;

import com.google.common.collect.Lists;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.set.basis.extensions.PathExtensions;
import org.eclipse.set.basis.files.SetFormat;
import org.eclipse.set.basis.files.ToolboxFile;
import org.eclipse.set.basis.files.ToolboxFileAC;
import org.eclipse.set.basis.files.ToolboxFileRole;
import org.eclipse.set.core.fileservice.ToolboxIDResolver;
import org.eclipse.set.core.services.files.ToolboxFileFormatService;
import org.eclipse.set.core.services.files.ToolboxFileService;
import org.eclipse.set.model.planpro.PlanPro.DocumentRoot;
import org.eclipse.set.model.planpro.PlanPro.PlanProFactory;
import org.eclipse.set.model.planpro.PlanPro.PlanPro_Schnittstelle;
import org.eclipse.set.ppmodel.extensions.DocumentRootExtensions;
import org.eclipse.set.ppmodel.extensions.PlanProSchnittstelleExtensions;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(immediate=true)
public class ToolboxFileServiceImpl
implements ToolboxFileService {
    private final List<ToolboxFileFormatService> formats = Lists.newLinkedList();

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addFormat(ToolboxFileFormatService format) {
        this.formats.add(format);
    }

    public ToolboxFile convertFormat(ToolboxFile toolboxFile, ToolboxFileRole role, Path tempDir, ToolboxFile.Format format) {
        if (toolboxFile.getFormat() == format) {
            return toolboxFile;
        }
        PlanPro_Schnittstelle oldschnittstelle = PlanProSchnittstelleExtensions.readFrom((Resource)toolboxFile.getPlanProResource());
        PlanPro_Schnittstelle newschnittstelle = (PlanPro_Schnittstelle)EcoreUtil.copy((EObject)oldschnittstelle);
        ToolboxFile newToolboxFile = toolboxFile;
        Path newPath = toolboxFile.getPath();
        if (format.isZippedPlanPro()) {
            newToolboxFile = this.convertToZipped(role);
            newPath = PathExtensions.replaceExtension((Path)newPath, (String)"planpro");
        } else if (format.isPlain()) {
            newToolboxFile = this.convertToPlain(role);
            newPath = PathExtensions.replaceExtension((Path)newPath, (String)"ppxml");
        }
        DocumentRoot documentRoot = PlanProFactory.eINSTANCE.createDocumentRoot();
        DocumentRootExtensions.fix((DocumentRoot)documentRoot);
        documentRoot.setPlanProSchnittstelle(newschnittstelle);
        newToolboxFile.getPlanProResource().getContents().add((Object)documentRoot);
        newToolboxFile.setPath(newPath);
        ToolboxIDResolver.resolveIDReferences(newschnittstelle);
        return newToolboxFile;
    }

    public ToolboxFile create(ToolboxFile.Format format, ToolboxFileRole role) {
        Optional<ToolboxFileFormatService> formatService = this.formats.stream().filter(f -> f.isSupported(format)).findFirst();
        ToolboxFile result = formatService.map(f -> f.create(format, role)).orElse(null);
        if (result == null) {
            throw new IllegalArgumentException("path \"" + format.toString() + "\" not supported.");
        }
        return result;
    }

    public ToolboxFile create(ToolboxFile toolboxFile) {
        Optional<ToolboxFileFormatService> formatService = this.formats.stream().filter(f -> f.isSupported(toolboxFile)).findFirst();
        ToolboxFile result = formatService.map(f -> f.create(toolboxFile)).orElse(null);
        if (result == null) {
            throw new IllegalArgumentException("toolbox file \"" + toolboxFile.getClass().getName() + "\" not supported.");
        }
        return result;
    }

    public List<String> extensionsForCategory(String category) {
        return this.formats.stream().flatMap(f -> f.extensionsForCategory(category).stream()).sorted((a, b) -> Integer.compare(b.getPriority(), a.getPriority())).map(e -> e.getExtension()).collect(Collectors.toList());
    }

    public ToolboxFile load(Path path, ToolboxFileRole role) {
        Optional<ToolboxFileFormatService> formatService = this.formats.stream().filter(f -> f.isSupported(path)).findFirst();
        ToolboxFile result = formatService.map(f -> f.load(path, role)).orElse(null);
        if (result == null) {
            throw new IllegalArgumentException("path \"" + path.toString() + "\" not supported.");
        }
        return result;
    }

    public ToolboxFileAC loadAC(Path path, ToolboxFileRole role) {
        return new ToolboxFileAC(this.load(path, role));
    }

    public void removeFormat(ToolboxFileFormatService format) {
        this.formats.remove(format);
    }

    private ToolboxFile convertToPlain(ToolboxFileRole role) {
        return this.create(SetFormat.createPlainPlanPro(), role);
    }

    private ToolboxFile convertToZipped(ToolboxFileRole role) {
        return this.create(SetFormat.createZippedPlanPro(), role);
    }
}

