/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.emfforms.basisattribute;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.databinding.Binding;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.internal.core.swt.renderer.EnumComboViewerSWTRenderer;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.editsupport.EMFFormsEditSupport;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.set.basis.exceptions.NoEnumTranslationFound;
import org.eclipse.set.core.services.Services;
import org.eclipse.set.core.services.enumtranslation.EnumTranslationService;
import org.eclipse.set.emfforms.basisattribute.BasisAttributeBinding;
import org.eclipse.set.emfforms.basisattribute.BasisAttributeRenderer;
import org.eclipse.set.emfforms.basisattribute.BasisAttributeSetting;
import org.eclipse.set.utils.emfforms.Renderers;
import org.eclipse.set.utils.emfforms.ToolboxRenderer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBasisAttributeEnumeratorRenderer<T>
extends EnumComboViewerSWTRenderer
implements BasisAttributeRenderer<T>,
ToolboxRenderer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractBasisAttributeEnumeratorRenderer.class);
    protected static final String EMPTY_VALUE = "<empty value>";
    protected static final String EMPTY_VALUE_LABEL = "";
    private final BasisAttributeBinding<T> binding;
    private ComboViewer comboViewer;
    private final Class<T> enumerationClass;
    private final EObject parent;
    private final EnumTranslationService translationService;
    protected final BasisAttributeSetting<T> basisAttributeSetting;
    final EMFFormsEditSupport emfFormsEditSupport;

    public AbstractBasisAttributeEnumeratorRenderer(Class<T> enumerationClass, VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider, EMFFormsEditSupport emfFormsEditSupport) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider, emfFormsEditSupport);
        this.enumerationClass = enumerationClass;
        this.emfFormsEditSupport = emfFormsEditSupport;
        this.basisAttributeSetting = new BasisAttributeSetting<T>(enumerationClass, vElement, viewContext);
        this.parent = this.basisAttributeSetting.getParent();
        this.binding = new BasisAttributeBinding(this);
        this.translationService = Services.getToolboxViewModelService().getTranslationService();
    }

    public void checkToolboxRenderer() {
        this.checkRenderer();
    }

    @Override
    public Control getControl() {
        return this.comboViewer.getControl();
    }

    @Override
    public EObject getParent() {
        return this.parent;
    }

    @Override
    public boolean isDisposed() {
        Renderers.isDisposed((ToolboxRenderer)this);
        return false;
    }

    @Override
    public void updateControl() {
        Optional<T> controlWert;
        Optional<T> modelWert = this.getModelWert();
        if (!modelWert.equals(controlWert = this.getControlWert())) {
            this.comboViewer.setSelection(this.toSelection(modelWert));
        }
    }

    @Override
    public void updateModel() {
        Optional<T> controlWert = this.getControlWert();
        if (this.isRemoveable(controlWert)) {
            this.basisAttributeSetting.removeBasisAttribute();
        } else {
            this.updateBasisAttributeWert(controlWert);
        }
    }

    private String enumeratorToString(Enumerator enumConstant) {
        try {
            return this.translationService.translate(enumConstant).getAlternative();
        }
        catch (NoEnumTranslationFound e) {
            LOGGER.error(e.getMessage());
            return enumConstant.getLiteral();
        }
    }

    private Optional<T> getControlWert() {
        ISelection selection = this.comboViewer.getSelection();
        if (selection.isEmpty()) {
            return Optional.empty();
        }
        if (!(selection instanceof StructuredSelection)) {
            return Optional.empty();
        }
        StructuredSelection structuredSelection = (StructuredSelection)selection;
        return this.objectToEnumerator(structuredSelection.getFirstElement());
    }

    private Optional<T> getModelWert() {
        return this.basisAttributeSetting.getWertValue();
    }

    private boolean isRemoveable(Optional<T> controlWert) {
        return !controlWert.isPresent() && !this.basisAttributeSetting.hasContents();
    }

    private Optional<T> objectToEnumerator(Object object) {
        if (this.enumerationClass.isAssignableFrom(object.getClass())) {
            return Optional.of(this.enumerationClass.cast(object));
        }
        return Optional.empty();
    }

    private ISelection toSelection(Optional<T> modelWert) {
        Object selectedObject = modelWert.map(e -> e).orElse(EMPTY_VALUE);
        return new StructuredSelection(selectedObject);
    }

    private void updateBasisAttributeWert(Optional<T> controlWert) {
        if (this.basisAttributeSetting.updateValue(controlWert.orElse(null))) {
            this.binding.unbind();
            this.binding.bind();
        }
    }

    protected Binding[] createBindings(Viewer viewer) throws DatabindingFailedException {
        this.comboViewer = (ComboViewer)viewer;
        this.binding.bind();
        return new Binding[0];
    }

    protected Viewer createJFaceViewer(Composite parentComposite) throws DatabindingFailedException {
        ComboViewer combo = new ComboViewer(parentComposite);
        combo.setContentProvider((IContentProvider)new ArrayContentProvider());
        combo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return AbstractBasisAttributeEnumeratorRenderer.this.getLabel(element);
            }
        });
        combo.setInput(this.getInputValues());
        combo.setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_control_enum");
        return combo;
    }

    protected void dispose() {
    }

    protected List<Object> getInputValues() {
        T[] enumConstants;
        ArrayList<Object> inputValues = new ArrayList<Object>();
        EStructuralFeature wertFeature = this.basisAttributeSetting.getWertFeature();
        EClassifier eType = wertFeature.getEType();
        String objectName = eType.getName();
        String enumName = objectName.replace("Object", EMPTY_VALUE_LABEL);
        EEnum eEnum = (EEnum)eType.getEPackage().getEClassifier(enumName);
        Class instanceClass = eEnum.getInstanceClass();
        T[] TArray = enumConstants = instanceClass.getEnumConstants();
        int n = enumConstants.length;
        int n2 = 0;
        while (n2 < n) {
            Object enumConstant = TArray[n2];
            if (!(enumConstant instanceof Enumerator)) {
                throw new IllegalArgumentException(enumConstant.toString());
            }
            inputValues.add(enumConstant);
            ++n2;
        }
        return inputValues;
    }

    protected String getLabel(Object element) {
        if (element == EMPTY_VALUE) {
            return EMPTY_VALUE_LABEL;
        }
        return this.enumeratorToString((Enumerator)element);
    }
}

