/**
 * Copyright (c) 2023 DB Netz AG and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 * 
 */
package org.eclipse.set.model.model11001.Basisobjekte;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>ENUMLST Objekt Art</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see org.eclipse.set.model.model11001.Basisobjekte.BasisobjektePackage#getENUMLSTObjektArt()
 * @model extendedMetaData="name='ENUMLST_Objekt_Art'"
 * @generated
 */
public enum ENUMLSTObjektArt implements Enumerator {
	/**
	 * The '<em><b>ENUMLST Objekt Art Anhang</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ANHANG_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_ANHANG(0, "ENUMLST_Objekt_Art_Anhang", "Anhang"),

	/**
	 * The '<em><b>ENUMLST Objekt Art ATO Segment Profile</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ATO_SEGMENT_PROFILE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_ATO_SEGMENT_PROFILE(1, "ENUMLST_Objekt_Art_ATO_Segment_Profile", "ATO_Segment_Profile"),

	/**
	 * The '<em><b>ENUMLST Objekt Art ATO Timing Point</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ATO_TIMING_POINT_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_ATO_TIMING_POINT(2, "ENUMLST_Objekt_Art_ATO_Timing_Point", "ATO_Timing_Point"),

	/**
	 * The '<em><b>ENUMLST Objekt Art ATO TS Instanz</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ATO_TS_INSTANZ_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_ATO_TS_INSTANZ(3, "ENUMLST_Objekt_Art_ATO_TS_Instanz", "ATO_TS_Instanz"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Aussenelementansteuerung</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_AUSSENELEMENTANSTEUERUNG_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_AUSSENELEMENTANSTEUERUNG(4, "ENUMLST_Objekt_Art_Aussenelementansteuerung", "Aussenelementansteuerung"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Bahnsteig Anlage</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BAHNSTEIG_ANLAGE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_BAHNSTEIG_ANLAGE(5, "ENUMLST_Objekt_Art_Bahnsteig_Anlage", "Bahnsteig_Anlage"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Bahnsteig Dach</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BAHNSTEIG_DACH_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_BAHNSTEIG_DACH(6, "ENUMLST_Objekt_Art_Bahnsteig_Dach", "Bahnsteig_Dach"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Bahnsteig Kante</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BAHNSTEIG_KANTE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_BAHNSTEIG_KANTE(7, "ENUMLST_Objekt_Art_Bahnsteig_Kante", "Bahnsteig_Kante"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Bahnsteig Zugang</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BAHNSTEIG_ZUGANG_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_BAHNSTEIG_ZUGANG(8, "ENUMLST_Objekt_Art_Bahnsteig_Zugang", "Bahnsteig_Zugang"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Balise</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BALISE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_BALISE(9, "ENUMLST_Objekt_Art_Balise", "Balise"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Bearbeitungsvermerk</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BEARBEITUNGSVERMERK_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_BEARBEITUNGSVERMERK(10, "ENUMLST_Objekt_Art_Bearbeitungsvermerk", "Bearbeitungsvermerk"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Bedien Anrueckabschnitt</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BEDIEN_ANRUECKABSCHNITT_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_BEDIEN_ANRUECKABSCHNITT(11, "ENUMLST_Objekt_Art_Bedien_Anrueckabschnitt", "Bedien_Anrueckabschnitt"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Bedien Anzeige Element</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BEDIEN_ANZEIGE_ELEMENT_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_BEDIEN_ANZEIGE_ELEMENT(12, "ENUMLST_Objekt_Art_Bedien_Anzeige_Element", "Bedien_Anzeige_Element"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Bedien Bezirk</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BEDIEN_BEZIRK_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_BEDIEN_BEZIRK(13, "ENUMLST_Objekt_Art_Bedien_Bezirk", "Bedien_Bezirk"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Bedien Einrichtung Oertlich</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BEDIEN_EINRICHTUNG_OERTLICH_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_BEDIEN_EINRICHTUNG_OERTLICH(14, "ENUMLST_Objekt_Art_Bedien_Einrichtung_Oertlich", "Bedien_Einrichtung_Oertlich"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Bedien GBT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BEDIEN_GBT_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_BEDIEN_GBT(15, "ENUMLST_Objekt_Art_Bedien_GBT", "Bedien_GBT"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Bedien Oberflaeche</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BEDIEN_OBERFLAECHE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_BEDIEN_OBERFLAECHE(16, "ENUMLST_Objekt_Art_Bedien_Oberflaeche", "Bedien_Oberflaeche"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Bedien Oberflaeche Bild</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BEDIEN_OBERFLAECHE_BILD_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_BEDIEN_OBERFLAECHE_BILD(17, "ENUMLST_Objekt_Art_Bedien_Oberflaeche_Bild", "Bedien_Oberflaeche_Bild"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Bedien Oertlichkeit</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BEDIEN_OERTLICHKEIT_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_BEDIEN_OERTLICHKEIT(18, "ENUMLST_Objekt_Art_Bedien_Oertlichkeit", "Bedien_Oertlichkeit"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Bedien Platz</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BEDIEN_PLATZ_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_BEDIEN_PLATZ(19, "ENUMLST_Objekt_Art_Bedien_Platz", "Bedien_Platz"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Bedien Standort</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BEDIEN_STANDORT_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_BEDIEN_STANDORT(20, "ENUMLST_Objekt_Art_Bedien_Standort", "Bedien_Standort"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Bedien Zentrale</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BEDIEN_ZENTRALE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_BEDIEN_ZENTRALE(21, "ENUMLST_Objekt_Art_Bedien_Zentrale", "Bedien_Zentrale"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Binaerdaten</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BINAERDATEN_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_BINAERDATEN(22, "ENUMLST_Objekt_Art_Binaerdaten", "Binaerdaten"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Block Anlage</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BLOCK_ANLAGE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_BLOCK_ANLAGE(23, "ENUMLST_Objekt_Art_Block_Anlage", "Block_Anlage"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Block Element</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BLOCK_ELEMENT_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_BLOCK_ELEMENT(24, "ENUMLST_Objekt_Art_Block_Element", "Block_Element"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Block Strecke</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BLOCK_STRECKE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_BLOCK_STRECKE(25, "ENUMLST_Objekt_Art_Block_Strecke", "Block_Strecke"),

	/**
	 * The '<em><b>ENUMLST Objekt Art BUE Anlage</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BUE_ANLAGE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_BUE_ANLAGE(26, "ENUMLST_Objekt_Art_BUE_Anlage", "BUE_Anlage"),

	/**
	 * The '<em><b>ENUMLST Objekt Art BUE Anlage Strasse</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BUE_ANLAGE_STRASSE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_BUE_ANLAGE_STRASSE(27, "ENUMLST_Objekt_Art_BUE_Anlage_Strasse", "BUE_Anlage_Strasse"),

	/**
	 * The '<em><b>ENUMLST Objekt Art BUE Anlage V</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BUE_ANLAGE_V_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_BUE_ANLAGE_V(28, "ENUMLST_Objekt_Art_BUE_Anlage_V", "BUE_Anlage_V"),

	/**
	 * The '<em><b>ENUMLST Objekt Art BUE Ausschaltung</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BUE_AUSSCHALTUNG_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_BUE_AUSSCHALTUNG(29, "ENUMLST_Objekt_Art_BUE_Ausschaltung", "BUE_Ausschaltung"),

	/**
	 * The '<em><b>ENUMLST Objekt Art BUE Bedien Anzeige Element</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BUE_BEDIEN_ANZEIGE_ELEMENT_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_BUE_BEDIEN_ANZEIGE_ELEMENT(30, "ENUMLST_Objekt_Art_BUE_Bedien_Anzeige_Element", "BUE_Bedien_Anzeige_Element"),

	/**
	 * The '<em><b>ENUMLST Objekt Art BUE Deckendes Signal Zuordnung</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BUE_DECKENDES_SIGNAL_ZUORDNUNG_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_BUE_DECKENDES_SIGNAL_ZUORDNUNG(31, "ENUMLST_Objekt_Art_BUE_Deckendes_Signal_Zuordnung", "BUE_Deckendes_Signal_Zuordnung"),

	/**
	 * The '<em><b>ENUMLST Objekt Art BUE Einschaltung</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BUE_EINSCHALTUNG_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_BUE_EINSCHALTUNG(32, "ENUMLST_Objekt_Art_BUE_Einschaltung", "BUE_Einschaltung"),

	/**
	 * The '<em><b>ENUMLST Objekt Art BUE Einschaltung Zuordnung</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BUE_EINSCHALTUNG_ZUORDNUNG_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_BUE_EINSCHALTUNG_ZUORDNUNG(33, "ENUMLST_Objekt_Art_BUE_Einschaltung_Zuordnung", "BUE_Einschaltung_Zuordnung"),

	/**
	 * The '<em><b>ENUMLST Objekt Art BUE Gefahrraum Eckpunkt</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BUE_GEFAHRRAUM_ECKPUNKT_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_BUE_GEFAHRRAUM_ECKPUNKT(34, "ENUMLST_Objekt_Art_BUE_Gefahrraum_Eckpunkt", "BUE_Gefahrraum_Eckpunkt"),

	/**
	 * The '<em><b>ENUMLST Objekt Art BUE Gleisbezogener Gefahrraum</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BUE_GLEISBEZOGENER_GEFAHRRAUM_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_BUE_GLEISBEZOGENER_GEFAHRRAUM(35, "ENUMLST_Objekt_Art_BUE_Gleisbezogener_Gefahrraum", "BUE_Gleisbezogener_Gefahrraum"),

	/**
	 * The '<em><b>ENUMLST Objekt Art BUE Kante</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BUE_KANTE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_BUE_KANTE(36, "ENUMLST_Objekt_Art_BUE_Kante", "BUE_Kante"),

	/**
	 * The '<em><b>ENUMLST Objekt Art BUE Kreuzungsplan</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BUE_KREUZUNGSPLAN_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_BUE_KREUZUNGSPLAN(37, "ENUMLST_Objekt_Art_BUE_Kreuzungsplan", "BUE_Kreuzungsplan"),

	/**
	 * The '<em><b>ENUMLST Objekt Art BUE Schnittstelle</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BUE_SCHNITTSTELLE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_BUE_SCHNITTSTELLE(38, "ENUMLST_Objekt_Art_BUE_Schnittstelle", "BUE_Schnittstelle"),

	/**
	 * The '<em><b>ENUMLST Objekt Art BUE Spezifisches Signal</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BUE_SPEZIFISCHES_SIGNAL_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_BUE_SPEZIFISCHES_SIGNAL(39, "ENUMLST_Objekt_Art_BUE_Spezifisches_Signal", "BUE_Spezifisches_Signal"),

	/**
	 * The '<em><b>ENUMLST Objekt Art BUE WS Fstr Zuordnung</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BUE_WS_FSTR_ZUORDNUNG_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_BUE_WS_FSTR_ZUORDNUNG(40, "ENUMLST_Objekt_Art_BUE_WS_Fstr_Zuordnung", "BUE_WS_Fstr_Zuordnung"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Datenpunkt</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_DATENPUNKT_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_DATENPUNKT(41, "ENUMLST_Objekt_Art_Datenpunkt", "Datenpunkt"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Datenpunkt Link</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_DATENPUNKT_LINK_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_DATENPUNKT_LINK(42, "ENUMLST_Objekt_Art_Datenpunkt_Link", "Datenpunkt_Link"),

	/**
	 * The '<em><b>ENUMLST Objekt Art ESTW Zentraleinheit</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ESTW_ZENTRALEINHEIT_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_ESTW_ZENTRALEINHEIT(43, "ENUMLST_Objekt_Art_ESTW_Zentraleinheit", "ESTW_Zentraleinheit"),

	/**
	 * The '<em><b>ENUMLST Objekt Art ETCS Kante</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ETCS_KANTE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_ETCS_KANTE(44, "ENUMLST_Objekt_Art_ETCS_Kante", "ETCS_Kante"),

	/**
	 * The '<em><b>ENUMLST Objekt Art ETCS Knoten</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ETCS_KNOTEN_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_ETCS_KNOTEN(45, "ENUMLST_Objekt_Art_ETCS_Knoten", "ETCS_Knoten"),

	/**
	 * The '<em><b>ENUMLST Objekt Art ETCS Richtungsanzeige</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ETCS_RICHTUNGSANZEIGE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_ETCS_RICHTUNGSANZEIGE(46, "ENUMLST_Objekt_Art_ETCS_Richtungsanzeige", "ETCS_Richtungsanzeige"),

	/**
	 * The '<em><b>ENUMLST Objekt Art ETCS Signal</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ETCS_SIGNAL_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_ETCS_SIGNAL(47, "ENUMLST_Objekt_Art_ETCS_Signal", "ETCS_Signal"),

	/**
	 * The '<em><b>ENUMLST Objekt Art ETCS WKr</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ETCS_WKR_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_ETCS_WKR(48, "ENUMLST_Objekt_Art_ETCS_W_Kr", "ETCS_W_Kr"),

	/**
	 * The '<em><b>ENUMLST Objekt Art EV Modul</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_EV_MODUL_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_EV_MODUL(49, "ENUMLST_Objekt_Art_EV_Modul", "EV_Modul"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Fachtelegramm</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_FACHTELEGRAMM_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_FACHTELEGRAMM(50, "ENUMLST_Objekt_Art_Fachtelegramm", "Fachtelegramm"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Fla Freimelde Zuordnung</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_FLA_FREIMELDE_ZUORDNUNG_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_FLA_FREIMELDE_ZUORDNUNG(51, "ENUMLST_Objekt_Art_Fla_Freimelde_Zuordnung", "Fla_Freimelde_Zuordnung"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Fla Schutz</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_FLA_SCHUTZ_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_FLA_SCHUTZ(52, "ENUMLST_Objekt_Art_Fla_Schutz", "Fla_Schutz"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Fla Zwieschutz</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_FLA_ZWIESCHUTZ_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_FLA_ZWIESCHUTZ(53, "ENUMLST_Objekt_Art_Fla_Zwieschutz", "Fla_Zwieschutz"),

	/**
	 * The '<em><b>ENUMLST Objekt Art FMA Anlage</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_FMA_ANLAGE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_FMA_ANLAGE(54, "ENUMLST_Objekt_Art_FMA_Anlage", "FMA_Anlage"),

	/**
	 * The '<em><b>ENUMLST Objekt Art FMA Element</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_FMA_ELEMENT_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_FMA_ELEMENT(55, "ENUMLST_Objekt_Art_FMA_Element", "FMA_Element"),

	/**
	 * The '<em><b>ENUMLST Objekt Art FMA Komponente</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_FMA_KOMPONENTE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_FMA_KOMPONENTE(56, "ENUMLST_Objekt_Art_FMA_Komponente", "FMA_Komponente"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Fstr Abhaengigkeit</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_FSTR_ABHAENGIGKEIT_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_FSTR_ABHAENGIGKEIT(57, "ENUMLST_Objekt_Art_Fstr_Abhaengigkeit", "Fstr_Abhaengigkeit"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Fstr Aneinander</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_FSTR_ANEINANDER_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_FSTR_ANEINANDER(58, "ENUMLST_Objekt_Art_Fstr_Aneinander", "Fstr_Aneinander"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Fstr Aneinander Zuordnung</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_FSTR_ANEINANDER_ZUORDNUNG_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_FSTR_ANEINANDER_ZUORDNUNG(59, "ENUMLST_Objekt_Art_Fstr_Aneinander_Zuordnung", "Fstr_Aneinander_Zuordnung"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Fstr DWeg</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_FSTR_DWEG_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_FSTR_DWEG(60, "ENUMLST_Objekt_Art_Fstr_DWeg", "Fstr_DWeg"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Fstr DWeg WKr</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_FSTR_DWEG_WKR_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_FSTR_DWEG_WKR(61, "ENUMLST_Objekt_Art_Fstr_DWeg_W_Kr", "Fstr_DWeg_W_Kr"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Fstr Fahrweg</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_FSTR_FAHRWEG_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_FSTR_FAHRWEG(62, "ENUMLST_Objekt_Art_Fstr_Fahrweg", "Fstr_Fahrweg"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Fstr Nichthaltfall</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_FSTR_NICHTHALTFALL_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_FSTR_NICHTHALTFALL(63, "ENUMLST_Objekt_Art_Fstr_Nichthaltfall", "Fstr_Nichthaltfall"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Fstr Rangier Fla Zuordnung</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_FSTR_RANGIER_FLA_ZUORDNUNG_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_FSTR_RANGIER_FLA_ZUORDNUNG(64, "ENUMLST_Objekt_Art_Fstr_Rangier_Fla_Zuordnung", "Fstr_Rangier_Fla_Zuordnung"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Fstr Signalisierung</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_FSTR_SIGNALISIERUNG_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_FSTR_SIGNALISIERUNG(65, "ENUMLST_Objekt_Art_Fstr_Signalisierung", "Fstr_Signalisierung"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Fstr Umfahrpunkt</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_FSTR_UMFAHRPUNKT_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_FSTR_UMFAHRPUNKT(66, "ENUMLST_Objekt_Art_Fstr_Umfahrpunkt", "Fstr_Umfahrpunkt"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Fstr Zug Rangier</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_FSTR_ZUG_RANGIER_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_FSTR_ZUG_RANGIER(67, "ENUMLST_Objekt_Art_Fstr_Zug_Rangier", "Fstr_Zug_Rangier"),

	/**
	 * The '<em><b>ENUMLST Objekt Art FT Anschaltbedingung</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_FT_ANSCHALTBEDINGUNG_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_FT_ANSCHALTBEDINGUNG(68, "ENUMLST_Objekt_Art_FT_Anschaltbedingung", "FT_Anschaltbedingung"),

	/**
	 * The '<em><b>ENUMLST Objekt Art FT Fahrweg Teil</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_FT_FAHRWEG_TEIL_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_FT_FAHRWEG_TEIL(69, "ENUMLST_Objekt_Art_FT_Fahrweg_Teil", "FT_Fahrweg_Teil"),

	/**
	 * The '<em><b>ENUMLST Objekt Art GEO Kante</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_GEO_KANTE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_GEO_KANTE(70, "ENUMLST_Objekt_Art_GEO_Kante", "GEO_Kante"),

	/**
	 * The '<em><b>ENUMLST Objekt Art GEO Knoten</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_GEO_KNOTEN_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_GEO_KNOTEN(71, "ENUMLST_Objekt_Art_GEO_Knoten", "GEO_Knoten"),

	/**
	 * The '<em><b>ENUMLST Objekt Art GEO Punkt</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_GEO_PUNKT_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_GEO_PUNKT(72, "ENUMLST_Objekt_Art_GEO_Punkt", "GEO_Punkt"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Geschwindigkeitsprofil</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_GESCHWINDIGKEITSPROFIL_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_GESCHWINDIGKEITSPROFIL(73, "ENUMLST_Objekt_Art_Geschwindigkeitsprofil", "Geschwindigkeitsprofil"),

	/**
	 * The '<em><b>ENUMLST Objekt Art GFR Anlage</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_GFR_ANLAGE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_GFR_ANLAGE(74, "ENUMLST_Objekt_Art_GFR_Anlage", "GFR_Anlage"),

	/**
	 * The '<em><b>ENUMLST Objekt Art GFR Element</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_GFR_ELEMENT_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_GFR_ELEMENT(75, "ENUMLST_Objekt_Art_GFR_Element", "GFR_Element"),

	/**
	 * The '<em><b>ENUMLST Objekt Art GFR Tripelspiegel</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_GFR_TRIPELSPIEGEL_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_GFR_TRIPELSPIEGEL(76, "ENUMLST_Objekt_Art_GFR_Tripelspiegel", "GFR_Tripelspiegel"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Gleis Abschluss</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_GLEIS_ABSCHLUSS_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_GLEIS_ABSCHLUSS(77, "ENUMLST_Objekt_Art_Gleis_Abschluss", "Gleis_Abschluss"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Gleis Abschnitt</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_GLEIS_ABSCHNITT_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_GLEIS_ABSCHNITT(78, "ENUMLST_Objekt_Art_Gleis_Abschnitt", "Gleis_Abschnitt"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Gleis Art</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_GLEIS_ART_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_GLEIS_ART(79, "ENUMLST_Objekt_Art_Gleis_Art", "Gleis_Art"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Gleis Baubereich</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_GLEIS_BAUBEREICH_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_GLEIS_BAUBEREICH(80, "ENUMLST_Objekt_Art_Gleis_Baubereich", "Gleis_Baubereich"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Gleis Bezeichnung</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_GLEIS_BEZEICHNUNG_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_GLEIS_BEZEICHNUNG(81, "ENUMLST_Objekt_Art_Gleis_Bezeichnung", "Gleis_Bezeichnung"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Gleis Fahrbahn</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_GLEIS_FAHRBAHN_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_GLEIS_FAHRBAHN(82, "ENUMLST_Objekt_Art_Gleis_Fahrbahn", "Gleis_Fahrbahn"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Gleis Lichtraum</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_GLEIS_LICHTRAUM_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_GLEIS_LICHTRAUM(83, "ENUMLST_Objekt_Art_Gleis_Lichtraum", "Gleis_Lichtraum"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Gleis Schaltgruppe</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_GLEIS_SCHALTGRUPPE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_GLEIS_SCHALTGRUPPE(84, "ENUMLST_Objekt_Art_Gleis_Schaltgruppe", "Gleis_Schaltgruppe"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Hoehenlinie</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_HOEHENLINIE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_HOEHENLINIE(85, "ENUMLST_Objekt_Art_Hoehenlinie", "Hoehenlinie"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Hoehenpunkt</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_HOEHENPUNKT_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_HOEHENPUNKT(86, "ENUMLST_Objekt_Art_Hoehenpunkt", "Hoehenpunkt"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Kabel</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_KABEL_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_KABEL(87, "ENUMLST_Objekt_Art_Kabel", "Kabel"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Kabel Verteilpunkt</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_KABEL_VERTEILPUNKT_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_KABEL_VERTEILPUNKT(88, "ENUMLST_Objekt_Art_Kabel_Verteilpunkt", "Kabel_Verteilpunkt"),

	/**
	 * The '<em><b>ENUMLST Objekt Art LEU Anlage</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_LEU_ANLAGE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_LEU_ANLAGE(89, "ENUMLST_Objekt_Art_LEU_Anlage", "LEU_Anlage"),

	/**
	 * The '<em><b>ENUMLST Objekt Art LEU Modul</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_LEU_MODUL_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_LEU_MODUL(90, "ENUMLST_Objekt_Art_LEU_Modul", "LEU_Modul"),

	/**
	 * The '<em><b>ENUMLST Objekt Art LEU Schaltkasten</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_LEU_SCHALTKASTEN_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_LEU_SCHALTKASTEN(91, "ENUMLST_Objekt_Art_LEU_Schaltkasten", "LEU_Schaltkasten"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Lieferobjekt</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_LIEFEROBJEKT_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_LIEFEROBJEKT(92, "ENUMLST_Objekt_Art_Lieferobjekt", "Lieferobjekt"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Luft Telegramm</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_LUFT_TELEGRAMM_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_LUFT_TELEGRAMM(93, "ENUMLST_Objekt_Art_Luft_Telegramm", "Luft_Telegramm"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Markanter Punkt</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_MARKANTER_PUNKT_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_MARKANTER_PUNKT(94, "ENUMLST_Objekt_Art_Markanter_Punkt", "Markanter_Punkt"),

	/**
	 * The '<em><b>ENUMLST Objekt Art NB</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_NB_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_NB(95, "ENUMLST_Objekt_Art_NB", "NB"),

	/**
	 * The '<em><b>ENUMLST Objekt Art NB Bedien Anzeige Element</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_NB_BEDIEN_ANZEIGE_ELEMENT_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_NB_BEDIEN_ANZEIGE_ELEMENT(96, "ENUMLST_Objekt_Art_NB_Bedien_Anzeige_Element", "NB_Bedien_Anzeige_Element"),

	/**
	 * The '<em><b>ENUMLST Objekt Art NB Zone</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_NB_ZONE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_NB_ZONE(97, "ENUMLST_Objekt_Art_NB_Zone", "NB_Zone"),

	/**
	 * The '<em><b>ENUMLST Objekt Art NB Zone Element</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_NB_ZONE_ELEMENT_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_NB_ZONE_ELEMENT(98, "ENUMLST_Objekt_Art_NB_Zone_Element", "NB_Zone_Element"),

	/**
	 * The '<em><b>ENUMLST Objekt Art NB Zone Grenze</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_NB_ZONE_GRENZE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_NB_ZONE_GRENZE(99, "ENUMLST_Objekt_Art_NB_Zone_Grenze", "NB_Zone_Grenze"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Oertlichkeit</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_OERTLICHKEIT_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_OERTLICHKEIT(100, "ENUMLST_Objekt_Art_Oertlichkeit", "Oertlichkeit"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Prog Datei Gruppe</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_PROG_DATEI_GRUPPE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_PROG_DATEI_GRUPPE(101, "ENUMLST_Objekt_Art_Prog_Datei_Gruppe", "Prog_Datei_Gruppe"),

	/**
	 * The '<em><b>ENUMLST Objekt Art PZB Element</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_PZB_ELEMENT_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_PZB_ELEMENT(102, "ENUMLST_Objekt_Art_PZB_Element", "PZB_Element"),

	/**
	 * The '<em><b>ENUMLST Objekt Art PZB Element Zuordnung</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_PZB_ELEMENT_ZUORDNUNG_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_PZB_ELEMENT_ZUORDNUNG(103, "ENUMLST_Objekt_Art_PZB_Element_Zuordnung", "PZB_Element_Zuordnung"),

	/**
	 * The '<em><b>ENUMLST Objekt Art PZB Zuordnung Signal</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_PZB_ZUORDNUNG_SIGNAL_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_PZB_ZUORDNUNG_SIGNAL(104, "ENUMLST_Objekt_Art_PZB_Zuordnung_Signal", "PZB_Zuordnung_Signal"),

	/**
	 * The '<em><b>ENUMLST Objekt Art RBC</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_RBC_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_RBC(105, "ENUMLST_Objekt_Art_RBC", "RBC"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Regelzeichnung</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_REGELZEICHNUNG_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_REGELZEICHNUNG(106, "ENUMLST_Objekt_Art_Regelzeichnung", "Regelzeichnung"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Regelzeichnung Parameter</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_REGELZEICHNUNG_PARAMETER_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_REGELZEICHNUNG_PARAMETER(107, "ENUMLST_Objekt_Art_Regelzeichnung_Parameter", "Regelzeichnung_Parameter"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Schaltmittel Fstr Zuordnung</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_SCHALTMITTEL_FSTR_ZUORDNUNG_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_SCHALTMITTEL_FSTR_ZUORDNUNG(108, "ENUMLST_Objekt_Art_Schaltmittel_Fstr_Zuordnung", "Schaltmittel_Fstr_Zuordnung"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Schaltmittel Zuordnung</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_SCHALTMITTEL_ZUORDNUNG_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_SCHALTMITTEL_ZUORDNUNG(109, "ENUMLST_Objekt_Art_Schaltmittel_Zuordnung", "Schaltmittel_Zuordnung"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Schloss</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_SCHLOSS_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_SCHLOSS(110, "ENUMLST_Objekt_Art_Schloss", "Schloss"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Schlosskombination</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_SCHLOSSKOMBINATION_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_SCHLOSSKOMBINATION(111, "ENUMLST_Objekt_Art_Schlosskombination", "Schlosskombination"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Schluessel</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_SCHLUESSEL_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_SCHLUESSEL(112, "ENUMLST_Objekt_Art_Schluessel", "Schluessel"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Schluesselsperre</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_SCHLUESSELSPERRE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_SCHLUESSELSPERRE(113, "ENUMLST_Objekt_Art_Schluesselsperre", "Schluesselsperre"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Schrankenantrieb</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_SCHRANKENANTRIEB_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_SCHRANKENANTRIEB(114, "ENUMLST_Objekt_Art_Schrankenantrieb", "Schrankenantrieb"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Signal</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_SIGNAL_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_SIGNAL(115, "ENUMLST_Objekt_Art_Signal", "Signal"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Signal Befestigung</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_SIGNAL_BEFESTIGUNG_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_SIGNAL_BEFESTIGUNG(116, "ENUMLST_Objekt_Art_Signal_Befestigung", "Signal_Befestigung"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Signal Fank Zuordnung</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_SIGNAL_FANK_ZUORDNUNG_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_SIGNAL_FANK_ZUORDNUNG(117, "ENUMLST_Objekt_Art_Signal_Fank_Zuordnung", "Signal_Fank_Zuordnung"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Signal Rahmen</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_SIGNAL_RAHMEN_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_SIGNAL_RAHMEN(118, "ENUMLST_Objekt_Art_Signal_Rahmen", "Signal_Rahmen"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Signal Signalbegriff</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_SIGNAL_SIGNALBEGRIFF_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_SIGNAL_SIGNALBEGRIFF(119, "ENUMLST_Objekt_Art_Signal_Signalbegriff", "Signal_Signalbegriff"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Sonstiger Punkt</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_SONSTIGER_PUNKT_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_SONSTIGER_PUNKT(120, "ENUMLST_Objekt_Art_Sonstiger_Punkt", "Sonstiger_Punkt"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Stell Bereich</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_STELL_BEREICH_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_STELL_BEREICH(121, "ENUMLST_Objekt_Art_Stell_Bereich", "Stell_Bereich"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Stellelement</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_STELLELEMENT_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_STELLELEMENT(122, "ENUMLST_Objekt_Art_Stellelement", "Stellelement"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Strecke</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_STRECKE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_STRECKE(123, "ENUMLST_Objekt_Art_Strecke", "Strecke"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Strecke Bremsweg</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_STRECKE_BREMSWEG_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_STRECKE_BREMSWEG(124, "ENUMLST_Objekt_Art_Strecke_Bremsweg", "Strecke_Bremsweg"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Strecke Punkt</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_STRECKE_PUNKT_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_STRECKE_PUNKT(125, "ENUMLST_Objekt_Art_Strecke_Punkt", "Strecke_Punkt"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Technik Standort</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_TECHNIK_STANDORT_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_TECHNIK_STANDORT(126, "ENUMLST_Objekt_Art_Technik_Standort", "Technik_Standort"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Technischer Bereich</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_TECHNISCHER_BEREICH_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_TECHNISCHER_BEREICH(127, "ENUMLST_Objekt_Art_Technischer_Bereich", "Technischer_Bereich"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Technischer Punkt</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_TECHNISCHER_PUNKT_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_TECHNISCHER_PUNKT(128, "ENUMLST_Objekt_Art_Technischer_Punkt", "Technischer_Punkt"),

	/**
	 * The '<em><b>ENUMLST Objekt Art TOP Kante</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_TOP_KANTE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_TOP_KANTE(129, "ENUMLST_Objekt_Art_TOP_Kante", "TOP_Kante"),

	/**
	 * The '<em><b>ENUMLST Objekt Art TOP Knoten</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_TOP_KNOTEN_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_TOP_KNOTEN(130, "ENUMLST_Objekt_Art_TOP_Knoten", "TOP_Knoten"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Trasse Kante</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_TRASSE_KANTE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_TRASSE_KANTE(131, "ENUMLST_Objekt_Art_Trasse_Kante", "Trasse_Kante"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Trasse Knoten</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_TRASSE_KNOTEN_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_TRASSE_KNOTEN(132, "ENUMLST_Objekt_Art_Trasse_Knoten", "Trasse_Knoten"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Ueberhoehung</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_UEBERHOEHUNG_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_UEBERHOEHUNG(133, "ENUMLST_Objekt_Art_Ueberhoehung", "Ueberhoehung"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Ueberhoehungslinie</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_UEBERHOEHUNGSLINIE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_UEBERHOEHUNGSLINIE(134, "ENUMLST_Objekt_Art_Ueberhoehungslinie", "Ueberhoehungslinie"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Uebertragungsweg</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_UEBERTRAGUNGSWEG_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_UEBERTRAGUNGSWEG(135, "ENUMLST_Objekt_Art_Uebertragungsweg", "Uebertragungsweg"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Unterbringung</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_UNTERBRINGUNG_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_UNTERBRINGUNG(136, "ENUMLST_Objekt_Art_Unterbringung", "Unterbringung"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Verkehrszeichen</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_VERKEHRSZEICHEN_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_VERKEHRSZEICHEN(137, "ENUMLST_Objekt_Art_Verkehrszeichen", "Verkehrszeichen"),

	/**
	 * The '<em><b>ENUMLST Objekt Art WKr Anlage</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_WKR_ANLAGE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_WKR_ANLAGE(138, "ENUMLST_Objekt_Art_W_Kr_Anlage", "W_Kr_Anlage"),

	/**
	 * The '<em><b>ENUMLST Objekt Art WKr Gsp Element</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_WKR_GSP_ELEMENT_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_WKR_GSP_ELEMENT(139, "ENUMLST_Objekt_Art_W_Kr_Gsp_Element", "W_Kr_Gsp_Element"),

	/**
	 * The '<em><b>ENUMLST Objekt Art WKr Gsp Komponente</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_WKR_GSP_KOMPONENTE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_WKR_GSP_KOMPONENTE(140, "ENUMLST_Objekt_Art_W_Kr_Gsp_Komponente", "W_Kr_Gsp_Komponente"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Weichenlaufkette</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_WEICHENLAUFKETTE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_WEICHENLAUFKETTE(141, "ENUMLST_Objekt_Art_Weichenlaufkette", "Weichenlaufkette"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Weichenlaufkette Zuordnung</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_WEICHENLAUFKETTE_ZUORDNUNG_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_WEICHENLAUFKETTE_ZUORDNUNG(142, "ENUMLST_Objekt_Art_Weichenlaufkette_Zuordnung", "Weichenlaufkette_Zuordnung"),

	/**
	 * The '<em><b>ENUMLST Objekt Art ZBS Schutzstrecke</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ZBS_SCHUTZSTRECKE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_ZBS_SCHUTZSTRECKE(143, "ENUMLST_Objekt_Art_ZBS_Schutzstrecke", "ZBS_Schutzstrecke"),

	/**
	 * The '<em><b>ENUMLST Objekt Art ZBS Signal</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ZBS_SIGNAL_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_ZBS_SIGNAL(144, "ENUMLST_Objekt_Art_ZBS_Signal", "ZBS_Signal"),

	/**
	 * The '<em><b>ENUMLST Objekt Art ZL</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ZL_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_ZL(145, "ENUMLST_Objekt_Art_ZL", "ZL"),

	/**
	 * The '<em><b>ENUMLST Objekt Art ZL DLP Abschnitt</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ZL_DLP_ABSCHNITT_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_ZL_DLP_ABSCHNITT(146, "ENUMLST_Objekt_Art_ZL_DLP_Abschnitt", "ZL_DLP_Abschnitt"),

	/**
	 * The '<em><b>ENUMLST Objekt Art ZL DLP Fstr</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ZL_DLP_FSTR_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_ZL_DLP_FSTR(147, "ENUMLST_Objekt_Art_ZL_DLP_Fstr", "ZL_DLP_Fstr"),

	/**
	 * The '<em><b>ENUMLST Objekt Art ZL Fstr</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ZL_FSTR_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_ZL_FSTR(148, "ENUMLST_Objekt_Art_ZL_Fstr", "ZL_Fstr"),

	/**
	 * The '<em><b>ENUMLST Objekt Art ZL Fstr Anstoss</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ZL_FSTR_ANSTOSS_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_ZL_FSTR_ANSTOSS(149, "ENUMLST_Objekt_Art_ZL_Fstr_Anstoss", "ZL_Fstr_Anstoss"),

	/**
	 * The '<em><b>ENUMLST Objekt Art ZL Signalgruppe</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ZL_SIGNALGRUPPE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_ZL_SIGNALGRUPPE(150, "ENUMLST_Objekt_Art_ZL_Signalgruppe", "ZL_Signalgruppe"),

	/**
	 * The '<em><b>ENUMLST Objekt Art ZL Signalgruppe Zuordnung</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ZL_SIGNALGRUPPE_ZUORDNUNG_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_ZL_SIGNALGRUPPE_ZUORDNUNG(151, "ENUMLST_Objekt_Art_ZL_Signalgruppe_Zuordnung", "ZL_Signalgruppe_Zuordnung"),

	/**
	 * The '<em><b>ENUMLST Objekt Art ZLV Bus</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ZLV_BUS_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_ZLV_BUS(152, "ENUMLST_Objekt_Art_ZLV_Bus", "ZLV_Bus"),

	/**
	 * The '<em><b>ENUMLST Objekt Art ZLV Bus Besondere Anlage</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ZLV_BUS_BESONDERE_ANLAGE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_ZLV_BUS_BESONDERE_ANLAGE(153, "ENUMLST_Objekt_Art_ZLV_Bus_Besondere_Anlage", "ZLV_Bus_Besondere_Anlage"),

	/**
	 * The '<em><b>ENUMLST Objekt Art ZLV Bus US Zuordnung</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ZLV_BUS_US_ZUORDNUNG_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_ZLV_BUS_US_ZUORDNUNG(154, "ENUMLST_Objekt_Art_ZLV_Bus_US_Zuordnung", "ZLV_Bus_US_Zuordnung"),

	/**
	 * The '<em><b>ENUMLST Objekt Art ZN</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ZN_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_ZN(155, "ENUMLST_Objekt_Art_ZN", "ZN"),

	/**
	 * The '<em><b>ENUMLST Objekt Art ZN Akustik</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ZN_AKUSTIK_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_ZN_AKUSTIK(156, "ENUMLST_Objekt_Art_ZN_Akustik", "ZN_Akustik"),

	/**
	 * The '<em><b>ENUMLST Objekt Art ZN Anzeigefeld</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ZN_ANZEIGEFELD_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_ZN_ANZEIGEFELD(157, "ENUMLST_Objekt_Art_ZN_Anzeigefeld", "ZN_Anzeigefeld"),

	/**
	 * The '<em><b>ENUMLST Objekt Art ZN Fortschalt Kriterium</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ZN_FORTSCHALT_KRITERIUM_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_ZN_FORTSCHALT_KRITERIUM(158, "ENUMLST_Objekt_Art_ZN_Fortschalt_Kriterium", "ZN_Fortschalt_Kriterium"),

	/**
	 * The '<em><b>ENUMLST Objekt Art ZN Telegramm 84 Zuordnung</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ZN_TELEGRAMM_84_ZUORDNUNG_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_ZN_TELEGRAMM_84_ZUORDNUNG(159, "ENUMLST_Objekt_Art_ZN_Telegramm_84_Zuordnung", "ZN_Telegramm_84_Zuordnung"),

	/**
	 * The '<em><b>ENUMLST Objekt Art ZN Telegramm 85 Zuordnung</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ZN_TELEGRAMM_85_ZUORDNUNG_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_ZN_TELEGRAMM_85_ZUORDNUNG(160, "ENUMLST_Objekt_Art_ZN_Telegramm_85_Zuordnung", "ZN_Telegramm_85_Zuordnung"),

	/**
	 * The '<em><b>ENUMLST Objekt Art ZN Unterstation</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ZN_UNTERSTATION_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_ZN_UNTERSTATION(161, "ENUMLST_Objekt_Art_ZN_Unterstation", "ZN_Unterstation"),

	/**
	 * The '<em><b>ENUMLST Objekt Art ZN ZBS</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ZN_ZBS_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_ZN_ZBS(162, "ENUMLST_Objekt_Art_ZN_ZBS", "ZN_ZBS"),

	/**
	 * The '<em><b>ENUMLST Objekt Art ZUB Bereichsgrenze</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ZUB_BEREICHSGRENZE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_ZUB_BEREICHSGRENZE(163, "ENUMLST_Objekt_Art_ZUB_Bereichsgrenze", "ZUB_Bereichsgrenze"),

	/**
	 * The '<em><b>ENUMLST Objekt Art ZUB Streckeneigenschaft</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ZUB_STRECKENEIGENSCHAFT_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_ZUB_STRECKENEIGENSCHAFT(164, "ENUMLST_Objekt_Art_ZUB_Streckeneigenschaft", "ZUB_Streckeneigenschaft"),

	/**
	 * The '<em><b>ENUMLST Objekt Art Zugeinwirkung</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ZUGEINWIRKUNG_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMLST_OBJEKT_ART_ZUGEINWIRKUNG(165, "ENUMLST_Objekt_Art_Zugeinwirkung", "Zugeinwirkung");

	/**
	 * The '<em><b>ENUMLST Objekt Art Anhang</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ANHANG
	 * @model name="ENUMLST_Objekt_Art_Anhang" literal="Anhang"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_ANHANG_VALUE = 0;

	/**
	 * The '<em><b>ENUMLST Objekt Art ATO Segment Profile</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ATO_SEGMENT_PROFILE
	 * @model name="ENUMLST_Objekt_Art_ATO_Segment_Profile" literal="ATO_Segment_Profile"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_ATO_SEGMENT_PROFILE_VALUE = 1;

	/**
	 * The '<em><b>ENUMLST Objekt Art ATO Timing Point</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ATO_TIMING_POINT
	 * @model name="ENUMLST_Objekt_Art_ATO_Timing_Point" literal="ATO_Timing_Point"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_ATO_TIMING_POINT_VALUE = 2;

	/**
	 * The '<em><b>ENUMLST Objekt Art ATO TS Instanz</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ATO_TS_INSTANZ
	 * @model name="ENUMLST_Objekt_Art_ATO_TS_Instanz" literal="ATO_TS_Instanz"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_ATO_TS_INSTANZ_VALUE = 3;

	/**
	 * The '<em><b>ENUMLST Objekt Art Aussenelementansteuerung</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_AUSSENELEMENTANSTEUERUNG
	 * @model name="ENUMLST_Objekt_Art_Aussenelementansteuerung" literal="Aussenelementansteuerung"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_AUSSENELEMENTANSTEUERUNG_VALUE = 4;

	/**
	 * The '<em><b>ENUMLST Objekt Art Bahnsteig Anlage</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BAHNSTEIG_ANLAGE
	 * @model name="ENUMLST_Objekt_Art_Bahnsteig_Anlage" literal="Bahnsteig_Anlage"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_BAHNSTEIG_ANLAGE_VALUE = 5;

	/**
	 * The '<em><b>ENUMLST Objekt Art Bahnsteig Dach</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BAHNSTEIG_DACH
	 * @model name="ENUMLST_Objekt_Art_Bahnsteig_Dach" literal="Bahnsteig_Dach"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_BAHNSTEIG_DACH_VALUE = 6;

	/**
	 * The '<em><b>ENUMLST Objekt Art Bahnsteig Kante</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BAHNSTEIG_KANTE
	 * @model name="ENUMLST_Objekt_Art_Bahnsteig_Kante" literal="Bahnsteig_Kante"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_BAHNSTEIG_KANTE_VALUE = 7;

	/**
	 * The '<em><b>ENUMLST Objekt Art Bahnsteig Zugang</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BAHNSTEIG_ZUGANG
	 * @model name="ENUMLST_Objekt_Art_Bahnsteig_Zugang" literal="Bahnsteig_Zugang"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_BAHNSTEIG_ZUGANG_VALUE = 8;

	/**
	 * The '<em><b>ENUMLST Objekt Art Balise</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BALISE
	 * @model name="ENUMLST_Objekt_Art_Balise" literal="Balise"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_BALISE_VALUE = 9;

	/**
	 * The '<em><b>ENUMLST Objekt Art Bearbeitungsvermerk</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BEARBEITUNGSVERMERK
	 * @model name="ENUMLST_Objekt_Art_Bearbeitungsvermerk" literal="Bearbeitungsvermerk"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_BEARBEITUNGSVERMERK_VALUE = 10;

	/**
	 * The '<em><b>ENUMLST Objekt Art Bedien Anrueckabschnitt</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BEDIEN_ANRUECKABSCHNITT
	 * @model name="ENUMLST_Objekt_Art_Bedien_Anrueckabschnitt" literal="Bedien_Anrueckabschnitt"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_BEDIEN_ANRUECKABSCHNITT_VALUE = 11;

	/**
	 * The '<em><b>ENUMLST Objekt Art Bedien Anzeige Element</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BEDIEN_ANZEIGE_ELEMENT
	 * @model name="ENUMLST_Objekt_Art_Bedien_Anzeige_Element" literal="Bedien_Anzeige_Element"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_BEDIEN_ANZEIGE_ELEMENT_VALUE = 12;

	/**
	 * The '<em><b>ENUMLST Objekt Art Bedien Bezirk</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BEDIEN_BEZIRK
	 * @model name="ENUMLST_Objekt_Art_Bedien_Bezirk" literal="Bedien_Bezirk"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_BEDIEN_BEZIRK_VALUE = 13;

	/**
	 * The '<em><b>ENUMLST Objekt Art Bedien Einrichtung Oertlich</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BEDIEN_EINRICHTUNG_OERTLICH
	 * @model name="ENUMLST_Objekt_Art_Bedien_Einrichtung_Oertlich" literal="Bedien_Einrichtung_Oertlich"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_BEDIEN_EINRICHTUNG_OERTLICH_VALUE = 14;

	/**
	 * The '<em><b>ENUMLST Objekt Art Bedien GBT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BEDIEN_GBT
	 * @model name="ENUMLST_Objekt_Art_Bedien_GBT" literal="Bedien_GBT"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_BEDIEN_GBT_VALUE = 15;

	/**
	 * The '<em><b>ENUMLST Objekt Art Bedien Oberflaeche</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BEDIEN_OBERFLAECHE
	 * @model name="ENUMLST_Objekt_Art_Bedien_Oberflaeche" literal="Bedien_Oberflaeche"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_BEDIEN_OBERFLAECHE_VALUE = 16;

	/**
	 * The '<em><b>ENUMLST Objekt Art Bedien Oberflaeche Bild</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BEDIEN_OBERFLAECHE_BILD
	 * @model name="ENUMLST_Objekt_Art_Bedien_Oberflaeche_Bild" literal="Bedien_Oberflaeche_Bild"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_BEDIEN_OBERFLAECHE_BILD_VALUE = 17;

	/**
	 * The '<em><b>ENUMLST Objekt Art Bedien Oertlichkeit</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BEDIEN_OERTLICHKEIT
	 * @model name="ENUMLST_Objekt_Art_Bedien_Oertlichkeit" literal="Bedien_Oertlichkeit"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_BEDIEN_OERTLICHKEIT_VALUE = 18;

	/**
	 * The '<em><b>ENUMLST Objekt Art Bedien Platz</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BEDIEN_PLATZ
	 * @model name="ENUMLST_Objekt_Art_Bedien_Platz" literal="Bedien_Platz"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_BEDIEN_PLATZ_VALUE = 19;

	/**
	 * The '<em><b>ENUMLST Objekt Art Bedien Standort</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BEDIEN_STANDORT
	 * @model name="ENUMLST_Objekt_Art_Bedien_Standort" literal="Bedien_Standort"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_BEDIEN_STANDORT_VALUE = 20;

	/**
	 * The '<em><b>ENUMLST Objekt Art Bedien Zentrale</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BEDIEN_ZENTRALE
	 * @model name="ENUMLST_Objekt_Art_Bedien_Zentrale" literal="Bedien_Zentrale"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_BEDIEN_ZENTRALE_VALUE = 21;

	/**
	 * The '<em><b>ENUMLST Objekt Art Binaerdaten</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BINAERDATEN
	 * @model name="ENUMLST_Objekt_Art_Binaerdaten" literal="Binaerdaten"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_BINAERDATEN_VALUE = 22;

	/**
	 * The '<em><b>ENUMLST Objekt Art Block Anlage</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BLOCK_ANLAGE
	 * @model name="ENUMLST_Objekt_Art_Block_Anlage" literal="Block_Anlage"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_BLOCK_ANLAGE_VALUE = 23;

	/**
	 * The '<em><b>ENUMLST Objekt Art Block Element</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BLOCK_ELEMENT
	 * @model name="ENUMLST_Objekt_Art_Block_Element" literal="Block_Element"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_BLOCK_ELEMENT_VALUE = 24;

	/**
	 * The '<em><b>ENUMLST Objekt Art Block Strecke</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BLOCK_STRECKE
	 * @model name="ENUMLST_Objekt_Art_Block_Strecke" literal="Block_Strecke"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_BLOCK_STRECKE_VALUE = 25;

	/**
	 * The '<em><b>ENUMLST Objekt Art BUE Anlage</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BUE_ANLAGE
	 * @model name="ENUMLST_Objekt_Art_BUE_Anlage" literal="BUE_Anlage"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_BUE_ANLAGE_VALUE = 26;

	/**
	 * The '<em><b>ENUMLST Objekt Art BUE Anlage Strasse</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BUE_ANLAGE_STRASSE
	 * @model name="ENUMLST_Objekt_Art_BUE_Anlage_Strasse" literal="BUE_Anlage_Strasse"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_BUE_ANLAGE_STRASSE_VALUE = 27;

	/**
	 * The '<em><b>ENUMLST Objekt Art BUE Anlage V</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BUE_ANLAGE_V
	 * @model name="ENUMLST_Objekt_Art_BUE_Anlage_V" literal="BUE_Anlage_V"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_BUE_ANLAGE_V_VALUE = 28;

	/**
	 * The '<em><b>ENUMLST Objekt Art BUE Ausschaltung</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BUE_AUSSCHALTUNG
	 * @model name="ENUMLST_Objekt_Art_BUE_Ausschaltung" literal="BUE_Ausschaltung"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_BUE_AUSSCHALTUNG_VALUE = 29;

	/**
	 * The '<em><b>ENUMLST Objekt Art BUE Bedien Anzeige Element</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BUE_BEDIEN_ANZEIGE_ELEMENT
	 * @model name="ENUMLST_Objekt_Art_BUE_Bedien_Anzeige_Element" literal="BUE_Bedien_Anzeige_Element"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_BUE_BEDIEN_ANZEIGE_ELEMENT_VALUE = 30;

	/**
	 * The '<em><b>ENUMLST Objekt Art BUE Deckendes Signal Zuordnung</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BUE_DECKENDES_SIGNAL_ZUORDNUNG
	 * @model name="ENUMLST_Objekt_Art_BUE_Deckendes_Signal_Zuordnung" literal="BUE_Deckendes_Signal_Zuordnung"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_BUE_DECKENDES_SIGNAL_ZUORDNUNG_VALUE = 31;

	/**
	 * The '<em><b>ENUMLST Objekt Art BUE Einschaltung</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BUE_EINSCHALTUNG
	 * @model name="ENUMLST_Objekt_Art_BUE_Einschaltung" literal="BUE_Einschaltung"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_BUE_EINSCHALTUNG_VALUE = 32;

	/**
	 * The '<em><b>ENUMLST Objekt Art BUE Einschaltung Zuordnung</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BUE_EINSCHALTUNG_ZUORDNUNG
	 * @model name="ENUMLST_Objekt_Art_BUE_Einschaltung_Zuordnung" literal="BUE_Einschaltung_Zuordnung"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_BUE_EINSCHALTUNG_ZUORDNUNG_VALUE = 33;

	/**
	 * The '<em><b>ENUMLST Objekt Art BUE Gefahrraum Eckpunkt</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BUE_GEFAHRRAUM_ECKPUNKT
	 * @model name="ENUMLST_Objekt_Art_BUE_Gefahrraum_Eckpunkt" literal="BUE_Gefahrraum_Eckpunkt"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_BUE_GEFAHRRAUM_ECKPUNKT_VALUE = 34;

	/**
	 * The '<em><b>ENUMLST Objekt Art BUE Gleisbezogener Gefahrraum</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BUE_GLEISBEZOGENER_GEFAHRRAUM
	 * @model name="ENUMLST_Objekt_Art_BUE_Gleisbezogener_Gefahrraum" literal="BUE_Gleisbezogener_Gefahrraum"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_BUE_GLEISBEZOGENER_GEFAHRRAUM_VALUE = 35;

	/**
	 * The '<em><b>ENUMLST Objekt Art BUE Kante</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BUE_KANTE
	 * @model name="ENUMLST_Objekt_Art_BUE_Kante" literal="BUE_Kante"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_BUE_KANTE_VALUE = 36;

	/**
	 * The '<em><b>ENUMLST Objekt Art BUE Kreuzungsplan</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BUE_KREUZUNGSPLAN
	 * @model name="ENUMLST_Objekt_Art_BUE_Kreuzungsplan" literal="BUE_Kreuzungsplan"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_BUE_KREUZUNGSPLAN_VALUE = 37;

	/**
	 * The '<em><b>ENUMLST Objekt Art BUE Schnittstelle</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BUE_SCHNITTSTELLE
	 * @model name="ENUMLST_Objekt_Art_BUE_Schnittstelle" literal="BUE_Schnittstelle"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_BUE_SCHNITTSTELLE_VALUE = 38;

	/**
	 * The '<em><b>ENUMLST Objekt Art BUE Spezifisches Signal</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BUE_SPEZIFISCHES_SIGNAL
	 * @model name="ENUMLST_Objekt_Art_BUE_Spezifisches_Signal" literal="BUE_Spezifisches_Signal"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_BUE_SPEZIFISCHES_SIGNAL_VALUE = 39;

	/**
	 * The '<em><b>ENUMLST Objekt Art BUE WS Fstr Zuordnung</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_BUE_WS_FSTR_ZUORDNUNG
	 * @model name="ENUMLST_Objekt_Art_BUE_WS_Fstr_Zuordnung" literal="BUE_WS_Fstr_Zuordnung"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_BUE_WS_FSTR_ZUORDNUNG_VALUE = 40;

	/**
	 * The '<em><b>ENUMLST Objekt Art Datenpunkt</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_DATENPUNKT
	 * @model name="ENUMLST_Objekt_Art_Datenpunkt" literal="Datenpunkt"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_DATENPUNKT_VALUE = 41;

	/**
	 * The '<em><b>ENUMLST Objekt Art Datenpunkt Link</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_DATENPUNKT_LINK
	 * @model name="ENUMLST_Objekt_Art_Datenpunkt_Link" literal="Datenpunkt_Link"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_DATENPUNKT_LINK_VALUE = 42;

	/**
	 * The '<em><b>ENUMLST Objekt Art ESTW Zentraleinheit</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ESTW_ZENTRALEINHEIT
	 * @model name="ENUMLST_Objekt_Art_ESTW_Zentraleinheit" literal="ESTW_Zentraleinheit"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_ESTW_ZENTRALEINHEIT_VALUE = 43;

	/**
	 * The '<em><b>ENUMLST Objekt Art ETCS Kante</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ETCS_KANTE
	 * @model name="ENUMLST_Objekt_Art_ETCS_Kante" literal="ETCS_Kante"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_ETCS_KANTE_VALUE = 44;

	/**
	 * The '<em><b>ENUMLST Objekt Art ETCS Knoten</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ETCS_KNOTEN
	 * @model name="ENUMLST_Objekt_Art_ETCS_Knoten" literal="ETCS_Knoten"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_ETCS_KNOTEN_VALUE = 45;

	/**
	 * The '<em><b>ENUMLST Objekt Art ETCS Richtungsanzeige</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ETCS_RICHTUNGSANZEIGE
	 * @model name="ENUMLST_Objekt_Art_ETCS_Richtungsanzeige" literal="ETCS_Richtungsanzeige"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_ETCS_RICHTUNGSANZEIGE_VALUE = 46;

	/**
	 * The '<em><b>ENUMLST Objekt Art ETCS Signal</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ETCS_SIGNAL
	 * @model name="ENUMLST_Objekt_Art_ETCS_Signal" literal="ETCS_Signal"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_ETCS_SIGNAL_VALUE = 47;

	/**
	 * The '<em><b>ENUMLST Objekt Art ETCS WKr</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ETCS_WKR
	 * @model name="ENUMLST_Objekt_Art_ETCS_W_Kr" literal="ETCS_W_Kr"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_ETCS_WKR_VALUE = 48;

	/**
	 * The '<em><b>ENUMLST Objekt Art EV Modul</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_EV_MODUL
	 * @model name="ENUMLST_Objekt_Art_EV_Modul" literal="EV_Modul"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_EV_MODUL_VALUE = 49;

	/**
	 * The '<em><b>ENUMLST Objekt Art Fachtelegramm</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_FACHTELEGRAMM
	 * @model name="ENUMLST_Objekt_Art_Fachtelegramm" literal="Fachtelegramm"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_FACHTELEGRAMM_VALUE = 50;

	/**
	 * The '<em><b>ENUMLST Objekt Art Fla Freimelde Zuordnung</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_FLA_FREIMELDE_ZUORDNUNG
	 * @model name="ENUMLST_Objekt_Art_Fla_Freimelde_Zuordnung" literal="Fla_Freimelde_Zuordnung"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_FLA_FREIMELDE_ZUORDNUNG_VALUE = 51;

	/**
	 * The '<em><b>ENUMLST Objekt Art Fla Schutz</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_FLA_SCHUTZ
	 * @model name="ENUMLST_Objekt_Art_Fla_Schutz" literal="Fla_Schutz"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_FLA_SCHUTZ_VALUE = 52;

	/**
	 * The '<em><b>ENUMLST Objekt Art Fla Zwieschutz</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_FLA_ZWIESCHUTZ
	 * @model name="ENUMLST_Objekt_Art_Fla_Zwieschutz" literal="Fla_Zwieschutz"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_FLA_ZWIESCHUTZ_VALUE = 53;

	/**
	 * The '<em><b>ENUMLST Objekt Art FMA Anlage</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_FMA_ANLAGE
	 * @model name="ENUMLST_Objekt_Art_FMA_Anlage" literal="FMA_Anlage"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_FMA_ANLAGE_VALUE = 54;

	/**
	 * The '<em><b>ENUMLST Objekt Art FMA Element</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_FMA_ELEMENT
	 * @model name="ENUMLST_Objekt_Art_FMA_Element" literal="FMA_Element"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_FMA_ELEMENT_VALUE = 55;

	/**
	 * The '<em><b>ENUMLST Objekt Art FMA Komponente</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_FMA_KOMPONENTE
	 * @model name="ENUMLST_Objekt_Art_FMA_Komponente" literal="FMA_Komponente"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_FMA_KOMPONENTE_VALUE = 56;

	/**
	 * The '<em><b>ENUMLST Objekt Art Fstr Abhaengigkeit</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_FSTR_ABHAENGIGKEIT
	 * @model name="ENUMLST_Objekt_Art_Fstr_Abhaengigkeit" literal="Fstr_Abhaengigkeit"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_FSTR_ABHAENGIGKEIT_VALUE = 57;

	/**
	 * The '<em><b>ENUMLST Objekt Art Fstr Aneinander</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_FSTR_ANEINANDER
	 * @model name="ENUMLST_Objekt_Art_Fstr_Aneinander" literal="Fstr_Aneinander"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_FSTR_ANEINANDER_VALUE = 58;

	/**
	 * The '<em><b>ENUMLST Objekt Art Fstr Aneinander Zuordnung</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_FSTR_ANEINANDER_ZUORDNUNG
	 * @model name="ENUMLST_Objekt_Art_Fstr_Aneinander_Zuordnung" literal="Fstr_Aneinander_Zuordnung"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_FSTR_ANEINANDER_ZUORDNUNG_VALUE = 59;

	/**
	 * The '<em><b>ENUMLST Objekt Art Fstr DWeg</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_FSTR_DWEG
	 * @model name="ENUMLST_Objekt_Art_Fstr_DWeg" literal="Fstr_DWeg"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_FSTR_DWEG_VALUE = 60;

	/**
	 * The '<em><b>ENUMLST Objekt Art Fstr DWeg WKr</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_FSTR_DWEG_WKR
	 * @model name="ENUMLST_Objekt_Art_Fstr_DWeg_W_Kr" literal="Fstr_DWeg_W_Kr"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_FSTR_DWEG_WKR_VALUE = 61;

	/**
	 * The '<em><b>ENUMLST Objekt Art Fstr Fahrweg</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_FSTR_FAHRWEG
	 * @model name="ENUMLST_Objekt_Art_Fstr_Fahrweg" literal="Fstr_Fahrweg"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_FSTR_FAHRWEG_VALUE = 62;

	/**
	 * The '<em><b>ENUMLST Objekt Art Fstr Nichthaltfall</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_FSTR_NICHTHALTFALL
	 * @model name="ENUMLST_Objekt_Art_Fstr_Nichthaltfall" literal="Fstr_Nichthaltfall"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_FSTR_NICHTHALTFALL_VALUE = 63;

	/**
	 * The '<em><b>ENUMLST Objekt Art Fstr Rangier Fla Zuordnung</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_FSTR_RANGIER_FLA_ZUORDNUNG
	 * @model name="ENUMLST_Objekt_Art_Fstr_Rangier_Fla_Zuordnung" literal="Fstr_Rangier_Fla_Zuordnung"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_FSTR_RANGIER_FLA_ZUORDNUNG_VALUE = 64;

	/**
	 * The '<em><b>ENUMLST Objekt Art Fstr Signalisierung</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_FSTR_SIGNALISIERUNG
	 * @model name="ENUMLST_Objekt_Art_Fstr_Signalisierung" literal="Fstr_Signalisierung"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_FSTR_SIGNALISIERUNG_VALUE = 65;

	/**
	 * The '<em><b>ENUMLST Objekt Art Fstr Umfahrpunkt</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_FSTR_UMFAHRPUNKT
	 * @model name="ENUMLST_Objekt_Art_Fstr_Umfahrpunkt" literal="Fstr_Umfahrpunkt"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_FSTR_UMFAHRPUNKT_VALUE = 66;

	/**
	 * The '<em><b>ENUMLST Objekt Art Fstr Zug Rangier</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_FSTR_ZUG_RANGIER
	 * @model name="ENUMLST_Objekt_Art_Fstr_Zug_Rangier" literal="Fstr_Zug_Rangier"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_FSTR_ZUG_RANGIER_VALUE = 67;

	/**
	 * The '<em><b>ENUMLST Objekt Art FT Anschaltbedingung</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_FT_ANSCHALTBEDINGUNG
	 * @model name="ENUMLST_Objekt_Art_FT_Anschaltbedingung" literal="FT_Anschaltbedingung"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_FT_ANSCHALTBEDINGUNG_VALUE = 68;

	/**
	 * The '<em><b>ENUMLST Objekt Art FT Fahrweg Teil</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_FT_FAHRWEG_TEIL
	 * @model name="ENUMLST_Objekt_Art_FT_Fahrweg_Teil" literal="FT_Fahrweg_Teil"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_FT_FAHRWEG_TEIL_VALUE = 69;

	/**
	 * The '<em><b>ENUMLST Objekt Art GEO Kante</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_GEO_KANTE
	 * @model name="ENUMLST_Objekt_Art_GEO_Kante" literal="GEO_Kante"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_GEO_KANTE_VALUE = 70;

	/**
	 * The '<em><b>ENUMLST Objekt Art GEO Knoten</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_GEO_KNOTEN
	 * @model name="ENUMLST_Objekt_Art_GEO_Knoten" literal="GEO_Knoten"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_GEO_KNOTEN_VALUE = 71;

	/**
	 * The '<em><b>ENUMLST Objekt Art GEO Punkt</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_GEO_PUNKT
	 * @model name="ENUMLST_Objekt_Art_GEO_Punkt" literal="GEO_Punkt"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_GEO_PUNKT_VALUE = 72;

	/**
	 * The '<em><b>ENUMLST Objekt Art Geschwindigkeitsprofil</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_GESCHWINDIGKEITSPROFIL
	 * @model name="ENUMLST_Objekt_Art_Geschwindigkeitsprofil" literal="Geschwindigkeitsprofil"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_GESCHWINDIGKEITSPROFIL_VALUE = 73;

	/**
	 * The '<em><b>ENUMLST Objekt Art GFR Anlage</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_GFR_ANLAGE
	 * @model name="ENUMLST_Objekt_Art_GFR_Anlage" literal="GFR_Anlage"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_GFR_ANLAGE_VALUE = 74;

	/**
	 * The '<em><b>ENUMLST Objekt Art GFR Element</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_GFR_ELEMENT
	 * @model name="ENUMLST_Objekt_Art_GFR_Element" literal="GFR_Element"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_GFR_ELEMENT_VALUE = 75;

	/**
	 * The '<em><b>ENUMLST Objekt Art GFR Tripelspiegel</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_GFR_TRIPELSPIEGEL
	 * @model name="ENUMLST_Objekt_Art_GFR_Tripelspiegel" literal="GFR_Tripelspiegel"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_GFR_TRIPELSPIEGEL_VALUE = 76;

	/**
	 * The '<em><b>ENUMLST Objekt Art Gleis Abschluss</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_GLEIS_ABSCHLUSS
	 * @model name="ENUMLST_Objekt_Art_Gleis_Abschluss" literal="Gleis_Abschluss"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_GLEIS_ABSCHLUSS_VALUE = 77;

	/**
	 * The '<em><b>ENUMLST Objekt Art Gleis Abschnitt</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_GLEIS_ABSCHNITT
	 * @model name="ENUMLST_Objekt_Art_Gleis_Abschnitt" literal="Gleis_Abschnitt"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_GLEIS_ABSCHNITT_VALUE = 78;

	/**
	 * The '<em><b>ENUMLST Objekt Art Gleis Art</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_GLEIS_ART
	 * @model name="ENUMLST_Objekt_Art_Gleis_Art" literal="Gleis_Art"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_GLEIS_ART_VALUE = 79;

	/**
	 * The '<em><b>ENUMLST Objekt Art Gleis Baubereich</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_GLEIS_BAUBEREICH
	 * @model name="ENUMLST_Objekt_Art_Gleis_Baubereich" literal="Gleis_Baubereich"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_GLEIS_BAUBEREICH_VALUE = 80;

	/**
	 * The '<em><b>ENUMLST Objekt Art Gleis Bezeichnung</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_GLEIS_BEZEICHNUNG
	 * @model name="ENUMLST_Objekt_Art_Gleis_Bezeichnung" literal="Gleis_Bezeichnung"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_GLEIS_BEZEICHNUNG_VALUE = 81;

	/**
	 * The '<em><b>ENUMLST Objekt Art Gleis Fahrbahn</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_GLEIS_FAHRBAHN
	 * @model name="ENUMLST_Objekt_Art_Gleis_Fahrbahn" literal="Gleis_Fahrbahn"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_GLEIS_FAHRBAHN_VALUE = 82;

	/**
	 * The '<em><b>ENUMLST Objekt Art Gleis Lichtraum</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_GLEIS_LICHTRAUM
	 * @model name="ENUMLST_Objekt_Art_Gleis_Lichtraum" literal="Gleis_Lichtraum"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_GLEIS_LICHTRAUM_VALUE = 83;

	/**
	 * The '<em><b>ENUMLST Objekt Art Gleis Schaltgruppe</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_GLEIS_SCHALTGRUPPE
	 * @model name="ENUMLST_Objekt_Art_Gleis_Schaltgruppe" literal="Gleis_Schaltgruppe"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_GLEIS_SCHALTGRUPPE_VALUE = 84;

	/**
	 * The '<em><b>ENUMLST Objekt Art Hoehenlinie</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_HOEHENLINIE
	 * @model name="ENUMLST_Objekt_Art_Hoehenlinie" literal="Hoehenlinie"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_HOEHENLINIE_VALUE = 85;

	/**
	 * The '<em><b>ENUMLST Objekt Art Hoehenpunkt</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_HOEHENPUNKT
	 * @model name="ENUMLST_Objekt_Art_Hoehenpunkt" literal="Hoehenpunkt"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_HOEHENPUNKT_VALUE = 86;

	/**
	 * The '<em><b>ENUMLST Objekt Art Kabel</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_KABEL
	 * @model name="ENUMLST_Objekt_Art_Kabel" literal="Kabel"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_KABEL_VALUE = 87;

	/**
	 * The '<em><b>ENUMLST Objekt Art Kabel Verteilpunkt</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_KABEL_VERTEILPUNKT
	 * @model name="ENUMLST_Objekt_Art_Kabel_Verteilpunkt" literal="Kabel_Verteilpunkt"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_KABEL_VERTEILPUNKT_VALUE = 88;

	/**
	 * The '<em><b>ENUMLST Objekt Art LEU Anlage</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_LEU_ANLAGE
	 * @model name="ENUMLST_Objekt_Art_LEU_Anlage" literal="LEU_Anlage"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_LEU_ANLAGE_VALUE = 89;

	/**
	 * The '<em><b>ENUMLST Objekt Art LEU Modul</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_LEU_MODUL
	 * @model name="ENUMLST_Objekt_Art_LEU_Modul" literal="LEU_Modul"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_LEU_MODUL_VALUE = 90;

	/**
	 * The '<em><b>ENUMLST Objekt Art LEU Schaltkasten</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_LEU_SCHALTKASTEN
	 * @model name="ENUMLST_Objekt_Art_LEU_Schaltkasten" literal="LEU_Schaltkasten"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_LEU_SCHALTKASTEN_VALUE = 91;

	/**
	 * The '<em><b>ENUMLST Objekt Art Lieferobjekt</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_LIEFEROBJEKT
	 * @model name="ENUMLST_Objekt_Art_Lieferobjekt" literal="Lieferobjekt"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_LIEFEROBJEKT_VALUE = 92;

	/**
	 * The '<em><b>ENUMLST Objekt Art Luft Telegramm</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_LUFT_TELEGRAMM
	 * @model name="ENUMLST_Objekt_Art_Luft_Telegramm" literal="Luft_Telegramm"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_LUFT_TELEGRAMM_VALUE = 93;

	/**
	 * The '<em><b>ENUMLST Objekt Art Markanter Punkt</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_MARKANTER_PUNKT
	 * @model name="ENUMLST_Objekt_Art_Markanter_Punkt" literal="Markanter_Punkt"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_MARKANTER_PUNKT_VALUE = 94;

	/**
	 * The '<em><b>ENUMLST Objekt Art NB</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_NB
	 * @model name="ENUMLST_Objekt_Art_NB" literal="NB"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_NB_VALUE = 95;

	/**
	 * The '<em><b>ENUMLST Objekt Art NB Bedien Anzeige Element</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_NB_BEDIEN_ANZEIGE_ELEMENT
	 * @model name="ENUMLST_Objekt_Art_NB_Bedien_Anzeige_Element" literal="NB_Bedien_Anzeige_Element"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_NB_BEDIEN_ANZEIGE_ELEMENT_VALUE = 96;

	/**
	 * The '<em><b>ENUMLST Objekt Art NB Zone</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_NB_ZONE
	 * @model name="ENUMLST_Objekt_Art_NB_Zone" literal="NB_Zone"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_NB_ZONE_VALUE = 97;

	/**
	 * The '<em><b>ENUMLST Objekt Art NB Zone Element</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_NB_ZONE_ELEMENT
	 * @model name="ENUMLST_Objekt_Art_NB_Zone_Element" literal="NB_Zone_Element"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_NB_ZONE_ELEMENT_VALUE = 98;

	/**
	 * The '<em><b>ENUMLST Objekt Art NB Zone Grenze</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_NB_ZONE_GRENZE
	 * @model name="ENUMLST_Objekt_Art_NB_Zone_Grenze" literal="NB_Zone_Grenze"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_NB_ZONE_GRENZE_VALUE = 99;

	/**
	 * The '<em><b>ENUMLST Objekt Art Oertlichkeit</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_OERTLICHKEIT
	 * @model name="ENUMLST_Objekt_Art_Oertlichkeit" literal="Oertlichkeit"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_OERTLICHKEIT_VALUE = 100;

	/**
	 * The '<em><b>ENUMLST Objekt Art Prog Datei Gruppe</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_PROG_DATEI_GRUPPE
	 * @model name="ENUMLST_Objekt_Art_Prog_Datei_Gruppe" literal="Prog_Datei_Gruppe"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_PROG_DATEI_GRUPPE_VALUE = 101;

	/**
	 * The '<em><b>ENUMLST Objekt Art PZB Element</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_PZB_ELEMENT
	 * @model name="ENUMLST_Objekt_Art_PZB_Element" literal="PZB_Element"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_PZB_ELEMENT_VALUE = 102;

	/**
	 * The '<em><b>ENUMLST Objekt Art PZB Element Zuordnung</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_PZB_ELEMENT_ZUORDNUNG
	 * @model name="ENUMLST_Objekt_Art_PZB_Element_Zuordnung" literal="PZB_Element_Zuordnung"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_PZB_ELEMENT_ZUORDNUNG_VALUE = 103;

	/**
	 * The '<em><b>ENUMLST Objekt Art PZB Zuordnung Signal</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_PZB_ZUORDNUNG_SIGNAL
	 * @model name="ENUMLST_Objekt_Art_PZB_Zuordnung_Signal" literal="PZB_Zuordnung_Signal"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_PZB_ZUORDNUNG_SIGNAL_VALUE = 104;

	/**
	 * The '<em><b>ENUMLST Objekt Art RBC</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_RBC
	 * @model name="ENUMLST_Objekt_Art_RBC" literal="RBC"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_RBC_VALUE = 105;

	/**
	 * The '<em><b>ENUMLST Objekt Art Regelzeichnung</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_REGELZEICHNUNG
	 * @model name="ENUMLST_Objekt_Art_Regelzeichnung" literal="Regelzeichnung"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_REGELZEICHNUNG_VALUE = 106;

	/**
	 * The '<em><b>ENUMLST Objekt Art Regelzeichnung Parameter</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_REGELZEICHNUNG_PARAMETER
	 * @model name="ENUMLST_Objekt_Art_Regelzeichnung_Parameter" literal="Regelzeichnung_Parameter"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_REGELZEICHNUNG_PARAMETER_VALUE = 107;

	/**
	 * The '<em><b>ENUMLST Objekt Art Schaltmittel Fstr Zuordnung</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_SCHALTMITTEL_FSTR_ZUORDNUNG
	 * @model name="ENUMLST_Objekt_Art_Schaltmittel_Fstr_Zuordnung" literal="Schaltmittel_Fstr_Zuordnung"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_SCHALTMITTEL_FSTR_ZUORDNUNG_VALUE = 108;

	/**
	 * The '<em><b>ENUMLST Objekt Art Schaltmittel Zuordnung</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_SCHALTMITTEL_ZUORDNUNG
	 * @model name="ENUMLST_Objekt_Art_Schaltmittel_Zuordnung" literal="Schaltmittel_Zuordnung"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_SCHALTMITTEL_ZUORDNUNG_VALUE = 109;

	/**
	 * The '<em><b>ENUMLST Objekt Art Schloss</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_SCHLOSS
	 * @model name="ENUMLST_Objekt_Art_Schloss" literal="Schloss"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_SCHLOSS_VALUE = 110;

	/**
	 * The '<em><b>ENUMLST Objekt Art Schlosskombination</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_SCHLOSSKOMBINATION
	 * @model name="ENUMLST_Objekt_Art_Schlosskombination" literal="Schlosskombination"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_SCHLOSSKOMBINATION_VALUE = 111;

	/**
	 * The '<em><b>ENUMLST Objekt Art Schluessel</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_SCHLUESSEL
	 * @model name="ENUMLST_Objekt_Art_Schluessel" literal="Schluessel"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_SCHLUESSEL_VALUE = 112;

	/**
	 * The '<em><b>ENUMLST Objekt Art Schluesselsperre</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_SCHLUESSELSPERRE
	 * @model name="ENUMLST_Objekt_Art_Schluesselsperre" literal="Schluesselsperre"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_SCHLUESSELSPERRE_VALUE = 113;

	/**
	 * The '<em><b>ENUMLST Objekt Art Schrankenantrieb</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_SCHRANKENANTRIEB
	 * @model name="ENUMLST_Objekt_Art_Schrankenantrieb" literal="Schrankenantrieb"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_SCHRANKENANTRIEB_VALUE = 114;

	/**
	 * The '<em><b>ENUMLST Objekt Art Signal</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_SIGNAL
	 * @model name="ENUMLST_Objekt_Art_Signal" literal="Signal"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_SIGNAL_VALUE = 115;

	/**
	 * The '<em><b>ENUMLST Objekt Art Signal Befestigung</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_SIGNAL_BEFESTIGUNG
	 * @model name="ENUMLST_Objekt_Art_Signal_Befestigung" literal="Signal_Befestigung"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_SIGNAL_BEFESTIGUNG_VALUE = 116;

	/**
	 * The '<em><b>ENUMLST Objekt Art Signal Fank Zuordnung</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_SIGNAL_FANK_ZUORDNUNG
	 * @model name="ENUMLST_Objekt_Art_Signal_Fank_Zuordnung" literal="Signal_Fank_Zuordnung"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_SIGNAL_FANK_ZUORDNUNG_VALUE = 117;

	/**
	 * The '<em><b>ENUMLST Objekt Art Signal Rahmen</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_SIGNAL_RAHMEN
	 * @model name="ENUMLST_Objekt_Art_Signal_Rahmen" literal="Signal_Rahmen"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_SIGNAL_RAHMEN_VALUE = 118;

	/**
	 * The '<em><b>ENUMLST Objekt Art Signal Signalbegriff</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_SIGNAL_SIGNALBEGRIFF
	 * @model name="ENUMLST_Objekt_Art_Signal_Signalbegriff" literal="Signal_Signalbegriff"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_SIGNAL_SIGNALBEGRIFF_VALUE = 119;

	/**
	 * The '<em><b>ENUMLST Objekt Art Sonstiger Punkt</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_SONSTIGER_PUNKT
	 * @model name="ENUMLST_Objekt_Art_Sonstiger_Punkt" literal="Sonstiger_Punkt"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_SONSTIGER_PUNKT_VALUE = 120;

	/**
	 * The '<em><b>ENUMLST Objekt Art Stell Bereich</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_STELL_BEREICH
	 * @model name="ENUMLST_Objekt_Art_Stell_Bereich" literal="Stell_Bereich"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_STELL_BEREICH_VALUE = 121;

	/**
	 * The '<em><b>ENUMLST Objekt Art Stellelement</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_STELLELEMENT
	 * @model name="ENUMLST_Objekt_Art_Stellelement" literal="Stellelement"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_STELLELEMENT_VALUE = 122;

	/**
	 * The '<em><b>ENUMLST Objekt Art Strecke</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_STRECKE
	 * @model name="ENUMLST_Objekt_Art_Strecke" literal="Strecke"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_STRECKE_VALUE = 123;

	/**
	 * The '<em><b>ENUMLST Objekt Art Strecke Bremsweg</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_STRECKE_BREMSWEG
	 * @model name="ENUMLST_Objekt_Art_Strecke_Bremsweg" literal="Strecke_Bremsweg"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_STRECKE_BREMSWEG_VALUE = 124;

	/**
	 * The '<em><b>ENUMLST Objekt Art Strecke Punkt</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_STRECKE_PUNKT
	 * @model name="ENUMLST_Objekt_Art_Strecke_Punkt" literal="Strecke_Punkt"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_STRECKE_PUNKT_VALUE = 125;

	/**
	 * The '<em><b>ENUMLST Objekt Art Technik Standort</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_TECHNIK_STANDORT
	 * @model name="ENUMLST_Objekt_Art_Technik_Standort" literal="Technik_Standort"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_TECHNIK_STANDORT_VALUE = 126;

	/**
	 * The '<em><b>ENUMLST Objekt Art Technischer Bereich</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_TECHNISCHER_BEREICH
	 * @model name="ENUMLST_Objekt_Art_Technischer_Bereich" literal="Technischer_Bereich"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_TECHNISCHER_BEREICH_VALUE = 127;

	/**
	 * The '<em><b>ENUMLST Objekt Art Technischer Punkt</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_TECHNISCHER_PUNKT
	 * @model name="ENUMLST_Objekt_Art_Technischer_Punkt" literal="Technischer_Punkt"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_TECHNISCHER_PUNKT_VALUE = 128;

	/**
	 * The '<em><b>ENUMLST Objekt Art TOP Kante</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_TOP_KANTE
	 * @model name="ENUMLST_Objekt_Art_TOP_Kante" literal="TOP_Kante"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_TOP_KANTE_VALUE = 129;

	/**
	 * The '<em><b>ENUMLST Objekt Art TOP Knoten</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_TOP_KNOTEN
	 * @model name="ENUMLST_Objekt_Art_TOP_Knoten" literal="TOP_Knoten"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_TOP_KNOTEN_VALUE = 130;

	/**
	 * The '<em><b>ENUMLST Objekt Art Trasse Kante</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_TRASSE_KANTE
	 * @model name="ENUMLST_Objekt_Art_Trasse_Kante" literal="Trasse_Kante"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_TRASSE_KANTE_VALUE = 131;

	/**
	 * The '<em><b>ENUMLST Objekt Art Trasse Knoten</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_TRASSE_KNOTEN
	 * @model name="ENUMLST_Objekt_Art_Trasse_Knoten" literal="Trasse_Knoten"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_TRASSE_KNOTEN_VALUE = 132;

	/**
	 * The '<em><b>ENUMLST Objekt Art Ueberhoehung</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_UEBERHOEHUNG
	 * @model name="ENUMLST_Objekt_Art_Ueberhoehung" literal="Ueberhoehung"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_UEBERHOEHUNG_VALUE = 133;

	/**
	 * The '<em><b>ENUMLST Objekt Art Ueberhoehungslinie</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_UEBERHOEHUNGSLINIE
	 * @model name="ENUMLST_Objekt_Art_Ueberhoehungslinie" literal="Ueberhoehungslinie"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_UEBERHOEHUNGSLINIE_VALUE = 134;

	/**
	 * The '<em><b>ENUMLST Objekt Art Uebertragungsweg</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_UEBERTRAGUNGSWEG
	 * @model name="ENUMLST_Objekt_Art_Uebertragungsweg" literal="Uebertragungsweg"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_UEBERTRAGUNGSWEG_VALUE = 135;

	/**
	 * The '<em><b>ENUMLST Objekt Art Unterbringung</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_UNTERBRINGUNG
	 * @model name="ENUMLST_Objekt_Art_Unterbringung" literal="Unterbringung"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_UNTERBRINGUNG_VALUE = 136;

	/**
	 * The '<em><b>ENUMLST Objekt Art Verkehrszeichen</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_VERKEHRSZEICHEN
	 * @model name="ENUMLST_Objekt_Art_Verkehrszeichen" literal="Verkehrszeichen"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_VERKEHRSZEICHEN_VALUE = 137;

	/**
	 * The '<em><b>ENUMLST Objekt Art WKr Anlage</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_WKR_ANLAGE
	 * @model name="ENUMLST_Objekt_Art_W_Kr_Anlage" literal="W_Kr_Anlage"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_WKR_ANLAGE_VALUE = 138;

	/**
	 * The '<em><b>ENUMLST Objekt Art WKr Gsp Element</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_WKR_GSP_ELEMENT
	 * @model name="ENUMLST_Objekt_Art_W_Kr_Gsp_Element" literal="W_Kr_Gsp_Element"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_WKR_GSP_ELEMENT_VALUE = 139;

	/**
	 * The '<em><b>ENUMLST Objekt Art WKr Gsp Komponente</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_WKR_GSP_KOMPONENTE
	 * @model name="ENUMLST_Objekt_Art_W_Kr_Gsp_Komponente" literal="W_Kr_Gsp_Komponente"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_WKR_GSP_KOMPONENTE_VALUE = 140;

	/**
	 * The '<em><b>ENUMLST Objekt Art Weichenlaufkette</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_WEICHENLAUFKETTE
	 * @model name="ENUMLST_Objekt_Art_Weichenlaufkette" literal="Weichenlaufkette"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_WEICHENLAUFKETTE_VALUE = 141;

	/**
	 * The '<em><b>ENUMLST Objekt Art Weichenlaufkette Zuordnung</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_WEICHENLAUFKETTE_ZUORDNUNG
	 * @model name="ENUMLST_Objekt_Art_Weichenlaufkette_Zuordnung" literal="Weichenlaufkette_Zuordnung"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_WEICHENLAUFKETTE_ZUORDNUNG_VALUE = 142;

	/**
	 * The '<em><b>ENUMLST Objekt Art ZBS Schutzstrecke</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ZBS_SCHUTZSTRECKE
	 * @model name="ENUMLST_Objekt_Art_ZBS_Schutzstrecke" literal="ZBS_Schutzstrecke"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_ZBS_SCHUTZSTRECKE_VALUE = 143;

	/**
	 * The '<em><b>ENUMLST Objekt Art ZBS Signal</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ZBS_SIGNAL
	 * @model name="ENUMLST_Objekt_Art_ZBS_Signal" literal="ZBS_Signal"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_ZBS_SIGNAL_VALUE = 144;

	/**
	 * The '<em><b>ENUMLST Objekt Art ZL</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ZL
	 * @model name="ENUMLST_Objekt_Art_ZL" literal="ZL"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_ZL_VALUE = 145;

	/**
	 * The '<em><b>ENUMLST Objekt Art ZL DLP Abschnitt</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ZL_DLP_ABSCHNITT
	 * @model name="ENUMLST_Objekt_Art_ZL_DLP_Abschnitt" literal="ZL_DLP_Abschnitt"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_ZL_DLP_ABSCHNITT_VALUE = 146;

	/**
	 * The '<em><b>ENUMLST Objekt Art ZL DLP Fstr</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ZL_DLP_FSTR
	 * @model name="ENUMLST_Objekt_Art_ZL_DLP_Fstr" literal="ZL_DLP_Fstr"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_ZL_DLP_FSTR_VALUE = 147;

	/**
	 * The '<em><b>ENUMLST Objekt Art ZL Fstr</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ZL_FSTR
	 * @model name="ENUMLST_Objekt_Art_ZL_Fstr" literal="ZL_Fstr"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_ZL_FSTR_VALUE = 148;

	/**
	 * The '<em><b>ENUMLST Objekt Art ZL Fstr Anstoss</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ZL_FSTR_ANSTOSS
	 * @model name="ENUMLST_Objekt_Art_ZL_Fstr_Anstoss" literal="ZL_Fstr_Anstoss"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_ZL_FSTR_ANSTOSS_VALUE = 149;

	/**
	 * The '<em><b>ENUMLST Objekt Art ZL Signalgruppe</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ZL_SIGNALGRUPPE
	 * @model name="ENUMLST_Objekt_Art_ZL_Signalgruppe" literal="ZL_Signalgruppe"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_ZL_SIGNALGRUPPE_VALUE = 150;

	/**
	 * The '<em><b>ENUMLST Objekt Art ZL Signalgruppe Zuordnung</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ZL_SIGNALGRUPPE_ZUORDNUNG
	 * @model name="ENUMLST_Objekt_Art_ZL_Signalgruppe_Zuordnung" literal="ZL_Signalgruppe_Zuordnung"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_ZL_SIGNALGRUPPE_ZUORDNUNG_VALUE = 151;

	/**
	 * The '<em><b>ENUMLST Objekt Art ZLV Bus</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ZLV_BUS
	 * @model name="ENUMLST_Objekt_Art_ZLV_Bus" literal="ZLV_Bus"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_ZLV_BUS_VALUE = 152;

	/**
	 * The '<em><b>ENUMLST Objekt Art ZLV Bus Besondere Anlage</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ZLV_BUS_BESONDERE_ANLAGE
	 * @model name="ENUMLST_Objekt_Art_ZLV_Bus_Besondere_Anlage" literal="ZLV_Bus_Besondere_Anlage"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_ZLV_BUS_BESONDERE_ANLAGE_VALUE = 153;

	/**
	 * The '<em><b>ENUMLST Objekt Art ZLV Bus US Zuordnung</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ZLV_BUS_US_ZUORDNUNG
	 * @model name="ENUMLST_Objekt_Art_ZLV_Bus_US_Zuordnung" literal="ZLV_Bus_US_Zuordnung"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_ZLV_BUS_US_ZUORDNUNG_VALUE = 154;

	/**
	 * The '<em><b>ENUMLST Objekt Art ZN</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ZN
	 * @model name="ENUMLST_Objekt_Art_ZN" literal="ZN"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_ZN_VALUE = 155;

	/**
	 * The '<em><b>ENUMLST Objekt Art ZN Akustik</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ZN_AKUSTIK
	 * @model name="ENUMLST_Objekt_Art_ZN_Akustik" literal="ZN_Akustik"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_ZN_AKUSTIK_VALUE = 156;

	/**
	 * The '<em><b>ENUMLST Objekt Art ZN Anzeigefeld</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ZN_ANZEIGEFELD
	 * @model name="ENUMLST_Objekt_Art_ZN_Anzeigefeld" literal="ZN_Anzeigefeld"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_ZN_ANZEIGEFELD_VALUE = 157;

	/**
	 * The '<em><b>ENUMLST Objekt Art ZN Fortschalt Kriterium</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ZN_FORTSCHALT_KRITERIUM
	 * @model name="ENUMLST_Objekt_Art_ZN_Fortschalt_Kriterium" literal="ZN_Fortschalt_Kriterium"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_ZN_FORTSCHALT_KRITERIUM_VALUE = 158;

	/**
	 * The '<em><b>ENUMLST Objekt Art ZN Telegramm 84 Zuordnung</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ZN_TELEGRAMM_84_ZUORDNUNG
	 * @model name="ENUMLST_Objekt_Art_ZN_Telegramm_84_Zuordnung" literal="ZN_Telegramm_84_Zuordnung"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_ZN_TELEGRAMM_84_ZUORDNUNG_VALUE = 159;

	/**
	 * The '<em><b>ENUMLST Objekt Art ZN Telegramm 85 Zuordnung</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ZN_TELEGRAMM_85_ZUORDNUNG
	 * @model name="ENUMLST_Objekt_Art_ZN_Telegramm_85_Zuordnung" literal="ZN_Telegramm_85_Zuordnung"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_ZN_TELEGRAMM_85_ZUORDNUNG_VALUE = 160;

	/**
	 * The '<em><b>ENUMLST Objekt Art ZN Unterstation</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ZN_UNTERSTATION
	 * @model name="ENUMLST_Objekt_Art_ZN_Unterstation" literal="ZN_Unterstation"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_ZN_UNTERSTATION_VALUE = 161;

	/**
	 * The '<em><b>ENUMLST Objekt Art ZN ZBS</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ZN_ZBS
	 * @model name="ENUMLST_Objekt_Art_ZN_ZBS" literal="ZN_ZBS"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_ZN_ZBS_VALUE = 162;

	/**
	 * The '<em><b>ENUMLST Objekt Art ZUB Bereichsgrenze</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ZUB_BEREICHSGRENZE
	 * @model name="ENUMLST_Objekt_Art_ZUB_Bereichsgrenze" literal="ZUB_Bereichsgrenze"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_ZUB_BEREICHSGRENZE_VALUE = 163;

	/**
	 * The '<em><b>ENUMLST Objekt Art ZUB Streckeneigenschaft</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ZUB_STRECKENEIGENSCHAFT
	 * @model name="ENUMLST_Objekt_Art_ZUB_Streckeneigenschaft" literal="ZUB_Streckeneigenschaft"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_ZUB_STRECKENEIGENSCHAFT_VALUE = 164;

	/**
	 * The '<em><b>ENUMLST Objekt Art Zugeinwirkung</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMLST_OBJEKT_ART_ZUGEINWIRKUNG
	 * @model name="ENUMLST_Objekt_Art_Zugeinwirkung" literal="Zugeinwirkung"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMLST_OBJEKT_ART_ZUGEINWIRKUNG_VALUE = 165;

	/**
	 * An array of all the '<em><b>ENUMLST Objekt Art</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final ENUMLSTObjektArt[] VALUES_ARRAY =
		new ENUMLSTObjektArt[] {
			ENUMLST_OBJEKT_ART_ANHANG,
			ENUMLST_OBJEKT_ART_ATO_SEGMENT_PROFILE,
			ENUMLST_OBJEKT_ART_ATO_TIMING_POINT,
			ENUMLST_OBJEKT_ART_ATO_TS_INSTANZ,
			ENUMLST_OBJEKT_ART_AUSSENELEMENTANSTEUERUNG,
			ENUMLST_OBJEKT_ART_BAHNSTEIG_ANLAGE,
			ENUMLST_OBJEKT_ART_BAHNSTEIG_DACH,
			ENUMLST_OBJEKT_ART_BAHNSTEIG_KANTE,
			ENUMLST_OBJEKT_ART_BAHNSTEIG_ZUGANG,
			ENUMLST_OBJEKT_ART_BALISE,
			ENUMLST_OBJEKT_ART_BEARBEITUNGSVERMERK,
			ENUMLST_OBJEKT_ART_BEDIEN_ANRUECKABSCHNITT,
			ENUMLST_OBJEKT_ART_BEDIEN_ANZEIGE_ELEMENT,
			ENUMLST_OBJEKT_ART_BEDIEN_BEZIRK,
			ENUMLST_OBJEKT_ART_BEDIEN_EINRICHTUNG_OERTLICH,
			ENUMLST_OBJEKT_ART_BEDIEN_GBT,
			ENUMLST_OBJEKT_ART_BEDIEN_OBERFLAECHE,
			ENUMLST_OBJEKT_ART_BEDIEN_OBERFLAECHE_BILD,
			ENUMLST_OBJEKT_ART_BEDIEN_OERTLICHKEIT,
			ENUMLST_OBJEKT_ART_BEDIEN_PLATZ,
			ENUMLST_OBJEKT_ART_BEDIEN_STANDORT,
			ENUMLST_OBJEKT_ART_BEDIEN_ZENTRALE,
			ENUMLST_OBJEKT_ART_BINAERDATEN,
			ENUMLST_OBJEKT_ART_BLOCK_ANLAGE,
			ENUMLST_OBJEKT_ART_BLOCK_ELEMENT,
			ENUMLST_OBJEKT_ART_BLOCK_STRECKE,
			ENUMLST_OBJEKT_ART_BUE_ANLAGE,
			ENUMLST_OBJEKT_ART_BUE_ANLAGE_STRASSE,
			ENUMLST_OBJEKT_ART_BUE_ANLAGE_V,
			ENUMLST_OBJEKT_ART_BUE_AUSSCHALTUNG,
			ENUMLST_OBJEKT_ART_BUE_BEDIEN_ANZEIGE_ELEMENT,
			ENUMLST_OBJEKT_ART_BUE_DECKENDES_SIGNAL_ZUORDNUNG,
			ENUMLST_OBJEKT_ART_BUE_EINSCHALTUNG,
			ENUMLST_OBJEKT_ART_BUE_EINSCHALTUNG_ZUORDNUNG,
			ENUMLST_OBJEKT_ART_BUE_GEFAHRRAUM_ECKPUNKT,
			ENUMLST_OBJEKT_ART_BUE_GLEISBEZOGENER_GEFAHRRAUM,
			ENUMLST_OBJEKT_ART_BUE_KANTE,
			ENUMLST_OBJEKT_ART_BUE_KREUZUNGSPLAN,
			ENUMLST_OBJEKT_ART_BUE_SCHNITTSTELLE,
			ENUMLST_OBJEKT_ART_BUE_SPEZIFISCHES_SIGNAL,
			ENUMLST_OBJEKT_ART_BUE_WS_FSTR_ZUORDNUNG,
			ENUMLST_OBJEKT_ART_DATENPUNKT,
			ENUMLST_OBJEKT_ART_DATENPUNKT_LINK,
			ENUMLST_OBJEKT_ART_ESTW_ZENTRALEINHEIT,
			ENUMLST_OBJEKT_ART_ETCS_KANTE,
			ENUMLST_OBJEKT_ART_ETCS_KNOTEN,
			ENUMLST_OBJEKT_ART_ETCS_RICHTUNGSANZEIGE,
			ENUMLST_OBJEKT_ART_ETCS_SIGNAL,
			ENUMLST_OBJEKT_ART_ETCS_WKR,
			ENUMLST_OBJEKT_ART_EV_MODUL,
			ENUMLST_OBJEKT_ART_FACHTELEGRAMM,
			ENUMLST_OBJEKT_ART_FLA_FREIMELDE_ZUORDNUNG,
			ENUMLST_OBJEKT_ART_FLA_SCHUTZ,
			ENUMLST_OBJEKT_ART_FLA_ZWIESCHUTZ,
			ENUMLST_OBJEKT_ART_FMA_ANLAGE,
			ENUMLST_OBJEKT_ART_FMA_ELEMENT,
			ENUMLST_OBJEKT_ART_FMA_KOMPONENTE,
			ENUMLST_OBJEKT_ART_FSTR_ABHAENGIGKEIT,
			ENUMLST_OBJEKT_ART_FSTR_ANEINANDER,
			ENUMLST_OBJEKT_ART_FSTR_ANEINANDER_ZUORDNUNG,
			ENUMLST_OBJEKT_ART_FSTR_DWEG,
			ENUMLST_OBJEKT_ART_FSTR_DWEG_WKR,
			ENUMLST_OBJEKT_ART_FSTR_FAHRWEG,
			ENUMLST_OBJEKT_ART_FSTR_NICHTHALTFALL,
			ENUMLST_OBJEKT_ART_FSTR_RANGIER_FLA_ZUORDNUNG,
			ENUMLST_OBJEKT_ART_FSTR_SIGNALISIERUNG,
			ENUMLST_OBJEKT_ART_FSTR_UMFAHRPUNKT,
			ENUMLST_OBJEKT_ART_FSTR_ZUG_RANGIER,
			ENUMLST_OBJEKT_ART_FT_ANSCHALTBEDINGUNG,
			ENUMLST_OBJEKT_ART_FT_FAHRWEG_TEIL,
			ENUMLST_OBJEKT_ART_GEO_KANTE,
			ENUMLST_OBJEKT_ART_GEO_KNOTEN,
			ENUMLST_OBJEKT_ART_GEO_PUNKT,
			ENUMLST_OBJEKT_ART_GESCHWINDIGKEITSPROFIL,
			ENUMLST_OBJEKT_ART_GFR_ANLAGE,
			ENUMLST_OBJEKT_ART_GFR_ELEMENT,
			ENUMLST_OBJEKT_ART_GFR_TRIPELSPIEGEL,
			ENUMLST_OBJEKT_ART_GLEIS_ABSCHLUSS,
			ENUMLST_OBJEKT_ART_GLEIS_ABSCHNITT,
			ENUMLST_OBJEKT_ART_GLEIS_ART,
			ENUMLST_OBJEKT_ART_GLEIS_BAUBEREICH,
			ENUMLST_OBJEKT_ART_GLEIS_BEZEICHNUNG,
			ENUMLST_OBJEKT_ART_GLEIS_FAHRBAHN,
			ENUMLST_OBJEKT_ART_GLEIS_LICHTRAUM,
			ENUMLST_OBJEKT_ART_GLEIS_SCHALTGRUPPE,
			ENUMLST_OBJEKT_ART_HOEHENLINIE,
			ENUMLST_OBJEKT_ART_HOEHENPUNKT,
			ENUMLST_OBJEKT_ART_KABEL,
			ENUMLST_OBJEKT_ART_KABEL_VERTEILPUNKT,
			ENUMLST_OBJEKT_ART_LEU_ANLAGE,
			ENUMLST_OBJEKT_ART_LEU_MODUL,
			ENUMLST_OBJEKT_ART_LEU_SCHALTKASTEN,
			ENUMLST_OBJEKT_ART_LIEFEROBJEKT,
			ENUMLST_OBJEKT_ART_LUFT_TELEGRAMM,
			ENUMLST_OBJEKT_ART_MARKANTER_PUNKT,
			ENUMLST_OBJEKT_ART_NB,
			ENUMLST_OBJEKT_ART_NB_BEDIEN_ANZEIGE_ELEMENT,
			ENUMLST_OBJEKT_ART_NB_ZONE,
			ENUMLST_OBJEKT_ART_NB_ZONE_ELEMENT,
			ENUMLST_OBJEKT_ART_NB_ZONE_GRENZE,
			ENUMLST_OBJEKT_ART_OERTLICHKEIT,
			ENUMLST_OBJEKT_ART_PROG_DATEI_GRUPPE,
			ENUMLST_OBJEKT_ART_PZB_ELEMENT,
			ENUMLST_OBJEKT_ART_PZB_ELEMENT_ZUORDNUNG,
			ENUMLST_OBJEKT_ART_PZB_ZUORDNUNG_SIGNAL,
			ENUMLST_OBJEKT_ART_RBC,
			ENUMLST_OBJEKT_ART_REGELZEICHNUNG,
			ENUMLST_OBJEKT_ART_REGELZEICHNUNG_PARAMETER,
			ENUMLST_OBJEKT_ART_SCHALTMITTEL_FSTR_ZUORDNUNG,
			ENUMLST_OBJEKT_ART_SCHALTMITTEL_ZUORDNUNG,
			ENUMLST_OBJEKT_ART_SCHLOSS,
			ENUMLST_OBJEKT_ART_SCHLOSSKOMBINATION,
			ENUMLST_OBJEKT_ART_SCHLUESSEL,
			ENUMLST_OBJEKT_ART_SCHLUESSELSPERRE,
			ENUMLST_OBJEKT_ART_SCHRANKENANTRIEB,
			ENUMLST_OBJEKT_ART_SIGNAL,
			ENUMLST_OBJEKT_ART_SIGNAL_BEFESTIGUNG,
			ENUMLST_OBJEKT_ART_SIGNAL_FANK_ZUORDNUNG,
			ENUMLST_OBJEKT_ART_SIGNAL_RAHMEN,
			ENUMLST_OBJEKT_ART_SIGNAL_SIGNALBEGRIFF,
			ENUMLST_OBJEKT_ART_SONSTIGER_PUNKT,
			ENUMLST_OBJEKT_ART_STELL_BEREICH,
			ENUMLST_OBJEKT_ART_STELLELEMENT,
			ENUMLST_OBJEKT_ART_STRECKE,
			ENUMLST_OBJEKT_ART_STRECKE_BREMSWEG,
			ENUMLST_OBJEKT_ART_STRECKE_PUNKT,
			ENUMLST_OBJEKT_ART_TECHNIK_STANDORT,
			ENUMLST_OBJEKT_ART_TECHNISCHER_BEREICH,
			ENUMLST_OBJEKT_ART_TECHNISCHER_PUNKT,
			ENUMLST_OBJEKT_ART_TOP_KANTE,
			ENUMLST_OBJEKT_ART_TOP_KNOTEN,
			ENUMLST_OBJEKT_ART_TRASSE_KANTE,
			ENUMLST_OBJEKT_ART_TRASSE_KNOTEN,
			ENUMLST_OBJEKT_ART_UEBERHOEHUNG,
			ENUMLST_OBJEKT_ART_UEBERHOEHUNGSLINIE,
			ENUMLST_OBJEKT_ART_UEBERTRAGUNGSWEG,
			ENUMLST_OBJEKT_ART_UNTERBRINGUNG,
			ENUMLST_OBJEKT_ART_VERKEHRSZEICHEN,
			ENUMLST_OBJEKT_ART_WKR_ANLAGE,
			ENUMLST_OBJEKT_ART_WKR_GSP_ELEMENT,
			ENUMLST_OBJEKT_ART_WKR_GSP_KOMPONENTE,
			ENUMLST_OBJEKT_ART_WEICHENLAUFKETTE,
			ENUMLST_OBJEKT_ART_WEICHENLAUFKETTE_ZUORDNUNG,
			ENUMLST_OBJEKT_ART_ZBS_SCHUTZSTRECKE,
			ENUMLST_OBJEKT_ART_ZBS_SIGNAL,
			ENUMLST_OBJEKT_ART_ZL,
			ENUMLST_OBJEKT_ART_ZL_DLP_ABSCHNITT,
			ENUMLST_OBJEKT_ART_ZL_DLP_FSTR,
			ENUMLST_OBJEKT_ART_ZL_FSTR,
			ENUMLST_OBJEKT_ART_ZL_FSTR_ANSTOSS,
			ENUMLST_OBJEKT_ART_ZL_SIGNALGRUPPE,
			ENUMLST_OBJEKT_ART_ZL_SIGNALGRUPPE_ZUORDNUNG,
			ENUMLST_OBJEKT_ART_ZLV_BUS,
			ENUMLST_OBJEKT_ART_ZLV_BUS_BESONDERE_ANLAGE,
			ENUMLST_OBJEKT_ART_ZLV_BUS_US_ZUORDNUNG,
			ENUMLST_OBJEKT_ART_ZN,
			ENUMLST_OBJEKT_ART_ZN_AKUSTIK,
			ENUMLST_OBJEKT_ART_ZN_ANZEIGEFELD,
			ENUMLST_OBJEKT_ART_ZN_FORTSCHALT_KRITERIUM,
			ENUMLST_OBJEKT_ART_ZN_TELEGRAMM_84_ZUORDNUNG,
			ENUMLST_OBJEKT_ART_ZN_TELEGRAMM_85_ZUORDNUNG,
			ENUMLST_OBJEKT_ART_ZN_UNTERSTATION,
			ENUMLST_OBJEKT_ART_ZN_ZBS,
			ENUMLST_OBJEKT_ART_ZUB_BEREICHSGRENZE,
			ENUMLST_OBJEKT_ART_ZUB_STRECKENEIGENSCHAFT,
			ENUMLST_OBJEKT_ART_ZUGEINWIRKUNG,
		};

	/**
	 * A public read-only list of all the '<em><b>ENUMLST Objekt Art</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<ENUMLSTObjektArt> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>ENUMLST Objekt Art</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param literal the literal.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMLSTObjektArt get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ENUMLSTObjektArt result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>ENUMLST Objekt Art</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param name the name.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMLSTObjektArt getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ENUMLSTObjektArt result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>ENUMLST Objekt Art</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the integer value.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMLSTObjektArt get(int value) {
		switch (value) {
			case ENUMLST_OBJEKT_ART_ANHANG_VALUE: return ENUMLST_OBJEKT_ART_ANHANG;
			case ENUMLST_OBJEKT_ART_ATO_SEGMENT_PROFILE_VALUE: return ENUMLST_OBJEKT_ART_ATO_SEGMENT_PROFILE;
			case ENUMLST_OBJEKT_ART_ATO_TIMING_POINT_VALUE: return ENUMLST_OBJEKT_ART_ATO_TIMING_POINT;
			case ENUMLST_OBJEKT_ART_ATO_TS_INSTANZ_VALUE: return ENUMLST_OBJEKT_ART_ATO_TS_INSTANZ;
			case ENUMLST_OBJEKT_ART_AUSSENELEMENTANSTEUERUNG_VALUE: return ENUMLST_OBJEKT_ART_AUSSENELEMENTANSTEUERUNG;
			case ENUMLST_OBJEKT_ART_BAHNSTEIG_ANLAGE_VALUE: return ENUMLST_OBJEKT_ART_BAHNSTEIG_ANLAGE;
			case ENUMLST_OBJEKT_ART_BAHNSTEIG_DACH_VALUE: return ENUMLST_OBJEKT_ART_BAHNSTEIG_DACH;
			case ENUMLST_OBJEKT_ART_BAHNSTEIG_KANTE_VALUE: return ENUMLST_OBJEKT_ART_BAHNSTEIG_KANTE;
			case ENUMLST_OBJEKT_ART_BAHNSTEIG_ZUGANG_VALUE: return ENUMLST_OBJEKT_ART_BAHNSTEIG_ZUGANG;
			case ENUMLST_OBJEKT_ART_BALISE_VALUE: return ENUMLST_OBJEKT_ART_BALISE;
			case ENUMLST_OBJEKT_ART_BEARBEITUNGSVERMERK_VALUE: return ENUMLST_OBJEKT_ART_BEARBEITUNGSVERMERK;
			case ENUMLST_OBJEKT_ART_BEDIEN_ANRUECKABSCHNITT_VALUE: return ENUMLST_OBJEKT_ART_BEDIEN_ANRUECKABSCHNITT;
			case ENUMLST_OBJEKT_ART_BEDIEN_ANZEIGE_ELEMENT_VALUE: return ENUMLST_OBJEKT_ART_BEDIEN_ANZEIGE_ELEMENT;
			case ENUMLST_OBJEKT_ART_BEDIEN_BEZIRK_VALUE: return ENUMLST_OBJEKT_ART_BEDIEN_BEZIRK;
			case ENUMLST_OBJEKT_ART_BEDIEN_EINRICHTUNG_OERTLICH_VALUE: return ENUMLST_OBJEKT_ART_BEDIEN_EINRICHTUNG_OERTLICH;
			case ENUMLST_OBJEKT_ART_BEDIEN_GBT_VALUE: return ENUMLST_OBJEKT_ART_BEDIEN_GBT;
			case ENUMLST_OBJEKT_ART_BEDIEN_OBERFLAECHE_VALUE: return ENUMLST_OBJEKT_ART_BEDIEN_OBERFLAECHE;
			case ENUMLST_OBJEKT_ART_BEDIEN_OBERFLAECHE_BILD_VALUE: return ENUMLST_OBJEKT_ART_BEDIEN_OBERFLAECHE_BILD;
			case ENUMLST_OBJEKT_ART_BEDIEN_OERTLICHKEIT_VALUE: return ENUMLST_OBJEKT_ART_BEDIEN_OERTLICHKEIT;
			case ENUMLST_OBJEKT_ART_BEDIEN_PLATZ_VALUE: return ENUMLST_OBJEKT_ART_BEDIEN_PLATZ;
			case ENUMLST_OBJEKT_ART_BEDIEN_STANDORT_VALUE: return ENUMLST_OBJEKT_ART_BEDIEN_STANDORT;
			case ENUMLST_OBJEKT_ART_BEDIEN_ZENTRALE_VALUE: return ENUMLST_OBJEKT_ART_BEDIEN_ZENTRALE;
			case ENUMLST_OBJEKT_ART_BINAERDATEN_VALUE: return ENUMLST_OBJEKT_ART_BINAERDATEN;
			case ENUMLST_OBJEKT_ART_BLOCK_ANLAGE_VALUE: return ENUMLST_OBJEKT_ART_BLOCK_ANLAGE;
			case ENUMLST_OBJEKT_ART_BLOCK_ELEMENT_VALUE: return ENUMLST_OBJEKT_ART_BLOCK_ELEMENT;
			case ENUMLST_OBJEKT_ART_BLOCK_STRECKE_VALUE: return ENUMLST_OBJEKT_ART_BLOCK_STRECKE;
			case ENUMLST_OBJEKT_ART_BUE_ANLAGE_VALUE: return ENUMLST_OBJEKT_ART_BUE_ANLAGE;
			case ENUMLST_OBJEKT_ART_BUE_ANLAGE_STRASSE_VALUE: return ENUMLST_OBJEKT_ART_BUE_ANLAGE_STRASSE;
			case ENUMLST_OBJEKT_ART_BUE_ANLAGE_V_VALUE: return ENUMLST_OBJEKT_ART_BUE_ANLAGE_V;
			case ENUMLST_OBJEKT_ART_BUE_AUSSCHALTUNG_VALUE: return ENUMLST_OBJEKT_ART_BUE_AUSSCHALTUNG;
			case ENUMLST_OBJEKT_ART_BUE_BEDIEN_ANZEIGE_ELEMENT_VALUE: return ENUMLST_OBJEKT_ART_BUE_BEDIEN_ANZEIGE_ELEMENT;
			case ENUMLST_OBJEKT_ART_BUE_DECKENDES_SIGNAL_ZUORDNUNG_VALUE: return ENUMLST_OBJEKT_ART_BUE_DECKENDES_SIGNAL_ZUORDNUNG;
			case ENUMLST_OBJEKT_ART_BUE_EINSCHALTUNG_VALUE: return ENUMLST_OBJEKT_ART_BUE_EINSCHALTUNG;
			case ENUMLST_OBJEKT_ART_BUE_EINSCHALTUNG_ZUORDNUNG_VALUE: return ENUMLST_OBJEKT_ART_BUE_EINSCHALTUNG_ZUORDNUNG;
			case ENUMLST_OBJEKT_ART_BUE_GEFAHRRAUM_ECKPUNKT_VALUE: return ENUMLST_OBJEKT_ART_BUE_GEFAHRRAUM_ECKPUNKT;
			case ENUMLST_OBJEKT_ART_BUE_GLEISBEZOGENER_GEFAHRRAUM_VALUE: return ENUMLST_OBJEKT_ART_BUE_GLEISBEZOGENER_GEFAHRRAUM;
			case ENUMLST_OBJEKT_ART_BUE_KANTE_VALUE: return ENUMLST_OBJEKT_ART_BUE_KANTE;
			case ENUMLST_OBJEKT_ART_BUE_KREUZUNGSPLAN_VALUE: return ENUMLST_OBJEKT_ART_BUE_KREUZUNGSPLAN;
			case ENUMLST_OBJEKT_ART_BUE_SCHNITTSTELLE_VALUE: return ENUMLST_OBJEKT_ART_BUE_SCHNITTSTELLE;
			case ENUMLST_OBJEKT_ART_BUE_SPEZIFISCHES_SIGNAL_VALUE: return ENUMLST_OBJEKT_ART_BUE_SPEZIFISCHES_SIGNAL;
			case ENUMLST_OBJEKT_ART_BUE_WS_FSTR_ZUORDNUNG_VALUE: return ENUMLST_OBJEKT_ART_BUE_WS_FSTR_ZUORDNUNG;
			case ENUMLST_OBJEKT_ART_DATENPUNKT_VALUE: return ENUMLST_OBJEKT_ART_DATENPUNKT;
			case ENUMLST_OBJEKT_ART_DATENPUNKT_LINK_VALUE: return ENUMLST_OBJEKT_ART_DATENPUNKT_LINK;
			case ENUMLST_OBJEKT_ART_ESTW_ZENTRALEINHEIT_VALUE: return ENUMLST_OBJEKT_ART_ESTW_ZENTRALEINHEIT;
			case ENUMLST_OBJEKT_ART_ETCS_KANTE_VALUE: return ENUMLST_OBJEKT_ART_ETCS_KANTE;
			case ENUMLST_OBJEKT_ART_ETCS_KNOTEN_VALUE: return ENUMLST_OBJEKT_ART_ETCS_KNOTEN;
			case ENUMLST_OBJEKT_ART_ETCS_RICHTUNGSANZEIGE_VALUE: return ENUMLST_OBJEKT_ART_ETCS_RICHTUNGSANZEIGE;
			case ENUMLST_OBJEKT_ART_ETCS_SIGNAL_VALUE: return ENUMLST_OBJEKT_ART_ETCS_SIGNAL;
			case ENUMLST_OBJEKT_ART_ETCS_WKR_VALUE: return ENUMLST_OBJEKT_ART_ETCS_WKR;
			case ENUMLST_OBJEKT_ART_EV_MODUL_VALUE: return ENUMLST_OBJEKT_ART_EV_MODUL;
			case ENUMLST_OBJEKT_ART_FACHTELEGRAMM_VALUE: return ENUMLST_OBJEKT_ART_FACHTELEGRAMM;
			case ENUMLST_OBJEKT_ART_FLA_FREIMELDE_ZUORDNUNG_VALUE: return ENUMLST_OBJEKT_ART_FLA_FREIMELDE_ZUORDNUNG;
			case ENUMLST_OBJEKT_ART_FLA_SCHUTZ_VALUE: return ENUMLST_OBJEKT_ART_FLA_SCHUTZ;
			case ENUMLST_OBJEKT_ART_FLA_ZWIESCHUTZ_VALUE: return ENUMLST_OBJEKT_ART_FLA_ZWIESCHUTZ;
			case ENUMLST_OBJEKT_ART_FMA_ANLAGE_VALUE: return ENUMLST_OBJEKT_ART_FMA_ANLAGE;
			case ENUMLST_OBJEKT_ART_FMA_ELEMENT_VALUE: return ENUMLST_OBJEKT_ART_FMA_ELEMENT;
			case ENUMLST_OBJEKT_ART_FMA_KOMPONENTE_VALUE: return ENUMLST_OBJEKT_ART_FMA_KOMPONENTE;
			case ENUMLST_OBJEKT_ART_FSTR_ABHAENGIGKEIT_VALUE: return ENUMLST_OBJEKT_ART_FSTR_ABHAENGIGKEIT;
			case ENUMLST_OBJEKT_ART_FSTR_ANEINANDER_VALUE: return ENUMLST_OBJEKT_ART_FSTR_ANEINANDER;
			case ENUMLST_OBJEKT_ART_FSTR_ANEINANDER_ZUORDNUNG_VALUE: return ENUMLST_OBJEKT_ART_FSTR_ANEINANDER_ZUORDNUNG;
			case ENUMLST_OBJEKT_ART_FSTR_DWEG_VALUE: return ENUMLST_OBJEKT_ART_FSTR_DWEG;
			case ENUMLST_OBJEKT_ART_FSTR_DWEG_WKR_VALUE: return ENUMLST_OBJEKT_ART_FSTR_DWEG_WKR;
			case ENUMLST_OBJEKT_ART_FSTR_FAHRWEG_VALUE: return ENUMLST_OBJEKT_ART_FSTR_FAHRWEG;
			case ENUMLST_OBJEKT_ART_FSTR_NICHTHALTFALL_VALUE: return ENUMLST_OBJEKT_ART_FSTR_NICHTHALTFALL;
			case ENUMLST_OBJEKT_ART_FSTR_RANGIER_FLA_ZUORDNUNG_VALUE: return ENUMLST_OBJEKT_ART_FSTR_RANGIER_FLA_ZUORDNUNG;
			case ENUMLST_OBJEKT_ART_FSTR_SIGNALISIERUNG_VALUE: return ENUMLST_OBJEKT_ART_FSTR_SIGNALISIERUNG;
			case ENUMLST_OBJEKT_ART_FSTR_UMFAHRPUNKT_VALUE: return ENUMLST_OBJEKT_ART_FSTR_UMFAHRPUNKT;
			case ENUMLST_OBJEKT_ART_FSTR_ZUG_RANGIER_VALUE: return ENUMLST_OBJEKT_ART_FSTR_ZUG_RANGIER;
			case ENUMLST_OBJEKT_ART_FT_ANSCHALTBEDINGUNG_VALUE: return ENUMLST_OBJEKT_ART_FT_ANSCHALTBEDINGUNG;
			case ENUMLST_OBJEKT_ART_FT_FAHRWEG_TEIL_VALUE: return ENUMLST_OBJEKT_ART_FT_FAHRWEG_TEIL;
			case ENUMLST_OBJEKT_ART_GEO_KANTE_VALUE: return ENUMLST_OBJEKT_ART_GEO_KANTE;
			case ENUMLST_OBJEKT_ART_GEO_KNOTEN_VALUE: return ENUMLST_OBJEKT_ART_GEO_KNOTEN;
			case ENUMLST_OBJEKT_ART_GEO_PUNKT_VALUE: return ENUMLST_OBJEKT_ART_GEO_PUNKT;
			case ENUMLST_OBJEKT_ART_GESCHWINDIGKEITSPROFIL_VALUE: return ENUMLST_OBJEKT_ART_GESCHWINDIGKEITSPROFIL;
			case ENUMLST_OBJEKT_ART_GFR_ANLAGE_VALUE: return ENUMLST_OBJEKT_ART_GFR_ANLAGE;
			case ENUMLST_OBJEKT_ART_GFR_ELEMENT_VALUE: return ENUMLST_OBJEKT_ART_GFR_ELEMENT;
			case ENUMLST_OBJEKT_ART_GFR_TRIPELSPIEGEL_VALUE: return ENUMLST_OBJEKT_ART_GFR_TRIPELSPIEGEL;
			case ENUMLST_OBJEKT_ART_GLEIS_ABSCHLUSS_VALUE: return ENUMLST_OBJEKT_ART_GLEIS_ABSCHLUSS;
			case ENUMLST_OBJEKT_ART_GLEIS_ABSCHNITT_VALUE: return ENUMLST_OBJEKT_ART_GLEIS_ABSCHNITT;
			case ENUMLST_OBJEKT_ART_GLEIS_ART_VALUE: return ENUMLST_OBJEKT_ART_GLEIS_ART;
			case ENUMLST_OBJEKT_ART_GLEIS_BAUBEREICH_VALUE: return ENUMLST_OBJEKT_ART_GLEIS_BAUBEREICH;
			case ENUMLST_OBJEKT_ART_GLEIS_BEZEICHNUNG_VALUE: return ENUMLST_OBJEKT_ART_GLEIS_BEZEICHNUNG;
			case ENUMLST_OBJEKT_ART_GLEIS_FAHRBAHN_VALUE: return ENUMLST_OBJEKT_ART_GLEIS_FAHRBAHN;
			case ENUMLST_OBJEKT_ART_GLEIS_LICHTRAUM_VALUE: return ENUMLST_OBJEKT_ART_GLEIS_LICHTRAUM;
			case ENUMLST_OBJEKT_ART_GLEIS_SCHALTGRUPPE_VALUE: return ENUMLST_OBJEKT_ART_GLEIS_SCHALTGRUPPE;
			case ENUMLST_OBJEKT_ART_HOEHENLINIE_VALUE: return ENUMLST_OBJEKT_ART_HOEHENLINIE;
			case ENUMLST_OBJEKT_ART_HOEHENPUNKT_VALUE: return ENUMLST_OBJEKT_ART_HOEHENPUNKT;
			case ENUMLST_OBJEKT_ART_KABEL_VALUE: return ENUMLST_OBJEKT_ART_KABEL;
			case ENUMLST_OBJEKT_ART_KABEL_VERTEILPUNKT_VALUE: return ENUMLST_OBJEKT_ART_KABEL_VERTEILPUNKT;
			case ENUMLST_OBJEKT_ART_LEU_ANLAGE_VALUE: return ENUMLST_OBJEKT_ART_LEU_ANLAGE;
			case ENUMLST_OBJEKT_ART_LEU_MODUL_VALUE: return ENUMLST_OBJEKT_ART_LEU_MODUL;
			case ENUMLST_OBJEKT_ART_LEU_SCHALTKASTEN_VALUE: return ENUMLST_OBJEKT_ART_LEU_SCHALTKASTEN;
			case ENUMLST_OBJEKT_ART_LIEFEROBJEKT_VALUE: return ENUMLST_OBJEKT_ART_LIEFEROBJEKT;
			case ENUMLST_OBJEKT_ART_LUFT_TELEGRAMM_VALUE: return ENUMLST_OBJEKT_ART_LUFT_TELEGRAMM;
			case ENUMLST_OBJEKT_ART_MARKANTER_PUNKT_VALUE: return ENUMLST_OBJEKT_ART_MARKANTER_PUNKT;
			case ENUMLST_OBJEKT_ART_NB_VALUE: return ENUMLST_OBJEKT_ART_NB;
			case ENUMLST_OBJEKT_ART_NB_BEDIEN_ANZEIGE_ELEMENT_VALUE: return ENUMLST_OBJEKT_ART_NB_BEDIEN_ANZEIGE_ELEMENT;
			case ENUMLST_OBJEKT_ART_NB_ZONE_VALUE: return ENUMLST_OBJEKT_ART_NB_ZONE;
			case ENUMLST_OBJEKT_ART_NB_ZONE_ELEMENT_VALUE: return ENUMLST_OBJEKT_ART_NB_ZONE_ELEMENT;
			case ENUMLST_OBJEKT_ART_NB_ZONE_GRENZE_VALUE: return ENUMLST_OBJEKT_ART_NB_ZONE_GRENZE;
			case ENUMLST_OBJEKT_ART_OERTLICHKEIT_VALUE: return ENUMLST_OBJEKT_ART_OERTLICHKEIT;
			case ENUMLST_OBJEKT_ART_PROG_DATEI_GRUPPE_VALUE: return ENUMLST_OBJEKT_ART_PROG_DATEI_GRUPPE;
			case ENUMLST_OBJEKT_ART_PZB_ELEMENT_VALUE: return ENUMLST_OBJEKT_ART_PZB_ELEMENT;
			case ENUMLST_OBJEKT_ART_PZB_ELEMENT_ZUORDNUNG_VALUE: return ENUMLST_OBJEKT_ART_PZB_ELEMENT_ZUORDNUNG;
			case ENUMLST_OBJEKT_ART_PZB_ZUORDNUNG_SIGNAL_VALUE: return ENUMLST_OBJEKT_ART_PZB_ZUORDNUNG_SIGNAL;
			case ENUMLST_OBJEKT_ART_RBC_VALUE: return ENUMLST_OBJEKT_ART_RBC;
			case ENUMLST_OBJEKT_ART_REGELZEICHNUNG_VALUE: return ENUMLST_OBJEKT_ART_REGELZEICHNUNG;
			case ENUMLST_OBJEKT_ART_REGELZEICHNUNG_PARAMETER_VALUE: return ENUMLST_OBJEKT_ART_REGELZEICHNUNG_PARAMETER;
			case ENUMLST_OBJEKT_ART_SCHALTMITTEL_FSTR_ZUORDNUNG_VALUE: return ENUMLST_OBJEKT_ART_SCHALTMITTEL_FSTR_ZUORDNUNG;
			case ENUMLST_OBJEKT_ART_SCHALTMITTEL_ZUORDNUNG_VALUE: return ENUMLST_OBJEKT_ART_SCHALTMITTEL_ZUORDNUNG;
			case ENUMLST_OBJEKT_ART_SCHLOSS_VALUE: return ENUMLST_OBJEKT_ART_SCHLOSS;
			case ENUMLST_OBJEKT_ART_SCHLOSSKOMBINATION_VALUE: return ENUMLST_OBJEKT_ART_SCHLOSSKOMBINATION;
			case ENUMLST_OBJEKT_ART_SCHLUESSEL_VALUE: return ENUMLST_OBJEKT_ART_SCHLUESSEL;
			case ENUMLST_OBJEKT_ART_SCHLUESSELSPERRE_VALUE: return ENUMLST_OBJEKT_ART_SCHLUESSELSPERRE;
			case ENUMLST_OBJEKT_ART_SCHRANKENANTRIEB_VALUE: return ENUMLST_OBJEKT_ART_SCHRANKENANTRIEB;
			case ENUMLST_OBJEKT_ART_SIGNAL_VALUE: return ENUMLST_OBJEKT_ART_SIGNAL;
			case ENUMLST_OBJEKT_ART_SIGNAL_BEFESTIGUNG_VALUE: return ENUMLST_OBJEKT_ART_SIGNAL_BEFESTIGUNG;
			case ENUMLST_OBJEKT_ART_SIGNAL_FANK_ZUORDNUNG_VALUE: return ENUMLST_OBJEKT_ART_SIGNAL_FANK_ZUORDNUNG;
			case ENUMLST_OBJEKT_ART_SIGNAL_RAHMEN_VALUE: return ENUMLST_OBJEKT_ART_SIGNAL_RAHMEN;
			case ENUMLST_OBJEKT_ART_SIGNAL_SIGNALBEGRIFF_VALUE: return ENUMLST_OBJEKT_ART_SIGNAL_SIGNALBEGRIFF;
			case ENUMLST_OBJEKT_ART_SONSTIGER_PUNKT_VALUE: return ENUMLST_OBJEKT_ART_SONSTIGER_PUNKT;
			case ENUMLST_OBJEKT_ART_STELL_BEREICH_VALUE: return ENUMLST_OBJEKT_ART_STELL_BEREICH;
			case ENUMLST_OBJEKT_ART_STELLELEMENT_VALUE: return ENUMLST_OBJEKT_ART_STELLELEMENT;
			case ENUMLST_OBJEKT_ART_STRECKE_VALUE: return ENUMLST_OBJEKT_ART_STRECKE;
			case ENUMLST_OBJEKT_ART_STRECKE_BREMSWEG_VALUE: return ENUMLST_OBJEKT_ART_STRECKE_BREMSWEG;
			case ENUMLST_OBJEKT_ART_STRECKE_PUNKT_VALUE: return ENUMLST_OBJEKT_ART_STRECKE_PUNKT;
			case ENUMLST_OBJEKT_ART_TECHNIK_STANDORT_VALUE: return ENUMLST_OBJEKT_ART_TECHNIK_STANDORT;
			case ENUMLST_OBJEKT_ART_TECHNISCHER_BEREICH_VALUE: return ENUMLST_OBJEKT_ART_TECHNISCHER_BEREICH;
			case ENUMLST_OBJEKT_ART_TECHNISCHER_PUNKT_VALUE: return ENUMLST_OBJEKT_ART_TECHNISCHER_PUNKT;
			case ENUMLST_OBJEKT_ART_TOP_KANTE_VALUE: return ENUMLST_OBJEKT_ART_TOP_KANTE;
			case ENUMLST_OBJEKT_ART_TOP_KNOTEN_VALUE: return ENUMLST_OBJEKT_ART_TOP_KNOTEN;
			case ENUMLST_OBJEKT_ART_TRASSE_KANTE_VALUE: return ENUMLST_OBJEKT_ART_TRASSE_KANTE;
			case ENUMLST_OBJEKT_ART_TRASSE_KNOTEN_VALUE: return ENUMLST_OBJEKT_ART_TRASSE_KNOTEN;
			case ENUMLST_OBJEKT_ART_UEBERHOEHUNG_VALUE: return ENUMLST_OBJEKT_ART_UEBERHOEHUNG;
			case ENUMLST_OBJEKT_ART_UEBERHOEHUNGSLINIE_VALUE: return ENUMLST_OBJEKT_ART_UEBERHOEHUNGSLINIE;
			case ENUMLST_OBJEKT_ART_UEBERTRAGUNGSWEG_VALUE: return ENUMLST_OBJEKT_ART_UEBERTRAGUNGSWEG;
			case ENUMLST_OBJEKT_ART_UNTERBRINGUNG_VALUE: return ENUMLST_OBJEKT_ART_UNTERBRINGUNG;
			case ENUMLST_OBJEKT_ART_VERKEHRSZEICHEN_VALUE: return ENUMLST_OBJEKT_ART_VERKEHRSZEICHEN;
			case ENUMLST_OBJEKT_ART_WKR_ANLAGE_VALUE: return ENUMLST_OBJEKT_ART_WKR_ANLAGE;
			case ENUMLST_OBJEKT_ART_WKR_GSP_ELEMENT_VALUE: return ENUMLST_OBJEKT_ART_WKR_GSP_ELEMENT;
			case ENUMLST_OBJEKT_ART_WKR_GSP_KOMPONENTE_VALUE: return ENUMLST_OBJEKT_ART_WKR_GSP_KOMPONENTE;
			case ENUMLST_OBJEKT_ART_WEICHENLAUFKETTE_VALUE: return ENUMLST_OBJEKT_ART_WEICHENLAUFKETTE;
			case ENUMLST_OBJEKT_ART_WEICHENLAUFKETTE_ZUORDNUNG_VALUE: return ENUMLST_OBJEKT_ART_WEICHENLAUFKETTE_ZUORDNUNG;
			case ENUMLST_OBJEKT_ART_ZBS_SCHUTZSTRECKE_VALUE: return ENUMLST_OBJEKT_ART_ZBS_SCHUTZSTRECKE;
			case ENUMLST_OBJEKT_ART_ZBS_SIGNAL_VALUE: return ENUMLST_OBJEKT_ART_ZBS_SIGNAL;
			case ENUMLST_OBJEKT_ART_ZL_VALUE: return ENUMLST_OBJEKT_ART_ZL;
			case ENUMLST_OBJEKT_ART_ZL_DLP_ABSCHNITT_VALUE: return ENUMLST_OBJEKT_ART_ZL_DLP_ABSCHNITT;
			case ENUMLST_OBJEKT_ART_ZL_DLP_FSTR_VALUE: return ENUMLST_OBJEKT_ART_ZL_DLP_FSTR;
			case ENUMLST_OBJEKT_ART_ZL_FSTR_VALUE: return ENUMLST_OBJEKT_ART_ZL_FSTR;
			case ENUMLST_OBJEKT_ART_ZL_FSTR_ANSTOSS_VALUE: return ENUMLST_OBJEKT_ART_ZL_FSTR_ANSTOSS;
			case ENUMLST_OBJEKT_ART_ZL_SIGNALGRUPPE_VALUE: return ENUMLST_OBJEKT_ART_ZL_SIGNALGRUPPE;
			case ENUMLST_OBJEKT_ART_ZL_SIGNALGRUPPE_ZUORDNUNG_VALUE: return ENUMLST_OBJEKT_ART_ZL_SIGNALGRUPPE_ZUORDNUNG;
			case ENUMLST_OBJEKT_ART_ZLV_BUS_VALUE: return ENUMLST_OBJEKT_ART_ZLV_BUS;
			case ENUMLST_OBJEKT_ART_ZLV_BUS_BESONDERE_ANLAGE_VALUE: return ENUMLST_OBJEKT_ART_ZLV_BUS_BESONDERE_ANLAGE;
			case ENUMLST_OBJEKT_ART_ZLV_BUS_US_ZUORDNUNG_VALUE: return ENUMLST_OBJEKT_ART_ZLV_BUS_US_ZUORDNUNG;
			case ENUMLST_OBJEKT_ART_ZN_VALUE: return ENUMLST_OBJEKT_ART_ZN;
			case ENUMLST_OBJEKT_ART_ZN_AKUSTIK_VALUE: return ENUMLST_OBJEKT_ART_ZN_AKUSTIK;
			case ENUMLST_OBJEKT_ART_ZN_ANZEIGEFELD_VALUE: return ENUMLST_OBJEKT_ART_ZN_ANZEIGEFELD;
			case ENUMLST_OBJEKT_ART_ZN_FORTSCHALT_KRITERIUM_VALUE: return ENUMLST_OBJEKT_ART_ZN_FORTSCHALT_KRITERIUM;
			case ENUMLST_OBJEKT_ART_ZN_TELEGRAMM_84_ZUORDNUNG_VALUE: return ENUMLST_OBJEKT_ART_ZN_TELEGRAMM_84_ZUORDNUNG;
			case ENUMLST_OBJEKT_ART_ZN_TELEGRAMM_85_ZUORDNUNG_VALUE: return ENUMLST_OBJEKT_ART_ZN_TELEGRAMM_85_ZUORDNUNG;
			case ENUMLST_OBJEKT_ART_ZN_UNTERSTATION_VALUE: return ENUMLST_OBJEKT_ART_ZN_UNTERSTATION;
			case ENUMLST_OBJEKT_ART_ZN_ZBS_VALUE: return ENUMLST_OBJEKT_ART_ZN_ZBS;
			case ENUMLST_OBJEKT_ART_ZUB_BEREICHSGRENZE_VALUE: return ENUMLST_OBJEKT_ART_ZUB_BEREICHSGRENZE;
			case ENUMLST_OBJEKT_ART_ZUB_STRECKENEIGENSCHAFT_VALUE: return ENUMLST_OBJEKT_ART_ZUB_STRECKENEIGENSCHAFT;
			case ENUMLST_OBJEKT_ART_ZUGEINWIRKUNG_VALUE: return ENUMLST_OBJEKT_ART_ZUGEINWIRKUNG;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private ENUMLSTObjektArt(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
	
} //ENUMLSTObjektArt
