/**
 * Copyright (c) 2023 DB Netz AG and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 * 
 */
package org.eclipse.set.model.model11001.Bahnuebergang;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>ENUMBUE Technik</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see org.eclipse.set.model.model11001.Bahnuebergang.BahnuebergangPackage#getENUMBUETechnik()
 * @model extendedMetaData="name='ENUMBUE_Technik'"
 * @generated
 */
public enum ENUMBUETechnik implements Enumerator {
	/**
	 * The '<em><b>ENUMBUE Technik Anrufschranke</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_TECHNIK_ANRUFSCHRANKE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMBUE_TECHNIK_ANRUFSCHRANKE(0, "ENUMBUE_Technik_Anrufschranke", "Anrufschranke"),

	/**
	 * The '<em><b>ENUMBUE Technik BUEP 93</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_TECHNIK_BUEP_93_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMBUE_TECHNIK_BUEP_93(1, "ENUMBUE_Technik_BUEP_93", "BUEP_93"),

	/**
	 * The '<em><b>ENUMBUE Technik BUES 72D</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_TECHNIK_BUES_72D_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMBUE_TECHNIK_BUES_72D(2, "ENUMBUE_Technik_BUES_72D", "BUES_72D"),

	/**
	 * The '<em><b>ENUMBUE Technik BUES 72Z</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_TECHNIK_BUES_72Z_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMBUE_TECHNIK_BUES_72Z(3, "ENUMBUE_Technik_BUES_72Z", "BUES_72Z"),

	/**
	 * The '<em><b>ENUMBUE Technik BUES2000</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_TECHNIK_BUES2000_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMBUE_TECHNIK_BUES2000(4, "ENUMBUE_Technik_BUES2000", "BUES2000"),

	/**
	 * The '<em><b>ENUMBUE Technik EBUET 80</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_TECHNIK_EBUET_80_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMBUE_TECHNIK_EBUET_80(5, "ENUMBUE_Technik_EBUET_80", "EBUET_80"),

	/**
	 * The '<em><b>ENUMBUE Technik EBUET 80 VB</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_TECHNIK_EBUET_80_VB_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMBUE_TECHNIK_EBUET_80_VB(6, "ENUMBUE_Technik_EBUET_80_VB", "EBUET_80_VB"),

	/**
	 * The '<em><b>ENUMBUE Technik FUE 58</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_TECHNIK_FUE_58_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMBUE_TECHNIK_FUE_58(7, "ENUMBUE_Technik_FUE_58", "FUE_58"),

	/**
	 * The '<em><b>ENUMBUE Technik FUE 60</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_TECHNIK_FUE_60_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMBUE_TECHNIK_FUE_60(8, "ENUMBUE_Technik_FUE_60", "FUE_60"),

	/**
	 * The '<em><b>ENUMBUE Technik HL 64 B</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_TECHNIK_HL_64_B_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMBUE_TECHNIK_HL_64_B(9, "ENUMBUE_Technik_HL_64_B", "HL_64_B"),

	/**
	 * The '<em><b>ENUMBUE Technik HL 64 C</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_TECHNIK_HL_64_C_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMBUE_TECHNIK_HL_64_C(10, "ENUMBUE_Technik_HL_64_C", "HL_64_C"),

	/**
	 * The '<em><b>ENUMBUE Technik HS 64 B</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_TECHNIK_HS_64_B_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMBUE_TECHNIK_HS_64_B(11, "ENUMBUE_Technik_HS_64_B", "HS_64_B"),

	/**
	 * The '<em><b>ENUMBUE Technik HS 64 C</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_TECHNIK_HS_64_C_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMBUE_TECHNIK_HS_64_C(12, "ENUMBUE_Technik_HS_64_C", "HS_64_C"),

	/**
	 * The '<em><b>ENUMBUE Technik keine</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_TECHNIK_KEINE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMBUE_TECHNIK_KEINE(13, "ENUMBUE_Technik_keine", "keine"),

	/**
	 * The '<em><b>ENUMBUE Technik LO1</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_TECHNIK_LO1_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMBUE_TECHNIK_LO1(14, "ENUMBUE_Technik_LO1", "LO1"),

	/**
	 * The '<em><b>ENUMBUE Technik LO1 57</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_TECHNIK_LO1_57_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMBUE_TECHNIK_LO1_57(15, "ENUMBUE_Technik_LO1_57", "LO1_57"),

	/**
	 * The '<em><b>ENUMBUE Technik NE BUE 90</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_TECHNIK_NE_BUE_90_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMBUE_TECHNIK_NE_BUE_90(16, "ENUMBUE_Technik_NE_BUE_90", "NE_BUE_90"),

	/**
	 * The '<em><b>ENUMBUE Technik RBUEP</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_TECHNIK_RBUEP_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMBUE_TECHNIK_RBUEP(17, "ENUMBUE_Technik_RBUEP", "RBUEP"),

	/**
	 * The '<em><b>ENUMBUE Technik RBUET</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_TECHNIK_RBUET_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMBUE_TECHNIK_RBUET(18, "ENUMBUE_Technik_RBUET", "RBUET"),

	/**
	 * The '<em><b>ENUMBUE Technik SIMIS LC</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_TECHNIK_SIMIS_LC_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMBUE_TECHNIK_SIMIS_LC(19, "ENUMBUE_Technik_SIMIS_LC", "SIMIS_LC"),

	/**
	 * The '<em><b>ENUMBUE Technik sonstige</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_TECHNIK_SONSTIGE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMBUE_TECHNIK_SONSTIGE(20, "ENUMBUE_Technik_sonstige", "sonstige");

	/**
	 * The '<em><b>ENUMBUE Technik Anrufschranke</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_TECHNIK_ANRUFSCHRANKE
	 * @model name="ENUMBUE_Technik_Anrufschranke" literal="Anrufschranke"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMBUE_TECHNIK_ANRUFSCHRANKE_VALUE = 0;

	/**
	 * The '<em><b>ENUMBUE Technik BUEP 93</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_TECHNIK_BUEP_93
	 * @model name="ENUMBUE_Technik_BUEP_93" literal="BUEP_93"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMBUE_TECHNIK_BUEP_93_VALUE = 1;

	/**
	 * The '<em><b>ENUMBUE Technik BUES 72D</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_TECHNIK_BUES_72D
	 * @model name="ENUMBUE_Technik_BUES_72D" literal="BUES_72D"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMBUE_TECHNIK_BUES_72D_VALUE = 2;

	/**
	 * The '<em><b>ENUMBUE Technik BUES 72Z</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_TECHNIK_BUES_72Z
	 * @model name="ENUMBUE_Technik_BUES_72Z" literal="BUES_72Z"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMBUE_TECHNIK_BUES_72Z_VALUE = 3;

	/**
	 * The '<em><b>ENUMBUE Technik BUES2000</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_TECHNIK_BUES2000
	 * @model name="ENUMBUE_Technik_BUES2000" literal="BUES2000"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMBUE_TECHNIK_BUES2000_VALUE = 4;

	/**
	 * The '<em><b>ENUMBUE Technik EBUET 80</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_TECHNIK_EBUET_80
	 * @model name="ENUMBUE_Technik_EBUET_80" literal="EBUET_80"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMBUE_TECHNIK_EBUET_80_VALUE = 5;

	/**
	 * The '<em><b>ENUMBUE Technik EBUET 80 VB</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_TECHNIK_EBUET_80_VB
	 * @model name="ENUMBUE_Technik_EBUET_80_VB" literal="EBUET_80_VB"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMBUE_TECHNIK_EBUET_80_VB_VALUE = 6;

	/**
	 * The '<em><b>ENUMBUE Technik FUE 58</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_TECHNIK_FUE_58
	 * @model name="ENUMBUE_Technik_FUE_58" literal="FUE_58"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMBUE_TECHNIK_FUE_58_VALUE = 7;

	/**
	 * The '<em><b>ENUMBUE Technik FUE 60</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_TECHNIK_FUE_60
	 * @model name="ENUMBUE_Technik_FUE_60" literal="FUE_60"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMBUE_TECHNIK_FUE_60_VALUE = 8;

	/**
	 * The '<em><b>ENUMBUE Technik HL 64 B</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_TECHNIK_HL_64_B
	 * @model name="ENUMBUE_Technik_HL_64_B" literal="HL_64_B"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMBUE_TECHNIK_HL_64_B_VALUE = 9;

	/**
	 * The '<em><b>ENUMBUE Technik HL 64 C</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_TECHNIK_HL_64_C
	 * @model name="ENUMBUE_Technik_HL_64_C" literal="HL_64_C"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMBUE_TECHNIK_HL_64_C_VALUE = 10;

	/**
	 * The '<em><b>ENUMBUE Technik HS 64 B</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_TECHNIK_HS_64_B
	 * @model name="ENUMBUE_Technik_HS_64_B" literal="HS_64_B"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMBUE_TECHNIK_HS_64_B_VALUE = 11;

	/**
	 * The '<em><b>ENUMBUE Technik HS 64 C</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_TECHNIK_HS_64_C
	 * @model name="ENUMBUE_Technik_HS_64_C" literal="HS_64_C"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMBUE_TECHNIK_HS_64_C_VALUE = 12;

	/**
	 * The '<em><b>ENUMBUE Technik keine</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_TECHNIK_KEINE
	 * @model name="ENUMBUE_Technik_keine" literal="keine"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMBUE_TECHNIK_KEINE_VALUE = 13;

	/**
	 * The '<em><b>ENUMBUE Technik LO1</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_TECHNIK_LO1
	 * @model name="ENUMBUE_Technik_LO1" literal="LO1"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMBUE_TECHNIK_LO1_VALUE = 14;

	/**
	 * The '<em><b>ENUMBUE Technik LO1 57</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_TECHNIK_LO1_57
	 * @model name="ENUMBUE_Technik_LO1_57" literal="LO1_57"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMBUE_TECHNIK_LO1_57_VALUE = 15;

	/**
	 * The '<em><b>ENUMBUE Technik NE BUE 90</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_TECHNIK_NE_BUE_90
	 * @model name="ENUMBUE_Technik_NE_BUE_90" literal="NE_BUE_90"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMBUE_TECHNIK_NE_BUE_90_VALUE = 16;

	/**
	 * The '<em><b>ENUMBUE Technik RBUEP</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_TECHNIK_RBUEP
	 * @model name="ENUMBUE_Technik_RBUEP" literal="RBUEP"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMBUE_TECHNIK_RBUEP_VALUE = 17;

	/**
	 * The '<em><b>ENUMBUE Technik RBUET</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_TECHNIK_RBUET
	 * @model name="ENUMBUE_Technik_RBUET" literal="RBUET"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMBUE_TECHNIK_RBUET_VALUE = 18;

	/**
	 * The '<em><b>ENUMBUE Technik SIMIS LC</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_TECHNIK_SIMIS_LC
	 * @model name="ENUMBUE_Technik_SIMIS_LC" literal="SIMIS_LC"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMBUE_TECHNIK_SIMIS_LC_VALUE = 19;

	/**
	 * The '<em><b>ENUMBUE Technik sonstige</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_TECHNIK_SONSTIGE
	 * @model name="ENUMBUE_Technik_sonstige" literal="sonstige"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMBUE_TECHNIK_SONSTIGE_VALUE = 20;

	/**
	 * An array of all the '<em><b>ENUMBUE Technik</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final ENUMBUETechnik[] VALUES_ARRAY =
		new ENUMBUETechnik[] {
			ENUMBUE_TECHNIK_ANRUFSCHRANKE,
			ENUMBUE_TECHNIK_BUEP_93,
			ENUMBUE_TECHNIK_BUES_72D,
			ENUMBUE_TECHNIK_BUES_72Z,
			ENUMBUE_TECHNIK_BUES2000,
			ENUMBUE_TECHNIK_EBUET_80,
			ENUMBUE_TECHNIK_EBUET_80_VB,
			ENUMBUE_TECHNIK_FUE_58,
			ENUMBUE_TECHNIK_FUE_60,
			ENUMBUE_TECHNIK_HL_64_B,
			ENUMBUE_TECHNIK_HL_64_C,
			ENUMBUE_TECHNIK_HS_64_B,
			ENUMBUE_TECHNIK_HS_64_C,
			ENUMBUE_TECHNIK_KEINE,
			ENUMBUE_TECHNIK_LO1,
			ENUMBUE_TECHNIK_LO1_57,
			ENUMBUE_TECHNIK_NE_BUE_90,
			ENUMBUE_TECHNIK_RBUEP,
			ENUMBUE_TECHNIK_RBUET,
			ENUMBUE_TECHNIK_SIMIS_LC,
			ENUMBUE_TECHNIK_SONSTIGE,
		};

	/**
	 * A public read-only list of all the '<em><b>ENUMBUE Technik</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<ENUMBUETechnik> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>ENUMBUE Technik</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param literal the literal.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMBUETechnik get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ENUMBUETechnik result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>ENUMBUE Technik</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param name the name.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMBUETechnik getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ENUMBUETechnik result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>ENUMBUE Technik</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the integer value.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMBUETechnik get(int value) {
		switch (value) {
			case ENUMBUE_TECHNIK_ANRUFSCHRANKE_VALUE: return ENUMBUE_TECHNIK_ANRUFSCHRANKE;
			case ENUMBUE_TECHNIK_BUEP_93_VALUE: return ENUMBUE_TECHNIK_BUEP_93;
			case ENUMBUE_TECHNIK_BUES_72D_VALUE: return ENUMBUE_TECHNIK_BUES_72D;
			case ENUMBUE_TECHNIK_BUES_72Z_VALUE: return ENUMBUE_TECHNIK_BUES_72Z;
			case ENUMBUE_TECHNIK_BUES2000_VALUE: return ENUMBUE_TECHNIK_BUES2000;
			case ENUMBUE_TECHNIK_EBUET_80_VALUE: return ENUMBUE_TECHNIK_EBUET_80;
			case ENUMBUE_TECHNIK_EBUET_80_VB_VALUE: return ENUMBUE_TECHNIK_EBUET_80_VB;
			case ENUMBUE_TECHNIK_FUE_58_VALUE: return ENUMBUE_TECHNIK_FUE_58;
			case ENUMBUE_TECHNIK_FUE_60_VALUE: return ENUMBUE_TECHNIK_FUE_60;
			case ENUMBUE_TECHNIK_HL_64_B_VALUE: return ENUMBUE_TECHNIK_HL_64_B;
			case ENUMBUE_TECHNIK_HL_64_C_VALUE: return ENUMBUE_TECHNIK_HL_64_C;
			case ENUMBUE_TECHNIK_HS_64_B_VALUE: return ENUMBUE_TECHNIK_HS_64_B;
			case ENUMBUE_TECHNIK_HS_64_C_VALUE: return ENUMBUE_TECHNIK_HS_64_C;
			case ENUMBUE_TECHNIK_KEINE_VALUE: return ENUMBUE_TECHNIK_KEINE;
			case ENUMBUE_TECHNIK_LO1_VALUE: return ENUMBUE_TECHNIK_LO1;
			case ENUMBUE_TECHNIK_LO1_57_VALUE: return ENUMBUE_TECHNIK_LO1_57;
			case ENUMBUE_TECHNIK_NE_BUE_90_VALUE: return ENUMBUE_TECHNIK_NE_BUE_90;
			case ENUMBUE_TECHNIK_RBUEP_VALUE: return ENUMBUE_TECHNIK_RBUEP;
			case ENUMBUE_TECHNIK_RBUET_VALUE: return ENUMBUE_TECHNIK_RBUET;
			case ENUMBUE_TECHNIK_SIMIS_LC_VALUE: return ENUMBUE_TECHNIK_SIMIS_LC;
			case ENUMBUE_TECHNIK_SONSTIGE_VALUE: return ENUMBUE_TECHNIK_SONSTIGE;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private ENUMBUETechnik(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
	
} //ENUMBUETechnik
