/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.toolboxmodel.transform.internal;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;

public abstract class AbstractEObjectTransformation {
    protected EObject transform(EObject source) {
        if (source == null) {
            return null;
        }
        EClass targetClass = this.getMatchingEClass(source.eClass());
        EObject target = EcoreUtil.create((EClass)targetClass);
        source.eClass().getEAllStructuralFeatures().stream().forEach(feature -> {
            EStructuralFeature targetFeature = targetClass.getEStructuralFeature(feature.getName());
            if (feature instanceof EAttribute var6_7) {
                AbstractEObjectTransformation.transformAttribute(source, target, (EAttribute)sourceAttribute, (EAttribute)targetFeature);
            } else {
                if (feature instanceof EReference var8_9 && targetFeature != null) {
                    this.transformReference(source, target, (EReference)sourceReference, (EReference)targetFeature);
                }
            }
        });
        return target;
    }

    protected static void transformAttribute(EObject source, EObject target, EAttribute sourceAttr, EAttribute targetAttr) {
        Object sourceValue = source.eGet((EStructuralFeature)sourceAttr);
        if (sourceValue == null && sourceAttr.isUnsettable() && source.eIsSet((EStructuralFeature)sourceAttr)) {
            target.eSet((EStructuralFeature)targetAttr, null);
        } else if (sourceValue != null && sourceValue != sourceAttr.getDefaultValue()) {
            EDataType sourceAttributeType = sourceAttr.getEAttributeType();
            EDataType targetAttributeType = targetAttr.getEAttributeType();
            if (!sourceAttributeType.getInstanceClass().equals(FeatureMap.Entry.class)) {
                String sourceStringValue = EcoreUtil.convertToString((EDataType)sourceAttributeType, (Object)sourceValue);
                target.eSet((EStructuralFeature)targetAttr, EcoreUtil.createFromString((EDataType)targetAttributeType, (String)sourceStringValue));
            }
        }
    }

    protected EStructuralFeature getMatchingEStructuralFeature(EStructuralFeature source) {
        EClass sourceClass = source.getEContainingClass();
        EClass targetClass = this.getMatchingEClass(sourceClass);
        return targetClass.getEStructuralFeature(source.getName());
    }

    protected EClass getMatchingEClass(EClass source) {
        EPackage sourcePackage = source.getEPackage();
        EPackage targetPackage = this.getMatchingEPackage(sourcePackage);
        return (EClass)targetPackage.getEClassifier(source.getName());
    }

    protected EPackage getMatchingEPackage(EPackage source) {
        EPackage.Registry registry = EPackage.Registry.INSTANCE;
        String nsUri = this.getTargetNamespace(source.getNsURI());
        for (String key : registry.keySet()) {
            EPackage ePackage = registry.getEPackage(key);
            if (!ePackage.getNsURI().equals(nsUri)) continue;
            return ePackage;
        }
        throw new IllegalArgumentException("No matching EPackage found for " + nsUri);
    }

    protected void transformReference(EObject source, EObject target, EReference sourceRef, EReference targetRef) {
        if (!sourceRef.isMany()) {
            EObject sourceValue = (EObject)source.eGet((EStructuralFeature)sourceRef);
            if (sourceValue == null) {
                if (source.eIsSet((EStructuralFeature)sourceRef) && sourceRef.isUnsettable()) {
                    target.eSet((EStructuralFeature)targetRef, null);
                }
                return;
            }
            EObject targetValue = this.transform(sourceValue);
            target.eSet((EStructuralFeature)targetRef, (Object)targetValue);
        } else {
            EList list = (EList)source.eGet((EStructuralFeature)sourceRef);
            EList targetList = (EList)target.eGet((EStructuralFeature)targetRef);
            list.forEach(entry -> {
                EObject targetValue = this.transform((EObject)entry);
                targetList.add((Object)targetValue);
            });
        }
    }

    protected abstract String getTargetNamespace(String var1);
}

