/**
 * Copyright (c) 2022 DB Netz AG and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 */
package org.eclipse.set.model.model1902.Verweise.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import org.eclipse.set.model.model1902.Verweise.util.VerweiseAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class VerweiseItemProviderAdapterFactory extends VerweiseAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public VerweiseItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Anforderer_Element_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Anforderer_Element_TypeClassItemProvider iD_Anforderer_Element_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Anforderer_Element_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Anforderer_Element_TypeClassAdapter() {
		if (iD_Anforderer_Element_TypeClassItemProvider == null) {
			iD_Anforderer_Element_TypeClassItemProvider = new ID_Anforderer_Element_TypeClassItemProvider(this);
		}

		return iD_Anforderer_Element_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Anforderung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Anforderung_TypeClassItemProvider iD_Anforderung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Anforderung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Anforderung_TypeClassAdapter() {
		if (iD_Anforderung_TypeClassItemProvider == null) {
			iD_Anforderung_TypeClassItemProvider = new ID_Anforderung_TypeClassItemProvider(this);
		}

		return iD_Anforderung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Anhang_ohne_Proxy_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Anhang_ohne_Proxy_TypeClassItemProvider iD_Anhang_ohne_Proxy_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Anhang_ohne_Proxy_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Anhang_ohne_Proxy_TypeClassAdapter() {
		if (iD_Anhang_ohne_Proxy_TypeClassItemProvider == null) {
			iD_Anhang_ohne_Proxy_TypeClassItemProvider = new ID_Anhang_ohne_Proxy_TypeClassItemProvider(this);
		}

		return iD_Anhang_ohne_Proxy_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Anhang_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Anhang_TypeClassItemProvider iD_Anhang_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Anhang_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Anhang_TypeClassAdapter() {
		if (iD_Anhang_TypeClassItemProvider == null) {
			iD_Anhang_TypeClassItemProvider = new ID_Anhang_TypeClassItemProvider(this);
		}

		return iD_Anhang_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Anschluss_Element_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Anschluss_Element_TypeClassItemProvider iD_Anschluss_Element_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Anschluss_Element_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Anschluss_Element_TypeClassAdapter() {
		if (iD_Anschluss_Element_TypeClassItemProvider == null) {
			iD_Anschluss_Element_TypeClassItemProvider = new ID_Anschluss_Element_TypeClassItemProvider(this);
		}

		return iD_Anschluss_Element_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Ausgabe_Fachdaten_ohne_Proxy_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Ausgabe_Fachdaten_ohne_Proxy_TypeClassItemProvider iD_Ausgabe_Fachdaten_ohne_Proxy_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Ausgabe_Fachdaten_ohne_Proxy_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Ausgabe_Fachdaten_ohne_Proxy_TypeClassAdapter() {
		if (iD_Ausgabe_Fachdaten_ohne_Proxy_TypeClassItemProvider == null) {
			iD_Ausgabe_Fachdaten_ohne_Proxy_TypeClassItemProvider = new ID_Ausgabe_Fachdaten_ohne_Proxy_TypeClassItemProvider(this);
		}

		return iD_Ausgabe_Fachdaten_ohne_Proxy_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Aussenelementansteuerung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Aussenelementansteuerung_TypeClassItemProvider iD_Aussenelementansteuerung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Aussenelementansteuerung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Aussenelementansteuerung_TypeClassAdapter() {
		if (iD_Aussenelementansteuerung_TypeClassItemProvider == null) {
			iD_Aussenelementansteuerung_TypeClassItemProvider = new ID_Aussenelementansteuerung_TypeClassItemProvider(this);
		}

		return iD_Aussenelementansteuerung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Bahnsteig_Anlage_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Bahnsteig_Anlage_TypeClassItemProvider iD_Bahnsteig_Anlage_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Bahnsteig_Anlage_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Bahnsteig_Anlage_TypeClassAdapter() {
		if (iD_Bahnsteig_Anlage_TypeClassItemProvider == null) {
			iD_Bahnsteig_Anlage_TypeClassItemProvider = new ID_Bahnsteig_Anlage_TypeClassItemProvider(this);
		}

		return iD_Bahnsteig_Anlage_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Bahnsteig_Kante_ohne_Proxy_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Bahnsteig_Kante_ohne_Proxy_TypeClassItemProvider iD_Bahnsteig_Kante_ohne_Proxy_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Bahnsteig_Kante_ohne_Proxy_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Bahnsteig_Kante_ohne_Proxy_TypeClassAdapter() {
		if (iD_Bahnsteig_Kante_ohne_Proxy_TypeClassItemProvider == null) {
			iD_Bahnsteig_Kante_ohne_Proxy_TypeClassItemProvider = new ID_Bahnsteig_Kante_ohne_Proxy_TypeClassItemProvider(this);
		}

		return iD_Bahnsteig_Kante_ohne_Proxy_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Bahnsteig_Kante_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Bahnsteig_Kante_TypeClassItemProvider iD_Bahnsteig_Kante_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Bahnsteig_Kante_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Bahnsteig_Kante_TypeClassAdapter() {
		if (iD_Bahnsteig_Kante_TypeClassItemProvider == null) {
			iD_Bahnsteig_Kante_TypeClassItemProvider = new ID_Bahnsteig_Kante_TypeClassItemProvider(this);
		}

		return iD_Bahnsteig_Kante_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Balise_ohne_Proxy_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Balise_ohne_Proxy_TypeClassItemProvider iD_Balise_ohne_Proxy_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Balise_ohne_Proxy_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Balise_ohne_Proxy_TypeClassAdapter() {
		if (iD_Balise_ohne_Proxy_TypeClassItemProvider == null) {
			iD_Balise_ohne_Proxy_TypeClassItemProvider = new ID_Balise_ohne_Proxy_TypeClassItemProvider(this);
		}

		return iD_Balise_ohne_Proxy_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Balise_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Balise_TypeClassItemProvider iD_Balise_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Balise_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Balise_TypeClassAdapter() {
		if (iD_Balise_TypeClassItemProvider == null) {
			iD_Balise_TypeClassItemProvider = new ID_Balise_TypeClassItemProvider(this);
		}

		return iD_Balise_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Basis_Objekt_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Basis_Objekt_TypeClassItemProvider iD_Basis_Objekt_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Basis_Objekt_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Basis_Objekt_TypeClassAdapter() {
		if (iD_Basis_Objekt_TypeClassItemProvider == null) {
			iD_Basis_Objekt_TypeClassItemProvider = new ID_Basis_Objekt_TypeClassItemProvider(this);
		}

		return iD_Basis_Objekt_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Bearbeitungsvermerk_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Bearbeitungsvermerk_TypeClassItemProvider iD_Bearbeitungsvermerk_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Bearbeitungsvermerk_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Bearbeitungsvermerk_TypeClassAdapter() {
		if (iD_Bearbeitungsvermerk_TypeClassItemProvider == null) {
			iD_Bearbeitungsvermerk_TypeClassItemProvider = new ID_Bearbeitungsvermerk_TypeClassItemProvider(this);
		}

		return iD_Bearbeitungsvermerk_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Bedien_Anzeige_Element_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Bedien_Anzeige_Element_TypeClassItemProvider iD_Bedien_Anzeige_Element_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Bedien_Anzeige_Element_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Bedien_Anzeige_Element_TypeClassAdapter() {
		if (iD_Bedien_Anzeige_Element_TypeClassItemProvider == null) {
			iD_Bedien_Anzeige_Element_TypeClassItemProvider = new ID_Bedien_Anzeige_Element_TypeClassItemProvider(this);
		}

		return iD_Bedien_Anzeige_Element_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Bedien_Bezirk_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Bedien_Bezirk_TypeClassItemProvider iD_Bedien_Bezirk_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Bedien_Bezirk_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Bedien_Bezirk_TypeClassAdapter() {
		if (iD_Bedien_Bezirk_TypeClassItemProvider == null) {
			iD_Bedien_Bezirk_TypeClassItemProvider = new ID_Bedien_Bezirk_TypeClassItemProvider(this);
		}

		return iD_Bedien_Bezirk_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Bedien_Einrichtung_Oertlich_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Bedien_Einrichtung_Oertlich_TypeClassItemProvider iD_Bedien_Einrichtung_Oertlich_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Bedien_Einrichtung_Oertlich_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Bedien_Einrichtung_Oertlich_TypeClassAdapter() {
		if (iD_Bedien_Einrichtung_Oertlich_TypeClassItemProvider == null) {
			iD_Bedien_Einrichtung_Oertlich_TypeClassItemProvider = new ID_Bedien_Einrichtung_Oertlich_TypeClassItemProvider(this);
		}

		return iD_Bedien_Einrichtung_Oertlich_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Bedien_Oberflaeche_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Bedien_Oberflaeche_TypeClassItemProvider iD_Bedien_Oberflaeche_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Bedien_Oberflaeche_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Bedien_Oberflaeche_TypeClassAdapter() {
		if (iD_Bedien_Oberflaeche_TypeClassItemProvider == null) {
			iD_Bedien_Oberflaeche_TypeClassItemProvider = new ID_Bedien_Oberflaeche_TypeClassItemProvider(this);
		}

		return iD_Bedien_Oberflaeche_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Bedien_Standort_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Bedien_Standort_TypeClassItemProvider iD_Bedien_Standort_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Bedien_Standort_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Bedien_Standort_TypeClassAdapter() {
		if (iD_Bedien_Standort_TypeClassItemProvider == null) {
			iD_Bedien_Standort_TypeClassItemProvider = new ID_Bedien_Standort_TypeClassItemProvider(this);
		}

		return iD_Bedien_Standort_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Bedien_Zentrale_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Bedien_Zentrale_TypeClassItemProvider iD_Bedien_Zentrale_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Bedien_Zentrale_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Bedien_Zentrale_TypeClassAdapter() {
		if (iD_Bedien_Zentrale_TypeClassItemProvider == null) {
			iD_Bedien_Zentrale_TypeClassItemProvider = new ID_Bedien_Zentrale_TypeClassItemProvider(this);
		}

		return iD_Bedien_Zentrale_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Beginn_Bereich_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Beginn_Bereich_TypeClassItemProvider iD_Beginn_Bereich_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Beginn_Bereich_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Beginn_Bereich_TypeClassAdapter() {
		if (iD_Beginn_Bereich_TypeClassItemProvider == null) {
			iD_Beginn_Bereich_TypeClassItemProvider = new ID_Beginn_Bereich_TypeClassItemProvider(this);
		}

		return iD_Beginn_Bereich_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Binaerdatei_ohne_Proxy_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Binaerdatei_ohne_Proxy_TypeClassItemProvider iD_Binaerdatei_ohne_Proxy_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Binaerdatei_ohne_Proxy_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Binaerdatei_ohne_Proxy_TypeClassAdapter() {
		if (iD_Binaerdatei_ohne_Proxy_TypeClassItemProvider == null) {
			iD_Binaerdatei_ohne_Proxy_TypeClassItemProvider = new ID_Binaerdatei_ohne_Proxy_TypeClassItemProvider(this);
		}

		return iD_Binaerdatei_ohne_Proxy_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Block_Anlage_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Block_Anlage_TypeClassItemProvider iD_Block_Anlage_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Block_Anlage_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Block_Anlage_TypeClassAdapter() {
		if (iD_Block_Anlage_TypeClassItemProvider == null) {
			iD_Block_Anlage_TypeClassItemProvider = new ID_Block_Anlage_TypeClassItemProvider(this);
		}

		return iD_Block_Anlage_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Block_Element_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Block_Element_TypeClassItemProvider iD_Block_Element_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Block_Element_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Block_Element_TypeClassAdapter() {
		if (iD_Block_Element_TypeClassItemProvider == null) {
			iD_Block_Element_TypeClassItemProvider = new ID_Block_Element_TypeClassItemProvider(this);
		}

		return iD_Block_Element_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Block_Strecke_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Block_Strecke_TypeClassItemProvider iD_Block_Strecke_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Block_Strecke_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Block_Strecke_TypeClassAdapter() {
		if (iD_Block_Strecke_TypeClassItemProvider == null) {
			iD_Block_Strecke_TypeClassItemProvider = new ID_Block_Strecke_TypeClassItemProvider(this);
		}

		return iD_Block_Strecke_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_BUE_Anlage_ohne_Proxy_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_BUE_Anlage_ohne_Proxy_TypeClassItemProvider iD_BUE_Anlage_ohne_Proxy_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_BUE_Anlage_ohne_Proxy_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_BUE_Anlage_ohne_Proxy_TypeClassAdapter() {
		if (iD_BUE_Anlage_ohne_Proxy_TypeClassItemProvider == null) {
			iD_BUE_Anlage_ohne_Proxy_TypeClassItemProvider = new ID_BUE_Anlage_ohne_Proxy_TypeClassItemProvider(this);
		}

		return iD_BUE_Anlage_ohne_Proxy_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_BUE_Anlage_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_BUE_Anlage_TypeClassItemProvider iD_BUE_Anlage_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_BUE_Anlage_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_BUE_Anlage_TypeClassAdapter() {
		if (iD_BUE_Anlage_TypeClassItemProvider == null) {
			iD_BUE_Anlage_TypeClassItemProvider = new ID_BUE_Anlage_TypeClassItemProvider(this);
		}

		return iD_BUE_Anlage_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_BUE_Bedien_Anzeige_Element_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_BUE_Bedien_Anzeige_Element_TypeClassItemProvider iD_BUE_Bedien_Anzeige_Element_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_BUE_Bedien_Anzeige_Element_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_BUE_Bedien_Anzeige_Element_TypeClassAdapter() {
		if (iD_BUE_Bedien_Anzeige_Element_TypeClassItemProvider == null) {
			iD_BUE_Bedien_Anzeige_Element_TypeClassItemProvider = new ID_BUE_Bedien_Anzeige_Element_TypeClassItemProvider(this);
		}

		return iD_BUE_Bedien_Anzeige_Element_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_BUE_Einschaltung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_BUE_Einschaltung_TypeClassItemProvider iD_BUE_Einschaltung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_BUE_Einschaltung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_BUE_Einschaltung_TypeClassAdapter() {
		if (iD_BUE_Einschaltung_TypeClassItemProvider == null) {
			iD_BUE_Einschaltung_TypeClassItemProvider = new ID_BUE_Einschaltung_TypeClassItemProvider(this);
		}

		return iD_BUE_Einschaltung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_BUE_Gleisbezogener_Gefahrraum_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_BUE_Gleisbezogener_Gefahrraum_TypeClassItemProvider iD_BUE_Gleisbezogener_Gefahrraum_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_BUE_Gleisbezogener_Gefahrraum_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_BUE_Gleisbezogener_Gefahrraum_TypeClassAdapter() {
		if (iD_BUE_Gleisbezogener_Gefahrraum_TypeClassItemProvider == null) {
			iD_BUE_Gleisbezogener_Gefahrraum_TypeClassItemProvider = new ID_BUE_Gleisbezogener_Gefahrraum_TypeClassItemProvider(this);
		}

		return iD_BUE_Gleisbezogener_Gefahrraum_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_BUE_Schnittstelle_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_BUE_Schnittstelle_TypeClassItemProvider iD_BUE_Schnittstelle_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_BUE_Schnittstelle_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_BUE_Schnittstelle_TypeClassAdapter() {
		if (iD_BUE_Schnittstelle_TypeClassItemProvider == null) {
			iD_BUE_Schnittstelle_TypeClassItemProvider = new ID_BUE_Schnittstelle_TypeClassItemProvider(this);
		}

		return iD_BUE_Schnittstelle_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_BUE_WS_Fstr_Zuordnung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_BUE_WS_Fstr_Zuordnung_TypeClassItemProvider iD_BUE_WS_Fstr_Zuordnung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_BUE_WS_Fstr_Zuordnung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_BUE_WS_Fstr_Zuordnung_TypeClassAdapter() {
		if (iD_BUE_WS_Fstr_Zuordnung_TypeClassItemProvider == null) {
			iD_BUE_WS_Fstr_Zuordnung_TypeClassItemProvider = new ID_BUE_WS_Fstr_Zuordnung_TypeClassItemProvider(this);
		}

		return iD_BUE_WS_Fstr_Zuordnung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Datenpunkt_ohne_Proxy_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Datenpunkt_ohne_Proxy_TypeClassItemProvider iD_Datenpunkt_ohne_Proxy_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Datenpunkt_ohne_Proxy_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Datenpunkt_ohne_Proxy_TypeClassAdapter() {
		if (iD_Datenpunkt_ohne_Proxy_TypeClassItemProvider == null) {
			iD_Datenpunkt_ohne_Proxy_TypeClassItemProvider = new ID_Datenpunkt_ohne_Proxy_TypeClassItemProvider(this);
		}

		return iD_Datenpunkt_ohne_Proxy_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Datenpunkt_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Datenpunkt_TypeClassItemProvider iD_Datenpunkt_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Datenpunkt_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Datenpunkt_TypeClassAdapter() {
		if (iD_Datenpunkt_TypeClassItemProvider == null) {
			iD_Datenpunkt_TypeClassItemProvider = new ID_Datenpunkt_TypeClassItemProvider(this);
		}

		return iD_Datenpunkt_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_DP_Bezugspunkt_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_DP_Bezugspunkt_TypeClassItemProvider iD_DP_Bezugspunkt_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_DP_Bezugspunkt_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_DP_Bezugspunkt_TypeClassAdapter() {
		if (iD_DP_Bezugspunkt_TypeClassItemProvider == null) {
			iD_DP_Bezugspunkt_TypeClassItemProvider = new ID_DP_Bezugspunkt_TypeClassItemProvider(this);
		}

		return iD_DP_Bezugspunkt_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Einschaltpunkt_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Einschaltpunkt_TypeClassItemProvider iD_Einschaltpunkt_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Einschaltpunkt_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Einschaltpunkt_TypeClassAdapter() {
		if (iD_Einschaltpunkt_TypeClassItemProvider == null) {
			iD_Einschaltpunkt_TypeClassItemProvider = new ID_Einschaltpunkt_TypeClassItemProvider(this);
		}

		return iD_Einschaltpunkt_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Element_Grenze_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Element_Grenze_TypeClassItemProvider iD_Element_Grenze_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Element_Grenze_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Element_Grenze_TypeClassAdapter() {
		if (iD_Element_Grenze_TypeClassItemProvider == null) {
			iD_Element_Grenze_TypeClassItemProvider = new ID_Element_Grenze_TypeClassItemProvider(this);
		}

		return iD_Element_Grenze_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Element_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Element_TypeClassItemProvider iD_Element_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Element_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Element_TypeClassAdapter() {
		if (iD_Element_TypeClassItemProvider == null) {
			iD_Element_TypeClassItemProvider = new ID_Element_TypeClassItemProvider(this);
		}

		return iD_Element_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Element_Unterbringung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Element_Unterbringung_TypeClassItemProvider iD_Element_Unterbringung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Element_Unterbringung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Element_Unterbringung_TypeClassAdapter() {
		if (iD_Element_Unterbringung_TypeClassItemProvider == null) {
			iD_Element_Unterbringung_TypeClassItemProvider = new ID_Element_Unterbringung_TypeClassItemProvider(this);
		}

		return iD_Element_Unterbringung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Energie_Eingang_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Energie_Eingang_TypeClassItemProvider iD_Energie_Eingang_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Energie_Eingang_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Energie_Eingang_TypeClassAdapter() {
		if (iD_Energie_Eingang_TypeClassItemProvider == null) {
			iD_Energie_Eingang_TypeClassItemProvider = new ID_Energie_Eingang_TypeClassItemProvider(this);
		}

		return iD_Energie_Eingang_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Energie_Primaer_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Energie_Primaer_TypeClassItemProvider iD_Energie_Primaer_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Energie_Primaer_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Energie_Primaer_TypeClassAdapter() {
		if (iD_Energie_Primaer_TypeClassItemProvider == null) {
			iD_Energie_Primaer_TypeClassItemProvider = new ID_Energie_Primaer_TypeClassItemProvider(this);
		}

		return iD_Energie_Primaer_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_ESTW_Zentraleinheit_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_ESTW_Zentraleinheit_TypeClassItemProvider iD_ESTW_Zentraleinheit_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_ESTW_Zentraleinheit_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_ESTW_Zentraleinheit_TypeClassAdapter() {
		if (iD_ESTW_Zentraleinheit_TypeClassItemProvider == null) {
			iD_ESTW_Zentraleinheit_TypeClassItemProvider = new ID_ESTW_Zentraleinheit_TypeClassItemProvider(this);
		}

		return iD_ESTW_Zentraleinheit_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_ETCS_Knoten_ohne_Proxy_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_ETCS_Knoten_ohne_Proxy_TypeClassItemProvider iD_ETCS_Knoten_ohne_Proxy_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_ETCS_Knoten_ohne_Proxy_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_ETCS_Knoten_ohne_Proxy_TypeClassAdapter() {
		if (iD_ETCS_Knoten_ohne_Proxy_TypeClassItemProvider == null) {
			iD_ETCS_Knoten_ohne_Proxy_TypeClassItemProvider = new ID_ETCS_Knoten_ohne_Proxy_TypeClassItemProvider(this);
		}

		return iD_ETCS_Knoten_ohne_Proxy_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_ETCS_Knoten_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_ETCS_Knoten_TypeClassItemProvider iD_ETCS_Knoten_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_ETCS_Knoten_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_ETCS_Knoten_TypeClassAdapter() {
		if (iD_ETCS_Knoten_TypeClassItemProvider == null) {
			iD_ETCS_Knoten_TypeClassItemProvider = new ID_ETCS_Knoten_TypeClassItemProvider(this);
		}

		return iD_ETCS_Knoten_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_EV_Modul_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_EV_Modul_TypeClassItemProvider iD_EV_Modul_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_EV_Modul_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_EV_Modul_TypeClassAdapter() {
		if (iD_EV_Modul_TypeClassItemProvider == null) {
			iD_EV_Modul_TypeClassItemProvider = new ID_EV_Modul_TypeClassItemProvider(this);
		}

		return iD_EV_Modul_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Fachtelegramm_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Fachtelegramm_TypeClassItemProvider iD_Fachtelegramm_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Fachtelegramm_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Fachtelegramm_TypeClassAdapter() {
		if (iD_Fachtelegramm_TypeClassItemProvider == null) {
			iD_Fachtelegramm_TypeClassItemProvider = new ID_Fachtelegramm_TypeClassItemProvider(this);
		}

		return iD_Fachtelegramm_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Fla_Schutz_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Fla_Schutz_TypeClassItemProvider iD_Fla_Schutz_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Fla_Schutz_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Fla_Schutz_TypeClassAdapter() {
		if (iD_Fla_Schutz_TypeClassItemProvider == null) {
			iD_Fla_Schutz_TypeClassItemProvider = new ID_Fla_Schutz_TypeClassItemProvider(this);
		}

		return iD_Fla_Schutz_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_FMA_Anlage_Rangier_Frei_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_FMA_Anlage_Rangier_Frei_TypeClassItemProvider iD_FMA_Anlage_Rangier_Frei_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_FMA_Anlage_Rangier_Frei_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_FMA_Anlage_Rangier_Frei_TypeClassAdapter() {
		if (iD_FMA_Anlage_Rangier_Frei_TypeClassItemProvider == null) {
			iD_FMA_Anlage_Rangier_Frei_TypeClassItemProvider = new ID_FMA_Anlage_Rangier_Frei_TypeClassItemProvider(this);
		}

		return iD_FMA_Anlage_Rangier_Frei_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_FMA_Anlage_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_FMA_Anlage_TypeClassItemProvider iD_FMA_Anlage_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_FMA_Anlage_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_FMA_Anlage_TypeClassAdapter() {
		if (iD_FMA_Anlage_TypeClassItemProvider == null) {
			iD_FMA_Anlage_TypeClassItemProvider = new ID_FMA_Anlage_TypeClassItemProvider(this);
		}

		return iD_FMA_Anlage_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_FMA_Element_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_FMA_Element_TypeClassItemProvider iD_FMA_Element_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_FMA_Element_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_FMA_Element_TypeClassAdapter() {
		if (iD_FMA_Element_TypeClassItemProvider == null) {
			iD_FMA_Element_TypeClassItemProvider = new ID_FMA_Element_TypeClassItemProvider(this);
		}

		return iD_FMA_Element_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_FMA_Komponente_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_FMA_Komponente_TypeClassItemProvider iD_FMA_Komponente_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_FMA_Komponente_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_FMA_Komponente_TypeClassAdapter() {
		if (iD_FMA_Komponente_TypeClassItemProvider == null) {
			iD_FMA_Komponente_TypeClassItemProvider = new ID_FMA_Komponente_TypeClassItemProvider(this);
		}

		return iD_FMA_Komponente_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Fortschaltung_Start_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Fortschaltung_Start_TypeClassItemProvider iD_Fortschaltung_Start_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Fortschaltung_Start_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Fortschaltung_Start_TypeClassAdapter() {
		if (iD_Fortschaltung_Start_TypeClassItemProvider == null) {
			iD_Fortschaltung_Start_TypeClassItemProvider = new ID_Fortschaltung_Start_TypeClassItemProvider(this);
		}

		return iD_Fortschaltung_Start_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Fstr_Aneinander_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Fstr_Aneinander_TypeClassItemProvider iD_Fstr_Aneinander_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Fstr_Aneinander_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Fstr_Aneinander_TypeClassAdapter() {
		if (iD_Fstr_Aneinander_TypeClassItemProvider == null) {
			iD_Fstr_Aneinander_TypeClassItemProvider = new ID_Fstr_Aneinander_TypeClassItemProvider(this);
		}

		return iD_Fstr_Aneinander_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Fstr_Ausschluss_Besonders_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Fstr_Ausschluss_Besonders_TypeClassItemProvider iD_Fstr_Ausschluss_Besonders_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Fstr_Ausschluss_Besonders_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Fstr_Ausschluss_Besonders_TypeClassAdapter() {
		if (iD_Fstr_Ausschluss_Besonders_TypeClassItemProvider == null) {
			iD_Fstr_Ausschluss_Besonders_TypeClassItemProvider = new ID_Fstr_Ausschluss_Besonders_TypeClassItemProvider(this);
		}

		return iD_Fstr_Ausschluss_Besonders_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Fstr_DWeg_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Fstr_DWeg_TypeClassItemProvider iD_Fstr_DWeg_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Fstr_DWeg_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Fstr_DWeg_TypeClassAdapter() {
		if (iD_Fstr_DWeg_TypeClassItemProvider == null) {
			iD_Fstr_DWeg_TypeClassItemProvider = new ID_Fstr_DWeg_TypeClassItemProvider(this);
		}

		return iD_Fstr_DWeg_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Fstr_Fahrweg_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Fstr_Fahrweg_TypeClassItemProvider iD_Fstr_Fahrweg_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Fstr_Fahrweg_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Fstr_Fahrweg_TypeClassAdapter() {
		if (iD_Fstr_Fahrweg_TypeClassItemProvider == null) {
			iD_Fstr_Fahrweg_TypeClassItemProvider = new ID_Fstr_Fahrweg_TypeClassItemProvider(this);
		}

		return iD_Fstr_Fahrweg_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Fstr_Zug_Rangier_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Fstr_Zug_Rangier_TypeClassItemProvider iD_Fstr_Zug_Rangier_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Fstr_Zug_Rangier_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Fstr_Zug_Rangier_TypeClassAdapter() {
		if (iD_Fstr_Zug_Rangier_TypeClassItemProvider == null) {
			iD_Fstr_Zug_Rangier_TypeClassItemProvider = new ID_Fstr_Zug_Rangier_TypeClassItemProvider(this);
		}

		return iD_Fstr_Zug_Rangier_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_FT_Anschaltbedingung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_FT_Anschaltbedingung_TypeClassItemProvider iD_FT_Anschaltbedingung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_FT_Anschaltbedingung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_FT_Anschaltbedingung_TypeClassAdapter() {
		if (iD_FT_Anschaltbedingung_TypeClassItemProvider == null) {
			iD_FT_Anschaltbedingung_TypeClassItemProvider = new ID_FT_Anschaltbedingung_TypeClassItemProvider(this);
		}

		return iD_FT_Anschaltbedingung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_FT_Fahrweg_Teil_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_FT_Fahrweg_Teil_TypeClassItemProvider iD_FT_Fahrweg_Teil_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_FT_Fahrweg_Teil_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_FT_Fahrweg_Teil_TypeClassAdapter() {
		if (iD_FT_Fahrweg_Teil_TypeClassItemProvider == null) {
			iD_FT_Fahrweg_Teil_TypeClassItemProvider = new ID_FT_Fahrweg_Teil_TypeClassItemProvider(this);
		}

		return iD_FT_Fahrweg_Teil_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_GEO_Art_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_GEO_Art_TypeClassItemProvider iD_GEO_Art_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_GEO_Art_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_GEO_Art_TypeClassAdapter() {
		if (iD_GEO_Art_TypeClassItemProvider == null) {
			iD_GEO_Art_TypeClassItemProvider = new ID_GEO_Art_TypeClassItemProvider(this);
		}

		return iD_GEO_Art_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_GEO_Knoten_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_GEO_Knoten_TypeClassItemProvider iD_GEO_Knoten_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_GEO_Knoten_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_GEO_Knoten_TypeClassAdapter() {
		if (iD_GEO_Knoten_TypeClassItemProvider == null) {
			iD_GEO_Knoten_TypeClassItemProvider = new ID_GEO_Knoten_TypeClassItemProvider(this);
		}

		return iD_GEO_Knoten_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_GEO_Punkt_ohne_Proxy_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_GEO_Punkt_ohne_Proxy_TypeClassItemProvider iD_GEO_Punkt_ohne_Proxy_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_GEO_Punkt_ohne_Proxy_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_GEO_Punkt_ohne_Proxy_TypeClassAdapter() {
		if (iD_GEO_Punkt_ohne_Proxy_TypeClassItemProvider == null) {
			iD_GEO_Punkt_ohne_Proxy_TypeClassItemProvider = new ID_GEO_Punkt_ohne_Proxy_TypeClassItemProvider(this);
		}

		return iD_GEO_Punkt_ohne_Proxy_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_GEO_Punkt_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_GEO_Punkt_TypeClassItemProvider iD_GEO_Punkt_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_GEO_Punkt_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_GEO_Punkt_TypeClassAdapter() {
		if (iD_GEO_Punkt_TypeClassItemProvider == null) {
			iD_GEO_Punkt_TypeClassItemProvider = new ID_GEO_Punkt_TypeClassItemProvider(this);
		}

		return iD_GEO_Punkt_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Geraet_Programmiert_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Geraet_Programmiert_TypeClassItemProvider iD_Geraet_Programmiert_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Geraet_Programmiert_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Geraet_Programmiert_TypeClassAdapter() {
		if (iD_Geraet_Programmiert_TypeClassItemProvider == null) {
			iD_Geraet_Programmiert_TypeClassItemProvider = new ID_Geraet_Programmiert_TypeClassItemProvider(this);
		}

		return iD_Geraet_Programmiert_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_GFR_Anlage_ohne_Proxy_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_GFR_Anlage_ohne_Proxy_TypeClassItemProvider iD_GFR_Anlage_ohne_Proxy_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_GFR_Anlage_ohne_Proxy_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_GFR_Anlage_ohne_Proxy_TypeClassAdapter() {
		if (iD_GFR_Anlage_ohne_Proxy_TypeClassItemProvider == null) {
			iD_GFR_Anlage_ohne_Proxy_TypeClassItemProvider = new ID_GFR_Anlage_ohne_Proxy_TypeClassItemProvider(this);
		}

		return iD_GFR_Anlage_ohne_Proxy_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Gleis_Abschnitt_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Gleis_Abschnitt_TypeClassItemProvider iD_Gleis_Abschnitt_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Gleis_Abschnitt_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Gleis_Abschnitt_TypeClassAdapter() {
		if (iD_Gleis_Abschnitt_TypeClassItemProvider == null) {
			iD_Gleis_Abschnitt_TypeClassItemProvider = new ID_Gleis_Abschnitt_TypeClassItemProvider(this);
		}

		return iD_Gleis_Abschnitt_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Gleis_Bezeichnung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Gleis_Bezeichnung_TypeClassItemProvider iD_Gleis_Bezeichnung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Gleis_Bezeichnung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Gleis_Bezeichnung_TypeClassAdapter() {
		if (iD_Gleis_Bezeichnung_TypeClassItemProvider == null) {
			iD_Gleis_Bezeichnung_TypeClassItemProvider = new ID_Gleis_Bezeichnung_TypeClassItemProvider(this);
		}

		return iD_Gleis_Bezeichnung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Grenzzeichen_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Grenzzeichen_TypeClassItemProvider iD_Grenzzeichen_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Grenzzeichen_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Grenzzeichen_TypeClassAdapter() {
		if (iD_Grenzzeichen_TypeClassItemProvider == null) {
			iD_Grenzzeichen_TypeClassItemProvider = new ID_Grenzzeichen_TypeClassItemProvider(this);
		}

		return iD_Grenzzeichen_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Handschalt_Wirkfunktion_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Handschalt_Wirkfunktion_TypeClassItemProvider iD_Handschalt_Wirkfunktion_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Handschalt_Wirkfunktion_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Handschalt_Wirkfunktion_TypeClassAdapter() {
		if (iD_Handschalt_Wirkfunktion_TypeClassItemProvider == null) {
			iD_Handschalt_Wirkfunktion_TypeClassItemProvider = new ID_Handschalt_Wirkfunktion_TypeClassItemProvider(this);
		}

		return iD_Handschalt_Wirkfunktion_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Hoehenpunkt_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Hoehenpunkt_TypeClassItemProvider iD_Hoehenpunkt_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Hoehenpunkt_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Hoehenpunkt_TypeClassAdapter() {
		if (iD_Hoehenpunkt_TypeClassItemProvider == null) {
			iD_Hoehenpunkt_TypeClassItemProvider = new ID_Hoehenpunkt_TypeClassItemProvider(this);
		}

		return iD_Hoehenpunkt_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Information_Eingang_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Information_Eingang_TypeClassItemProvider iD_Information_Eingang_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Information_Eingang_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Information_Eingang_TypeClassAdapter() {
		if (iD_Information_Eingang_TypeClassItemProvider == null) {
			iD_Information_Eingang_TypeClassItemProvider = new ID_Information_Eingang_TypeClassItemProvider(this);
		}

		return iD_Information_Eingang_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Information_Primaer_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Information_Primaer_TypeClassItemProvider iD_Information_Primaer_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Information_Primaer_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Information_Primaer_TypeClassAdapter() {
		if (iD_Information_Primaer_TypeClassItemProvider == null) {
			iD_Information_Primaer_TypeClassItemProvider = new ID_Information_Primaer_TypeClassItemProvider(this);
		}

		return iD_Information_Primaer_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_LEU_Anlage_ohne_Proxy_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_LEU_Anlage_ohne_Proxy_TypeClassItemProvider iD_LEU_Anlage_ohne_Proxy_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_LEU_Anlage_ohne_Proxy_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_LEU_Anlage_ohne_Proxy_TypeClassAdapter() {
		if (iD_LEU_Anlage_ohne_Proxy_TypeClassItemProvider == null) {
			iD_LEU_Anlage_ohne_Proxy_TypeClassItemProvider = new ID_LEU_Anlage_ohne_Proxy_TypeClassItemProvider(this);
		}

		return iD_LEU_Anlage_ohne_Proxy_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_LEU_Anlage_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_LEU_Anlage_TypeClassItemProvider iD_LEU_Anlage_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_LEU_Anlage_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_LEU_Anlage_TypeClassAdapter() {
		if (iD_LEU_Anlage_TypeClassItemProvider == null) {
			iD_LEU_Anlage_TypeClassItemProvider = new ID_LEU_Anlage_TypeClassItemProvider(this);
		}

		return iD_LEU_Anlage_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_LEU_Bezugspunkt_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_LEU_Bezugspunkt_TypeClassItemProvider iD_LEU_Bezugspunkt_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_LEU_Bezugspunkt_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_LEU_Bezugspunkt_TypeClassAdapter() {
		if (iD_LEU_Bezugspunkt_TypeClassItemProvider == null) {
			iD_LEU_Bezugspunkt_TypeClassItemProvider = new ID_LEU_Bezugspunkt_TypeClassItemProvider(this);
		}

		return iD_LEU_Bezugspunkt_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_LEU_Schaltkasten_ohne_Proxy_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_LEU_Schaltkasten_ohne_Proxy_TypeClassItemProvider iD_LEU_Schaltkasten_ohne_Proxy_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_LEU_Schaltkasten_ohne_Proxy_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_LEU_Schaltkasten_ohne_Proxy_TypeClassAdapter() {
		if (iD_LEU_Schaltkasten_ohne_Proxy_TypeClassItemProvider == null) {
			iD_LEU_Schaltkasten_ohne_Proxy_TypeClassItemProvider = new ID_LEU_Schaltkasten_ohne_Proxy_TypeClassItemProvider(this);
		}

		return iD_LEU_Schaltkasten_ohne_Proxy_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_LO_Einbau_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_LO_Einbau_TypeClassItemProvider iD_LO_Einbau_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_LO_Einbau_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_LO_Einbau_TypeClassAdapter() {
		if (iD_LO_Einbau_TypeClassItemProvider == null) {
			iD_LO_Einbau_TypeClassItemProvider = new ID_LO_Einbau_TypeClassItemProvider(this);
		}

		return iD_LO_Einbau_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Markante_Stelle_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Markante_Stelle_TypeClassItemProvider iD_Markante_Stelle_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Markante_Stelle_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Markante_Stelle_TypeClassAdapter() {
		if (iD_Markante_Stelle_TypeClassItemProvider == null) {
			iD_Markante_Stelle_TypeClassItemProvider = new ID_Markante_Stelle_TypeClassItemProvider(this);
		}

		return iD_Markante_Stelle_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Markanter_Punkt_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Markanter_Punkt_TypeClassItemProvider iD_Markanter_Punkt_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Markanter_Punkt_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Markanter_Punkt_TypeClassAdapter() {
		if (iD_Markanter_Punkt_TypeClassItemProvider == null) {
			iD_Markanter_Punkt_TypeClassItemProvider = new ID_Markanter_Punkt_TypeClassItemProvider(this);
		}

		return iD_Markanter_Punkt_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_NB_Element_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_NB_Element_TypeClassItemProvider iD_NB_Element_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_NB_Element_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_NB_Element_TypeClassAdapter() {
		if (iD_NB_Element_TypeClassItemProvider == null) {
			iD_NB_Element_TypeClassItemProvider = new ID_NB_Element_TypeClassItemProvider(this);
		}

		return iD_NB_Element_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_NB_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_NB_TypeClassItemProvider iD_NB_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_NB_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_NB_TypeClassAdapter() {
		if (iD_NB_TypeClassItemProvider == null) {
			iD_NB_TypeClassItemProvider = new ID_NB_TypeClassItemProvider(this);
		}

		return iD_NB_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_NB_Zone_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_NB_Zone_TypeClassItemProvider iD_NB_Zone_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_NB_Zone_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_NB_Zone_TypeClassAdapter() {
		if (iD_NB_Zone_TypeClassItemProvider == null) {
			iD_NB_Zone_TypeClassItemProvider = new ID_NB_Zone_TypeClassItemProvider(this);
		}

		return iD_NB_Zone_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Oertlichkeit_Proxy_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Oertlichkeit_Proxy_TypeClassItemProvider iD_Oertlichkeit_Proxy_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Oertlichkeit_Proxy_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Oertlichkeit_Proxy_TypeClassAdapter() {
		if (iD_Oertlichkeit_Proxy_TypeClassItemProvider == null) {
			iD_Oertlichkeit_Proxy_TypeClassItemProvider = new ID_Oertlichkeit_Proxy_TypeClassItemProvider(this);
		}

		return iD_Oertlichkeit_Proxy_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Oertlichkeit_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Oertlichkeit_TypeClassItemProvider iD_Oertlichkeit_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Oertlichkeit_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Oertlichkeit_TypeClassAdapter() {
		if (iD_Oertlichkeit_TypeClassItemProvider == null) {
			iD_Oertlichkeit_TypeClassItemProvider = new ID_Oertlichkeit_TypeClassItemProvider(this);
		}

		return iD_Oertlichkeit_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_PlanPro_Schnittstelle_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_PlanPro_Schnittstelle_TypeClassItemProvider iD_PlanPro_Schnittstelle_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_PlanPro_Schnittstelle_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_PlanPro_Schnittstelle_TypeClassAdapter() {
		if (iD_PlanPro_Schnittstelle_TypeClassItemProvider == null) {
			iD_PlanPro_Schnittstelle_TypeClassItemProvider = new ID_PlanPro_Schnittstelle_TypeClassItemProvider(this);
		}

		return iD_PlanPro_Schnittstelle_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Planung_Einzel_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Planung_Einzel_TypeClassItemProvider iD_Planung_Einzel_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Planung_Einzel_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Planung_Einzel_TypeClassAdapter() {
		if (iD_Planung_Einzel_TypeClassItemProvider == null) {
			iD_Planung_Einzel_TypeClassItemProvider = new ID_Planung_Einzel_TypeClassItemProvider(this);
		}

		return iD_Planung_Einzel_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Planungsgrundlage_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Planungsgrundlage_TypeClassItemProvider iD_Planungsgrundlage_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Planungsgrundlage_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Planungsgrundlage_TypeClassAdapter() {
		if (iD_Planungsgrundlage_TypeClassItemProvider == null) {
			iD_Planungsgrundlage_TypeClassItemProvider = new ID_Planungsgrundlage_TypeClassItemProvider(this);
		}

		return iD_Planungsgrundlage_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_PZB_Element_Bezugspunkt_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_PZB_Element_Bezugspunkt_TypeClassItemProvider iD_PZB_Element_Bezugspunkt_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_PZB_Element_Bezugspunkt_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_PZB_Element_Bezugspunkt_TypeClassAdapter() {
		if (iD_PZB_Element_Bezugspunkt_TypeClassItemProvider == null) {
			iD_PZB_Element_Bezugspunkt_TypeClassItemProvider = new ID_PZB_Element_Bezugspunkt_TypeClassItemProvider(this);
		}

		return iD_PZB_Element_Bezugspunkt_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_PZB_Element_Mitnutzung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_PZB_Element_Mitnutzung_TypeClassItemProvider iD_PZB_Element_Mitnutzung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_PZB_Element_Mitnutzung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_PZB_Element_Mitnutzung_TypeClassAdapter() {
		if (iD_PZB_Element_Mitnutzung_TypeClassItemProvider == null) {
			iD_PZB_Element_Mitnutzung_TypeClassItemProvider = new ID_PZB_Element_Mitnutzung_TypeClassItemProvider(this);
		}

		return iD_PZB_Element_Mitnutzung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_PZB_Element_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_PZB_Element_TypeClassItemProvider iD_PZB_Element_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_PZB_Element_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_PZB_Element_TypeClassAdapter() {
		if (iD_PZB_Element_TypeClassItemProvider == null) {
			iD_PZB_Element_TypeClassItemProvider = new ID_PZB_Element_TypeClassItemProvider(this);
		}

		return iD_PZB_Element_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_PZB_Element_Zuordnung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_PZB_Element_Zuordnung_TypeClassItemProvider iD_PZB_Element_Zuordnung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_PZB_Element_Zuordnung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_PZB_Element_Zuordnung_TypeClassAdapter() {
		if (iD_PZB_Element_Zuordnung_TypeClassItemProvider == null) {
			iD_PZB_Element_Zuordnung_TypeClassItemProvider = new ID_PZB_Element_Zuordnung_TypeClassItemProvider(this);
		}

		return iD_PZB_Element_Zuordnung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Quellelement_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Quellelement_TypeClassItemProvider iD_Quellelement_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Quellelement_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Quellelement_TypeClassAdapter() {
		if (iD_Quellelement_TypeClassItemProvider == null) {
			iD_Quellelement_TypeClassItemProvider = new ID_Quellelement_TypeClassItemProvider(this);
		}

		return iD_Quellelement_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_RBC_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_RBC_TypeClassItemProvider iD_RBC_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_RBC_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_RBC_TypeClassAdapter() {
		if (iD_RBC_TypeClassItemProvider == null) {
			iD_RBC_TypeClassItemProvider = new ID_RBC_TypeClassItemProvider(this);
		}

		return iD_RBC_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Regelzeichnung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Regelzeichnung_TypeClassItemProvider iD_Regelzeichnung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Regelzeichnung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Regelzeichnung_TypeClassAdapter() {
		if (iD_Regelzeichnung_TypeClassItemProvider == null) {
			iD_Regelzeichnung_TypeClassItemProvider = new ID_Regelzeichnung_TypeClassItemProvider(this);
		}

		return iD_Regelzeichnung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Schalter_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Schalter_TypeClassItemProvider iD_Schalter_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Schalter_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Schalter_TypeClassAdapter() {
		if (iD_Schalter_TypeClassItemProvider == null) {
			iD_Schalter_TypeClassItemProvider = new ID_Schalter_TypeClassItemProvider(this);
		}

		return iD_Schalter_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Schaltmittel_Zuordnung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Schaltmittel_Zuordnung_TypeClassItemProvider iD_Schaltmittel_Zuordnung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Schaltmittel_Zuordnung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Schaltmittel_Zuordnung_TypeClassAdapter() {
		if (iD_Schaltmittel_Zuordnung_TypeClassItemProvider == null) {
			iD_Schaltmittel_Zuordnung_TypeClassItemProvider = new ID_Schaltmittel_Zuordnung_TypeClassItemProvider(this);
		}

		return iD_Schaltmittel_Zuordnung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Schlosskombination_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Schlosskombination_TypeClassItemProvider iD_Schlosskombination_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Schlosskombination_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Schlosskombination_TypeClassAdapter() {
		if (iD_Schlosskombination_TypeClassItemProvider == null) {
			iD_Schlosskombination_TypeClassItemProvider = new ID_Schlosskombination_TypeClassItemProvider(this);
		}

		return iD_Schlosskombination_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Schluessel_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Schluessel_TypeClassItemProvider iD_Schluessel_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Schluessel_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Schluessel_TypeClassAdapter() {
		if (iD_Schluessel_TypeClassItemProvider == null) {
			iD_Schluessel_TypeClassItemProvider = new ID_Schluessel_TypeClassItemProvider(this);
		}

		return iD_Schluessel_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Schluesselsperre_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Schluesselsperre_TypeClassItemProvider iD_Schluesselsperre_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Schluesselsperre_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Schluesselsperre_TypeClassAdapter() {
		if (iD_Schluesselsperre_TypeClassItemProvider == null) {
			iD_Schluesselsperre_TypeClassItemProvider = new ID_Schluesselsperre_TypeClassItemProvider(this);
		}

		return iD_Schluesselsperre_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Signal_Befestigung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Signal_Befestigung_TypeClassItemProvider iD_Signal_Befestigung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Signal_Befestigung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Signal_Befestigung_TypeClassAdapter() {
		if (iD_Signal_Befestigung_TypeClassItemProvider == null) {
			iD_Signal_Befestigung_TypeClassItemProvider = new ID_Signal_Befestigung_TypeClassItemProvider(this);
		}

		return iD_Signal_Befestigung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Signal_Fank_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Signal_Fank_TypeClassItemProvider iD_Signal_Fank_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Signal_Fank_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Signal_Fank_TypeClassAdapter() {
		if (iD_Signal_Fank_TypeClassItemProvider == null) {
			iD_Signal_Fank_TypeClassItemProvider = new ID_Signal_Fank_TypeClassItemProvider(this);
		}

		return iD_Signal_Fank_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Signal_Gleisbezechnung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Signal_Gleisbezechnung_TypeClassItemProvider iD_Signal_Gleisbezechnung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Signal_Gleisbezechnung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Signal_Gleisbezechnung_TypeClassAdapter() {
		if (iD_Signal_Gleisbezechnung_TypeClassItemProvider == null) {
			iD_Signal_Gleisbezechnung_TypeClassItemProvider = new ID_Signal_Gleisbezechnung_TypeClassItemProvider(this);
		}

		return iD_Signal_Gleisbezechnung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Signal_ohne_Proxy_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Signal_ohne_Proxy_TypeClassItemProvider iD_Signal_ohne_Proxy_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Signal_ohne_Proxy_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Signal_ohne_Proxy_TypeClassAdapter() {
		if (iD_Signal_ohne_Proxy_TypeClassItemProvider == null) {
			iD_Signal_ohne_Proxy_TypeClassItemProvider = new ID_Signal_ohne_Proxy_TypeClassItemProvider(this);
		}

		return iD_Signal_ohne_Proxy_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Signal_Rahmen_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Signal_Rahmen_TypeClassItemProvider iD_Signal_Rahmen_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Signal_Rahmen_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Signal_Rahmen_TypeClassAdapter() {
		if (iD_Signal_Rahmen_TypeClassItemProvider == null) {
			iD_Signal_Rahmen_TypeClassItemProvider = new ID_Signal_Rahmen_TypeClassItemProvider(this);
		}

		return iD_Signal_Rahmen_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Signal_Signalbegriff_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Signal_Signalbegriff_TypeClassItemProvider iD_Signal_Signalbegriff_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Signal_Signalbegriff_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Signal_Signalbegriff_TypeClassAdapter() {
		if (iD_Signal_Signalbegriff_TypeClassItemProvider == null) {
			iD_Signal_Signalbegriff_TypeClassItemProvider = new ID_Signal_Signalbegriff_TypeClassItemProvider(this);
		}

		return iD_Signal_Signalbegriff_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Signal_Start_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Signal_Start_TypeClassItemProvider iD_Signal_Start_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Signal_Start_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Signal_Start_TypeClassAdapter() {
		if (iD_Signal_Start_TypeClassItemProvider == null) {
			iD_Signal_Start_TypeClassItemProvider = new ID_Signal_Start_TypeClassItemProvider(this);
		}

		return iD_Signal_Start_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Signal_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Signal_TypeClassItemProvider iD_Signal_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Signal_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Signal_TypeClassAdapter() {
		if (iD_Signal_TypeClassItemProvider == null) {
			iD_Signal_TypeClassItemProvider = new ID_Signal_TypeClassItemProvider(this);
		}

		return iD_Signal_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Sonderanlage_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Sonderanlage_TypeClassItemProvider iD_Sonderanlage_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Sonderanlage_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Sonderanlage_TypeClassAdapter() {
		if (iD_Sonderanlage_TypeClassItemProvider == null) {
			iD_Sonderanlage_TypeClassItemProvider = new ID_Sonderanlage_TypeClassItemProvider(this);
		}

		return iD_Sonderanlage_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Stellelement_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Stellelement_TypeClassItemProvider iD_Stellelement_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Stellelement_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Stellelement_TypeClassAdapter() {
		if (iD_Stellelement_TypeClassItemProvider == null) {
			iD_Stellelement_TypeClassItemProvider = new ID_Stellelement_TypeClassItemProvider(this);
		}

		return iD_Stellelement_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Stellwerk_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Stellwerk_TypeClassItemProvider iD_Stellwerk_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Stellwerk_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Stellwerk_TypeClassAdapter() {
		if (iD_Stellwerk_TypeClassItemProvider == null) {
			iD_Stellwerk_TypeClassItemProvider = new ID_Stellwerk_TypeClassItemProvider(this);
		}

		return iD_Stellwerk_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Strecke_Punkt_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Strecke_Punkt_TypeClassItemProvider iD_Strecke_Punkt_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Strecke_Punkt_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Strecke_Punkt_TypeClassAdapter() {
		if (iD_Strecke_Punkt_TypeClassItemProvider == null) {
			iD_Strecke_Punkt_TypeClassItemProvider = new ID_Strecke_Punkt_TypeClassItemProvider(this);
		}

		return iD_Strecke_Punkt_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Strecke_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Strecke_TypeClassItemProvider iD_Strecke_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Strecke_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Strecke_TypeClassAdapter() {
		if (iD_Strecke_TypeClassItemProvider == null) {
			iD_Strecke_TypeClassItemProvider = new ID_Strecke_TypeClassItemProvider(this);
		}

		return iD_Strecke_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Technischer_Punkt_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Technischer_Punkt_TypeClassItemProvider iD_Technischer_Punkt_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Technischer_Punkt_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Technischer_Punkt_TypeClassAdapter() {
		if (iD_Technischer_Punkt_TypeClassItemProvider == null) {
			iD_Technischer_Punkt_TypeClassItemProvider = new ID_Technischer_Punkt_TypeClassItemProvider(this);
		}

		return iD_Technischer_Punkt_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_TOP_Kante_ohne_Proxy_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_TOP_Kante_ohne_Proxy_TypeClassItemProvider iD_TOP_Kante_ohne_Proxy_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_TOP_Kante_ohne_Proxy_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_TOP_Kante_ohne_Proxy_TypeClassAdapter() {
		if (iD_TOP_Kante_ohne_Proxy_TypeClassItemProvider == null) {
			iD_TOP_Kante_ohne_Proxy_TypeClassItemProvider = new ID_TOP_Kante_ohne_Proxy_TypeClassItemProvider(this);
		}

		return iD_TOP_Kante_ohne_Proxy_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_TOP_Kante_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_TOP_Kante_TypeClassItemProvider iD_TOP_Kante_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_TOP_Kante_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_TOP_Kante_TypeClassAdapter() {
		if (iD_TOP_Kante_TypeClassItemProvider == null) {
			iD_TOP_Kante_TypeClassItemProvider = new ID_TOP_Kante_TypeClassItemProvider(this);
		}

		return iD_TOP_Kante_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_TOP_Knoten_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_TOP_Knoten_TypeClassItemProvider iD_TOP_Knoten_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_TOP_Knoten_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_TOP_Knoten_TypeClassAdapter() {
		if (iD_TOP_Knoten_TypeClassItemProvider == null) {
			iD_TOP_Knoten_TypeClassItemProvider = new ID_TOP_Knoten_TypeClassItemProvider(this);
		}

		return iD_TOP_Knoten_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Trasse_Kante_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Trasse_Kante_TypeClassItemProvider iD_Trasse_Kante_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Trasse_Kante_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Trasse_Kante_TypeClassAdapter() {
		if (iD_Trasse_Kante_TypeClassItemProvider == null) {
			iD_Trasse_Kante_TypeClassItemProvider = new ID_Trasse_Kante_TypeClassItemProvider(this);
		}

		return iD_Trasse_Kante_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Trasse_Knoten_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Trasse_Knoten_TypeClassItemProvider iD_Trasse_Knoten_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Trasse_Knoten_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Trasse_Knoten_TypeClassAdapter() {
		if (iD_Trasse_Knoten_TypeClassItemProvider == null) {
			iD_Trasse_Knoten_TypeClassItemProvider = new ID_Trasse_Knoten_TypeClassItemProvider(this);
		}

		return iD_Trasse_Knoten_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Ueberhoehung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Ueberhoehung_TypeClassItemProvider iD_Ueberhoehung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Ueberhoehung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Ueberhoehung_TypeClassAdapter() {
		if (iD_Ueberhoehung_TypeClassItemProvider == null) {
			iD_Ueberhoehung_TypeClassItemProvider = new ID_Ueberhoehung_TypeClassItemProvider(this);
		}

		return iD_Ueberhoehung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Uebertragungsweg_Nach_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Uebertragungsweg_Nach_TypeClassItemProvider iD_Uebertragungsweg_Nach_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Uebertragungsweg_Nach_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Uebertragungsweg_Nach_TypeClassAdapter() {
		if (iD_Uebertragungsweg_Nach_TypeClassItemProvider == null) {
			iD_Uebertragungsweg_Nach_TypeClassItemProvider = new ID_Uebertragungsweg_Nach_TypeClassItemProvider(this);
		}

		return iD_Uebertragungsweg_Nach_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Uebertragungsweg_Von_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Uebertragungsweg_Von_TypeClassItemProvider iD_Uebertragungsweg_Von_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Uebertragungsweg_Von_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Uebertragungsweg_Von_TypeClassAdapter() {
		if (iD_Uebertragungsweg_Von_TypeClassItemProvider == null) {
			iD_Uebertragungsweg_Von_TypeClassItemProvider = new ID_Uebertragungsweg_Von_TypeClassItemProvider(this);
		}

		return iD_Uebertragungsweg_Von_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Umfahrpunkt_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Umfahrpunkt_TypeClassItemProvider iD_Umfahrpunkt_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Umfahrpunkt_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Umfahrpunkt_TypeClassAdapter() {
		if (iD_Umfahrpunkt_TypeClassItemProvider == null) {
			iD_Umfahrpunkt_TypeClassItemProvider = new ID_Umfahrpunkt_TypeClassItemProvider(this);
		}

		return iD_Umfahrpunkt_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Unterbringung_ohne_Proxy_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Unterbringung_ohne_Proxy_TypeClassItemProvider iD_Unterbringung_ohne_Proxy_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Unterbringung_ohne_Proxy_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Unterbringung_ohne_Proxy_TypeClassAdapter() {
		if (iD_Unterbringung_ohne_Proxy_TypeClassItemProvider == null) {
			iD_Unterbringung_ohne_Proxy_TypeClassItemProvider = new ID_Unterbringung_ohne_Proxy_TypeClassItemProvider(this);
		}

		return iD_Unterbringung_ohne_Proxy_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Unterbringung_Technik_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Unterbringung_Technik_TypeClassItemProvider iD_Unterbringung_Technik_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Unterbringung_Technik_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Unterbringung_Technik_TypeClassAdapter() {
		if (iD_Unterbringung_Technik_TypeClassItemProvider == null) {
			iD_Unterbringung_Technik_TypeClassItemProvider = new ID_Unterbringung_Technik_TypeClassItemProvider(this);
		}

		return iD_Unterbringung_Technik_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Unterbringung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Unterbringung_TypeClassItemProvider iD_Unterbringung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Unterbringung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Unterbringung_TypeClassAdapter() {
		if (iD_Unterbringung_TypeClassItemProvider == null) {
			iD_Unterbringung_TypeClassItemProvider = new ID_Unterbringung_TypeClassItemProvider(this);
		}

		return iD_Unterbringung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Ur_Objekt_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Ur_Objekt_TypeClassItemProvider iD_Ur_Objekt_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Ur_Objekt_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Ur_Objekt_TypeClassAdapter() {
		if (iD_Ur_Objekt_TypeClassItemProvider == null) {
			iD_Ur_Objekt_TypeClassItemProvider = new ID_Ur_Objekt_TypeClassItemProvider(this);
		}

		return iD_Ur_Objekt_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Verknuepftes_Element_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Verknuepftes_Element_TypeClassItemProvider iD_Verknuepftes_Element_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Verknuepftes_Element_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Verknuepftes_Element_TypeClassAdapter() {
		if (iD_Verknuepftes_Element_TypeClassItemProvider == null) {
			iD_Verknuepftes_Element_TypeClassItemProvider = new ID_Verknuepftes_Element_TypeClassItemProvider(this);
		}

		return iD_Verknuepftes_Element_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_W_Kr_Anlage_ohne_Proxy_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_W_Kr_Anlage_ohne_Proxy_TypeClassItemProvider iD_W_Kr_Anlage_ohne_Proxy_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_W_Kr_Anlage_ohne_Proxy_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_W_Kr_Anlage_ohne_Proxy_TypeClassAdapter() {
		if (iD_W_Kr_Anlage_ohne_Proxy_TypeClassItemProvider == null) {
			iD_W_Kr_Anlage_ohne_Proxy_TypeClassItemProvider = new ID_W_Kr_Anlage_ohne_Proxy_TypeClassItemProvider(this);
		}

		return iD_W_Kr_Anlage_ohne_Proxy_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_W_Kr_Anlage_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_W_Kr_Anlage_TypeClassItemProvider iD_W_Kr_Anlage_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_W_Kr_Anlage_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_W_Kr_Anlage_TypeClassAdapter() {
		if (iD_W_Kr_Anlage_TypeClassItemProvider == null) {
			iD_W_Kr_Anlage_TypeClassItemProvider = new ID_W_Kr_Anlage_TypeClassItemProvider(this);
		}

		return iD_W_Kr_Anlage_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_W_Kr_Gsp_Element_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_W_Kr_Gsp_Element_TypeClassItemProvider iD_W_Kr_Gsp_Element_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_W_Kr_Gsp_Element_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_W_Kr_Gsp_Element_TypeClassAdapter() {
		if (iD_W_Kr_Gsp_Element_TypeClassItemProvider == null) {
			iD_W_Kr_Gsp_Element_TypeClassItemProvider = new ID_W_Kr_Gsp_Element_TypeClassItemProvider(this);
		}

		return iD_W_Kr_Gsp_Element_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_W_Kr_Gsp_Komponente_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_W_Kr_Gsp_Komponente_TypeClassItemProvider iD_W_Kr_Gsp_Komponente_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_W_Kr_Gsp_Komponente_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_W_Kr_Gsp_Komponente_TypeClassAdapter() {
		if (iD_W_Kr_Gsp_Komponente_TypeClassItemProvider == null) {
			iD_W_Kr_Gsp_Komponente_TypeClassItemProvider = new ID_W_Kr_Gsp_Komponente_TypeClassItemProvider(this);
		}

		return iD_W_Kr_Gsp_Komponente_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Weichenlaufkette_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Weichenlaufkette_TypeClassItemProvider iD_Weichenlaufkette_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Weichenlaufkette_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Weichenlaufkette_TypeClassAdapter() {
		if (iD_Weichenlaufkette_TypeClassItemProvider == null) {
			iD_Weichenlaufkette_TypeClassItemProvider = new ID_Weichenlaufkette_TypeClassItemProvider(this);
		}

		return iD_Weichenlaufkette_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Ziel_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Ziel_TypeClassItemProvider iD_Ziel_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Ziel_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Ziel_TypeClassAdapter() {
		if (iD_Ziel_TypeClassItemProvider == null) {
			iD_Ziel_TypeClassItemProvider = new ID_Ziel_TypeClassItemProvider(this);
		}

		return iD_Ziel_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_ZL_DLP_Fstr_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_ZL_DLP_Fstr_TypeClassItemProvider iD_ZL_DLP_Fstr_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_ZL_DLP_Fstr_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_ZL_DLP_Fstr_TypeClassAdapter() {
		if (iD_ZL_DLP_Fstr_TypeClassItemProvider == null) {
			iD_ZL_DLP_Fstr_TypeClassItemProvider = new ID_ZL_DLP_Fstr_TypeClassItemProvider(this);
		}

		return iD_ZL_DLP_Fstr_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_ZL_Fstr_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_ZL_Fstr_TypeClassItemProvider iD_ZL_Fstr_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_ZL_Fstr_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_ZL_Fstr_TypeClassAdapter() {
		if (iD_ZL_Fstr_TypeClassItemProvider == null) {
			iD_ZL_Fstr_TypeClassItemProvider = new ID_ZL_Fstr_TypeClassItemProvider(this);
		}

		return iD_ZL_Fstr_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_ZL_Signalgruppe_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_ZL_Signalgruppe_TypeClassItemProvider iD_ZL_Signalgruppe_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_ZL_Signalgruppe_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_ZL_Signalgruppe_TypeClassAdapter() {
		if (iD_ZL_Signalgruppe_TypeClassItemProvider == null) {
			iD_ZL_Signalgruppe_TypeClassItemProvider = new ID_ZL_Signalgruppe_TypeClassItemProvider(this);
		}

		return iD_ZL_Signalgruppe_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_ZL_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_ZL_TypeClassItemProvider iD_ZL_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_ZL_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_ZL_TypeClassAdapter() {
		if (iD_ZL_TypeClassItemProvider == null) {
			iD_ZL_TypeClassItemProvider = new ID_ZL_TypeClassItemProvider(this);
		}

		return iD_ZL_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_ZLV_Bus_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_ZLV_Bus_TypeClassItemProvider iD_ZLV_Bus_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_ZLV_Bus_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_ZLV_Bus_TypeClassAdapter() {
		if (iD_ZLV_Bus_TypeClassItemProvider == null) {
			iD_ZLV_Bus_TypeClassItemProvider = new ID_ZLV_Bus_TypeClassItemProvider(this);
		}

		return iD_ZLV_Bus_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_ZN_Anzeigefeld_Anstoss_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_ZN_Anzeigefeld_Anstoss_TypeClassItemProvider iD_ZN_Anzeigefeld_Anstoss_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_ZN_Anzeigefeld_Anstoss_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_ZN_Anzeigefeld_Anstoss_TypeClassAdapter() {
		if (iD_ZN_Anzeigefeld_Anstoss_TypeClassItemProvider == null) {
			iD_ZN_Anzeigefeld_Anstoss_TypeClassItemProvider = new ID_ZN_Anzeigefeld_Anstoss_TypeClassItemProvider(this);
		}

		return iD_ZN_Anzeigefeld_Anstoss_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_ZN_Anzeigefeld_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_ZN_Anzeigefeld_TypeClassItemProvider iD_ZN_Anzeigefeld_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_ZN_Anzeigefeld_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_ZN_Anzeigefeld_TypeClassAdapter() {
		if (iD_ZN_Anzeigefeld_TypeClassItemProvider == null) {
			iD_ZN_Anzeigefeld_TypeClassItemProvider = new ID_ZN_Anzeigefeld_TypeClassItemProvider(this);
		}

		return iD_ZN_Anzeigefeld_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_ZN_Fortschalt_Kriterium_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_ZN_Fortschalt_Kriterium_TypeClassItemProvider iD_ZN_Fortschalt_Kriterium_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_ZN_Fortschalt_Kriterium_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_ZN_Fortschalt_Kriterium_TypeClassAdapter() {
		if (iD_ZN_Fortschalt_Kriterium_TypeClassItemProvider == null) {
			iD_ZN_Fortschalt_Kriterium_TypeClassItemProvider = new ID_ZN_Fortschalt_Kriterium_TypeClassItemProvider(this);
		}

		return iD_ZN_Fortschalt_Kriterium_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_ZN_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_ZN_TypeClassItemProvider iD_ZN_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_ZN_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_ZN_TypeClassAdapter() {
		if (iD_ZN_TypeClassItemProvider == null) {
			iD_ZN_TypeClassItemProvider = new ID_ZN_TypeClassItemProvider(this);
		}

		return iD_ZN_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_ZN_Unterstation_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_ZN_Unterstation_TypeClassItemProvider iD_ZN_Unterstation_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_ZN_Unterstation_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_ZN_Unterstation_TypeClassAdapter() {
		if (iD_ZN_Unterstation_TypeClassItemProvider == null) {
			iD_ZN_Unterstation_TypeClassItemProvider = new ID_ZN_Unterstation_TypeClassItemProvider(this);
		}

		return iD_ZN_Unterstation_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_ZN_ZBS_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_ZN_ZBS_TypeClassItemProvider iD_ZN_ZBS_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_ZN_ZBS_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_ZN_ZBS_TypeClassAdapter() {
		if (iD_ZN_ZBS_TypeClassItemProvider == null) {
			iD_ZN_ZBS_TypeClassItemProvider = new ID_ZN_ZBS_TypeClassItemProvider(this);
		}

		return iD_ZN_ZBS_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Zugeinwirkung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Zugeinwirkung_TypeClassItemProvider iD_Zugeinwirkung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Zugeinwirkung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Zugeinwirkung_TypeClassAdapter() {
		if (iD_Zugeinwirkung_TypeClassItemProvider == null) {
			iD_Zugeinwirkung_TypeClassItemProvider = new ID_Zugeinwirkung_TypeClassItemProvider(this);
		}

		return iD_Zugeinwirkung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model1902.Verweise.ID_Zweites_Haltfallkriterium_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Zweites_Haltfallkriterium_TypeClassItemProvider iD_Zweites_Haltfallkriterium_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model1902.Verweise.ID_Zweites_Haltfallkriterium_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Zweites_Haltfallkriterium_TypeClassAdapter() {
		if (iD_Zweites_Haltfallkriterium_TypeClassItemProvider == null) {
			iD_Zweites_Haltfallkriterium_TypeClassItemProvider = new ID_Zweites_Haltfallkriterium_TypeClassItemProvider(this);
		}

		return iD_Zweites_Haltfallkriterium_TypeClassItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void dispose() {
		if (iD_Anforderer_Element_TypeClassItemProvider != null) iD_Anforderer_Element_TypeClassItemProvider.dispose();
		if (iD_Anforderung_TypeClassItemProvider != null) iD_Anforderung_TypeClassItemProvider.dispose();
		if (iD_Anhang_ohne_Proxy_TypeClassItemProvider != null) iD_Anhang_ohne_Proxy_TypeClassItemProvider.dispose();
		if (iD_Anhang_TypeClassItemProvider != null) iD_Anhang_TypeClassItemProvider.dispose();
		if (iD_Anschluss_Element_TypeClassItemProvider != null) iD_Anschluss_Element_TypeClassItemProvider.dispose();
		if (iD_Ausgabe_Fachdaten_ohne_Proxy_TypeClassItemProvider != null) iD_Ausgabe_Fachdaten_ohne_Proxy_TypeClassItemProvider.dispose();
		if (iD_Aussenelementansteuerung_TypeClassItemProvider != null) iD_Aussenelementansteuerung_TypeClassItemProvider.dispose();
		if (iD_Bahnsteig_Anlage_TypeClassItemProvider != null) iD_Bahnsteig_Anlage_TypeClassItemProvider.dispose();
		if (iD_Bahnsteig_Kante_ohne_Proxy_TypeClassItemProvider != null) iD_Bahnsteig_Kante_ohne_Proxy_TypeClassItemProvider.dispose();
		if (iD_Bahnsteig_Kante_TypeClassItemProvider != null) iD_Bahnsteig_Kante_TypeClassItemProvider.dispose();
		if (iD_Balise_ohne_Proxy_TypeClassItemProvider != null) iD_Balise_ohne_Proxy_TypeClassItemProvider.dispose();
		if (iD_Balise_TypeClassItemProvider != null) iD_Balise_TypeClassItemProvider.dispose();
		if (iD_Basis_Objekt_TypeClassItemProvider != null) iD_Basis_Objekt_TypeClassItemProvider.dispose();
		if (iD_Bearbeitungsvermerk_TypeClassItemProvider != null) iD_Bearbeitungsvermerk_TypeClassItemProvider.dispose();
		if (iD_Bedien_Anzeige_Element_TypeClassItemProvider != null) iD_Bedien_Anzeige_Element_TypeClassItemProvider.dispose();
		if (iD_Bedien_Bezirk_TypeClassItemProvider != null) iD_Bedien_Bezirk_TypeClassItemProvider.dispose();
		if (iD_Bedien_Einrichtung_Oertlich_TypeClassItemProvider != null) iD_Bedien_Einrichtung_Oertlich_TypeClassItemProvider.dispose();
		if (iD_Bedien_Oberflaeche_TypeClassItemProvider != null) iD_Bedien_Oberflaeche_TypeClassItemProvider.dispose();
		if (iD_Bedien_Standort_TypeClassItemProvider != null) iD_Bedien_Standort_TypeClassItemProvider.dispose();
		if (iD_Bedien_Zentrale_TypeClassItemProvider != null) iD_Bedien_Zentrale_TypeClassItemProvider.dispose();
		if (iD_Beginn_Bereich_TypeClassItemProvider != null) iD_Beginn_Bereich_TypeClassItemProvider.dispose();
		if (iD_Binaerdatei_ohne_Proxy_TypeClassItemProvider != null) iD_Binaerdatei_ohne_Proxy_TypeClassItemProvider.dispose();
		if (iD_Block_Anlage_TypeClassItemProvider != null) iD_Block_Anlage_TypeClassItemProvider.dispose();
		if (iD_Block_Element_TypeClassItemProvider != null) iD_Block_Element_TypeClassItemProvider.dispose();
		if (iD_Block_Strecke_TypeClassItemProvider != null) iD_Block_Strecke_TypeClassItemProvider.dispose();
		if (iD_BUE_Anlage_ohne_Proxy_TypeClassItemProvider != null) iD_BUE_Anlage_ohne_Proxy_TypeClassItemProvider.dispose();
		if (iD_BUE_Anlage_TypeClassItemProvider != null) iD_BUE_Anlage_TypeClassItemProvider.dispose();
		if (iD_BUE_Bedien_Anzeige_Element_TypeClassItemProvider != null) iD_BUE_Bedien_Anzeige_Element_TypeClassItemProvider.dispose();
		if (iD_BUE_Einschaltung_TypeClassItemProvider != null) iD_BUE_Einschaltung_TypeClassItemProvider.dispose();
		if (iD_BUE_Gleisbezogener_Gefahrraum_TypeClassItemProvider != null) iD_BUE_Gleisbezogener_Gefahrraum_TypeClassItemProvider.dispose();
		if (iD_BUE_Schnittstelle_TypeClassItemProvider != null) iD_BUE_Schnittstelle_TypeClassItemProvider.dispose();
		if (iD_BUE_WS_Fstr_Zuordnung_TypeClassItemProvider != null) iD_BUE_WS_Fstr_Zuordnung_TypeClassItemProvider.dispose();
		if (iD_Datenpunkt_ohne_Proxy_TypeClassItemProvider != null) iD_Datenpunkt_ohne_Proxy_TypeClassItemProvider.dispose();
		if (iD_Datenpunkt_TypeClassItemProvider != null) iD_Datenpunkt_TypeClassItemProvider.dispose();
		if (iD_DP_Bezugspunkt_TypeClassItemProvider != null) iD_DP_Bezugspunkt_TypeClassItemProvider.dispose();
		if (iD_Einschaltpunkt_TypeClassItemProvider != null) iD_Einschaltpunkt_TypeClassItemProvider.dispose();
		if (iD_Element_Grenze_TypeClassItemProvider != null) iD_Element_Grenze_TypeClassItemProvider.dispose();
		if (iD_Element_TypeClassItemProvider != null) iD_Element_TypeClassItemProvider.dispose();
		if (iD_Element_Unterbringung_TypeClassItemProvider != null) iD_Element_Unterbringung_TypeClassItemProvider.dispose();
		if (iD_Energie_Eingang_TypeClassItemProvider != null) iD_Energie_Eingang_TypeClassItemProvider.dispose();
		if (iD_Energie_Primaer_TypeClassItemProvider != null) iD_Energie_Primaer_TypeClassItemProvider.dispose();
		if (iD_ESTW_Zentraleinheit_TypeClassItemProvider != null) iD_ESTW_Zentraleinheit_TypeClassItemProvider.dispose();
		if (iD_ETCS_Knoten_ohne_Proxy_TypeClassItemProvider != null) iD_ETCS_Knoten_ohne_Proxy_TypeClassItemProvider.dispose();
		if (iD_ETCS_Knoten_TypeClassItemProvider != null) iD_ETCS_Knoten_TypeClassItemProvider.dispose();
		if (iD_EV_Modul_TypeClassItemProvider != null) iD_EV_Modul_TypeClassItemProvider.dispose();
		if (iD_Fachtelegramm_TypeClassItemProvider != null) iD_Fachtelegramm_TypeClassItemProvider.dispose();
		if (iD_Fla_Schutz_TypeClassItemProvider != null) iD_Fla_Schutz_TypeClassItemProvider.dispose();
		if (iD_FMA_Anlage_Rangier_Frei_TypeClassItemProvider != null) iD_FMA_Anlage_Rangier_Frei_TypeClassItemProvider.dispose();
		if (iD_FMA_Anlage_TypeClassItemProvider != null) iD_FMA_Anlage_TypeClassItemProvider.dispose();
		if (iD_FMA_Element_TypeClassItemProvider != null) iD_FMA_Element_TypeClassItemProvider.dispose();
		if (iD_FMA_Komponente_TypeClassItemProvider != null) iD_FMA_Komponente_TypeClassItemProvider.dispose();
		if (iD_Fortschaltung_Start_TypeClassItemProvider != null) iD_Fortschaltung_Start_TypeClassItemProvider.dispose();
		if (iD_Fstr_Aneinander_TypeClassItemProvider != null) iD_Fstr_Aneinander_TypeClassItemProvider.dispose();
		if (iD_Fstr_Ausschluss_Besonders_TypeClassItemProvider != null) iD_Fstr_Ausschluss_Besonders_TypeClassItemProvider.dispose();
		if (iD_Fstr_DWeg_TypeClassItemProvider != null) iD_Fstr_DWeg_TypeClassItemProvider.dispose();
		if (iD_Fstr_Fahrweg_TypeClassItemProvider != null) iD_Fstr_Fahrweg_TypeClassItemProvider.dispose();
		if (iD_Fstr_Zug_Rangier_TypeClassItemProvider != null) iD_Fstr_Zug_Rangier_TypeClassItemProvider.dispose();
		if (iD_FT_Anschaltbedingung_TypeClassItemProvider != null) iD_FT_Anschaltbedingung_TypeClassItemProvider.dispose();
		if (iD_FT_Fahrweg_Teil_TypeClassItemProvider != null) iD_FT_Fahrweg_Teil_TypeClassItemProvider.dispose();
		if (iD_GEO_Art_TypeClassItemProvider != null) iD_GEO_Art_TypeClassItemProvider.dispose();
		if (iD_GEO_Knoten_TypeClassItemProvider != null) iD_GEO_Knoten_TypeClassItemProvider.dispose();
		if (iD_GEO_Punkt_ohne_Proxy_TypeClassItemProvider != null) iD_GEO_Punkt_ohne_Proxy_TypeClassItemProvider.dispose();
		if (iD_GEO_Punkt_TypeClassItemProvider != null) iD_GEO_Punkt_TypeClassItemProvider.dispose();
		if (iD_Geraet_Programmiert_TypeClassItemProvider != null) iD_Geraet_Programmiert_TypeClassItemProvider.dispose();
		if (iD_GFR_Anlage_ohne_Proxy_TypeClassItemProvider != null) iD_GFR_Anlage_ohne_Proxy_TypeClassItemProvider.dispose();
		if (iD_Gleis_Abschnitt_TypeClassItemProvider != null) iD_Gleis_Abschnitt_TypeClassItemProvider.dispose();
		if (iD_Gleis_Bezeichnung_TypeClassItemProvider != null) iD_Gleis_Bezeichnung_TypeClassItemProvider.dispose();
		if (iD_Grenzzeichen_TypeClassItemProvider != null) iD_Grenzzeichen_TypeClassItemProvider.dispose();
		if (iD_Handschalt_Wirkfunktion_TypeClassItemProvider != null) iD_Handschalt_Wirkfunktion_TypeClassItemProvider.dispose();
		if (iD_Hoehenpunkt_TypeClassItemProvider != null) iD_Hoehenpunkt_TypeClassItemProvider.dispose();
		if (iD_Information_Eingang_TypeClassItemProvider != null) iD_Information_Eingang_TypeClassItemProvider.dispose();
		if (iD_Information_Primaer_TypeClassItemProvider != null) iD_Information_Primaer_TypeClassItemProvider.dispose();
		if (iD_LEU_Anlage_ohne_Proxy_TypeClassItemProvider != null) iD_LEU_Anlage_ohne_Proxy_TypeClassItemProvider.dispose();
		if (iD_LEU_Anlage_TypeClassItemProvider != null) iD_LEU_Anlage_TypeClassItemProvider.dispose();
		if (iD_LEU_Bezugspunkt_TypeClassItemProvider != null) iD_LEU_Bezugspunkt_TypeClassItemProvider.dispose();
		if (iD_LEU_Schaltkasten_ohne_Proxy_TypeClassItemProvider != null) iD_LEU_Schaltkasten_ohne_Proxy_TypeClassItemProvider.dispose();
		if (iD_LO_Einbau_TypeClassItemProvider != null) iD_LO_Einbau_TypeClassItemProvider.dispose();
		if (iD_Markante_Stelle_TypeClassItemProvider != null) iD_Markante_Stelle_TypeClassItemProvider.dispose();
		if (iD_Markanter_Punkt_TypeClassItemProvider != null) iD_Markanter_Punkt_TypeClassItemProvider.dispose();
		if (iD_NB_Element_TypeClassItemProvider != null) iD_NB_Element_TypeClassItemProvider.dispose();
		if (iD_NB_TypeClassItemProvider != null) iD_NB_TypeClassItemProvider.dispose();
		if (iD_NB_Zone_TypeClassItemProvider != null) iD_NB_Zone_TypeClassItemProvider.dispose();
		if (iD_Oertlichkeit_Proxy_TypeClassItemProvider != null) iD_Oertlichkeit_Proxy_TypeClassItemProvider.dispose();
		if (iD_Oertlichkeit_TypeClassItemProvider != null) iD_Oertlichkeit_TypeClassItemProvider.dispose();
		if (iD_PlanPro_Schnittstelle_TypeClassItemProvider != null) iD_PlanPro_Schnittstelle_TypeClassItemProvider.dispose();
		if (iD_Planung_Einzel_TypeClassItemProvider != null) iD_Planung_Einzel_TypeClassItemProvider.dispose();
		if (iD_Planungsgrundlage_TypeClassItemProvider != null) iD_Planungsgrundlage_TypeClassItemProvider.dispose();
		if (iD_PZB_Element_Bezugspunkt_TypeClassItemProvider != null) iD_PZB_Element_Bezugspunkt_TypeClassItemProvider.dispose();
		if (iD_PZB_Element_Mitnutzung_TypeClassItemProvider != null) iD_PZB_Element_Mitnutzung_TypeClassItemProvider.dispose();
		if (iD_PZB_Element_TypeClassItemProvider != null) iD_PZB_Element_TypeClassItemProvider.dispose();
		if (iD_PZB_Element_Zuordnung_TypeClassItemProvider != null) iD_PZB_Element_Zuordnung_TypeClassItemProvider.dispose();
		if (iD_Quellelement_TypeClassItemProvider != null) iD_Quellelement_TypeClassItemProvider.dispose();
		if (iD_RBC_TypeClassItemProvider != null) iD_RBC_TypeClassItemProvider.dispose();
		if (iD_Regelzeichnung_TypeClassItemProvider != null) iD_Regelzeichnung_TypeClassItemProvider.dispose();
		if (iD_Schalter_TypeClassItemProvider != null) iD_Schalter_TypeClassItemProvider.dispose();
		if (iD_Schaltmittel_Zuordnung_TypeClassItemProvider != null) iD_Schaltmittel_Zuordnung_TypeClassItemProvider.dispose();
		if (iD_Schlosskombination_TypeClassItemProvider != null) iD_Schlosskombination_TypeClassItemProvider.dispose();
		if (iD_Schluessel_TypeClassItemProvider != null) iD_Schluessel_TypeClassItemProvider.dispose();
		if (iD_Schluesselsperre_TypeClassItemProvider != null) iD_Schluesselsperre_TypeClassItemProvider.dispose();
		if (iD_Signal_Befestigung_TypeClassItemProvider != null) iD_Signal_Befestigung_TypeClassItemProvider.dispose();
		if (iD_Signal_Fank_TypeClassItemProvider != null) iD_Signal_Fank_TypeClassItemProvider.dispose();
		if (iD_Signal_Gleisbezechnung_TypeClassItemProvider != null) iD_Signal_Gleisbezechnung_TypeClassItemProvider.dispose();
		if (iD_Signal_ohne_Proxy_TypeClassItemProvider != null) iD_Signal_ohne_Proxy_TypeClassItemProvider.dispose();
		if (iD_Signal_Rahmen_TypeClassItemProvider != null) iD_Signal_Rahmen_TypeClassItemProvider.dispose();
		if (iD_Signal_Signalbegriff_TypeClassItemProvider != null) iD_Signal_Signalbegriff_TypeClassItemProvider.dispose();
		if (iD_Signal_Start_TypeClassItemProvider != null) iD_Signal_Start_TypeClassItemProvider.dispose();
		if (iD_Signal_TypeClassItemProvider != null) iD_Signal_TypeClassItemProvider.dispose();
		if (iD_Sonderanlage_TypeClassItemProvider != null) iD_Sonderanlage_TypeClassItemProvider.dispose();
		if (iD_Stellelement_TypeClassItemProvider != null) iD_Stellelement_TypeClassItemProvider.dispose();
		if (iD_Stellwerk_TypeClassItemProvider != null) iD_Stellwerk_TypeClassItemProvider.dispose();
		if (iD_Strecke_Punkt_TypeClassItemProvider != null) iD_Strecke_Punkt_TypeClassItemProvider.dispose();
		if (iD_Strecke_TypeClassItemProvider != null) iD_Strecke_TypeClassItemProvider.dispose();
		if (iD_Technischer_Punkt_TypeClassItemProvider != null) iD_Technischer_Punkt_TypeClassItemProvider.dispose();
		if (iD_TOP_Kante_ohne_Proxy_TypeClassItemProvider != null) iD_TOP_Kante_ohne_Proxy_TypeClassItemProvider.dispose();
		if (iD_TOP_Kante_TypeClassItemProvider != null) iD_TOP_Kante_TypeClassItemProvider.dispose();
		if (iD_TOP_Knoten_TypeClassItemProvider != null) iD_TOP_Knoten_TypeClassItemProvider.dispose();
		if (iD_Trasse_Kante_TypeClassItemProvider != null) iD_Trasse_Kante_TypeClassItemProvider.dispose();
		if (iD_Trasse_Knoten_TypeClassItemProvider != null) iD_Trasse_Knoten_TypeClassItemProvider.dispose();
		if (iD_Ueberhoehung_TypeClassItemProvider != null) iD_Ueberhoehung_TypeClassItemProvider.dispose();
		if (iD_Uebertragungsweg_Nach_TypeClassItemProvider != null) iD_Uebertragungsweg_Nach_TypeClassItemProvider.dispose();
		if (iD_Uebertragungsweg_Von_TypeClassItemProvider != null) iD_Uebertragungsweg_Von_TypeClassItemProvider.dispose();
		if (iD_Umfahrpunkt_TypeClassItemProvider != null) iD_Umfahrpunkt_TypeClassItemProvider.dispose();
		if (iD_Unterbringung_ohne_Proxy_TypeClassItemProvider != null) iD_Unterbringung_ohne_Proxy_TypeClassItemProvider.dispose();
		if (iD_Unterbringung_Technik_TypeClassItemProvider != null) iD_Unterbringung_Technik_TypeClassItemProvider.dispose();
		if (iD_Unterbringung_TypeClassItemProvider != null) iD_Unterbringung_TypeClassItemProvider.dispose();
		if (iD_Ur_Objekt_TypeClassItemProvider != null) iD_Ur_Objekt_TypeClassItemProvider.dispose();
		if (iD_Verknuepftes_Element_TypeClassItemProvider != null) iD_Verknuepftes_Element_TypeClassItemProvider.dispose();
		if (iD_W_Kr_Anlage_ohne_Proxy_TypeClassItemProvider != null) iD_W_Kr_Anlage_ohne_Proxy_TypeClassItemProvider.dispose();
		if (iD_W_Kr_Anlage_TypeClassItemProvider != null) iD_W_Kr_Anlage_TypeClassItemProvider.dispose();
		if (iD_W_Kr_Gsp_Element_TypeClassItemProvider != null) iD_W_Kr_Gsp_Element_TypeClassItemProvider.dispose();
		if (iD_W_Kr_Gsp_Komponente_TypeClassItemProvider != null) iD_W_Kr_Gsp_Komponente_TypeClassItemProvider.dispose();
		if (iD_Weichenlaufkette_TypeClassItemProvider != null) iD_Weichenlaufkette_TypeClassItemProvider.dispose();
		if (iD_Ziel_TypeClassItemProvider != null) iD_Ziel_TypeClassItemProvider.dispose();
		if (iD_ZL_DLP_Fstr_TypeClassItemProvider != null) iD_ZL_DLP_Fstr_TypeClassItemProvider.dispose();
		if (iD_ZL_Fstr_TypeClassItemProvider != null) iD_ZL_Fstr_TypeClassItemProvider.dispose();
		if (iD_ZL_Signalgruppe_TypeClassItemProvider != null) iD_ZL_Signalgruppe_TypeClassItemProvider.dispose();
		if (iD_ZL_TypeClassItemProvider != null) iD_ZL_TypeClassItemProvider.dispose();
		if (iD_ZLV_Bus_TypeClassItemProvider != null) iD_ZLV_Bus_TypeClassItemProvider.dispose();
		if (iD_ZN_Anzeigefeld_Anstoss_TypeClassItemProvider != null) iD_ZN_Anzeigefeld_Anstoss_TypeClassItemProvider.dispose();
		if (iD_ZN_Anzeigefeld_TypeClassItemProvider != null) iD_ZN_Anzeigefeld_TypeClassItemProvider.dispose();
		if (iD_ZN_Fortschalt_Kriterium_TypeClassItemProvider != null) iD_ZN_Fortschalt_Kriterium_TypeClassItemProvider.dispose();
		if (iD_ZN_TypeClassItemProvider != null) iD_ZN_TypeClassItemProvider.dispose();
		if (iD_ZN_Unterstation_TypeClassItemProvider != null) iD_ZN_Unterstation_TypeClassItemProvider.dispose();
		if (iD_ZN_ZBS_TypeClassItemProvider != null) iD_ZN_ZBS_TypeClassItemProvider.dispose();
		if (iD_Zugeinwirkung_TypeClassItemProvider != null) iD_Zugeinwirkung_TypeClassItemProvider.dispose();
		if (iD_Zweites_Haltfallkriterium_TypeClassItemProvider != null) iD_Zweites_Haltfallkriterium_TypeClassItemProvider.dispose();
	}

}
