/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.clientscripting.internal;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.rap.clientscripting.ClientListener;
import org.eclipse.rap.demo.clientscripting.internal.ResourceLoaderUtil;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class CustomBehaviors {
    private static final Pattern DATE_PATTERN = Pattern.compile("^\\s*(\\d+)\\.\\s*(\\d+)\\.\\s*(\\d+)\\s*$");
    private static final String RESOURCES_PREFIX = "org/eclipse/rap/demo/clientscripting/internal/";
    private static final String[] VALID_DOMAINS = new String[]{"eclipse.org", "eclipsesource.com", "googlemail.com", "gmail.com", "nasa.gov"};

    private CustomBehaviors() {
    }

    public static void addUpperCaseBehavior(Text text) {
        String scriptCode = ResourceLoaderUtil.readTextContent("org/eclipse/rap/demo/clientscripting/internal/UpperCase.js");
        ClientListener clientListener = new ClientListener(scriptCode);
        clientListener.addTo((Widget)text, 25);
    }

    public static void addDigitsOnlyBehavior(Text text) {
        String scriptCode = ResourceLoaderUtil.readTextContent("org/eclipse/rap/demo/clientscripting/internal/DigitsOnly.js");
        ClientListener clientListener = new ClientListener(scriptCode);
        clientListener.addTo((Widget)text, 24);
    }

    public static void addDigitsOnlyEnforcementBehavior(Text text) {
        String scriptCode = ResourceLoaderUtil.readTextContent("org/eclipse/rap/demo/clientscripting/internal/DigitsOnlyEnforcement.js");
        ClientListener clientListener = new ClientListener(scriptCode);
        clientListener.addTo((Widget)text, 25);
    }

    public static void addDateFieldBehavior(Text text) {
        CustomBehaviors.addClientSideDateFieldBehavior(text);
        CustomBehaviors.addServerSideDateFieldBehavior(text);
    }

    private static void addClientSideDateFieldBehavior(Text text) {
        String scriptCode = ResourceLoaderUtil.readTextContent("org/eclipse/rap/demo/clientscripting/internal/DateField.js");
        ClientListener clientListener = new ClientListener(scriptCode);
        clientListener.addTo((Widget)text, 25);
        clientListener.addTo((Widget)text, 24);
    }

    private static void addServerSideDateFieldBehavior(final Text text) {
        text.setMessage("DD.MM.YYYY");
        text.setTextLimit("DD.MM.YYYY".length());
        text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent event) {
                String dateText = text.getText();
                if (dateText.length() > 0) {
                    try {
                        String date = CustomBehaviors.evaluateDate(dateText);
                        text.setText(date);
                        CustomBehaviors.showWarning(text, null);
                    }
                    catch (Exception exception) {
                        CustomBehaviors.showWarning(text, exception.getMessage());
                    }
                }
            }
        });
    }

    public static void addCounterBehavior(Control control) {
        String scriptCode = ResourceLoaderUtil.readTextContent("org/eclipse/rap/demo/clientscripting/internal/Counter.js");
        ClientListener listener = new ClientListener(scriptCode);
        listener.addTo((Widget)control, 3);
    }

    public static void addEMailBehavior(Text text) {
        CustomBehaviors.addClientSideEmailBehavior(text);
        CustomBehaviors.addServerSideEmailBehavior(text);
    }

    private static void addClientSideEmailBehavior(Text text) {
        String scriptCode = ResourceLoaderUtil.readTextContent("org/eclipse/rap/demo/clientscripting/internal/Email.js");
        ClientListener listener = new ClientListener(scriptCode);
        listener.addTo((Widget)text, 24);
    }

    private static void addServerSideEmailBehavior(final Text text) {
        text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent event) {
                String mail = text.getText();
                if (mail.matches("^\\S+@\\S+\\.[a-zA-Z]{2,5}$")) {
                    boolean valid = false;
                    int i = 0;
                    while (i < VALID_DOMAINS.length) {
                        String domain = VALID_DOMAINS[i];
                        if (mail.endsWith(domain)) {
                            valid = true;
                        }
                        ++i;
                    }
                    if (!valid) {
                        String message = "This is an unkown domain. Following domains are valid:\n";
                        int i2 = 0;
                        while (i2 < VALID_DOMAINS.length) {
                            message = String.valueOf(message) + VALID_DOMAINS[i2];
                            if (i2 < VALID_DOMAINS.length - 1) {
                                message = String.valueOf(message) + ", ";
                            }
                            ++i2;
                        }
                        CustomBehaviors.showWarning(text, message);
                    }
                }
            }
        });
    }

    public static void addLoggerBehavior(Widget widget) {
        String scriptCode = ResourceLoaderUtil.readTextContent("org/eclipse/rap/demo/clientscripting/internal/Logger.js");
        ClientListener listener = new ClientListener(scriptCode);
        listener.addTo(widget, 1);
        listener.addTo(widget, 2);
        listener.addTo(widget, 15);
        listener.addTo(widget, 16);
        listener.addTo(widget, 3);
        listener.addTo(widget, 4);
        listener.addTo(widget, 6);
        listener.addTo(widget, 7);
        listener.addTo(widget, 5);
        listener.addTo(widget, 8);
    }

    private static void showWarning(Text text, String message) {
        if (message == null) {
            text.setBackground(null);
            text.setToolTipText(null);
        } else {
            text.setBackground(new Color((Device)text.getDisplay(), 255, 255, 128));
            text.setToolTipText(message);
        }
    }

    private static String evaluateDate(String string) {
        Matcher matcher = DATE_PATTERN.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Illegal date format, expected: DD.MM.YYYY");
        }
        int day = Integer.parseInt(matcher.group(1));
        int month = Integer.parseInt(matcher.group(2));
        int year = Integer.parseInt(matcher.group(3));
        if (day < 0) {
            throw new IllegalArgumentException("Illegal year: " + year);
        }
        if (year < 50) {
            year += 2000;
        } else if (year < 100) {
            year += 1900;
        }
        if (month < 1 || month > 12) {
            throw new IllegalArgumentException("Illegal month: " + month);
        }
        if (day < 1 || day > 31) {
            throw new IllegalArgumentException("Illegal day: " + day);
        }
        return CustomBehaviors.formatDate(day, month, year);
    }

    private static String formatDate(int day, int month, int year) {
        StringBuilder builder = new StringBuilder();
        builder.append(CustomBehaviors.padZero(day, 2));
        builder.append(".");
        builder.append(CustomBehaviors.padZero(month, 2));
        builder.append(".");
        builder.append(year);
        return builder.toString();
    }

    private static String padZero(int number, int length) {
        String result = Integer.toString(number);
        if (result.length() < length) {
            StringBuilder builder = new StringBuilder();
            int i = result.length();
            while (i < length) {
                builder.append('0');
                ++i;
            }
            builder.append(result);
            result = builder.toString();
        }
        return result;
    }
}

