/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Loader;
import org.apache.catalina.Session;
import org.apache.catalina.security.SecurityUtil;
import org.apache.catalina.session.ManagerBase;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.util.CustomObjectInputStream;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;

public class StandardManager
extends ManagerBase {
    private final Log log = LogFactory.getLog(StandardManager.class);
    protected static final String info = "StandardManager/1.0";
    protected static String name = "StandardManager";
    protected String pathname = "SESSIONS.ser";

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public String getName() {
        return name;
    }

    public String getPathname() {
        return this.pathname;
    }

    public void setPathname(String pathname) {
        String oldPathname = this.pathname;
        this.pathname = pathname;
        this.support.firePropertyChange("pathname", oldPathname, this.pathname);
    }

    @Override
    public void load() throws ClassNotFoundException, IOException {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                AccessController.doPrivileged(new PrivilegedDoLoad());
            }
            catch (PrivilegedActionException ex) {
                Exception exception = ex.getException();
                if (exception instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)exception;
                }
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Unreported exception in load() " + exception);
                }
            }
        } else {
            this.doLoad();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doLoad() throws ClassNotFoundException, IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Start: Loading persisted sessions");
        }
        this.sessions.clear();
        File file = this.file();
        if (file == null) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(sm.getString("standardManager.loading", this.pathname));
        }
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        ObjectInputStream ois = null;
        Loader loader = null;
        ClassLoader classLoader = null;
        try {
            fis = new FileInputStream(file.getAbsolutePath());
            bis = new BufferedInputStream(fis);
            if (this.container != null) {
                loader = this.container.getLoader();
            }
            if (loader != null) {
                classLoader = loader.getClassLoader();
            }
            if (classLoader != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Creating custom object input stream for class loader ");
                }
                ois = new CustomObjectInputStream(bis, classLoader);
            } else {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Creating standard object input stream");
                }
                ois = new ObjectInputStream(bis);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("No persisted data file found");
            }
            return;
        }
        catch (IOException e) {
            this.log.error(sm.getString("standardManager.loading.ioe", e), e);
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException iOException) {}
            }
            throw e;
        }
        Map map = this.sessions;
        synchronized (map) {
            try {
                try {
                    Integer count = (Integer)ois.readObject();
                    int n = count;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Loading " + n + " persisted sessions");
                    }
                    int i = 0;
                    while (i < n) {
                        StandardSession session = this.getNewSession();
                        session.readObjectData(ois);
                        session.setManager(this);
                        this.sessions.put(session.getIdInternal(), session);
                        session.activate();
                        if (!session.isValidInternal()) {
                            session.setValid(true);
                            session.expire();
                        }
                        ++this.sessionCounter;
                        ++i;
                    }
                }
                catch (ClassNotFoundException e) {
                    this.log.error(sm.getString("standardManager.loading.cnfe", e), e);
                    try {
                        ois.close();
                    }
                    catch (IOException iOException) {}
                    throw e;
                }
                catch (IOException e) {
                    this.log.error(sm.getString("standardManager.loading.ioe", e), e);
                    try {
                        ois.close();
                    }
                    catch (IOException iOException) {}
                    throw e;
                }
            }
            catch (Throwable throwable) {
                try {
                    ois.close();
                }
                catch (IOException iOException) {}
                if (file.exists()) {
                    file.delete();
                }
                throw throwable;
            }
            try {
                ois.close();
            }
            catch (IOException iOException) {}
            if (file.exists()) {
                file.delete();
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Finish: Loading persisted sessions");
        }
    }

    @Override
    public void unload() throws IOException {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                AccessController.doPrivileged(new PrivilegedDoUnload());
            }
            catch (PrivilegedActionException ex) {
                Exception exception = ex.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Unreported exception in unLoad() " + exception);
                }
            }
        } else {
            this.doUnload();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doUnload() throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug(sm.getString("standardManager.unloading.debug"));
        }
        if (this.sessions.isEmpty()) {
            this.log.debug(sm.getString("standardManager.unloading.nosessions"));
            return;
        }
        File file = this.file();
        if (file == null) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(sm.getString("standardManager.unloading", this.pathname));
        }
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            fos = new FileOutputStream(file.getAbsolutePath());
            oos = new ObjectOutputStream(new BufferedOutputStream(fos));
        }
        catch (IOException e) {
            this.log.error(sm.getString("standardManager.unloading.ioe", e), e);
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
            throw e;
        }
        ArrayList<StandardSession> list = new ArrayList<StandardSession>();
        Map map = this.sessions;
        synchronized (map) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Unloading " + this.sessions.size() + " sessions");
            }
            try {
                oos.writeObject(new Integer(this.sessions.size()));
                for (StandardSession session : this.sessions.values()) {
                    list.add(session);
                    session.passivate();
                    session.writeObjectData(oos);
                }
            }
            catch (IOException e) {
                this.log.error(sm.getString("standardManager.unloading.ioe", e), e);
                try {
                    oos.close();
                }
                catch (IOException iOException) {}
                throw e;
            }
        }
        try {
            oos.flush();
        }
        catch (Throwable throwable) {
            try {
                oos.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            oos.close();
        }
        catch (IOException iOException) {}
        if (this.log.isDebugEnabled()) {
            this.log.debug("Expiring " + list.size() + " persisted sessions");
        }
        for (StandardSession session : list) {
            try {
                try {
                    session.expire(false);
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable(t);
                    session.recycle();
                    continue;
                }
            }
            catch (Throwable throwable) {
                session.recycle();
                throw throwable;
            }
            session.recycle();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Unloading complete");
        }
    }

    @Override
    protected synchronized void startInternal() throws LifecycleException {
        super.startInternal();
        try {
            this.load();
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            this.log.error(sm.getString("standardManager.managerLoad"), t);
        }
        this.setState(LifecycleState.STARTING);
    }

    @Override
    protected synchronized void stopInternal() throws LifecycleException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Stopping");
        }
        this.setState(LifecycleState.STOPPING);
        try {
            this.unload();
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            this.log.error(sm.getString("standardManager.managerUnload"), t);
        }
        Session[] sessions = this.findSessions();
        int i = 0;
        while (i < sessions.length) {
            block10: {
                Session session = sessions[i];
                try {
                    try {
                        if (session.isValid()) {
                            session.expire();
                        }
                    }
                    catch (Throwable t) {
                        ExceptionUtils.handleThrowable(t);
                        session.recycle();
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    session.recycle();
                    throw throwable;
                }
                session.recycle();
            }
            ++i;
        }
        super.stopInternal();
    }

    protected File file() {
        ServletContext servletContext;
        File tempdir;
        if (this.pathname == null || this.pathname.length() == 0) {
            return null;
        }
        File file = new File(this.pathname);
        if (!file.isAbsolute() && this.container instanceof Context && (tempdir = (File)(servletContext = ((Context)this.container).getServletContext()).getAttribute("javax.servlet.context.tempdir")) != null) {
            file = new File(tempdir, this.pathname);
        }
        return file;
    }

    private class PrivilegedDoLoad
    implements PrivilegedExceptionAction<Void> {
        PrivilegedDoLoad() {
        }

        @Override
        public Void run() throws Exception {
            StandardManager.this.doLoad();
            return null;
        }
    }

    private class PrivilegedDoUnload
    implements PrivilegedExceptionAction<Void> {
        PrivilegedDoUnload() {
        }

        @Override
        public Void run() throws Exception {
            StandardManager.this.doUnload();
            return null;
        }
    }
}

