/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.deploy;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Hashtable;
import javax.naming.NamingException;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Server;
import org.apache.catalina.deploy.ContextEjb;
import org.apache.catalina.deploy.ContextEnvironment;
import org.apache.catalina.deploy.ContextLocalEjb;
import org.apache.catalina.deploy.ContextResource;
import org.apache.catalina.deploy.ContextResourceEnvRef;
import org.apache.catalina.deploy.ContextResourceLink;
import org.apache.catalina.deploy.ContextService;
import org.apache.catalina.deploy.ContextTransaction;
import org.apache.catalina.deploy.MessageDestinationRef;
import org.apache.catalina.mbeans.MBeanUtils;
import org.apache.catalina.util.LifecycleMBeanBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.naming.ContextBindings;
import org.apache.tomcat.util.res.StringManager;

public class NamingResources
extends LifecycleMBeanBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(NamingResources.class);
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.deploy");
    private volatile boolean resourceRequireExplicitRegistration = false;
    private Object container = null;
    private Hashtable<String, String> entries = new Hashtable();
    private HashMap<String, ContextEjb> ejbs = new HashMap();
    private HashMap<String, ContextEnvironment> envs = new HashMap();
    private HashMap<String, ContextLocalEjb> localEjbs = new HashMap();
    private HashMap<String, MessageDestinationRef> mdrs = new HashMap();
    private HashMap<String, ContextResourceEnvRef> resourceEnvRefs = new HashMap();
    private HashMap<String, ContextResource> resources = new HashMap();
    private HashMap<String, ContextResourceLink> resourceLinks = new HashMap();
    private HashMap<String, ContextService> services = new HashMap();
    private ContextTransaction transaction = null;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);

    public Object getContainer() {
        return this.container;
    }

    public void setContainer(Object container) {
        this.container = container;
    }

    public void setTransaction(ContextTransaction transaction) {
        this.transaction = transaction;
    }

    public ContextTransaction getTransaction() {
        return this.transaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEjb(ContextEjb ejb) {
        if (this.entries.containsKey(ejb.getName())) {
            return;
        }
        this.entries.put(ejb.getName(), ejb.getType());
        HashMap<String, ContextEjb> hashMap = this.ejbs;
        synchronized (hashMap) {
            ejb.setNamingResources(this);
            this.ejbs.put(ejb.getName(), ejb);
        }
        this.support.firePropertyChange("ejb", null, ejb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addEnvironment(ContextEnvironment environment) {
        Serializable ce;
        if (this.entries.containsKey(environment.getName())) {
            ce = this.findEnvironment(environment.getName());
            ContextResourceLink rl = this.findResourceLink(environment.getName());
            if (ce != null) {
                if (!((ContextEnvironment)ce).getOverride()) return;
                this.removeEnvironment(environment.getName());
            } else {
                if (rl == null) return;
                NamingResources global = this.getServer().getGlobalNamingResources();
                if (global.findEnvironment(rl.getGlobal()) != null) {
                    if (!global.findEnvironment(rl.getGlobal()).getOverride()) return;
                    this.removeResourceLink(environment.getName());
                }
            }
        }
        this.entries.put(environment.getName(), environment.getType());
        ce = this.envs;
        synchronized (ce) {
            environment.setNamingResources(this);
            this.envs.put(environment.getName(), environment);
        }
        this.support.firePropertyChange("environment", null, environment);
        if (!this.resourceRequireExplicitRegistration) return;
        try {
            MBeanUtils.createMBean(environment);
            return;
        }
        catch (Exception e) {
            log.warn(sm.getString("namingResources.mbeanCreateFail", environment.getName()), e);
        }
    }

    private Server getServer() {
        if (this.container instanceof Server) {
            return (Server)this.container;
        }
        if (this.container instanceof Context) {
            Engine engine = (Engine)((Context)this.container).getParent().getParent();
            return engine.getService().getServer();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLocalEjb(ContextLocalEjb ejb) {
        if (this.entries.containsKey(ejb.getName())) {
            return;
        }
        this.entries.put(ejb.getName(), ejb.getType());
        HashMap<String, ContextLocalEjb> hashMap = this.localEjbs;
        synchronized (hashMap) {
            ejb.setNamingResources(this);
            this.localEjbs.put(ejb.getName(), ejb);
        }
        this.support.firePropertyChange("localEjb", null, ejb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageDestinationRef(MessageDestinationRef mdr) {
        if (this.entries.containsKey(mdr.getName())) {
            return;
        }
        this.entries.put(mdr.getName(), mdr.getType());
        HashMap<String, MessageDestinationRef> hashMap = this.mdrs;
        synchronized (hashMap) {
            mdr.setNamingResources(this);
            this.mdrs.put(mdr.getName(), mdr);
        }
        this.support.firePropertyChange("messageDestinationRef", null, mdr);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResource(ContextResource resource) {
        if (this.entries.containsKey(resource.getName())) {
            return;
        }
        this.entries.put(resource.getName(), resource.getType());
        HashMap<String, ContextResource> hashMap = this.resources;
        synchronized (hashMap) {
            resource.setNamingResources(this);
            this.resources.put(resource.getName(), resource);
        }
        this.support.firePropertyChange("resource", null, resource);
        if (this.resourceRequireExplicitRegistration) {
            try {
                MBeanUtils.createMBean(resource);
            }
            catch (Exception e) {
                log.warn(sm.getString("namingResources.mbeanCreateFail", resource.getName()), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResourceEnvRef(ContextResourceEnvRef resource) {
        if (this.entries.containsKey(resource.getName())) {
            return;
        }
        this.entries.put(resource.getName(), resource.getType());
        HashMap<String, ContextResourceEnvRef> hashMap = this.resourceEnvRefs;
        synchronized (hashMap) {
            resource.setNamingResources(this);
            this.resourceEnvRefs.put(resource.getName(), resource);
        }
        this.support.firePropertyChange("resourceEnvRef", null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResourceLink(ContextResourceLink resourceLink) {
        if (this.entries.containsKey(resourceLink.getName())) {
            return;
        }
        Object value = resourceLink.getType();
        if (value == null) {
            value = "";
        }
        this.entries.put(resourceLink.getName(), (String)value);
        value = this.resourceLinks;
        synchronized (value) {
            resourceLink.setNamingResources(this);
            this.resourceLinks.put(resourceLink.getName(), resourceLink);
        }
        this.support.firePropertyChange("resourceLink", null, resourceLink);
        if (this.resourceRequireExplicitRegistration) {
            try {
                MBeanUtils.createMBean(resourceLink);
            }
            catch (Exception e) {
                log.warn(sm.getString("namingResources.mbeanCreateFail", resourceLink.getName()), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addService(ContextService service) {
        if (this.entries.containsKey(service.getName())) {
            return;
        }
        String value = service.getType();
        if (value == null) {
            value = "";
        }
        this.entries.put(service.getName(), value);
        HashMap<String, ContextService> hashMap = this.services;
        synchronized (hashMap) {
            service.setNamingResources(this);
            this.services.put(service.getName(), service);
        }
        this.support.firePropertyChange("service", null, service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextEjb findEjb(String name) {
        HashMap<String, ContextEjb> hashMap = this.ejbs;
        synchronized (hashMap) {
            return this.ejbs.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextEjb[] findEjbs() {
        HashMap<String, ContextEjb> hashMap = this.ejbs;
        synchronized (hashMap) {
            ContextEjb[] results = new ContextEjb[this.ejbs.size()];
            return this.ejbs.values().toArray(results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextEnvironment findEnvironment(String name) {
        HashMap<String, ContextEnvironment> hashMap = this.envs;
        synchronized (hashMap) {
            return this.envs.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextEnvironment[] findEnvironments() {
        HashMap<String, ContextEnvironment> hashMap = this.envs;
        synchronized (hashMap) {
            ContextEnvironment[] results = new ContextEnvironment[this.envs.size()];
            return this.envs.values().toArray(results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextLocalEjb findLocalEjb(String name) {
        HashMap<String, ContextLocalEjb> hashMap = this.localEjbs;
        synchronized (hashMap) {
            return this.localEjbs.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextLocalEjb[] findLocalEjbs() {
        HashMap<String, ContextLocalEjb> hashMap = this.localEjbs;
        synchronized (hashMap) {
            ContextLocalEjb[] results = new ContextLocalEjb[this.localEjbs.size()];
            return this.localEjbs.values().toArray(results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageDestinationRef findMessageDestinationRef(String name) {
        HashMap<String, MessageDestinationRef> hashMap = this.mdrs;
        synchronized (hashMap) {
            return this.mdrs.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageDestinationRef[] findMessageDestinationRefs() {
        HashMap<String, MessageDestinationRef> hashMap = this.mdrs;
        synchronized (hashMap) {
            MessageDestinationRef[] results = new MessageDestinationRef[this.mdrs.size()];
            return this.mdrs.values().toArray(results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextResource findResource(String name) {
        HashMap<String, ContextResource> hashMap = this.resources;
        synchronized (hashMap) {
            return this.resources.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextResourceLink findResourceLink(String name) {
        HashMap<String, ContextResourceLink> hashMap = this.resourceLinks;
        synchronized (hashMap) {
            return this.resourceLinks.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextResourceLink[] findResourceLinks() {
        HashMap<String, ContextResourceLink> hashMap = this.resourceLinks;
        synchronized (hashMap) {
            ContextResourceLink[] results = new ContextResourceLink[this.resourceLinks.size()];
            return this.resourceLinks.values().toArray(results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextResource[] findResources() {
        HashMap<String, ContextResource> hashMap = this.resources;
        synchronized (hashMap) {
            ContextResource[] results = new ContextResource[this.resources.size()];
            return this.resources.values().toArray(results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextResourceEnvRef findResourceEnvRef(String name) {
        HashMap<String, ContextResourceEnvRef> hashMap = this.resourceEnvRefs;
        synchronized (hashMap) {
            return this.resourceEnvRefs.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextResourceEnvRef[] findResourceEnvRefs() {
        HashMap<String, ContextResourceEnvRef> hashMap = this.resourceEnvRefs;
        synchronized (hashMap) {
            ContextResourceEnvRef[] results = new ContextResourceEnvRef[this.resourceEnvRefs.size()];
            return this.resourceEnvRefs.values().toArray(results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextService findService(String name) {
        HashMap<String, ContextService> hashMap = this.services;
        synchronized (hashMap) {
            return this.services.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextService[] findServices() {
        HashMap<String, ContextService> hashMap = this.services;
        synchronized (hashMap) {
            ContextService[] results = new ContextService[this.services.size()];
            return this.services.values().toArray(results);
        }
    }

    public boolean exists(String name) {
        return this.entries.containsKey(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEjb(String name) {
        this.entries.remove(name);
        ContextEjb ejb = null;
        HashMap<String, ContextEjb> hashMap = this.ejbs;
        synchronized (hashMap) {
            ejb = this.ejbs.remove(name);
        }
        if (ejb != null) {
            this.support.firePropertyChange("ejb", ejb, null);
            ejb.setNamingResources(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEnvironment(String name) {
        this.entries.remove(name);
        ContextEnvironment environment = null;
        HashMap<String, ContextEnvironment> hashMap = this.envs;
        synchronized (hashMap) {
            environment = this.envs.remove(name);
        }
        if (environment != null) {
            this.support.firePropertyChange("environment", environment, null);
            if (this.resourceRequireExplicitRegistration) {
                try {
                    MBeanUtils.destroyMBean(environment);
                }
                catch (Exception e) {
                    log.warn(sm.getString("namingResources.mbeanDestroyFail", environment.getName()), e);
                }
            }
            environment.setNamingResources(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocalEjb(String name) {
        this.entries.remove(name);
        ContextLocalEjb localEjb = null;
        HashMap<String, ContextLocalEjb> hashMap = this.localEjbs;
        synchronized (hashMap) {
            localEjb = this.localEjbs.remove(name);
        }
        if (localEjb != null) {
            this.support.firePropertyChange("localEjb", localEjb, null);
            localEjb.setNamingResources(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageDestinationRef(String name) {
        this.entries.remove(name);
        MessageDestinationRef mdr = null;
        HashMap<String, MessageDestinationRef> hashMap = this.mdrs;
        synchronized (hashMap) {
            mdr = this.mdrs.remove(name);
        }
        if (mdr != null) {
            this.support.firePropertyChange("messageDestinationRef", mdr, null);
            mdr.setNamingResources(null);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResource(String name) {
        this.entries.remove(name);
        ContextResource resource = null;
        HashMap<String, ContextResource> hashMap = this.resources;
        synchronized (hashMap) {
            resource = this.resources.remove(name);
        }
        if (resource != null) {
            this.support.firePropertyChange("resource", resource, null);
            if (this.resourceRequireExplicitRegistration) {
                try {
                    MBeanUtils.destroyMBean(resource);
                }
                catch (Exception e) {
                    log.warn(sm.getString("namingResources.mbeanDestroyFail", resource.getName()), e);
                }
            }
            resource.setNamingResources(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResourceEnvRef(String name) {
        this.entries.remove(name);
        ContextResourceEnvRef resourceEnvRef = null;
        HashMap<String, ContextResourceEnvRef> hashMap = this.resourceEnvRefs;
        synchronized (hashMap) {
            resourceEnvRef = this.resourceEnvRefs.remove(name);
        }
        if (resourceEnvRef != null) {
            this.support.firePropertyChange("resourceEnvRef", resourceEnvRef, null);
            resourceEnvRef.setNamingResources(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResourceLink(String name) {
        this.entries.remove(name);
        ContextResourceLink resourceLink = null;
        HashMap<String, ContextResourceLink> hashMap = this.resourceLinks;
        synchronized (hashMap) {
            resourceLink = this.resourceLinks.remove(name);
        }
        if (resourceLink != null) {
            this.support.firePropertyChange("resourceLink", resourceLink, null);
            if (this.resourceRequireExplicitRegistration) {
                try {
                    MBeanUtils.destroyMBean(resourceLink);
                }
                catch (Exception e) {
                    log.warn(sm.getString("namingResources.mbeanDestroyFail", resourceLink.getName()), e);
                }
            }
            resourceLink.setNamingResources(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeService(String name) {
        this.entries.remove(name);
        ContextService service = null;
        HashMap<String, ContextService> hashMap = this.services;
        synchronized (hashMap) {
            service = this.services.remove(name);
        }
        if (service != null) {
            this.support.firePropertyChange("service", service, null);
            service.setNamingResources(null);
        }
    }

    @Override
    protected void initInternal() throws LifecycleException {
        super.initInternal();
        this.resourceRequireExplicitRegistration = true;
        for (ContextResource cr : this.resources.values()) {
            try {
                MBeanUtils.createMBean(cr);
            }
            catch (Exception e) {
                log.warn(sm.getString("namingResources.mbeanCreateFail", cr.getName()), e);
            }
        }
        for (ContextEnvironment ce : this.envs.values()) {
            try {
                MBeanUtils.createMBean(ce);
            }
            catch (Exception e) {
                log.warn(sm.getString("namingResources.mbeanCreateFail", ce.getName()), e);
            }
        }
        for (ContextResourceLink crl : this.resourceLinks.values()) {
            try {
                MBeanUtils.createMBean(crl);
            }
            catch (Exception e) {
                log.warn(sm.getString("namingResources.mbeanCreateFail", crl.getName()), e);
            }
        }
    }

    @Override
    protected void startInternal() throws LifecycleException {
        this.fireLifecycleEvent("configure_start", null);
        this.setState(LifecycleState.STARTING);
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        this.cleanUp();
        this.setState(LifecycleState.STOPPING);
        this.fireLifecycleEvent("configure_stop", null);
    }

    private void cleanUp() {
        javax.naming.Context ctxt;
        if (this.resources.size() == 0) {
            return;
        }
        try {
            if (this.container instanceof Server) {
                ctxt = ((Server)this.container).getGlobalNamingContext();
            } else {
                ctxt = ContextBindings.getClassLoader();
                ctxt = (javax.naming.Context)ctxt.lookup("comp/env");
            }
        }
        catch (NamingException e) {
            log.warn(sm.getString("namingResources.cleanupNoContext", this.container), e);
            return;
        }
        for (ContextResource cr : this.resources.values()) {
            Object resource;
            String closeMethod;
            if (!cr.getSingleton() || (closeMethod = cr.getCloseMethod()) == null || closeMethod.length() <= 0) continue;
            String name = cr.getName();
            try {
                resource = ctxt.lookup(name);
            }
            catch (NamingException e) {
                log.warn(sm.getString("namingResources.cleanupNoResource", cr.getName(), this.container), e);
                continue;
            }
            this.cleanUp(resource, name, closeMethod);
        }
    }

    private void cleanUp(Object resource, String name, String closeMethod) {
        Method m = null;
        try {
            m = resource.getClass().getMethod(closeMethod, null);
        }
        catch (SecurityException securityException) {
            log.debug(sm.getString("namingResources.cleanupCloseSecurity", closeMethod, name, this.container));
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            log.debug(sm.getString("namingResources.cleanupNoClose", name, this.container, closeMethod));
            return;
        }
        if (m != null) {
            try {
                m.invoke(resource, null);
            }
            catch (IllegalArgumentException e) {
                log.warn(sm.getString("namingResources.cleanupCloseFailed", closeMethod, name, this.container), e);
            }
            catch (IllegalAccessException e) {
                log.warn(sm.getString("namingResources.cleanupCloseFailed", closeMethod, name, this.container), e);
            }
            catch (InvocationTargetException e) {
                log.warn(sm.getString("namingResources.cleanupCloseFailed", closeMethod, name, this.container), e);
            }
        }
    }

    @Override
    protected void destroyInternal() throws LifecycleException {
        this.resourceRequireExplicitRegistration = false;
        for (ContextResourceLink crl : this.resourceLinks.values()) {
            try {
                MBeanUtils.destroyMBean(crl);
            }
            catch (Exception e) {
                log.warn(sm.getString("namingResources.mbeanDestroyFail", crl.getName()), e);
            }
        }
        for (ContextEnvironment ce : this.envs.values()) {
            try {
                MBeanUtils.destroyMBean(ce);
            }
            catch (Exception e) {
                log.warn(sm.getString("namingResources.mbeanDestroyFail", ce.getName()), e);
            }
        }
        for (ContextResource cr : this.resources.values()) {
            try {
                MBeanUtils.destroyMBean(cr);
            }
            catch (Exception e) {
                log.warn(sm.getString("namingResources.mbeanDestroyFail", cr.getName()), e);
            }
        }
        super.destroyInternal();
    }

    @Override
    protected String getDomainInternal() {
        Object c = this.getContainer();
        if (c instanceof LifecycleMBeanBase) {
            return ((LifecycleMBeanBase)c).getDomain();
        }
        return null;
    }

    @Override
    protected String getObjectNameKeyProperties() {
        Object c = this.getContainer();
        if (c instanceof Container) {
            return "type=NamingResources" + MBeanUtils.getContainerKeyProperties((Container)c);
        }
        return "type=NamingResources";
    }
}

