/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.DispatcherType;
import javax.servlet.FilterRegistration;
import org.apache.catalina.Context;
import org.apache.catalina.deploy.FilterDef;
import org.apache.catalina.deploy.FilterMap;
import org.apache.catalina.util.ParameterMap;
import org.apache.tomcat.util.res.StringManager;

public class ApplicationFilterRegistration
implements FilterRegistration.Dynamic {
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    private FilterDef filterDef;
    private Context context;

    public ApplicationFilterRegistration(FilterDef filterDef, Context context) {
        this.filterDef = filterDef;
        this.context = context;
    }

    public void addMappingForServletNames(EnumSet<DispatcherType> dispatcherTypes, boolean isMatchAfter, String ... servletNames) {
        FilterMap filterMap = new FilterMap();
        filterMap.setFilterName(this.filterDef.getFilterName());
        if (dispatcherTypes != null) {
            for (DispatcherType dispatcherType : dispatcherTypes) {
                filterMap.setDispatcher(dispatcherType.name());
            }
        }
        if (servletNames != null) {
            String[] stringArray = servletNames;
            int n = servletNames.length;
            int n2 = 0;
            while (n2 < n) {
                String servletName = stringArray[n2];
                filterMap.addServletName(servletName);
                ++n2;
            }
            if (isMatchAfter) {
                this.context.addFilterMapBefore(filterMap);
            } else {
                this.context.addFilterMap(filterMap);
            }
        }
    }

    public void addMappingForUrlPatterns(EnumSet<DispatcherType> dispatcherTypes, boolean isMatchAfter, String ... urlPatterns) {
        FilterMap filterMap = new FilterMap();
        filterMap.setFilterName(this.filterDef.getFilterName());
        if (dispatcherTypes != null) {
            for (DispatcherType dispatcherType : dispatcherTypes) {
                filterMap.setDispatcher(dispatcherType.name());
            }
        }
        if (urlPatterns != null) {
            String[] stringArray = urlPatterns;
            int n = urlPatterns.length;
            int n2 = 0;
            while (n2 < n) {
                String urlPattern = stringArray[n2];
                filterMap.addURLPattern(urlPattern);
                ++n2;
            }
            if (isMatchAfter) {
                this.context.addFilterMapBefore(filterMap);
            } else {
                this.context.addFilterMap(filterMap);
            }
        }
    }

    public Collection<String> getServletNameMappings() {
        FilterMap[] filterMaps;
        HashSet<String> result = new HashSet<String>();
        FilterMap[] filterMapArray = filterMaps = this.context.findFilterMaps();
        int n = filterMaps.length;
        int n2 = 0;
        while (n2 < n) {
            FilterMap filterMap = filterMapArray[n2];
            if (filterMap.getFilterName().equals(this.filterDef.getFilterName())) {
                String[] stringArray = filterMap.getServletNames();
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String servletName = stringArray[n4];
                    result.add(servletName);
                    ++n4;
                }
            }
            ++n2;
        }
        return result;
    }

    public Collection<String> getUrlPatternMappings() {
        FilterMap[] filterMaps;
        HashSet<String> result = new HashSet<String>();
        FilterMap[] filterMapArray = filterMaps = this.context.findFilterMaps();
        int n = filterMaps.length;
        int n2 = 0;
        while (n2 < n) {
            FilterMap filterMap = filterMapArray[n2];
            if (filterMap.getFilterName().equals(this.filterDef.getFilterName())) {
                String[] stringArray = filterMap.getURLPatterns();
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String urlPattern = stringArray[n4];
                    result.add(urlPattern);
                    ++n4;
                }
            }
            ++n2;
        }
        return result;
    }

    public String getClassName() {
        return this.filterDef.getFilterClass();
    }

    public String getInitParameter(String name) {
        return this.filterDef.getParameterMap().get(name);
    }

    public Map<String, String> getInitParameters() {
        ParameterMap<String, String> result = new ParameterMap<String, String>();
        result.putAll(this.filterDef.getParameterMap());
        result.setLocked(true);
        return result;
    }

    public String getName() {
        return this.filterDef.getFilterName();
    }

    public boolean setInitParameter(String name, String value) {
        if (name == null || value == null) {
            throw new IllegalArgumentException(sm.getString("applicationFilterRegistration.nullInitParam", name, value));
        }
        if (this.getInitParameter(name) != null) {
            return false;
        }
        this.filterDef.addInitParameter(name, value);
        return true;
    }

    public Set<String> setInitParameters(Map<String, String> initParameters) {
        HashSet<String> conflicts = new HashSet<String>();
        for (Map.Entry<String, String> entry : initParameters.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) {
                throw new IllegalArgumentException(sm.getString("applicationFilterRegistration.nullInitParams", entry.getKey(), entry.getValue()));
            }
            if (this.getInitParameter(entry.getKey()) == null) continue;
            conflicts.add(entry.getKey());
        }
        for (Map.Entry<String, String> entry : initParameters.entrySet()) {
            this.setInitParameter(entry.getKey(), entry.getValue());
        }
        return conflicts;
    }

    public void setAsyncSupported(boolean asyncSupported) {
        this.filterDef.setAsyncSupported(Boolean.valueOf(asyncSupported).toString());
    }
}

