/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.conversion;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.Format;
import org.eclipse.core.internal.databinding.conversion.NumberToNumberConverter;

public class NumberToBigIntegerConverter
extends NumberToNumberConverter<BigInteger> {
    public NumberToBigIntegerConverter(Format numberFormat, Class<?> fromType) {
        super(numberFormat, fromType, BigInteger.class);
    }

    @Override
    protected BigInteger doConvert(Number number) {
        return NumberToBigIntegerConverter.toBigDecimal(number).toBigInteger();
    }

    private static BigDecimal toBigDecimal(Number number) {
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        return BigDecimal.valueOf(number.doubleValue());
    }
}

