/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.preferences;

import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.internal.preferences.PrefsMessages;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.preferences.AbstractPreferenceStorage;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.prefs.BackingStoreException;

public class ScopeDescriptor {
    String name;
    AbstractPreferenceStorage storage;
    Set<String> loadedNodes = Collections.synchronizedSet(new HashSet());

    public ScopeDescriptor(AbstractPreferenceStorage storage) {
        this.storage = storage;
    }

    String getName() {
        return this.name;
    }

    IEclipsePreferences getLoadLevel(IEclipsePreferences node) {
        String path = node.absolutePath();
        int count = EclipsePreferences.getSegmentCount(path);
        if (count == 1 || count == 0) {
            return null;
        }
        if (count == 2) {
            return node;
        }
        int i = count;
        while (i > 2 && node.parent() != null) {
            node = (IEclipsePreferences)node.parent();
            --i;
        }
        return node;
    }

    String[] childrenNames(final String path) throws BackingStoreException {
        if (this.storage == null) {
            return new String[0];
        }
        final String[][] result = new String[1][];
        final BackingStoreException[] bse = new BackingStoreException[1];
        ISafeRunnable code = new ISafeRunnable(){

            public void run() throws Exception {
                result[0] = ScopeDescriptor.this.storage.childrenNames(path);
            }

            public void handleException(Throwable exception) {
                bse[0] = exception instanceof BackingStoreException ? (BackingStoreException)exception : new BackingStoreException(NLS.bind((String)PrefsMessages.childrenNames2, (Object)path), exception);
            }
        };
        SafeRunner.run((ISafeRunnable)code);
        if (bse[0] != null) {
            throw bse[0];
        }
        return result[0] == null ? new String[]{} : result[0];
    }

    Properties load(final String path) throws BackingStoreException {
        if (this.storage == null) {
            return null;
        }
        final Properties[] result = new Properties[1];
        final BackingStoreException[] bse = new BackingStoreException[1];
        ISafeRunnable code = new ISafeRunnable(){

            public void run() throws Exception {
                result[0] = ScopeDescriptor.this.storage.load(path);
            }

            public void handleException(Throwable exception) {
                bse[0] = exception instanceof BackingStoreException ? (BackingStoreException)exception : new BackingStoreException(NLS.bind((String)PrefsMessages.preferences_loadException, (Object)path), exception);
            }
        };
        SafeRunner.run((ISafeRunnable)code);
        if (bse[0] != null) {
            throw bse[0];
        }
        return result[0] == null ? null : result[0];
    }

    void save(final String path, final Properties properties) throws BackingStoreException {
        if (this.storage == null) {
            return;
        }
        final BackingStoreException[] bse = new BackingStoreException[1];
        ISafeRunnable code = new ISafeRunnable(){

            public void run() throws Exception {
                ScopeDescriptor.this.storage.save(path, properties);
            }

            public void handleException(Throwable exception) {
                bse[0] = exception instanceof BackingStoreException ? (BackingStoreException)exception : new BackingStoreException(NLS.bind((String)PrefsMessages.preferences_saveException, (Object)path), exception);
            }
        };
        SafeRunner.run((ISafeRunnable)code);
        if (bse[0] != null) {
            throw bse[0];
        }
    }

    boolean isAlreadyLoaded(String node) {
        return this.loadedNodes.contains(node);
    }

    void loaded(String node) {
        this.loadedNodes.add(node);
    }

    void removed(String path) {
        if (this.storage != null) {
            SafeRunner.run(() -> this.storage.removed(path));
        }
    }
}

