/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.plurl.impl;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.net.ContentHandler;
import java.net.ContentHandlerFactory;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.eclipse.equinox.plurl.Plurl;
import org.eclipse.equinox.plurl.PlurlFactory;
import org.eclipse.equinox.plurl.PlurlStreamHandler;
import org.eclipse.equinox.plurl.PlurlStreamHandlerBase;
import org.eclipse.equinox.plurl.impl.CallStack;
import org.eclipse.equinox.plurl.impl.SecurityManagerCallStack;
import org.eclipse.equinox.plurl.impl.StackWalkerCallStack;
import org.eclipse.equinox.plurl.impl.URLToHandler;

public final class PlurlImpl
implements Plurl {
    private static final String PROTOCOL_HANDLER_PKGS = "java.protocol.handler.pkgs";
    private static final String CONTENT_HANDLER_PKGS = "java.content.handler.pkgs";
    private static final String DEFAULT_VM_CONTENT_HANDLERS = "sun.net.www.content";
    private volatile Set<String> forbiddenProtocols = new HashSet<String>(Arrays.asList("jar", "jmod", "file", "jrt"));
    private static final String THIS_PACKAGE = PlurlImpl.class.getPackage().getName();
    static String PLURL_STREAM_HANDLER_CLASS_NAME = PlurlStreamHandler.class.getName();
    static final Field URL_HANDLER_FIELD = PlurlImpl.findUrlHandlerField();
    private static final Collection<ClassLoader> systemLoaders;
    List<URLStreamHandlerFactoryHolder> streamHandlerFactories = Collections.emptyList();
    List<ContentHandlerFactoryHolder> contentHandlerFactories = Collections.emptyList();
    final ServiceLoader<URLStreamHandlerFactory> builtinURLStreamHandlerFactoryLoader;
    final ServiceLoader<ContentHandlerFactory> builtinContentHandlerFactoryLoader;
    final CallStack callStack;
    private final ThreadLocal<List<String>> creatingProtocols = new ThreadLocal();
    final URLToHandler urlToHandler = new URLToHandler();
    static final PlurlStreamHandler NULL_HANDLER;

    static {
        ArrayList<ClassLoader> loaders = new ArrayList<ClassLoader>();
        try {
            ClassLoader cl = ClassLoader.getSystemClassLoader();
            cl = cl != null ? cl.getParent() : null;
            while (cl != null) {
                loaders.add(cl);
                cl = cl.getParent();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        systemLoaders = Collections.unmodifiableCollection(loaders);
        NULL_HANDLER = new PlurlStreamHandlerBase(){

            @Override
            public URLConnection openConnection(URL u) throws IOException {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static boolean isSystemClass(String pName, final Class<?> clazz) {
        if (pName != null && pName.startsWith("jdk.")) {
            return true;
        }
        ClassLoader cl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return clazz.getClassLoader();
            }
        });
        return cl == null || systemLoaders.contains(cl);
    }

    /*
     * Unable to fully structure code
     */
    private static Field findUrlHandlerField() {
        block7: {
            f = null;
            try {
                f = URL.class.getDeclaredField("handler");
                break block7;
            }
            catch (Exception e) {
                var6_4 = fields = URL.class.getDeclaredFields();
                var5_5 = fields.length;
                var4_6 = 0;
                ** while (var4_6 < var5_5)
            }
lbl-1000:
            // 1 sources

            {
                field = var6_4[var4_6];
                isStatic = Modifier.isStatic(field.getModifiers());
                if (!isStatic && field.getType().equals(URLStreamHandler.class)) {
                    f = field;
                    break;
                }
                ++var4_6;
                continue;
            }
        }
        if (f == null) {
            return null;
        }
        try {
            f.setAccessible(true);
            return f;
        }
        catch (Exception var1_2) {
            return null;
        }
    }

    static boolean setHandler(URL u, Object h) {
        if (URL_HANDLER_FIELD == null || !(h instanceof URLStreamHandler)) {
            return false;
        }
        try {
            URL_HANDLER_FIELD.set(u, h);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return true;
    }

    boolean isRecursive(String protocol) {
        List<String> protocols = this.creatingProtocols.get();
        if (protocols == null) {
            protocols = new ArrayList<String>(1);
            this.creatingProtocols.set(protocols);
        }
        if (protocols.contains(protocol)) {
            return true;
        }
        protocols.add(protocol);
        return false;
    }

    void releaseRecursive(String protocol) {
        List<String> protocols = this.creatingProtocols.get();
        protocols.remove(protocol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void install(String ... forbidden) {
        if (forbidden != null && forbidden.length > 0) {
            HashSet<String> forbiddenSet2 = new HashSet<String>(Arrays.asList(forbidden));
            this.forbiddenProtocols = forbiddenSet2.contains("plurlForbidNothing") ? Collections.emptySet() : forbiddenSet2;
        }
        try {
            new URL("plurl", "op", "addURLStreamHandlerFactory");
            return;
        }
        catch (MalformedURLException forbiddenSet2) {
            try {
                Class<URLConnection> forbiddenSet2 = URLConnection.class;
                synchronized (URLConnection.class) {
                    URLConnection.setContentHandlerFactory(new PlurlContentHandlerFactory());
                    URL.setURLStreamHandlerFactory(new PlurlURLStreamHandlerFactory());
                    // ** MonitorExit[forbiddenSet] (shouldn't be in output)
                }
            }
            catch (Throwable t) {
                try {
                    new URL("plurl", "op", "addURLStreamHandlerFactory");
                    return;
                }
                catch (MalformedURLException malformedURLException) {
                    throw new IllegalStateException("Cannot install the plurl factories.", t);
                }
            }
            {
                return;
            }
        }
    }

    public PlurlImpl() {
        this.builtinContentHandlerFactoryLoader = ServiceLoader.load(ContentHandlerFactory.class);
        this.builtinURLStreamHandlerFactoryLoader = ServiceLoader.load(URLStreamHandlerFactory.class);
        this.callStack = this.createCallStack();
    }

    private CallStack createCallStack() {
        try {
            Class.forName("java.lang.StackWalker");
            return new StackWalkerCallStack();
        }
        catch (ClassNotFoundException e) {
            return new SecurityManagerCallStack();
        }
    }

    ContentHandler createContentHandlerImpl(String mimetype) {
        ContentHandler builtin = this.findBuiltInContentHandler(mimetype);
        if (builtin != null) {
            return builtin;
        }
        return new PlurlRootContentHandler(mimetype);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    URLStreamHandler createURLStreamHandlerImpl(String protocol) {
        URLStreamHandlerFactoryHolder factoryHolder;
        block9: {
            if (this.forbiddenProtocols.contains(protocol)) {
                return null;
            }
            if (this.isRecursive(protocol)) {
                return null;
            }
            try {
                URLStreamHandler builtin = this.findBuiltinURLStreamHandler(protocol);
                if (builtin != null) {
                    URLStreamHandler uRLStreamHandler = builtin;
                    return uRLStreamHandler;
                }
            }
            catch (UnsupportedOperationException e) {
                if (!(e.getCause() instanceof ReflectiveOperationException)) break block9;
                return null;
            }
        }
        if ((factoryHolder = this.findFactory(this.getURLStreamHandlerFactories())) == null) return null;
        PlurlStreamHandler shouldHandle = (PlurlStreamHandler)factoryHolder.getHandler(protocol);
        if (shouldHandle == null) return null;
        return new PlurlRootURLStreamHandler(protocol);
        finally {
            this.releaseRecursive(protocol);
        }
    }

    private ContentHandler findBuiltInContentHandler(final String mimetype) {
        return AccessController.doPrivileged(new PrivilegedAction<ContentHandler>(){

            @Override
            public ContentHandler run() {
                return PlurlImpl.this.findBuiltinContentHandlerImpl(mimetype);
            }
        });
    }

    private URLStreamHandler findBuiltinURLStreamHandler(final String protocol) {
        return AccessController.doPrivileged(new PrivilegedAction<URLStreamHandler>(){

            @Override
            public URLStreamHandler run() {
                return PlurlImpl.this.findBuiltinURLStreamHandlerImpl(protocol);
            }
        });
    }

    ContentHandler findBuiltinContentHandlerImpl(String contentType) {
        for (ContentHandlerFactory f : this.builtinContentHandlerFactoryLoader) {
            ContentHandler h = f.createContentHandler(contentType);
            if (h == null) continue;
            return h;
        }
        String builtInHandlers = System.getProperty(CONTENT_HANDLER_PKGS);
        builtInHandlers = builtInHandlers == null ? DEFAULT_VM_CONTENT_HANDLERS : "sun.net.www.content|" + builtInHandlers;
        String convertedContentType = contentType.replace('.', '_');
        convertedContentType = convertedContentType.replace('/', '.');
        convertedContentType = convertedContentType.replace('-', '_');
        StringTokenizer tok = new StringTokenizer(builtInHandlers, "|");
        while (tok.hasMoreElements()) {
            StringBuilder name = new StringBuilder();
            name.append(tok.nextToken());
            name.append(".");
            name.append(convertedContentType);
            try {
                Class<?> clazz;
                block6: {
                    clazz = null;
                    try {
                        clazz = Class.forName(name.toString());
                    }
                    catch (ClassNotFoundException e) {
                        ClassLoader cl = ClassLoader.getSystemClassLoader();
                        if (cl == null) break block6;
                        clazz = cl.loadClass(name.toString());
                    }
                }
                if (clazz == null) continue;
                return (ContentHandler)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    URLStreamHandler findBuiltinURLStreamHandlerImpl(String protocol) {
        for (URLStreamHandlerFactory f : this.builtinURLStreamHandlerFactoryLoader) {
            URLStreamHandler h = f.createURLStreamHandler(protocol);
            if (h == null) continue;
            return h;
        }
        String builtInHandlers = System.getProperty(PROTOCOL_HANDLER_PKGS);
        if (builtInHandlers == null) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(builtInHandlers, "|");
        while (tok.hasMoreElements()) {
            URLStreamHandler found = this.findBuildinURLStreamHandlerImpl(protocol, tok.nextToken());
            if (found == null) continue;
            return found;
        }
        return null;
    }

    URLStreamHandler findBuildinURLStreamHandlerImpl(String protocol, String inPackage) {
        Class<?> clazz = null;
        StringBuilder name = new StringBuilder();
        name.append(inPackage);
        name.append(".");
        name.append(protocol);
        name.append(".Handler");
        try {
            block8: {
                try {
                    clazz = Class.forName(name.toString());
                }
                catch (ClassNotFoundException e) {
                    ClassLoader cl = ClassLoader.getSystemClassLoader();
                    if (cl == null) break block8;
                    try {
                        clazz = cl.loadClass(name.toString());
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
            }
            if (clazz != null) {
                return (URLStreamHandler)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (ReflectiveOperationException e) {
            String message = "The module for class '" + clazz.getName() + "' must be configured to open the '" + inPackage + '.' + protocol + "' package for reflection to support the handler." + " For example, by using the JVM option: '--add-opens java.base/" + inPackage + '.' + protocol + "=ALL-UNNAMED'.";
            throw new UnsupportedOperationException(message, e);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    URLConnection plurlOperation(URL u) {
        final String path = u.getPath();
        return new URLConnection(u){

            @Override
            public void connect() throws IOException {
            }

            @Override
            public Consumer<Object> getContent() throws IOException {
                switch (path) {
                    case "addURLStreamHandlerFactory": {
                        return f -> PlurlImpl.this.add((URLStreamHandlerFactory)f);
                    }
                    case "removeURLStreamHandlerFactory": {
                        return f -> PlurlImpl.this.remove((URLStreamHandlerFactory)URLStreamHandlerFactory.class.cast(f));
                    }
                    case "addContentHandlerFactory": {
                        return f -> PlurlImpl.this.add((ContentHandlerFactory)f);
                    }
                    case "removeContentHandlerFactory": {
                        return f -> PlurlImpl.this.remove((ContentHandlerFactory)ContentHandlerFactory.class.cast(f));
                    }
                }
                throw new IOException("Unknown plurl operation: " + path);
            }
        };
    }

    boolean isMultiplexing(List<?> factories) {
        return factories.size() > 1;
    }

    synchronized void add(URLStreamHandlerFactory f) {
        ArrayList<URLStreamHandlerFactoryHolder> updated = new ArrayList<URLStreamHandlerFactoryHolder>(this.streamHandlerFactories);
        updated.removeIf(h -> h.getFactory() == null);
        updated.add(new URLStreamHandlerFactoryHolder(f));
        this.streamHandlerFactories = updated;
    }

    synchronized void remove(URLStreamHandlerFactory f) {
        ArrayList<URLStreamHandlerFactoryHolder> updated = new ArrayList<URLStreamHandlerFactoryHolder>(this.streamHandlerFactories);
        updated.removeIf(h -> h.getFactory() == f || h.getFactory() == null);
        this.streamHandlerFactories = updated.isEmpty() ? Collections.emptyList() : updated;
    }

    synchronized List<URLStreamHandlerFactoryHolder> getURLStreamHandlerFactories() {
        return this.streamHandlerFactories;
    }

    synchronized List<ContentHandlerFactoryHolder> getContentHandlerFactories() {
        return this.contentHandlerFactories;
    }

    synchronized void add(ContentHandlerFactory f) {
        ArrayList<ContentHandlerFactoryHolder> updated = new ArrayList<ContentHandlerFactoryHolder>(this.contentHandlerFactories);
        updated.removeIf(h -> h.getFactory() == null);
        updated.add(new ContentHandlerFactoryHolder(f));
        this.contentHandlerFactories = updated;
    }

    synchronized void remove(ContentHandlerFactory f) {
        ArrayList<ContentHandlerFactoryHolder> updated = new ArrayList<ContentHandlerFactoryHolder>(this.contentHandlerFactories);
        updated.removeIf(h -> h.getFactory() == f || h.getFactory() == null);
        this.contentHandlerFactories = updated.isEmpty() ? Collections.emptyList() : updated;
    }

    ContentHandler findContentHandler(String contentType) {
        ContentHandlerFactoryHolder f = this.findFactory(this.getContentHandlerFactories());
        if (f != null) {
            return (ContentHandler)f.getHandler(contentType);
        }
        return null;
    }

    PlurlStreamHandler findPlurlStreamHandler(String protocol) {
        URLStreamHandlerFactoryHolder f = this.findFactory(this.getURLStreamHandlerFactories());
        if (f != null) {
            return (PlurlStreamHandler)f.getHandler(protocol);
        }
        return null;
    }

    private <F> F findFactory(List<F> factories) {
        Class<?>[] callStackClasses;
        int numFactories = factories.size();
        if (numFactories == 1) {
            return factories.get(0);
        }
        Class<?>[] classArray = callStackClasses = this.getCallStack();
        int n = callStackClasses.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> stack = classArray[n2];
            String pName = this.getPackageName(stack);
            if (!THIS_PACKAGE.equals(pName) && !PlurlImpl.isSystemClass(pName, stack)) {
                for (F f : factories) {
                    boolean shouldHandle = false;
                    if (f instanceof PlurlFactory) {
                        shouldHandle = ((PlurlFactory)f).shouldHandle(stack);
                    } else {
                        try {
                            shouldHandle = (Boolean)this.findShouldHandle(f.getClass()).invoke(f, stack);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (!shouldHandle) continue;
                    return f;
                }
            }
            ++n2;
        }
        return numFactories > 0 ? (F)factories.get(0) : null;
    }

    Method findShouldHandle(Class<?> clazz) throws NoSuchMethodException {
        Method shouldHandle = null;
        try {
            shouldHandle = clazz.getMethod("shouldHandle", Class.class);
        }
        catch (NoSuchMethodException e) {
            try {
                shouldHandle = clazz.getMethod("hasAuthority", Class.class);
            }
            catch (NoSuchMethodException e1) {
                throw e;
            }
        }
        shouldHandle.setAccessible(true);
        return shouldHandle;
    }

    private String getPackageName(Class<?> clazz) {
        String name = clazz.getName();
        int lastDot = name.lastIndexOf(46);
        if (lastDot >= 0) {
            return name.substring(0, lastDot);
        }
        return "";
    }

    private Class<?>[] getCallStack() {
        return this.callStack.getClassContext();
    }

    PlurlStreamHandler newProxyPlurlStreamHandler(URLStreamHandler handler) {
        Class<?> checkClass = handler.getClass();
        while (checkClass != null) {
            Class<?>[] classArray = checkClass.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> i = classArray[n2];
                if (PLURL_STREAM_HANDLER_CLASS_NAME.equals(i.getName())) {
                    Method[] methodArray = i.getMethods();
                    int n3 = methodArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Method m = methodArray[n4];
                        if (m.getName().equals("parseURL")) {
                            Class<?> plurlStreamHandlerClass = i;
                            Class<?> plurlSetterClass = m.getParameterTypes()[0];
                            return new PlurlStreamHandlerProxy(handler, plurlStreamHandlerClass, plurlSetterClass);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            checkClass = checkClass.getSuperclass();
        }
        return null;
    }

    public class ContentHandlerFactoryHolder
    extends PlurlFactoryHolder<ContentHandlerFactory, ContentHandler> {
        public ContentHandlerFactoryHolder(ContentHandlerFactory factory) {
            super(factory);
        }

        @Override
        protected ContentHandler createHandler(String mimetype, ContentHandlerFactory f) {
            return f.createContentHandler(mimetype);
        }

        @Override
        protected void remove(ContentHandlerFactory f) {
            PlurlImpl.this.remove(f);
        }
    }

    public static interface LegacyFactory {
        public void register(Object var1);

        public void unregister(Object var1);

        public boolean isMultiplexing();
    }

    public class PlurlContentHandlerFactory
    implements ContentHandlerFactory,
    LegacyFactory {
        @Override
        public ContentHandler createContentHandler(String mimetype) {
            return PlurlImpl.this.createContentHandlerImpl(mimetype);
        }

        @Override
        public void register(Object factory) {
            PlurlImpl.this.add((ContentHandlerFactory)factory);
        }

        @Override
        public void unregister(Object factory) {
            PlurlImpl.this.remove((ContentHandlerFactory)factory);
        }

        @Override
        public boolean isMultiplexing() {
            return PlurlImpl.this.isMultiplexing(PlurlImpl.this.getURLStreamHandlerFactories());
        }
    }

    public abstract class PlurlFactoryHolder<F, H>
    implements PlurlFactory {
        private final WeakReference<F> factory;
        private final Map<String, H> handlers = new ConcurrentHashMap<String, H>();
        private final Method shouldHandleMethod;

        public PlurlFactoryHolder(F factory) {
            this.factory = new WeakReference<F>(factory);
            if (factory instanceof PlurlFactory) {
                this.shouldHandleMethod = null;
            } else {
                try {
                    this.shouldHandleMethod = PlurlImpl.this.findShouldHandle(factory.getClass());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }

        F getFactory() {
            return (F)this.factory.get();
        }

        @Override
        public boolean shouldHandle(Class<?> clazz) {
            Object f = this.factory.get();
            if (f == null) {
                return false;
            }
            if (this.shouldHandleMethod != null) {
                try {
                    return (Boolean)this.shouldHandleMethod.invoke(f, clazz);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return ((PlurlFactory)f).shouldHandle(clazz);
        }

        H getHandler(String type) {
            Object f = this.factory.get();
            if (f == null) {
                this.handlers.clear();
                this.remove(null);
                return null;
            }
            return (H)this.handlers.computeIfAbsent(type, t -> this.createHandler((String)t, (F)f));
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + '@' + System.identityHashCode(this) + '[' + this.factory.get() + ']' + this.handlers;
        }

        protected abstract H createHandler(String var1, F var2);

        protected abstract void remove(F var1);
    }

    class PlurlRootContentHandler
    extends ContentHandler {
        private final String contentType;

        PlurlRootContentHandler(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public Object getContent(URLConnection uConn) throws IOException {
            ContentHandler handler = PlurlImpl.this.findContentHandler(this.contentType);
            if (handler != null) {
                return handler.getContent(uConn);
            }
            return uConn.getInputStream();
        }
    }

    class PlurlRootURLStreamHandler
    extends URLStreamHandler
    implements PlurlStreamHandler.PlurlSetter {
        private final String protocol;
        private final AtomicReference<PlurlStreamHandler> builtin = new AtomicReference();

        private PlurlStreamHandler lookupPlurlStreamHandler(URL u) {
            if (u != null && PlurlImpl.this.isMultiplexing(PlurlImpl.this.getURLStreamHandlerFactories())) {
                return PlurlImpl.this.urlToHandler.get(u, this::findPlurlStreamHandlerImpl);
            }
            return this.findPlurlStreamHandlerImpl();
        }

        private PlurlStreamHandler findPlurlStreamHandlerImpl() {
            PlurlStreamHandler h = PlurlImpl.this.findPlurlStreamHandler(this.protocol);
            if (h == null && (h = this.findBuiltin()) == null) {
                throw new IllegalStateException("No handler found for protocol: " + this.protocol);
            }
            return h;
        }

        private PlurlStreamHandler findBuiltin() {
            PlurlStreamHandler result = this.builtin.updateAndGet(h -> {
                URLStreamHandler found = PlurlImpl.this.findBuildinURLStreamHandlerImpl(this.protocol, "sun.net.www.protocol");
                if (found == null) {
                    return NULL_HANDLER;
                }
                return new PlurlStreamHandlerReflective(found);
            });
            return result == NULL_HANDLER ? null : result;
        }

        PlurlRootURLStreamHandler(String protocol) {
            this.protocol = protocol;
        }

        @Override
        protected boolean equals(URL u1, URL u2) {
            return this.lookupPlurlStreamHandler(u1).equals(u1, u2);
        }

        @Override
        protected int hashCode(URL u) {
            return this.lookupPlurlStreamHandler(u).hashCode(u);
        }

        @Override
        protected boolean hostsEqual(URL u1, URL u2) {
            return this.lookupPlurlStreamHandler(u1).hostsEqual(u1, u2);
        }

        @Override
        protected int getDefaultPort() {
            return this.lookupPlurlStreamHandler(null).getDefaultPort();
        }

        @Override
        protected InetAddress getHostAddress(URL u) {
            return this.lookupPlurlStreamHandler(u).getHostAddress(u);
        }

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            return this.lookupPlurlStreamHandler(u).openConnection(u);
        }

        @Override
        protected URLConnection openConnection(URL u, java.net.Proxy p) throws IOException {
            return this.lookupPlurlStreamHandler(u).openConnection(u, p);
        }

        @Override
        protected void parseURL(URL u, String spec, int start, int limit) {
            PlurlStreamHandler h = this.lookupPlurlStreamHandler(u);
            if (PlurlImpl.setHandler(u, h)) {
                h.parseURL(null, u, spec, start, limit);
            } else {
                h.parseURL(this, u, spec, start, limit);
            }
        }

        @Override
        protected boolean sameFile(URL u1, URL u2) {
            return this.lookupPlurlStreamHandler(u1).sameFile(u1, u2);
        }

        @Override
        protected String toExternalForm(URL u) {
            return this.lookupPlurlStreamHandler(u).toExternalForm(u);
        }

        @Override
        public void setURL(URL u, String protocol, String host, int port, String authority, String userInfo, String path, String query, String ref) {
            super.setURL(u, protocol, host, port, authority, userInfo, path, query, ref);
        }
    }

    static class PlurlStreamHandlerProxy
    extends URLStreamHandler
    implements PlurlStreamHandler {
        private final URLStreamHandler handler;
        private final Class<?> plurlSetterClass;
        private final Method equals;
        private final Method getDefaultPort;
        private final Method getHostAddress;
        private final Method hashCode;
        private final Method hostsEqual;
        private final Method openConnection;
        private final Method openConnectionProxy;
        private final Method parseURL;
        private final Method sameFile;
        private final Method toExternalForm;
        final Method setURL;
        final Method setURLDeprecated;

        public PlurlStreamHandlerProxy(URLStreamHandler handler, Class<?> plurlUrlHandlerClass, Class<?> plurlSetterClass) {
            this.handler = handler;
            this.plurlSetterClass = plurlSetterClass;
            this.openConnection = PlurlStreamHandlerProxy.findMethod(plurlUrlHandlerClass, "openConnection", URL.class);
            this.openConnectionProxy = PlurlStreamHandlerProxy.findMethod(plurlUrlHandlerClass, "openConnection", URL.class, java.net.Proxy.class);
            this.parseURL = PlurlStreamHandlerProxy.findMethod(plurlUrlHandlerClass, "parseURL", plurlSetterClass, URL.class, String.class, Integer.TYPE, Integer.TYPE);
            this.equals = PlurlStreamHandlerProxy.findMethod(plurlUrlHandlerClass, "equals", URL.class, URL.class);
            this.getDefaultPort = PlurlStreamHandlerProxy.findMethod(plurlUrlHandlerClass, "getDefaultPort", new Class[0]);
            this.getHostAddress = PlurlStreamHandlerProxy.findMethod(plurlUrlHandlerClass, "getHostAddress", URL.class);
            this.hashCode = PlurlStreamHandlerProxy.findMethod(plurlUrlHandlerClass, "hashCode", URL.class);
            this.hostsEqual = PlurlStreamHandlerProxy.findMethod(plurlUrlHandlerClass, "hostsEqual", URL.class, URL.class);
            this.sameFile = PlurlStreamHandlerProxy.findMethod(plurlUrlHandlerClass, "sameFile", URL.class, URL.class);
            this.toExternalForm = PlurlStreamHandlerProxy.findMethod(plurlUrlHandlerClass, "toExternalForm", URL.class);
            this.setURL = PlurlStreamHandlerProxy.findMethod(plurlUrlHandlerClass, "setURL", URL.class, String.class, String.class, Integer.TYPE, String.class, String.class, String.class, String.class, String.class);
            this.setURLDeprecated = PlurlStreamHandlerProxy.findMethod(plurlUrlHandlerClass, "setURL", URL.class, String.class, String.class, Integer.TYPE, String.class, String.class);
        }

        private static Method findMethod(Class<?> plurlUrlHandlerClass, String methodName, Class<?> ... args) {
            Method result = null;
            try {
                result = plurlUrlHandlerClass.getDeclaredMethod(methodName, args);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return result;
        }

        Object invoke(Method m, Object ... args) {
            try {
                return m.invoke((Object)this.handler, args);
            }
            catch (InvocationTargetException e) {
                throw (RuntimeException)e.getTargetException();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        @Override
        public boolean equals(URL u1, URL u2) {
            return (Boolean)this.invoke(this.equals, u1, u2);
        }

        @Override
        public int hashCode(URL u) {
            return (Integer)this.invoke(this.hashCode, u);
        }

        @Override
        public boolean hostsEqual(URL u1, URL u2) {
            return (Boolean)this.invoke(this.hostsEqual, u1, u2);
        }

        @Override
        public int getDefaultPort() {
            return (Integer)this.invoke(this.getDefaultPort, new Object[0]);
        }

        @Override
        public InetAddress getHostAddress(URL u) {
            return (InetAddress)this.invoke(this.getHostAddress, u);
        }

        @Override
        public URLConnection openConnection(URL u) throws IOException {
            return (URLConnection)this.invoke(this.openConnection, u);
        }

        @Override
        public URLConnection openConnection(URL u, java.net.Proxy p) throws IOException {
            return (URLConnection)this.invoke(this.openConnectionProxy, u, p);
        }

        @Override
        public void parseURL(final PlurlStreamHandler.PlurlSetter plurlSetter, URL u, String spec, int start, int limit) {
            PlurlImpl.setHandler(u, this.handler);
            Object plurlSetterProxy = null;
            if (plurlSetter != null) {
                plurlSetterProxy = Proxy.newProxyInstance(this.handler.getClass().getClassLoader(), new Class[]{this.plurlSetterClass}, new InvocationHandler(){

                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        if ("setURL".equals(method.getName())) {
                            if (args.length == 9) {
                                plurlSetter.setURL((URL)args[0], (String)args[1], (String)args[2], (Integer)args[3], (String)args[4], (String)args[5], (String)args[6], (String)args[7], (String)args[8]);
                            } else {
                                plurlSetter.setURL((URL)args[0], (String)args[1], (String)args[2], (Integer)args[3], null, null, (String)args[4], null, (String)args[5]);
                            }
                        }
                        return null;
                    }
                });
            }
            this.invoke(this.parseURL, plurlSetterProxy, u, spec, start, limit);
        }

        @Override
        public boolean sameFile(URL u1, URL u2) {
            return (Boolean)this.invoke(this.sameFile, u1, u2);
        }

        @Override
        public String toExternalForm(URL u) {
            return (String)this.invoke(this.toExternalForm, u);
        }

        @Override
        public void setURL(URL u, String protocol, String host, int port, String authority, String userInfo, String path, String query, String ref) {
            this.invoke(this.setURL, u, protocol, host, port, authority, userInfo, path, query, ref);
        }

        @Override
        public void setURL(URL u, String protocol, String host, int port, String file, String ref) {
            this.invoke(this.setURLDeprecated, u, protocol, host, port, file, ref);
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + '@' + System.identityHashCode(this) + '[' + this.handler + ']';
        }
    }

    static class PlurlStreamHandlerReflective
    extends URLStreamHandler
    implements PlurlStreamHandler {
        private final URLStreamHandler handler;
        private final Method openConnectionMethod;
        private final Method openConnectionProxyMethod;
        private final Method parseURLMethod;
        private final Method equalsMethod;
        private final Method getDefaultPortMethod;
        private final Method getHostAddressMethod;
        private final Method hashCodeMethod;
        private final Method hostsEqualMethod;
        private final Method sameFileMethod;
        private final Method toExternalFormMethod;

        public PlurlStreamHandlerReflective(URLStreamHandler handler) {
            this.handler = handler;
            this.openConnectionMethod = PlurlStreamHandlerReflective.findMethod(handler, "openConnection", URL.class);
            this.openConnectionProxyMethod = PlurlStreamHandlerReflective.findMethod(handler, "openConnection", URL.class, java.net.Proxy.class);
            this.parseURLMethod = PlurlStreamHandlerReflective.findMethod(handler, "parseURL", URL.class, String.class, Integer.TYPE, Integer.TYPE);
            this.equalsMethod = PlurlStreamHandlerReflective.findMethod(handler, "equals", URL.class, URL.class);
            this.getDefaultPortMethod = PlurlStreamHandlerReflective.findMethod(handler, "getDefaultPort", new Class[0]);
            this.getHostAddressMethod = PlurlStreamHandlerReflective.findMethod(handler, "getHostAddress", URL.class);
            this.hashCodeMethod = PlurlStreamHandlerReflective.findMethod(handler, "hashCode", URL.class);
            this.hostsEqualMethod = PlurlStreamHandlerReflective.findMethod(handler, "hostsEqual", URL.class, URL.class);
            this.sameFileMethod = PlurlStreamHandlerReflective.findMethod(handler, "sameFile", URL.class, URL.class);
            this.toExternalFormMethod = PlurlStreamHandlerReflective.findMethod(handler, "toExternalForm", URL.class);
            if (URL_HANDLER_FIELD == null) {
                throw new RuntimeException(PlurlStreamHandlerReflective.getReflectionErrorMessage(handler.getClass()));
            }
        }

        private <T extends Throwable> Object invoke(Method m, Object ... args) throws T {
            try {
                return m.invoke((Object)this.handler, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        private static String getReflectionErrorMessage(Class<? extends URLStreamHandler> handlerClass) {
            return "The java.base module must be configured to open the java.net package for reflection to support the handler of type '" + handlerClass.getName() + "'." + " For example, by using the JVM option: '--add-opens java.base/java.net=ALL-UNNAMED'. " + "Another option is to make the class '" + handlerClass.getName() + "' implement the org.eclipse.equinox.purl.PlurlStreamHandler interface.";
        }

        private static Method findMethod(URLStreamHandler h, String methodName, Class<?> ... args) {
            Method result = null;
            Class<?> handlerClass = h.getClass();
            try {
                result = handlerClass.getDeclaredMethod(methodName, args);
                result.setAccessible(true);
            }
            catch (Exception e1) {
                try {
                    result = URLStreamHandler.class.getDeclaredMethod(methodName, args);
                    result.setAccessible(true);
                }
                catch (Exception e2) {
                    String message = PlurlStreamHandlerReflective.getReflectionErrorMessage(handlerClass);
                    throw new RuntimeException(message, e2);
                }
            }
            return result;
        }

        @Override
        public boolean equals(URL u1, URL u2) {
            return (Boolean)this.invoke(this.equalsMethod, u1, u2);
        }

        @Override
        public int hashCode(URL u) {
            return (Integer)this.invoke(this.hashCodeMethod, u);
        }

        @Override
        public boolean hostsEqual(URL u1, URL u2) {
            return (Boolean)this.invoke(this.hostsEqualMethod, u1, u2);
        }

        @Override
        public int getDefaultPort() {
            return (Integer)this.invoke(this.getDefaultPortMethod, new Object[0]);
        }

        @Override
        public InetAddress getHostAddress(URL u) {
            return (InetAddress)this.invoke(this.getHostAddressMethod, u);
        }

        @Override
        public URLConnection openConnection(URL u) throws IOException {
            return (URLConnection)this.invoke(this.openConnectionMethod, u);
        }

        @Override
        public URLConnection openConnection(URL u, java.net.Proxy p) throws IOException {
            return (URLConnection)this.invoke(this.openConnectionProxyMethod, u, p);
        }

        @Override
        public boolean sameFile(URL u1, URL u2) {
            return (Boolean)this.invoke(this.sameFileMethod, u1, u2);
        }

        @Override
        public String toExternalForm(URL u) {
            return (String)this.invoke(this.toExternalFormMethod, u);
        }

        @Override
        public void parseURL(PlurlStreamHandler.PlurlSetter plurlSetter, URL u, String spec, int start, int limit) {
            try {
                PlurlImpl.setHandler(u, this.handler);
                this.invoke(this.parseURLMethod, u, spec, start, limit);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void setURL(URL u, String protocol, String host, int port, String file, String ref) {
            super.setURL(u, protocol, host, port, file, ref);
        }

        @Override
        public void setURL(URL u, String protocol, String host, int port, String authority, String userInfo, String path, String query, String ref) {
            super.setURL(u, protocol, host, port, authority, userInfo, path, query, ref);
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + '@' + System.identityHashCode(this) + '[' + this.handler + ']';
        }
    }

    public class PlurlURLStreamHandlerFactory
    extends URLStreamHandler
    implements URLStreamHandlerFactory,
    LegacyFactory {
        @Override
        public URLStreamHandler createURLStreamHandler(String protocol) {
            if (protocol.equals("plurl")) {
                return this;
            }
            return PlurlImpl.this.createURLStreamHandlerImpl(protocol);
        }

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            return PlurlImpl.this.plurlOperation(u);
        }

        @Override
        public void register(Object factory) {
            PlurlImpl.this.add((URLStreamHandlerFactory)factory);
        }

        @Override
        public void unregister(Object factory) {
            PlurlImpl.this.remove((URLStreamHandlerFactory)factory);
        }

        @Override
        public boolean isMultiplexing() {
            return PlurlImpl.this.isMultiplexing(PlurlImpl.this.getContentHandlerFactories());
        }
    }

    public class URLStreamHandlerFactoryHolder
    extends PlurlFactoryHolder<URLStreamHandlerFactory, PlurlStreamHandler> {
        public URLStreamHandlerFactoryHolder(URLStreamHandlerFactory factory) {
            super(factory);
        }

        @Override
        protected PlurlStreamHandler createHandler(String protocol, URLStreamHandlerFactory f) {
            URLStreamHandler handler = f.createURLStreamHandler(protocol);
            if (handler == null) {
                return null;
            }
            if (handler instanceof PlurlStreamHandler) {
                return (PlurlStreamHandler)((Object)handler);
            }
            PlurlStreamHandler proxyPlurlStreamHandler = PlurlImpl.this.newProxyPlurlStreamHandler(handler);
            if (proxyPlurlStreamHandler != null) {
                return proxyPlurlStreamHandler;
            }
            return new PlurlStreamHandlerReflective(handler);
        }

        @Override
        protected void remove(URLStreamHandlerFactory f) {
            PlurlImpl.this.remove(f);
        }
    }
}

