/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.e4.apache.jxpath;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.rap.e4.apache.jxpath.JXPathBasicBeanInfo;
import org.eclipse.rap.e4.apache.jxpath.JXPathBeanInfo;
import org.eclipse.rap.e4.apache.jxpath.MapDynamicPropertyHandler;

public class JXPathIntrospector {
    private static HashMap byClass = new HashMap();
    private static HashMap byInterface = new HashMap();

    static {
        JXPathIntrospector.registerAtomicClass(Class.class);
        JXPathIntrospector.registerAtomicClass(Boolean.TYPE);
        JXPathIntrospector.registerAtomicClass(Boolean.class);
        JXPathIntrospector.registerAtomicClass(Byte.TYPE);
        JXPathIntrospector.registerAtomicClass(Byte.class);
        JXPathIntrospector.registerAtomicClass(Character.TYPE);
        JXPathIntrospector.registerAtomicClass(Character.class);
        JXPathIntrospector.registerAtomicClass(Short.TYPE);
        JXPathIntrospector.registerAtomicClass(Short.class);
        JXPathIntrospector.registerAtomicClass(Integer.TYPE);
        JXPathIntrospector.registerAtomicClass(Integer.class);
        JXPathIntrospector.registerAtomicClass(Long.TYPE);
        JXPathIntrospector.registerAtomicClass(Long.class);
        JXPathIntrospector.registerAtomicClass(Float.TYPE);
        JXPathIntrospector.registerAtomicClass(Float.class);
        JXPathIntrospector.registerAtomicClass(Double.TYPE);
        JXPathIntrospector.registerAtomicClass(Double.class);
        JXPathIntrospector.registerAtomicClass(String.class);
        JXPathIntrospector.registerAtomicClass(Date.class);
        JXPathIntrospector.registerAtomicClass(java.sql.Date.class);
        JXPathIntrospector.registerAtomicClass(Time.class);
        JXPathIntrospector.registerAtomicClass(Timestamp.class);
        JXPathIntrospector.registerDynamicClass(Map.class, MapDynamicPropertyHandler.class);
    }

    public static void registerAtomicClass(Class beanClass) {
        byClass.put(beanClass, new JXPathBasicBeanInfo(beanClass, true));
    }

    public static void registerDynamicClass(Class beanClass, Class dynamicPropertyHandlerClass) {
        JXPathBasicBeanInfo bi = new JXPathBasicBeanInfo(beanClass, dynamicPropertyHandlerClass);
        if (beanClass.isInterface()) {
            byInterface.put(beanClass, bi);
        } else {
            byClass.put(beanClass, bi);
        }
    }

    public static JXPathBeanInfo getBeanInfo(Class beanClass) {
        JXPathBeanInfo beanInfo = (JXPathBeanInfo)byClass.get(beanClass);
        if (beanInfo == null) {
            beanInfo = JXPathIntrospector.findDynamicBeanInfo(beanClass);
            if (beanInfo == null && (beanInfo = JXPathIntrospector.findInformant(beanClass)) == null) {
                beanInfo = new JXPathBasicBeanInfo(beanClass);
            }
            byClass.put(beanClass, beanInfo);
        }
        return beanInfo;
    }

    private static JXPathBeanInfo findDynamicBeanInfo(Class beanClass) {
        Class sup;
        JXPathBeanInfo beanInfo = null;
        if (beanClass.isInterface() && (beanInfo = (JXPathBeanInfo)byInterface.get(beanClass)) != null && beanInfo.isDynamic()) {
            return beanInfo;
        }
        Class<?>[] interfaces = beanClass.getInterfaces();
        if (interfaces != null) {
            int i = 0;
            while (i < interfaces.length) {
                beanInfo = JXPathIntrospector.findDynamicBeanInfo(interfaces[i]);
                if (beanInfo != null && beanInfo.isDynamic()) {
                    return beanInfo;
                }
                ++i;
            }
        }
        if ((sup = beanClass.getSuperclass()) != null) {
            beanInfo = (JXPathBeanInfo)byClass.get(sup);
            if (beanInfo != null && beanInfo.isDynamic()) {
                return beanInfo;
            }
            return JXPathIntrospector.findDynamicBeanInfo(sup);
        }
        return null;
    }

    private static synchronized JXPathBeanInfo findInformant(Class beanClass) {
        String name = String.valueOf(beanClass.getName()) + "XBeanInfo";
        try {
            return (JXPathBeanInfo)JXPathIntrospector.instantiate(beanClass, name);
        }
        catch (Exception exception) {
            try {
                if (JXPathBeanInfo.class.isAssignableFrom(beanClass)) {
                    return (JXPathBeanInfo)beanClass.newInstance();
                }
            }
            catch (Exception exception2) {}
            return null;
        }
    }

    private static Object instantiate(Class sibling, String className) throws Exception {
        ClassLoader cl = sibling.getClassLoader();
        if (cl != null) {
            try {
                Class<?> cls = cl.loadClass(className);
                return cls.newInstance();
            }
            catch (Exception exception) {}
        }
        Class<?> cls = Class.forName(className);
        return cls.newInstance();
    }
}

