/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.composite.model;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.cheatsheets.composite.model.CompositeCheatSheetModel;
import org.eclipse.ui.internal.cheatsheets.composite.model.TaskGroup;
import org.eclipse.ui.internal.cheatsheets.composite.parser.ITaskParseStrategy;
import org.eclipse.ui.internal.provisional.cheatsheets.ICompositeCheatSheet;
import org.eclipse.ui.internal.provisional.cheatsheets.ICompositeCheatSheetTask;
import org.eclipse.ui.internal.provisional.cheatsheets.ITaskGroup;
import org.osgi.framework.Bundle;

public abstract class AbstractTask
implements ICompositeCheatSheetTask {
    protected CompositeCheatSheetModel model;
    protected int state = 0;
    private String id;
    private String name;
    protected String kind;
    private Dictionary parameters;
    private String description;
    private String completionMessage;
    private ArrayList requiredTasks;
    private ArrayList successorTasks;
    private boolean skippable;
    private TaskGroup parent;
    protected static final ICompositeCheatSheetTask[] EMPTY = new ICompositeCheatSheetTask[0];

    public AbstractTask(CompositeCheatSheetModel model, String id, String name, String kind) {
        this.model = model;
        this.id = id;
        this.name = name;
        this.kind = kind;
        this.parameters = new Hashtable();
        this.description = "";
        this.requiredTasks = new ArrayList();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public Dictionary getParameters() {
        return this.parameters;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setCompletionMessage(String completionMessage) {
        this.completionMessage = completionMessage;
    }

    @Override
    public String getCompletionMessage() {
        return this.completionMessage;
    }

    @Override
    public ICompositeCheatSheetTask[] getRequiredTasks() {
        if (this.requiredTasks == null) {
            return EMPTY;
        }
        return this.requiredTasks.toArray(new ICompositeCheatSheetTask[this.requiredTasks.size()]);
    }

    public ICompositeCheatSheetTask[] getSuccessorTasks() {
        if (this.successorTasks == null) {
            return EMPTY;
        }
        return this.successorTasks.toArray(new ICompositeCheatSheetTask[this.successorTasks.size()]);
    }

    public void addRequiredTask(AbstractTask task) {
        if (this.requiredTasks == null) {
            this.requiredTasks = new ArrayList();
        }
        this.requiredTasks.add(task);
        if (task.successorTasks == null) {
            task.successorTasks = new ArrayList();
        }
        task.successorTasks.add(this);
    }

    @Override
    public int getState() {
        return this.state;
    }

    public void complete() {
        this.setState(3);
    }

    @Override
    public boolean requiredTasksCompleted() {
        boolean startable = true;
        ICompositeCheatSheetTask[] requiredTasks = this.getRequiredTasks();
        int i = 0;
        while (i < requiredTasks.length) {
            if (requiredTasks[i].getState() != 3 && requiredTasks[i].getState() != 2) {
                startable = false;
            }
            ++i;
        }
        return startable;
    }

    public boolean requiresTask(ICompositeCheatSheetTask candidateTask) {
        return this.requiredTasks.contains(candidateTask);
    }

    public void setState(int state) {
        this.setStateNoNotify(state);
        this.model.sendTaskChangeEvents();
    }

    public void setStateNoNotify(int state) {
        this.state = state;
        if (this.parent != null) {
            this.parent.checkState();
        }
        this.model.stateChanged(this);
    }

    public URL getInputUrl(String path) throws MalformedURLException {
        int index = path.indexOf(47, 1);
        if (index >= 1 && path.charAt(0) == '/') {
            String bundleName = path.substring(1, index);
            String relativePath = path.substring(index + 1);
            Bundle bundle = Platform.getBundle((String)bundleName);
            if (bundle != null) {
                return FileLocator.find((Bundle)bundle, (IPath)new Path(relativePath), null);
            }
        }
        return new URL(this.model.getContentUrl(), path);
    }

    @Override
    public ICompositeCheatSheet getCompositeCheatSheet() {
        return this.model;
    }

    public abstract ITaskParseStrategy getParserStrategy();

    @Override
    public abstract ICompositeCheatSheetTask[] getSubtasks();

    public void setSkippable(boolean skippable) {
        this.skippable = skippable;
    }

    @Override
    public boolean isSkippable() {
        return this.skippable;
    }

    protected void setParent(TaskGroup parent) {
        this.parent = parent;
    }

    @Override
    public ITaskGroup getParent() {
        return this.parent;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

