/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.rap.fileupload.DiskFileUploadReceiver;
import org.eclipse.rap.fileupload.FileUploadEvent;
import org.eclipse.rap.fileupload.FileUploadHandler;
import org.eclipse.rap.fileupload.FileUploadListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.internal.widgets.ProgressCollector;
import org.eclipse.swt.internal.widgets.UploadPanel;
import org.eclipse.swt.internal.widgets.Uploader;
import org.eclipse.swt.widgets.Display;

public class FileUploadRunnable
implements Runnable {
    private final Display display;
    private final UploadPanel uploadPanel;
    private final ProgressCollector progressCollector;
    private final Uploader uploader;
    private final FileUploadHandler handler;
    private final UploadProgressListener listener;
    private final AtomicReference<State> state;
    private final Object lock;

    public FileUploadRunnable(UploadPanel uploadPanel, ProgressCollector progressCollector, Uploader uploader, FileUploadHandler handler) {
        this.uploadPanel = uploadPanel;
        this.progressCollector = progressCollector;
        this.uploader = uploader;
        this.handler = handler;
        this.display = uploadPanel.getDisplay();
        this.state = new AtomicReference<State>(State.WAITING);
        this.lock = new Object();
        this.listener = new UploadProgressListener();
        this.setupFileUploadHandler();
        uploadPanel.updateIcons(State.WAITING);
    }

    @Override
    public void run() {
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                FileUploadRunnable.this.uploader.submit(FileUploadRunnable.this.handler.getUploadUrl());
            }
        });
        if (!this.display.isDisposed()) {
            this.doWait();
        }
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                FileUploadRunnable.this.uploader.dispose();
                FileUploadRunnable.this.handler.removeUploadListener((FileUploadListener)FileUploadRunnable.this.listener);
                FileUploadRunnable.this.handler.dispose();
            }
        });
    }

    private void setupFileUploadHandler() {
        this.handler.addUploadListener((FileUploadListener)this.listener);
        this.uploadPanel.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                FileUploadRunnable.this.doNotify();
                FileUploadRunnable.this.handler.removeUploadListener((FileUploadListener)FileUploadRunnable.this.listener);
                FileUploadRunnable.this.handler.dispose();
            }
        });
    }

    void handleProgress(long bytesRead, long contentLength) {
        if (this.state.compareAndSet(State.WAITING, State.UPLOADING)) {
            this.uploadPanel.updateIcons(State.UPLOADING);
        }
        double fraction = (double)bytesRead / (double)contentLength;
        int percent = (int)Math.floor(fraction * 100.0);
        this.progressCollector.updateProgress(percent);
    }

    void handleFinished(List<String> targetFileNames) {
        this.state.set(State.FINISHED);
        this.uploadPanel.updateIcons(State.FINISHED);
        this.progressCollector.resetToolTip();
        this.progressCollector.updateCompletedFiles(targetFileNames);
    }

    void handleFailed(Exception exception) {
        this.state.set(State.FAILED);
        this.uploadPanel.updateIcons(State.FAILED);
        this.progressCollector.resetToolTip();
        if (exception != null) {
            this.progressCollector.addException(exception);
            this.uploadPanel.updateToolTips(exception);
        }
    }

    State getState() {
        return this.state.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWait() {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.lock.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doNotify() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notify();
        }
    }

    private void asyncExec(Runnable runnable) {
        if (!this.display.isDisposed()) {
            this.display.asyncExec(runnable);
        }
    }

    static enum State {
        WAITING,
        UPLOADING,
        FINISHED,
        FAILED;

    }

    private final class UploadProgressListener
    implements FileUploadListener {
        private UploadProgressListener() {
        }

        public void uploadProgress(final FileUploadEvent event) {
            FileUploadRunnable.this.asyncExec(new Runnable(){

                @Override
                public void run() {
                    FileUploadRunnable.this.handleProgress(event.getBytesRead(), event.getContentLength());
                }
            });
        }

        public void uploadFinished(FileUploadEvent event) {
            FileUploadHandler uploadHandler = (FileUploadHandler)event.getSource();
            DiskFileUploadReceiver receiver = (DiskFileUploadReceiver)uploadHandler.getReceiver();
            final List<String> targetFileNames = this.getTargetFileNames(receiver);
            FileUploadRunnable.this.asyncExec(new Runnable(){

                @Override
                public void run() {
                    FileUploadRunnable.this.handleFinished(targetFileNames);
                }
            });
            FileUploadRunnable.this.doNotify();
        }

        public void uploadFailed(final FileUploadEvent event) {
            FileUploadRunnable.this.asyncExec(new Runnable(){

                @Override
                public void run() {
                    FileUploadRunnable.this.handleFailed(event.getException());
                }
            });
            FileUploadRunnable.this.doNotify();
        }

        private List<String> getTargetFileNames(DiskFileUploadReceiver receiver) {
            ArrayList<String> result = new ArrayList<String>();
            File[] fileArray = receiver.getTargetFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File targetFile = fileArray[n2];
                result.add(targetFile.getAbsolutePath());
                ++n2;
            }
            return result;
        }
    }
}

