/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.theme;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.rap.rwt.internal.theme.CssElement;
import org.eclipse.rap.rwt.internal.theme.CssValue;
import org.eclipse.rap.rwt.internal.theme.ThemeableWidget;
import org.eclipse.rap.rwt.internal.theme.css.ConditionalValue;
import org.eclipse.rap.rwt.internal.theme.css.StyleSheet;

public final class CssValuesMap {
    private final Map<String, Map<String, ConditionalValue[]>> elementsMap = new HashMap<String, Map<String, ConditionalValue[]>>();

    public CssValuesMap(StyleSheet styleSheet, ThemeableWidget[] themeableWidgets) {
        this.extractValues(styleSheet, themeableWidgets);
    }

    public ConditionalValue[] getValues(String elementName, String propertyName) {
        ConditionalValue[] result = null;
        Map<String, ConditionalValue[]> valuesMap = this.elementsMap.get(elementName);
        if (valuesMap != null) {
            result = valuesMap.get(propertyName);
        }
        if (result == null) {
            result = this.elementsMap.get("*").get(propertyName);
        }
        return result;
    }

    public CssValue[] getAllValues() {
        LinkedHashSet<CssValue> resultSet = new LinkedHashSet<CssValue>();
        for (Map<String, ConditionalValue[]> valuesMap : this.elementsMap.values()) {
            Iterator<ConditionalValue[]> iterator = valuesMap.values().iterator();
            while (iterator.hasNext()) {
                ConditionalValue[] condValues;
                ConditionalValue[] conditionalValueArray = condValues = iterator.next();
                int n = condValues.length;
                int n2 = 0;
                while (n2 < n) {
                    ConditionalValue condValue = conditionalValueArray[n2];
                    resultSet.add(condValue.value);
                    ++n2;
                }
            }
        }
        return resultSet.toArray(new CssValue[resultSet.size()]);
    }

    private void extractValues(StyleSheet styleSheet, ThemeableWidget[] themeableWidgets) {
        ThemeableWidget[] themeableWidgetArray = themeableWidgets;
        int n = themeableWidgets.length;
        int n2 = 0;
        while (n2 < n) {
            ThemeableWidget themeableWidget = themeableWidgetArray[n2];
            this.extractValuesForWidget(styleSheet, themeableWidget);
            ++n2;
        }
    }

    private void extractValuesForWidget(StyleSheet styleSheet, ThemeableWidget themeableWidget) {
        if (themeableWidget.elements != null) {
            CssElement[] cssElementArray = themeableWidget.elements;
            int n = themeableWidget.elements.length;
            int n2 = 0;
            while (n2 < n) {
                CssElement element = cssElementArray[n2];
                this.extractValuesForElement(styleSheet, element);
                ++n2;
            }
        }
    }

    private void extractValuesForElement(StyleSheet styleSheet, CssElement element) {
        String elementName = element.getName();
        String[] properties = element.getProperties();
        LinkedHashMap<String, ConditionalValue[]> valuesMap = new LinkedHashMap<String, ConditionalValue[]>();
        this.elementsMap.put(elementName, valuesMap);
        String[] stringArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            String propertyName = stringArray[n2];
            ConditionalValue[] values = styleSheet.getValues(elementName, propertyName);
            valuesMap.put(propertyName, this.filterValues(values, element));
            ++n2;
        }
    }

    private ConditionalValue[] filterValues(ConditionalValue[] values, CssElement element) {
        ArrayList<ConditionalValue> resultList = new ArrayList<ConditionalValue>();
        String[] latestConstraint = null;
        ConditionalValue[] conditionalValueArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            ConditionalValue value = conditionalValueArray[n2];
            if (!Arrays.equals(latestConstraint, value.constraints) && CssValuesMap.matches(element, value.constraints)) {
                resultList.add(value);
                latestConstraint = value.constraints;
            }
            ++n2;
        }
        return resultList.toArray(new ConditionalValue[resultList.size()]);
    }

    private static boolean matches(CssElement element, String[] constraints) {
        boolean passed = true;
        if (!"*".equals(element.getName())) {
            int k = 0;
            while (k < constraints.length && passed) {
                String constraint = constraints[k];
                if (constraint.charAt(0) == ':') {
                    passed &= CssValuesMap.contains(element.getStates(), constraint.substring(1));
                } else if (constraint.charAt(0) == '[') {
                    passed &= CssValuesMap.contains(element.getStyles(), constraint.substring(1));
                }
                ++k;
            }
        }
        return passed;
    }

    private static boolean contains(String[] elements, String string) {
        int i = 0;
        while (i < elements.length) {
            if (string.equals(elements[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

