/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.scripting;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rap.rwt.internal.scripting.ClientFunction;
import org.eclipse.rap.rwt.internal.scripting.ClientListenerOperation;
import org.eclipse.rap.rwt.scripting.ClientListener;
import org.eclipse.swt.widgets.Widget;

public class ClientListenerUtil {
    private static final String OPERATIONS = "rwt.clientListenerOperations";

    public static String getRemoteId(ClientFunction function) {
        return function.getRemoteId();
    }

    public static String getEventType(int bindingType) {
        String result = null;
        switch (bindingType) {
            case 2: {
                result = "KeyUp";
                break;
            }
            case 1: {
                result = "KeyDown";
                break;
            }
            case 15: {
                result = "FocusIn";
                break;
            }
            case 16: {
                result = "FocusOut";
                break;
            }
            case 3: {
                result = "MouseDown";
                break;
            }
            case 4: {
                result = "MouseUp";
                break;
            }
            case 6: {
                result = "MouseEnter";
                break;
            }
            case 7: {
                result = "MouseExit";
                break;
            }
            case 5: {
                result = "MouseMove";
                break;
            }
            case 8: {
                result = "MouseDoubleClick";
                break;
            }
            case 24: {
                result = "Modify";
                break;
            }
            case 22: {
                result = "Show";
                break;
            }
            case 23: {
                result = "Hide";
                break;
            }
            case 25: {
                result = "Verify";
                break;
            }
            case 9: {
                result = "Paint";
                break;
            }
            case 11: {
                result = "Resize";
                break;
            }
            case 13: {
                result = "Selection";
                break;
            }
            case 14: {
                result = "DefaultSelection";
                break;
            }
            case 37: {
                result = "MouseWheel";
            }
        }
        if (result == null) {
            throw new IllegalArgumentException("Unsupported event type " + bindingType);
        }
        return result;
    }

    public static void clientListenerAdded(Widget widget, int eventType, ClientListener listener) {
        List<ClientListenerOperation> operations = ClientListenerUtil.getClientListenerOperations(widget);
        if (operations == null) {
            operations = new ArrayList<ClientListenerOperation>(1);
            widget.setData(OPERATIONS, operations);
        }
        operations.add(new ClientListenerOperation.AddListener(eventType, listener));
    }

    public static void clientListenerRemoved(Widget widget, int eventType, ClientListener listener) {
        List<ClientListenerOperation> operations = ClientListenerUtil.getClientListenerOperations(widget);
        if (operations == null) {
            operations = new ArrayList<ClientListenerOperation>(1);
            widget.setData(OPERATIONS, operations);
        }
        operations.add(new ClientListenerOperation.RemoveListener(eventType, listener));
    }

    public static List<ClientListenerOperation> getClientListenerOperations(Widget widget) {
        return (List)widget.getData(OPERATIONS);
    }

    public static void clearClientListenerOperations(Widget widget) {
        widget.setData(OPERATIONS, null);
    }
}

