/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.launch.tab;

import java.io.Serializable;
import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.rap.ui.internal.launch.Activator;
import org.eclipse.rap.ui.internal.launch.LaunchMessages;
import org.eclipse.rap.ui.internal.launch.tab.AbstractExtension;
import org.eclipse.rap.ui.internal.launch.tab.ApplicationExtension;
import org.eclipse.rap.ui.internal.launch.tab.EntryPointExtension;
import org.eclipse.rap.ui.internal.launch.tab.SelectionDialogUtil;
import org.eclipse.rap.ui.internal.launch.util.Images;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.SearchPattern;

final class EntryPointApplicationSelectionDialog
extends FilteredItemsSelectionDialog {
    private static final String SETTINGS_ID = "org.eclipse.rap.ui.launch.ENTRY_POINT_SELECTION_DIALOG";
    private static final String HAS_TARGET_SCOPE = "hasTargetScope";
    private static final Comparator COMPARATOR = new EntryPointComparator();
    private AbstractExtension[] entryPoints;
    private boolean hasTargetScope;
    private final ToggleFilterScopeAction toggleFilterScopeAction;

    EntryPointApplicationSelectionDialog(Shell shell) {
        super(shell);
        this.setTitle(LaunchMessages.EntryPointSelectionDialog_Title);
        String msg = LaunchMessages.EntryPointSelectionDialog_Message;
        this.toggleFilterScopeAction = new ToggleFilterScopeAction();
        this.setMessage(msg);
        this.setSelectionHistory(new EntryPointSelectionHistory());
        this.setListLabelProvider((ILabelProvider)new EntryPointLabelProvider());
        this.setDetailsLabelProvider((ILabelProvider)new EntryPointLabelProvider());
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(SETTINGS_ID);
        if (section == null) {
            section = settings.addNewSection(SETTINGS_ID);
        }
        return section;
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider provider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor monitor) throws CoreException {
        this.startMonitoring(monitor);
        this.prepareContent(monitor);
        this.addContentToProvider(provider, itemsFilter);
        this.finishMonitoring(monitor);
    }

    private void startMonitoring(IProgressMonitor monitor) {
        if (monitor != null && this.entryPoints == null) {
            String msg = LaunchMessages.EntryPointSelectionDialog_Searching;
            monitor.beginTask(msg, -1);
        }
    }

    private void prepareContent(IProgressMonitor monitor) {
        if (this.entryPoints == null) {
            this.createContent(monitor);
        }
    }

    private void createContent(IProgressMonitor monitor) {
        AbstractExtension[] tempApplications;
        AbstractExtension[] tempEntryPoints;
        if (this.hasTargetScope) {
            tempEntryPoints = EntryPointExtension.findAllActive(monitor);
            tempApplications = ApplicationExtension.findAllActive(monitor);
        } else {
            tempEntryPoints = EntryPointExtension.findInWorkspace(monitor);
            tempApplications = ApplicationExtension.findInWorkspace(monitor);
        }
        this.initializeEntryPoints(tempEntryPoints, tempApplications);
    }

    private void initializeEntryPoints(AbstractExtension[] tempEntryPoints, AbstractExtension[] tempApplications) {
        this.entryPoints = new AbstractExtension[tempEntryPoints.length + tempApplications.length];
        System.arraycopy(tempEntryPoints, 0, this.entryPoints, 0, tempEntryPoints.length);
        System.arraycopy(tempApplications, 0, this.entryPoints, tempEntryPoints.length, tempApplications.length);
    }

    private void addContentToProvider(FilteredItemsSelectionDialog.AbstractContentProvider provider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter) {
        int i = 0;
        while (i < this.entryPoints.length) {
            provider.add((Object)this.entryPoints[i], itemsFilter);
            ++i;
        }
    }

    private void finishMonitoring(IProgressMonitor monitor) {
        if (monitor != null) {
            monitor.done();
        }
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        SearchPattern searchPattern = SelectionDialogUtil.createSearchPattern();
        return new EntryPointItemsFilter(searchPattern, this.hasTargetScope);
    }

    public String getElementName(Object element) {
        AbstractExtension entryPoint = (AbstractExtension)element;
        String project = entryPoint.getProject();
        String decorator = "";
        if (element instanceof EntryPointExtension) {
            decorator = ((EntryPointExtension)entryPoint).getParameter();
        } else if (element instanceof ApplicationExtension) {
            decorator = ((ApplicationExtension)entryPoint).getId();
        }
        return SelectionDialogUtil.getLabel(project, decorator);
    }

    protected Comparator getItemsComparator() {
        return COMPARATOR;
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    protected void fillViewMenu(IMenuManager menuManager) {
        super.fillViewMenu(menuManager);
        menuManager.add((IAction)this.toggleFilterScopeAction);
    }

    protected void storeDialog(IDialogSettings settings) {
        super.storeDialog(settings);
        settings.put(HAS_TARGET_SCOPE, this.toggleFilterScopeAction.isChecked());
    }

    protected void restoreDialog(IDialogSettings settings) {
        super.restoreDialog(settings);
        if (settings.get(HAS_TARGET_SCOPE) != null) {
            this.toggleFilterScopeAction.setChecked(settings.getBoolean(HAS_TARGET_SCOPE));
            this.toggleFilterScopeAction.run();
        }
    }

    private static final class EntryPointComparator
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = 1L;

        private EntryPointComparator() {
        }

        public int compare(Object object1, Object object2) {
            int result = -1;
            AbstractExtension extension1 = (AbstractExtension)object1;
            AbstractExtension extension2 = (AbstractExtension)object2;
            if (extension1 instanceof EntryPointExtension && extension2 instanceof EntryPointExtension) {
                result = this.handleEntryPointExtension(extension1, extension2);
            } else if (extension1 instanceof ApplicationExtension && extension2 instanceof ApplicationExtension) {
                result = this.handleApplicationExtension(extension1, extension2);
            }
            return result;
        }

        private int handleEntryPointExtension(AbstractExtension extension1, AbstractExtension extension2) {
            EntryPointExtension entryExtension1 = (EntryPointExtension)extension1;
            String string1 = String.valueOf(extension1.getProject()) + entryExtension1.getParameter();
            EntryPointExtension entryExtension2 = (EntryPointExtension)extension2;
            String string2 = String.valueOf(extension2.getProject()) + entryExtension2.getParameter();
            return string1.compareTo(string2);
        }

        private int handleApplicationExtension(AbstractExtension extension1, AbstractExtension extension2) {
            ApplicationExtension appExtension1 = (ApplicationExtension)extension1;
            String string1 = String.valueOf(extension1.getProject()) + appExtension1.getId();
            ApplicationExtension appExtension2 = (ApplicationExtension)extension2;
            String string2 = String.valueOf(extension2.getProject()) + appExtension2.getId();
            return string1.compareTo(string2);
        }
    }

    private final class EntryPointItemsFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        private final boolean scope;

        public EntryPointItemsFilter(SearchPattern searchPattern, boolean scope) {
            super((FilteredItemsSelectionDialog)EntryPointApplicationSelectionDialog.this, searchPattern);
            this.scope = scope;
        }

        public boolean isConsistentItem(Object item) {
            return true;
        }

        public boolean matchItem(Object item) {
            boolean result = false;
            if (item instanceof EntryPointExtension) {
                result = this.matches(((EntryPointExtension)item).getParameter());
            } else if (item instanceof ApplicationExtension) {
                result = this.matches(((ApplicationExtension)item).getId());
            }
            return result;
        }

        public boolean isSubFilter(FilteredItemsSelectionDialog.ItemsFilter filter) {
            boolean result = this.scope != ((EntryPointItemsFilter)filter).scope ? false : super.isSubFilter(filter);
            return result;
        }

        public boolean equalsFilter(FilteredItemsSelectionDialog.ItemsFilter filter) {
            boolean result = this.scope != ((EntryPointItemsFilter)filter).scope ? false : super.equalsFilter(filter);
            return result;
        }
    }

    private static final class EntryPointLabelProvider
    extends LabelProvider {
        private final Image image = Images.EXTENSION.createImage();

        private EntryPointLabelProvider() {
        }

        public String getText(Object element) {
            String result = null;
            if (element != null) {
                AbstractExtension extension = (AbstractExtension)element;
                String project = extension.getProject();
                String decorator = "";
                if (extension instanceof EntryPointExtension) {
                    decorator = ((EntryPointExtension)extension).getParameter();
                } else if (extension instanceof ApplicationExtension) {
                    decorator = ((ApplicationExtension)extension).getId();
                }
                result = SelectionDialogUtil.getLabel(project, decorator);
            }
            return result;
        }

        public Image getImage(Object element) {
            return this.image;
        }

        public void dispose() {
            this.image.dispose();
            super.dispose();
        }
    }

    private static final class EntryPointSelectionHistory
    extends FilteredItemsSelectionDialog.SelectionHistory {
        private EntryPointSelectionHistory() {
        }

        protected Object restoreItemFromMemento(IMemento memento) {
            return null;
        }

        protected void storeItemToMemento(Object item, IMemento memento) {
        }
    }

    private class ToggleFilterScopeAction
    extends Action {
        public ToggleFilterScopeAction() {
            super(LaunchMessages.ServletNameSelectionDialog_WorkspaceFilterMsg, 2);
            this.setChecked(EntryPointApplicationSelectionDialog.this.hasTargetScope);
        }

        public void run() {
            EntryPointApplicationSelectionDialog.this.hasTargetScope = this.isChecked();
            EntryPointApplicationSelectionDialog.this.entryPoints = null;
            EntryPointApplicationSelectionDialog.this.applyFilter();
        }
    }
}

