/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.launch.tab;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.pde.ui.launcher.AbstractLauncherTab;
import org.eclipse.rap.ui.internal.launch.LaunchMessages;
import org.eclipse.rap.ui.internal.launch.RAPLaunchConfig;
import org.eclipse.rap.ui.internal.launch.RAPLaunchConfigValidator;
import org.eclipse.rap.ui.internal.launch.URLBuilder;
import org.eclipse.rap.ui.internal.launch.tab.AbstractExtension;
import org.eclipse.rap.ui.internal.launch.tab.ApplicationExtension;
import org.eclipse.rap.ui.internal.launch.tab.BrandingExtension;
import org.eclipse.rap.ui.internal.launch.tab.DataLocationBlock;
import org.eclipse.rap.ui.internal.launch.tab.EntryPointApplicationSelectionDialog;
import org.eclipse.rap.ui.internal.launch.tab.EntryPointExtension;
import org.eclipse.rap.ui.internal.launch.tab.ServletNameSelectionDialog;
import org.eclipse.rap.ui.internal.launch.util.ErrorUtil;
import org.eclipse.rap.ui.internal.launch.util.Images;
import org.eclipse.rap.ui.internal.launch.util.LauncherSerializationUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferencesUtil;

public final class MainTab
extends AbstractLauncherTab {
    private static final String BROWSER_PREFERENCE_PAGE = "org.eclipse.ui.browser.preferencePage";
    private final GridDataFactory fillHorizontal;
    private final ModifyListener modifyListener;
    private final SelectionListener selectionListener;
    private final Image tabImage = Images.DESC_MAIN_TAB.createImage();
    private final Image warnImage = Images.WARNING.createImage();
    private Text servletNameTextField;
    private Text entryPointTextField;
    private Button terminatePreviousCheckBox;
    private Button openBrowserCheckBox;
    private Button internalBrowserRadioButton;
    private Button externalBrowserRadioButton;
    private Text applicationUrlTextField;
    private Button manualPortCheckBox;
    private Button contextPathCheckBox;
    private Text contextPathTextField;
    private Spinner portSpinner;
    private Button useSessionTimeoutCheckBox;
    private Spinner sessionTimeoutSpinner;
    private ComboViewer logLevelCombo;
    private ComboViewer libraryVariantCombo;
    private ILaunchConfigurationListener launchConfigListener;
    private DataLocationBlock dataLocationBlock;

    public MainTab() {
        GridData gridData = new GridData(4, 0x1000000, true, false);
        this.fillHorizontal = GridDataFactory.createFrom((GridData)gridData);
        this.modifyListener = this.createDialogModifyListener();
        this.selectionListener = this.createDialogSelectionListener();
        this.addLaunchConfigListener();
    }

    private ModifyListener createDialogModifyListener() {
        ModifyListener result = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MainTab.this.updateLaunchConfigurationDialog();
            }
        };
        return result;
    }

    private SelectionAdapter createDialogSelectionListener() {
        SelectionAdapter result = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainTab.this.updateLaunchConfigurationDialog();
            }
        };
        return result;
    }

    public void dispose() {
        this.tabImage.dispose();
        this.warnImage.dispose();
        ILaunchManager launchManager = this.getLaunchManager();
        launchManager.removeLaunchConfigurationListener(this.launchConfigListener);
        super.dispose();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        this.createServletNameAndEntryPointSection(container);
        this.createBrowserModeSection(container);
        this.createRuntimeSettingsSection(container);
        this.createDataLocationSection(container);
        Dialog.applyDialogFont((Control)container);
        this.setControl((Control)container);
    }

    public String getName() {
        return LaunchMessages.MainTab_Name;
    }

    public Image getImage() {
        return this.tabImage;
    }

    public void initializeFrom(ILaunchConfiguration config) {
        RAPLaunchConfig rapConfig = new RAPLaunchConfig(config);
        try {
            this.servletNameTextField.setText(rapConfig.getServletName());
            this.entryPointTextField.setText(rapConfig.getEntryPoint());
            this.terminatePreviousCheckBox.setSelection(rapConfig.getTerminatePrevious());
            this.manualPortCheckBox.setSelection(rapConfig.getUseManualPort());
            this.portSpinner.setSelection(rapConfig.getPort());
            this.contextPathCheckBox.setSelection(rapConfig.getUseManualContextPath());
            this.contextPathTextField.setText(rapConfig.getContextPath());
            boolean openBrowser = rapConfig.getOpenBrowser();
            this.openBrowserCheckBox.setSelection(openBrowser);
            this.internalBrowserRadioButton.setEnabled(openBrowser);
            this.externalBrowserRadioButton.setEnabled(openBrowser);
            if (RAPLaunchConfig.BrowserMode.EXTERNAL.equals(rapConfig.getBrowserMode())) {
                this.externalBrowserRadioButton.setSelection(true);
                this.internalBrowserRadioButton.setSelection(false);
            } else {
                this.externalBrowserRadioButton.setSelection(false);
                this.internalBrowserRadioButton.setSelection(true);
            }
            this.useSessionTimeoutCheckBox.setSelection(rapConfig.getUseSessionTimeout());
            this.sessionTimeoutSpinner.setSelection(rapConfig.getSessionTimeout());
            Level logLevel = rapConfig.getLogLevel();
            StructuredSelection logSelection = new StructuredSelection((Object)logLevel);
            this.logLevelCombo.setSelection((ISelection)logSelection);
            RAPLaunchConfig.LibraryVariant libVariant = rapConfig.getLibraryVariant();
            StructuredSelection libSelection = new StructuredSelection((Object)libVariant);
            this.libraryVariantCombo.setSelection((ISelection)libSelection);
            this.dataLocationBlock.initializeFrom(rapConfig);
        }
        catch (CoreException e) {
            ErrorUtil.show(null, e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        RAPLaunchConfig rapConfig = new RAPLaunchConfig((ILaunchConfiguration)config);
        rapConfig.setServletName(this.servletNameTextField.getText());
        rapConfig.setEntryPoint(this.entryPointTextField.getText());
        rapConfig.setTerminatePrevious(this.terminatePreviousCheckBox.getSelection());
        rapConfig.setOpenBrowser(this.openBrowserCheckBox.getSelection());
        rapConfig.setBrowserMode(this.getBrowserMode());
        this.portSpinner.setEnabled(this.manualPortCheckBox.getSelection());
        rapConfig.setUseManualPort(this.manualPortCheckBox.getSelection());
        rapConfig.setPort(this.portSpinner.getSelection());
        this.contextPathTextField.setEnabled(this.contextPathCheckBox.getSelection());
        rapConfig.setUseManualContextPath(this.contextPathCheckBox.getSelection());
        rapConfig.setContextPath(this.contextPathTextField.getText());
        this.sessionTimeoutSpinner.setEnabled(this.useSessionTimeoutCheckBox.getSelection());
        rapConfig.setUseSessionTimeout(this.useSessionTimeoutCheckBox.getSelection());
        rapConfig.setSessionTimeout(this.sessionTimeoutSpinner.getSelection());
        rapConfig.setLogLevel(this.getLogLevel());
        rapConfig.setLibraryVariant(this.getLibraryVariant());
        rapConfig.setDataLocation(this.dataLocationBlock.getLocation());
        boolean useDefaultDataLocation = this.dataLocationBlock.getUseDefaultDataLocation();
        rapConfig.setUseDefaultDataLocation(useDefaultDataLocation);
        rapConfig.setDoClearDataLocation(this.dataLocationBlock.getDoClearDataLocation());
        rapConfig.setAskClearDataLocation(false);
        this.validate(rapConfig);
        this.setDirty(true);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        RAPLaunchConfig.setDefaults(config);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return this.getErrorMessage() == null;
    }

    public void validateTab() {
    }

    private void addLaunchConfigListener() {
        this.launchConfigListener = this.getLaunchConfigListener();
        ILaunchManager launchManager = this.getLaunchManager();
        launchManager.addLaunchConfigurationListener(this.launchConfigListener);
    }

    private ILaunchConfigurationListener getLaunchConfigListener() {
        ILaunchConfigurationListener result = new ILaunchConfigurationListener(){

            public void launchConfigurationChanged(ILaunchConfiguration configuration) {
                RAPLaunchConfig rapConfig = new RAPLaunchConfig(configuration);
                MainTab.this.validate(rapConfig);
                MainTab.this.updateApplicationUrl(rapConfig);
            }

            public void launchConfigurationAdded(ILaunchConfiguration configuration) {
            }

            public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
            }
        };
        return result;
    }

    private void createDataLocationSection(Composite container) {
        this.dataLocationBlock = new DataLocationBlock(this);
        Control blockControl = this.dataLocationBlock.createControl(container);
        blockControl.setLayoutData((Object)new GridData(768));
    }

    private void createServletNameAndEntryPointSection(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout(3, false));
        group.setLayoutData((Object)this.fillHorizontal.create());
        group.setText(LaunchMessages.MainTab_ServletAndEntryPoint);
        this.createServletNamePart((Composite)group);
        this.createEntryPointPart((Composite)group);
        this.createSessionPart((Composite)group);
    }

    private void createServletNamePart(Composite parent) {
        Label lblServletName = new Label(parent, 0);
        lblServletName.setText(LaunchMessages.MainTab_ServletName);
        this.servletNameTextField = new Text(parent, 2048);
        this.servletNameTextField.setLayoutData((Object)this.fillHorizontal.create());
        this.servletNameTextField.addModifyListener(this.modifyListener);
        Button btnBrowseServletName = new Button(parent, 8);
        btnBrowseServletName.setText(LaunchMessages.MainTab_BrowseServletName);
        btnBrowseServletName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainTab.this.handleBrowseServletName();
            }
        });
    }

    private void createEntryPointPart(Composite parent) {
        Label lblEntryPoint = new Label(parent, 0);
        lblEntryPoint.setText(LaunchMessages.MainTab_EntryPoint);
        this.entryPointTextField = new Text(parent, 2048);
        this.entryPointTextField.setLayoutData((Object)this.fillHorizontal.create());
        this.entryPointTextField.addModifyListener(this.modifyListener);
        Button btnBrowseEntryPoint = new Button(parent, 8);
        btnBrowseEntryPoint.setText(LaunchMessages.MainTab_BrowseEntryPoint);
        btnBrowseEntryPoint.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainTab.this.handleBrowseEntryPointAndApplications();
            }
        });
    }

    private void createSessionPart(Composite parent) {
        this.terminatePreviousCheckBox = new Button(parent, 32);
        this.terminatePreviousCheckBox.setLayoutData((Object)MainTab.spanHorizontal(3, 0));
        String text = LaunchMessages.MainTab_TerminatePrevious;
        this.terminatePreviousCheckBox.setText(text);
        this.terminatePreviousCheckBox.addSelectionListener(this.selectionListener);
    }

    private void createBrowserModeSection(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayoutData((Object)this.fillHorizontal.create());
        group.setText(LaunchMessages.MainTab_Browser);
        group.setLayout((Layout)new GridLayout(3, false));
        this.createBrowserActivationPart((Composite)group);
        this.createBrowserModePart((Composite)group);
        this.createApplicationUrlPart((Composite)group);
    }

    private void createBrowserActivationPart(Composite parent) {
        this.openBrowserCheckBox = new Button(parent, 32);
        GridDataFactory.swtDefaults().grab(true, false).span(2, 1).applyTo((Control)this.openBrowserCheckBox);
        this.openBrowserCheckBox.setText(LaunchMessages.MainTab_OpenApplicationIn);
        this.openBrowserCheckBox.addSelectionListener(this.selectionListener);
        Link lnkBrowserPrefs = new Link(parent, 0);
        lnkBrowserPrefs.setText(LaunchMessages.MainTab_ConfigureBrowsers);
        lnkBrowserPrefs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainTab.this.handleBrowserPrefsLink();
            }
        });
    }

    private void createBrowserModePart(Composite parent) {
        this.internalBrowserRadioButton = new Button(parent, 16);
        GridDataFactory radioBtnData = GridDataFactory.fillDefaults().indent(17, 0);
        this.internalBrowserRadioButton.setLayoutData((Object)radioBtnData.create());
        this.internalBrowserRadioButton.setText(LaunchMessages.MainTab_InternalBrowser);
        this.internalBrowserRadioButton.addSelectionListener(this.selectionListener);
        this.externalBrowserRadioButton = new Button(parent, 16);
        this.externalBrowserRadioButton.setLayoutData((Object)radioBtnData.create());
        this.externalBrowserRadioButton.setText(LaunchMessages.MainTab_ExternalBrowser);
        this.externalBrowserRadioButton.addSelectionListener(this.selectionListener);
        this.openBrowserCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean openBrowser = MainTab.this.openBrowserCheckBox.getSelection();
                MainTab.this.internalBrowserRadioButton.setEnabled(openBrowser);
                MainTab.this.externalBrowserRadioButton.setEnabled(openBrowser);
            }
        });
    }

    private void createApplicationUrlPart(Composite parent) {
        Composite urlComposite = new Composite(parent, 0);
        Label finalUrlLabel = new Label(urlComposite, 0);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)urlComposite);
        GridLayoutFactory.fillDefaults().numColumns(3).generateLayout(urlComposite);
        finalUrlLabel.setText(LaunchMessages.MainTab_ApplicationUrl);
        this.applicationUrlTextField = new Text(urlComposite, 12);
        this.applicationUrlTextField.setBackground(this.applicationUrlTextField.getParent().getBackground());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.applicationUrlTextField);
    }

    private void createRuntimeSettingsSection(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayoutData((Object)this.fillHorizontal.create());
        group.setText(LaunchMessages.MainTab_RuntimeSettings);
        group.setLayout((Layout)new GridLayout(2, true));
        Composite leftPart = new Composite((Composite)group, 0);
        leftPart.setLayout((Layout)this.createGridLayoutWithoutMargin(2));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)leftPart);
        this.createRuntimeSettingsLeftPart(leftPart);
        Composite rightPart = new Composite((Composite)group, 0);
        rightPart.setLayout((Layout)this.createGridLayoutWithoutMargin(2));
        GridDataFactory.fillDefaults().grab(true, false).indent(15, 0).applyTo((Control)rightPart);
        this.createRuntimeSettingsRightPart(rightPart);
    }

    private GridLayout createGridLayoutWithoutMargin(int numColumns) {
        GridLayout result = new GridLayout(numColumns, false);
        result.marginHeight = 0;
        result.marginWidth = 0;
        return result;
    }

    private void createRuntimeSettingsLeftPart(Composite leftPartComposite) {
        this.manualPortCheckBox = new Button(leftPartComposite, 32);
        this.manualPortCheckBox.setText(LaunchMessages.MainTab_ManualPortConfig);
        this.manualPortCheckBox.addSelectionListener(this.selectionListener);
        this.portSpinner = new Spinner(leftPartComposite, 2048);
        this.portSpinner.setLayoutData((Object)new GridData(4, -1, true, false));
        this.portSpinner.setMinimum(0);
        this.portSpinner.setMaximum(65535);
        this.portSpinner.addModifyListener(this.modifyListener);
        this.useSessionTimeoutCheckBox = new Button(leftPartComposite, 32);
        this.useSessionTimeoutCheckBox.setText(LaunchMessages.MainTab_ManualTimeoutConfig);
        this.useSessionTimeoutCheckBox.addSelectionListener(this.selectionListener);
        this.sessionTimeoutSpinner = new Spinner(leftPartComposite, 2048);
        this.sessionTimeoutSpinner.setLayoutData((Object)new GridData(4, -1, true, false));
        this.sessionTimeoutSpinner.setMinimum(0);
        this.sessionTimeoutSpinner.setMaximum(Integer.MAX_VALUE);
        this.sessionTimeoutSpinner.addModifyListener(this.modifyListener);
        this.contextPathCheckBox = new Button(leftPartComposite, 32);
        this.contextPathCheckBox.setText(LaunchMessages.MainTab_ManualContextPath);
        this.contextPathCheckBox.addSelectionListener(this.selectionListener);
        this.contextPathTextField = new Text(leftPartComposite, 2052);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.contextPathTextField);
        this.contextPathTextField.addModifyListener(this.modifyListener);
    }

    private void createRuntimeSettingsRightPart(Composite righttPartComposite) {
        Label logLevelLabel = new Label(righttPartComposite, 0);
        logLevelLabel.setText(LaunchMessages.MainTab_ClientLogLevel);
        this.logLevelCombo = new ComboViewer(righttPartComposite, 12);
        this.logLevelCombo.getCombo().setLayoutData((Object)new GridData(4, 4, true, false));
        int itemCount = RAPLaunchConfig.LOG_LEVELS.length;
        this.logLevelCombo.getCombo().setVisibleItemCount(itemCount);
        this.logLevelCombo.setLabelProvider((IBaseLabelProvider)new LogLevelLabelProvider());
        this.logLevelCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.logLevelCombo.setInput((Object)RAPLaunchConfig.LOG_LEVELS);
        this.createLogControlDecorator();
        Label libraryVariantLabel = new Label(righttPartComposite, 0);
        libraryVariantLabel.setText(LaunchMessages.MainTab_ClientLibraryVariant);
        this.libraryVariantCombo = new ComboViewer(righttPartComposite, 12);
        this.libraryVariantCombo.getCombo().setLayoutData((Object)new GridData(4, 4, true, false));
        this.libraryVariantCombo.setLabelProvider((IBaseLabelProvider)new LibraryVariantLabelProvider());
        this.libraryVariantCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.libraryVariantCombo.setInput((Object)RAPLaunchConfig.LibraryVariant.values());
        this.libraryVariantCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MainTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void createLogControlDecorator() {
        final ControlDecoration logDecorator = new ControlDecoration(this.logLevelCombo.getControl(), 16384);
        FieldDecorationRegistry registry = FieldDecorationRegistry.getDefault();
        FieldDecoration warningDecoration = registry.getFieldDecoration("DEC_WARNING");
        logDecorator.setImage(warningDecoration.getImage());
        logDecorator.setShowHover(true);
        logDecorator.setDescriptionText(LaunchMessages.MainTab_LogWarningMsg);
        logDecorator.setMarginWidth(5);
        this.updateLogDecorator(logDecorator);
        this.logLevelCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MainTab.this.updateLaunchConfigurationDialog();
                MainTab.this.updateLogDecorator(logDecorator);
            }
        });
    }

    private void updateLogDecorator(ControlDecoration decorator) {
        Level logLevel = this.getLogLevel();
        if (logLevel == Level.OFF) {
            decorator.hide();
        } else {
            decorator.show();
        }
    }

    private static GridData spanHorizontal(int span, int indent) {
        GridData result = new GridData(4, 0x1000000, true, false, span, -1);
        result.horizontalIndent = indent;
        return result;
    }

    private void validate(RAPLaunchConfig config) {
        RAPLaunchConfigValidator validator = new RAPLaunchConfigValidator(config);
        IStatus[] states = validator.validate();
        String infoMessage = MainTab.findMessage(states, 1);
        String warnMessage = MainTab.findMessage(states, 2);
        String errorMessage = MainTab.findMessage(states, 4);
        if (warnMessage != null) {
            this.setMessage(warnMessage);
        } else {
            this.setMessage(infoMessage);
        }
        this.setErrorMessage(errorMessage);
    }

    private void updateApplicationUrl(RAPLaunchConfig config) {
        String applicationUrl;
        try {
            applicationUrl = this.getApplicationUrl(config);
        }
        catch (Exception e) {
            this.setErrorMessage(e.getMessage());
            applicationUrl = "";
        }
        this.udpateApplicationUrlTextField(applicationUrl);
    }

    private String getApplicationUrl(RAPLaunchConfig config) throws CoreException {
        String result;
        if (config.getUseManualPort()) {
            int port = config.getPort();
            result = URLBuilder.fromLaunchConfig(config, port, false);
        } else {
            result = URLBuilder.fromLaunchConfig(config, "<PORT>", false);
        }
        return result;
    }

    private void udpateApplicationUrlTextField(final String finalApplicationUrl) {
        if (this.applicationUrlTextField != null && !this.applicationUrlTextField.isDisposed()) {
            this.applicationUrlTextField.getDisplay().syncExec(new Runnable(){

                public void run() {
                    if (!finalApplicationUrl.equals(MainTab.this.applicationUrlTextField.getText())) {
                        MainTab.this.applicationUrlTextField.setText(finalApplicationUrl);
                    }
                }
            });
        }
    }

    private static String findMessage(IStatus[] states, int severity) {
        String result = null;
        int i = 0;
        while (result == null && i < states.length) {
            if (states[i].matches(severity)) {
                result = states[i].getMessage();
            }
            ++i;
        }
        return result;
    }

    private void handleBrowseEntryPointAndApplications() {
        EntryPointApplicationSelectionDialog dialog = new EntryPointApplicationSelectionDialog(this.getShell());
        if (dialog.open() == 0) {
            Object[] selection = dialog.getResult();
            AbstractExtension selectedExtension = (AbstractExtension)selection[0];
            this.handleSelectedExtension(selectedExtension);
        }
    }

    private void handleSelectedExtension(AbstractExtension selectedExtension) {
        if (selectedExtension instanceof EntryPointExtension) {
            EntryPointExtension entry = (EntryPointExtension)selectedExtension;
            String serializedEntryPoint = LauncherSerializationUtil.serializeEntryPointExntesion(entry);
            this.entryPointTextField.setText(serializedEntryPoint);
        } else if (selectedExtension instanceof ApplicationExtension) {
            ApplicationExtension ext = (ApplicationExtension)selectedExtension;
            String serializedAppExt = LauncherSerializationUtil.serializeApplicationExtension(ext);
            this.entryPointTextField.setText(serializedAppExt);
        }
    }

    private void handleBrowseServletName() {
        ServletNameSelectionDialog dialog = new ServletNameSelectionDialog(this.getShell());
        if (dialog.open() == 0) {
            Object[] selection = dialog.getResult();
            BrandingExtension branding = (BrandingExtension)selection[0];
            String serializedBranding = LauncherSerializationUtil.serializeBrandingExtension(branding);
            this.servletNameTextField.setText(serializedBranding);
            String defaultEntryPointId = branding.getDefaultEntryPointId();
            String parameter = null;
            EntryPointExtension etryPoint = EntryPointExtension.findById(defaultEntryPointId);
            if (etryPoint != null) {
                parameter = LauncherSerializationUtil.serializeEntryPointExntesion(etryPoint);
            }
            if (this.entryPointTextField.getText().length() == 0 && parameter != null) {
                this.entryPointTextField.setText(parameter);
            }
        }
    }

    private void handleBrowserPrefsLink() {
        PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)BROWSER_PREFERENCE_PAGE, null, null);
        dialog.open();
        dialog.close();
    }

    private RAPLaunchConfig.BrowserMode getBrowserMode() {
        boolean selection = this.externalBrowserRadioButton.getSelection();
        return selection ? RAPLaunchConfig.BrowserMode.EXTERNAL : RAPLaunchConfig.BrowserMode.INTERNAL;
    }

    private Level getLogLevel() {
        Level result = Level.OFF;
        ISelection selection = this.logLevelCombo.getSelection();
        if (!selection.isEmpty()) {
            result = (Level)((IStructuredSelection)selection).getFirstElement();
        }
        return result;
    }

    private RAPLaunchConfig.LibraryVariant getLibraryVariant() {
        RAPLaunchConfig.LibraryVariant result = RAPLaunchConfig.LibraryVariant.STANDARD;
        ISelection selection = this.libraryVariantCombo.getSelection();
        if (!selection.isEmpty()) {
            IStructuredSelection structuredSel = (IStructuredSelection)selection;
            result = (RAPLaunchConfig.LibraryVariant)structuredSel.getFirstElement();
        }
        return result;
    }

    private static final class LibraryVariantLabelProvider
    extends LabelProvider {
        private LibraryVariantLabelProvider() {
        }

        public String getText(Object element) {
            String result = RAPLaunchConfig.LibraryVariant.STANDARD.equals(element) ? LaunchMessages.MainTab_LibraryVariantStandard : (RAPLaunchConfig.LibraryVariant.DEBUG.equals(element) ? LaunchMessages.MainTab_LibraryVariantDebug : super.getText(element));
            return result;
        }
    }

    private static final class LogLevelLabelProvider
    extends LabelProvider {
        private static final Map lables = new HashMap();

        static {
            lables.put(Level.ALL, LaunchMessages.MainTab_LogLevelAll);
            lables.put(Level.OFF, LaunchMessages.MainTab_LogLevelOff);
            lables.put(Level.CONFIG, LaunchMessages.MainTab_LogLevelConfig);
            lables.put(Level.WARNING, LaunchMessages.MainTab_LogLevelWarning);
            lables.put(Level.SEVERE, LaunchMessages.MainTab_LogLevelSevere);
            lables.put(Level.FINE, LaunchMessages.MainTab_LogLevelFine);
            lables.put(Level.FINER, LaunchMessages.MainTab_LogLevelFiner);
            lables.put(Level.FINEST, LaunchMessages.MainTab_LogLevelFinest);
            lables.put(Level.INFO, LaunchMessages.MainTab_LogLevelInfo);
        }

        private LogLevelLabelProvider() {
        }

        public String getText(Object element) {
            String result = (String)lables.get(element);
            if (result == null) {
                result = super.getText(element);
            }
            return result;
        }
    }
}

