/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.resources;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.rwt.internal.engine.RWTFactory;
import org.eclipse.rwt.internal.resources.JSFile;
import org.eclipse.rwt.internal.util.ParamCheck;
import org.eclipse.rwt.resources.IResourceManager;

public final class ResourceUtil {
    static /* synthetic */ Class class$0;

    static byte[] read(String name, String charset, boolean compress, IResourceManager resourceManager) throws IOException {
        byte[] result = charset != null ? ResourceUtil.readText(name, charset, compress, resourceManager) : ResourceUtil.readBinary(name, resourceManager);
        return result;
    }

    static byte[] read(InputStream is, String charset, boolean compress) throws IOException {
        byte[] result = charset != null ? ResourceUtil.readText(is, charset, compress) : ResourceUtil.readBinary(is);
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void write(File toWrite, byte[] content) throws IOException {
        FileOutputStream fos = new FileOutputStream(toWrite);
        try {
            BufferedOutputStream out = new BufferedOutputStream(fos);
            try {
                ((OutputStream)out).write(content);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                ((OutputStream)out).close();
                throw throwable;
            }
            {
                Object var4_6 = null;
                ((OutputStream)out).close();
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            fos.close();
            throw throwable;
        }
        {
            Object var6_9 = null;
        }
        fos.close();
        RWTFactory.getJSLibraryConcatenator().appendJSLibrary(toWrite, content);
    }

    public static void useJsLibrary(String libraryName) {
        ParamCheck.notNull(libraryName, "libraryName");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] readText(String name, String charset, boolean compress, IResourceManager resourceManager) throws IOException {
        byte[] result;
        InputStream is = ResourceUtil.openStream(name, resourceManager);
        try {
            result = ResourceUtil.readText(is, charset, compress);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            is.close();
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        is.close();
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static byte[] readText(InputStream is, String charset, boolean compress) throws IOException {
        StringBuffer text = new StringBuffer();
        InputStreamReader reader = new InputStreamReader(is, charset);
        BufferedReader br = new BufferedReader(reader);
        char[] buffer = new char[8096];
        try {
            int readChars = br.read(buffer);
            while (readChars != -1) {
                text.append(buffer, 0, readChars);
                readChars = br.read(buffer);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            br.close();
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        br.close();
        if (compress) {
            ResourceUtil.compress(text);
        }
        return text.toString().getBytes("UTF-8");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] readBinary(String name, IResourceManager resourceManager) throws IOException {
        byte[] result;
        InputStream is = ResourceUtil.openStream(name, resourceManager);
        try {
            result = ResourceUtil.readBinary(is);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            is.close();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        is.close();
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static byte[] readBinary(InputStream stream) throws IOException {
        ByteArrayOutputStream bufferedResult = new ByteArrayOutputStream();
        BufferedInputStream bufferedStream = new BufferedInputStream(stream);
        try {
            byte[] buffer = new byte[256];
            int read = bufferedStream.read(buffer);
            while (read != -1) {
                bufferedResult.write(buffer, 0, read);
                read = bufferedStream.read(buffer);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            bufferedStream.close();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        bufferedStream.close();
        return bufferedResult.toByteArray();
    }

    private static InputStream openStream(String name, IResourceManager resourceManager) throws IOException {
        ClassLoader loader;
        URL resource;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.internal.resources.ResourceManagerImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((resource = (loader = clazz.getClassLoader()).getResource(name)) == null) {
            resource = resourceManager.getResource(name);
        }
        if (resource == null) {
            throw new IOException("Resource to read not found: " + name);
        }
        URLConnection con = resource.openConnection();
        con.setUseCaches(false);
        return con.getInputStream();
    }

    static void compress(StringBuffer javaScript) throws IOException {
        JSFile jsFile = new JSFile(javaScript.toString());
        javaScript.setLength(0);
        javaScript.append(jsFile.compress());
    }

    private ResourceUtil() {
    }
}

