/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.compiler.ISourceElementRequestor;
import org.eclipse.dltk.compiler.SourceElementRequestorAdaptor;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.ICalleeProcessor;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceElementParser;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.search.SearchParticipant;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.SearchRequestor;
import org.eclipse.php.internal.core.Logger;

public class PHPCalleeProcessor
implements ICalleeProcessor {
    private IMethod method;
    private IDLTKSearchScope scope;
    private Map<Object, Object> fSearchResults = new HashMap<Object, Object>();

    public PHPCalleeProcessor(IMethod method, IProgressMonitor monitor, IDLTKSearchScope scope) {
        this.method = method;
        this.scope = scope;
    }

    public Map<Object, Object> doOperation() {
        try {
            if (this.method.getSource() != null) {
                RequestorAdaptor requestor = new RequestorAdaptor();
                ISourceElementParser parser = DLTKLanguageManager.getSourceElementParser((String)"org.eclipse.php.core.PHPNature");
                parser.setRequestor((ISourceElementRequestor)requestor);
                parser.parseSourceModule((IModuleSource)this.method.getAncestor(5));
            }
            return this.fSearchResults;
        }
        catch (ModelException e) {
            Logger.logException(e);
            return this.fSearchResults;
        }
    }

    public IMethod[] findMethods(String methodName, int argCount, int sourcePosition) {
        ArrayList<IMethod> methods;
        block4: {
            methods = new ArrayList<IMethod>();
            ISourceModule module = this.method.getSourceModule();
            try {
                IModelElement[] elements = module.codeSelect(sourcePosition, methodName.length());
                int i = 0;
                while (i < elements.length) {
                    if (elements[i] instanceof IMethod) {
                        methods.add((IMethod)elements[i]);
                    }
                    ++i;
                }
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG) break block4;
                e.printStackTrace();
            }
        }
        return methods.toArray(new IMethod[methods.size()]);
    }

    protected void search(String patternString, int searchFor, int limitTo, IDLTKSearchScope scope, SearchRequestor resultCollector) throws CoreException {
        this.search(patternString, searchFor, limitTo, 0, scope, resultCollector);
    }

    protected void search(String patternString, int searchFor, int limitTo, int matchRule, IDLTKSearchScope scope, SearchRequestor requestor) throws CoreException {
        if (patternString.indexOf(42) != -1 || patternString.indexOf(63) != -1) {
            matchRule |= 2;
        }
        SearchPattern pattern = SearchPattern.createPattern((String)patternString, (int)searchFor, (int)limitTo, (int)matchRule, (IDLTKLanguageToolkit)scope.getLanguageToolkit());
        SearchEngine searchEngine = new SearchEngine();
        searchEngine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, null);
    }

    private class RequestorAdaptor
    extends SourceElementRequestorAdaptor {
        private RequestorAdaptor() {
        }

        public void acceptMethodReference(String methodName, int argCount, int sourcePosition, int sourceEndPosition) {
            try {
                if (sourcePosition < PHPCalleeProcessor.this.method.getSourceRange().getOffset() || sourceEndPosition > PHPCalleeProcessor.this.method.getSourceRange().getLength() + PHPCalleeProcessor.this.method.getSourceRange().getOffset()) {
                    return;
                }
            }
            catch (ModelException e1) {
                Logger.logException(e1);
            }
            SimpleReference ref = new SimpleReference(sourcePosition, sourceEndPosition, methodName);
            IMethod[] methods = PHPCalleeProcessor.this.findMethods(methodName, argCount, sourcePosition);
            PHPCalleeProcessor.this.fSearchResults.put(ref, methods);
        }
    }
}

