/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeHelper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.eclipse.rdf4j.sail.shacl.results.ValidationResult;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;

public class ValidationReportNode
implements PlanNode {
    private final Function<ValidationTuple, ValidationResult> validationResultFunction;
    PlanNode parent;
    private boolean printed = false;
    private ValidationExecutionLogger validationExecutionLogger;

    public ValidationReportNode(PlanNode parent, Function<ValidationTuple, ValidationResult> validationResultFunction, ConnectionsGroup connectionsGroup) {
        this.parent = PlanNodeHelper.handleSorting(this, parent, connectionsGroup);
        this.validationResultFunction = validationResultFunction;
    }

    @Override
    public CloseableIteration<? extends ValidationTuple> iterator() {
        return new LoggingCloseableIteration(this, this.validationExecutionLogger){
            private CloseableIteration<? extends ValidationTuple> iterator;

            @Override
            protected void init() {
                this.iterator = ValidationReportNode.this.parent.iterator();
            }

            @Override
            public void localClose() {
                if (this.iterator != null) {
                    this.iterator.close();
                }
            }

            @Override
            public boolean localHasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public ValidationTuple loggingNext() {
                ValidationTuple next = (ValidationTuple)this.iterator.next();
                return next.addValidationResult(ValidationReportNode.this.validationResultFunction);
            }
        };
    }

    @Override
    public int depth() {
        return this.parent.depth() + 1;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId()).append(" [label=\"").append(StringEscapeUtils.escapeJava((String)this.toString())).append("\"];").append("\n");
        stringBuilder.append(this.parent.getId() + " -> " + this.getId()).append("\n");
        this.parent.getPlanAsGraphvizDot(stringBuilder);
    }

    @Override
    public String getId() {
        return "" + System.identityHashCode(this);
    }

    public String toString() {
        return "ValidationReportNode";
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
        this.parent.receiveLogger(validationExecutionLogger);
    }

    @Override
    public boolean producesSorted() {
        return this.parent.producesSorted();
    }

    @Override
    public boolean requiresSorted() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidationReportNode that = (ValidationReportNode)o;
        return this.validationResultFunction.equals(that.validationResultFunction) && this.parent.equals(that.parent);
    }

    public int hashCode() {
        return Objects.hash(this.validationResultFunction, this.parent);
    }
}

