/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.console.command;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.rdf4j.console.ConsoleIO;
import org.eclipse.rdf4j.console.ConsoleState;
import org.eclipse.rdf4j.console.command.ConsoleCommand;
import org.eclipse.rdf4j.console.command.Disconnect;
import org.eclipse.rdf4j.http.client.RDF4JProtocolSession;
import org.eclipse.rdf4j.http.client.SharedHttpClientSessionManager;
import org.eclipse.rdf4j.http.protocol.UnauthorizedException;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.manager.LocalRepositoryManager;
import org.eclipse.rdf4j.repository.manager.RemoteRepositoryManager;
import org.eclipse.rdf4j.repository.manager.RepositoryManager;

public class Connect
extends ConsoleCommand {
    private final Disconnect disconnect;

    @Override
    public String getName() {
        return "connect";
    }

    @Override
    public String getHelpShort() {
        return "Connects to a (local or remote) set of repositories";
    }

    @Override
    public String getHelpLong() {
        return "Usage:\nconnect default                         Opens the default repository set for this console\nconnect <dataDirectory>                 Opens the repository set in the specified data dir\nconnect <serverURL> [user [password]]   Connects to an RDF4J server with optional credentials\n";
    }

    public Connect(ConsoleIO consoleIO, ConsoleState state, Disconnect disconnect) {
        super(consoleIO, state);
        this.disconnect = disconnect;
    }

    @Override
    public void execute(String ... tokens) {
        if (tokens.length < 2) {
            this.writeln(this.getHelpLong());
            return;
        }
        String target = tokens[1];
        if ("default".equalsIgnoreCase(target)) {
            this.connectDefault();
        } else {
            try {
                new URL(target);
                String username = tokens.length > 2 ? tokens[2] : null;
                String password = tokens.length > 3 ? tokens[3] : null;
                this.connectRemote(target, username, password);
            }
            catch (MalformedURLException e) {
                this.connectLocal(target);
            }
        }
    }

    public boolean connectDefault() {
        return this.installNewManager(new LocalRepositoryManager(this.state.getDataDirectory()), "default data directory");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean connectRemote(String url, String user, String passwd) {
        String pass = passwd == null ? "" : passwd;
        boolean result = false;
        try {
            SharedHttpClientSessionManager client = new SharedHttpClientSessionManager();
            try (RDF4JProtocolSession httpClient = client.createRDF4JProtocolSession(url);){
                if (user != null) {
                    httpClient.setUsernameAndPassword(user, pass);
                }
                httpClient.getServerProtocol();
            }
            finally {
                client.shutDown();
            }
            RemoteRepositoryManager manager = new RemoteRepositoryManager(url);
            manager.setUsernameAndPassword(user, pass);
            result = this.installNewManager(manager, url);
        }
        catch (UnauthorizedException e) {
            if (user != null && !pass.isEmpty()) {
                this.writeError("Authentication for user '" + user + "' failed");
            } else {
                this.writeln("Authentication required");
                String username = this.consoleIO.readln("Username: ");
                String password = this.consoleIO.readPassword("Password: ");
                this.connectRemote(url, username, password);
            }
        }
        catch (IOException | RepositoryException e) {
            this.writeError("Failed to access the server", e);
        }
        return result;
    }

    public boolean connectLocal(String path) {
        File dir = new File(path);
        boolean result = false;
        if (dir.exists() && dir.isDirectory()) {
            result = this.installNewManager(new LocalRepositoryManager(dir), dir.toString());
        } else {
            this.writeError("Specified path is not an (existing) directory: " + path);
        }
        return result;
    }

    private boolean installNewManager(RepositoryManager newManager, String newManagerID) {
        boolean installed = false;
        String managerID = this.state.getManagerID();
        if (newManagerID.equals(managerID)) {
            this.writeln("Already connected to " + managerID);
            installed = true;
        } else {
            try {
                newManager.init();
                this.disconnect.execute(false);
                this.state.setManager(newManager);
                this.state.setManagerID(newManagerID);
                this.writeln("Connected to " + newManagerID);
                installed = true;
            }
            catch (RepositoryException e) {
                this.writeError("Failed to install new manager", e);
            }
        }
        return installed;
    }

    public boolean connectRemote(String url) {
        return this.connectRemote(url, null, null);
    }
}

