/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ctx.capability.ui.views;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.rcptt.core.model.IContext;
import org.eclipse.rcptt.core.model.IElementChangedListener;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7ElementDelta;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.IQ7Project;
import org.eclipse.rcptt.core.model.IQ7ProjectMetadata;
import org.eclipse.rcptt.core.model.ITestCase;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.model.Q7ElementChangedEvent;
import org.eclipse.rcptt.core.model.search.Q7SearchCore;
import org.eclipse.rcptt.core.scenario.GroupContext;
import org.eclipse.rcptt.ctx.capability.ui.views.CapabiltyContextTable;
import org.eclipse.rcptt.internal.core.model.Q7TestCase;

class WorkspaceChangeListener
implements IElementChangedListener {
    private final CapabiltyContextTable table;

    public WorkspaceChangeListener(CapabiltyContextTable table) {
        this.table = table;
    }

    public void elementChanged(Q7ElementChangedEvent event) {
        IQ7ElementDelta[] elementDeltas;
        IQ7ElementDelta delta = event.getDelta();
        IQ7NamedElement newContent = this.findRenamed(delta, this.table.getNamedElement());
        if (newContent != null) {
            this.table.setNamedElement(newContent);
        }
        IQ7ElementDelta[] iQ7ElementDeltaArray = elementDeltas = event.getDelta().getAffectedChildren();
        int n = elementDeltas.length;
        int n2 = 0;
        while (n2 < n) {
            IQ7ElementDelta iq7ElementDelta = iQ7ElementDeltaArray[n2];
            if (iq7ElementDelta.getElement() instanceof IQ7Project && (iq7ElementDelta.getFlags() & 0x80000) != 0) {
                this.refreshTable(null);
                return;
            }
            ++n2;
        }
        IQ7NamedElement[] elements = event.getDelta().getNamedElements();
        this.refreshTable(elements);
    }

    private void refreshTable(IQ7NamedElement[] elements) {
        if (this.table.getTableViewer() == null || this.table.getControl() == null || this.table.getControl().isDisposed()) {
            return;
        }
        boolean needRefresh = false;
        if (elements == null) {
            needRefresh = true;
        } else {
            IQ7NamedElement testCase = this.table.getNamedElement();
            String[] contexts = null;
            if (contexts == null && testCase instanceof ITestCase) {
                try {
                    contexts = ((ITestCase)testCase).getContexts();
                }
                catch (ModelException e) {
                    needRefresh = true;
                }
            }
            if (contexts == null && testCase instanceof IQ7ProjectMetadata) {
                try {
                    contexts = ((IQ7ProjectMetadata)testCase).getContexts();
                }
                catch (ModelException e) {
                    needRefresh = true;
                }
            }
            try {
                EList list;
                if (contexts == null && testCase instanceof IContext && testCase.getNamedElement() instanceof GroupContext && (list = ((GroupContext)this.table.getNamedElement().getNamedElement()).getContextReferences()) != null) {
                    contexts = (String[])list.toArray((Object[])new String[list.size()]);
                }
            }
            catch (Exception e) {
                needRefresh = true;
            }
            ArrayList<String> lc = new ArrayList<String>();
            if (contexts != null) {
                lc.addAll(Arrays.asList(contexts));
            }
            IQ7NamedElement[] iQ7NamedElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IQ7NamedElement element = iQ7NamedElementArray[n2];
                try {
                    String elementID = Q7SearchCore.findIDByDocument((IQ7Element)element);
                    if (elementID == null) {
                        elementID = element.getID();
                    }
                    if (needRefresh = lc.contains(elementID)) {
                        break;
                    }
                }
                catch (ModelException e) {
                    needRefresh = true;
                }
                ++n2;
            }
        }
        if (needRefresh) {
            this.table.refresh();
        }
    }

    private IQ7NamedElement findRenamed(IQ7ElementDelta delta, IQ7NamedElement element) {
        IQ7ElementDelta[] deltas;
        if (delta.getElement() instanceof ITestCase) {
            Q7TestCase test = (Q7TestCase)delta.getElement();
            if ((delta.getFlags() & 0x10) != 0 && delta.getMovedFromElement().getPath().equals((Object)element.getPath())) {
                return test;
            }
        }
        IQ7ElementDelta[] iQ7ElementDeltaArray = deltas = delta.getAffectedChildren();
        int n = deltas.length;
        int n2 = 0;
        while (n2 < n) {
            IQ7ElementDelta d = iQ7ElementDeltaArray[n2];
            IQ7NamedElement result = this.findRenamed(d, element);
            if (result != null) {
                return result;
            }
            ++n2;
        }
        return null;
    }
}

