/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.ecl.parser.ast;

import org.eclipse.rcptt.core.ecl.parser.ast.NodeVisitor;

public abstract class Node {
    public final int begin;
    public final int end;
    public final String text;

    public Node(String text, int begin, int end) {
        this.begin = begin;
        this.end = end;
        this.text = text;
    }

    public void accept(NodeVisitor visitor) {
        visitor.enter(this);
        visitor.exit(this);
    }

    public String getText(String text) {
        return text.substring(this.begin, this.end);
    }

    public boolean contains(int offset) {
        return this.begin <= offset && offset < this.end;
    }

    public boolean containsOrEnds(int offset) {
        return this.begin <= offset && offset <= this.end;
    }

    public int length() {
        return this.end - this.begin;
    }

    public String toString() {
        return String.format("Text: %s,  begin: %d, end: %d", this.text, this.begin, this.end);
    }
}

