/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.jetty.interaction;

import java.util.List;
import org.eclipse.passage.lic.internal.equinox.ServiceExtensions;
import org.eclipse.passage.lic.internal.jetty.JettyServer;
import org.eclipse.passage.lic.internal.jetty.interaction.JettyCommands;
import org.eclipse.passage.lic.internal.jetty.interaction.LicenseRequest;
import org.eclipse.passage.lic.internal.jetty.interaction.LicenseStatus;
import org.eclipse.passage.lic.internal.jetty.interaction.ServerHandles;
import org.osgi.framework.BundleContext;

final class Commands {
    private ServerHandles server;

    Commands() {
    }

    void register(BundleContext context, JettyServer jetty, String name) {
        this.registerSelfLicensingCommands(context);
        this.registerServerHandles(context, jetty, name);
        this.registerFromExtension(context);
    }

    ServerHandles server() {
        return this.server;
    }

    private void registerSelfLicensingCommands(BundleContext context) {
        new LicenseStatus().register(context);
        new LicenseRequest().register(context);
    }

    private void registerServerHandles(BundleContext context, JettyServer jetty, String name) {
        this.server = new ServerHandles(jetty, name);
        this.server.register(context);
    }

    private void registerFromExtension(BundleContext context) {
        this.commands().forEach(command -> command.register(context));
    }

    private List<JettyCommands> commands() {
        return new ServiceExtensions("org.eclipse.passage.lic.jetty", "commands", JettyCommands.class).get();
    }
}

