/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.equinox.access;

import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.passage.lic.api.LicensedProduct;
import org.eclipse.passage.lic.api.agreements.AgreementAcceptanceService;
import org.eclipse.passage.lic.api.agreements.AgreementToAccept;
import org.eclipse.passage.lic.equinox.SuppliedFrameworkAware;
import org.eclipse.passage.lic.equinox.access.BaseOption;
import org.eclipse.passage.lic.equinox.access.CoverageCheckOptionDecision;
import org.eclipse.passage.lic.equinox.access.Interaction;
import org.eclipse.passage.lic.equinox.access.Options;
import org.eclipse.passage.lic.internal.base.access.Libraries;
import org.eclipse.passage.lic.internal.equinox.access.AgreementAcceptanceDelegate;
import org.eclipse.passage.lic.internal.equinox.access.RegisteredLibraries;

final class OptionAccept
extends BaseOption<CoverageCheckOptionDecision> {
    private final Collection<AgreementToAccept> agreements;
    private final Options<AcceptanceDecision> options;
    private final Libraries libraries;

    public OptionAccept(Interaction.Smart interaction, Collection<AgreementToAccept> agreements, LicensedProduct product) {
        super('a', "Accept", "Read and accept license agreements", interaction);
        this.agreements = agreements;
        this.options = new Options(interaction, Arrays.asList(new OptionAccepted(interaction), new OptionDenied(interaction)));
        this.libraries = new Libraries((Supplier)new RegisteredLibraries(), () -> product);
    }

    @Override
    public CoverageCheckOptionDecision run() {
        this.interaction.head(String.format("accept license agreements: %d", this.agreements.size()), "Please read the agreement(s) carefully prior pressing 'I agree'");
        Optional<AgreementAcceptanceService> root = this.acceptanceService();
        if (!root.isPresent()) {
            this.reportInsufficientConfiguration();
            return CoverageCheckOptionDecision.quit;
        }
        AgreementAcceptanceDelegate acceptance = new AgreementAcceptanceDelegate(root.get(), this.libraries);
        this.agreements.forEach(agreement -> this.exposeForAccept((AgreementToAccept)agreement, acceptance));
        return CoverageCheckOptionDecision.reassess;
    }

    private void reportInsufficientConfiguration() {
        this.interaction.prompt("The product lacks configuration, thus license acceptance cannot be performed. \n Contact the vendor.");
    }

    private void exposeForAccept(AgreementToAccept agreement, AgreementAcceptanceDelegate service) {
        try {
            if (this.exposedAndAccepted(agreement)) {
                service.accept(agreement);
            }
        }
        catch (Exception e) {
            this.interaction.swear(e);
        }
    }

    private boolean exposedAndAccepted(AgreementToAccept agreement) {
        this.interaction.prompt(String.format("  ---\n%s\n   ---", agreement.acceptance().name()));
        this.interaction.prompt(new String(agreement.acceptance().content()));
        return AcceptanceDecision.accepted.equals((Object)this.options.promptAndPick().run());
    }

    private Optional<AgreementAcceptanceService> acceptanceService() {
        return new SuppliedFrameworkAware().withFramework(framework -> framework.accessCycleConfiguration().acceptance());
    }

    private static enum AcceptanceDecision {
        accepted,
        denied;

    }

    private static final class OptionAccepted
    extends BaseOption<AcceptanceDecision> {
        OptionAccepted(Interaction.Smart interaction) {
            super('a', "Accept", "I have read the text of the agreement carefully and ACCEPT all its terms", interaction);
        }

        @Override
        public AcceptanceDecision run() {
            this.interaction.prompt("--> Agreement has just been ACCEPTED");
            return AcceptanceDecision.accepted;
        }
    }

    private static final class OptionDenied
    extends BaseOption<AcceptanceDecision> {
        OptionDenied(Interaction.Smart interaction) {
            super('n', "Do not accept", "I DO NOT ACCEPT the agreement", interaction);
        }

        @Override
        public AcceptanceDecision run() {
            this.interaction.prompt("--> Agreementhas just been DENIED");
            return AcceptanceDecision.denied;
        }
    }
}

