/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.equinox.access;

import java.util.Optional;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.passage.lic.api.LicensedProduct;
import org.eclipse.passage.lic.api.ServiceInvocationResult;
import org.eclipse.passage.lic.api.access.GrantLockAttempt;
import org.eclipse.passage.lic.base.diagnostic.DiagnosticExplained;
import org.eclipse.passage.lic.equinox.EquinoxPassage;
import org.eclipse.passage.lic.equinox.access.ConsoleInteraction;
import org.eclipse.passage.lic.equinox.access.Interaction;
import org.eclipse.passage.lic.equinox.access.LicenseCoverageCheck;

public final class LicenseProtection {
    private final Logger log = LogManager.getLogger(this.getClass());
    private Optional<GrantLockAttempt> lock = Optional.empty();
    private final Supplier<Interaction> interaction;

    public LicenseProtection() {
        this(ConsoleInteraction::new);
    }

    public LicenseProtection(Supplier<Interaction> interaction) {
        this.interaction = interaction;
    }

    public boolean check() {
        if (this.licenseCoverageIsNotSufficient()) {
            return false;
        }
        return this.locAcquired();
    }

    public void release() {
        this.lock.ifPresent(acq -> {
            ServiceInvocationResult<Boolean> serviceInvocationResult = new EquinoxPassage().releaseLicense((GrantLockAttempt)acq);
        });
    }

    private boolean locAcquired() {
        Optional<GrantLockAttempt> attempt = this.acquireLicense();
        if (!attempt.isPresent()) {
            return false;
        }
        if (!attempt.get().successful()) {
            return false;
        }
        this.lock = attempt;
        return true;
    }

    private boolean licenseCoverageIsNotSufficient() {
        return !LicenseCoverageCheck.Result.proceed.equals((Object)new LicenseCoverageCheck(this.interaction.get()).run());
    }

    private Optional<GrantLockAttempt> acquireLicense() {
        return this.product().flatMap(this::acquireLicense);
    }

    private Optional<LicensedProduct> product() {
        ServiceInvocationResult<LicensedProduct> product = new EquinoxPassage().product();
        if (!product.data().isPresent()) {
            this.log.error(String.format("Failed to read product credentials:%s", new DiagnosticExplained(product.diagnostic()).get()));
        }
        return product.data();
    }

    private Optional<GrantLockAttempt> acquireLicense(LicensedProduct product) {
        ServiceInvocationResult<GrantLockAttempt> response = new EquinoxPassage().acquireLicense(product.identifier());
        if (!this.successful(response)) {
            this.log.error(String.format("Failed to acquire license \nfor product %s:\n%s\n", product, new DiagnosticExplained(response.diagnostic()).get()));
            return Optional.empty();
        }
        return Optional.of((GrantLockAttempt)response.data().get());
    }

    private boolean successful(ServiceInvocationResult<GrantLockAttempt> response) {
        return response.data().map(GrantLockAttempt::successful).orElse(Boolean.FALSE);
    }
}

