/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.equinox.requirements;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.passage.lic.api.ServiceInvocationResult;
import org.eclipse.passage.lic.api.diagnostic.Trouble;
import org.eclipse.passage.lic.api.diagnostic.TroubleCode;
import org.eclipse.passage.lic.api.registry.StringServiceId;
import org.eclipse.passage.lic.api.requirements.Requirement;
import org.eclipse.passage.lic.api.requirements.ResolvedRequirements;
import org.eclipse.passage.lic.base.BaseServiceInvocationResult;
import org.eclipse.passage.lic.base.diagnostic.code.ServiceCannotOperate;
import org.eclipse.passage.lic.equinox.requirements.RequirementFromComponent;
import org.eclipse.passage.lic.internal.equinox.i18n.EquinoxMessages;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.service.component.runtime.dto.ComponentDescriptionDTO;

public final class ComponentRequirements
implements ResolvedRequirements {
    private final Optional<BundleContext> context = Optional.of(FrameworkUtil.getBundle(this.getClass()).getBundleContext());
    private final Optional<ServiceComponentRuntime> runtime = this.retrieveRuntime();

    private Optional<ServiceComponentRuntime> retrieveRuntime() {
        BundleContext bundle = this.context.get();
        return Optional.ofNullable(bundle.getServiceReference(ServiceComponentRuntime.class)).map(ref -> (ServiceComponentRuntime)bundle.getService(ref));
    }

    public StringServiceId id() {
        return new StringServiceId("OSGi component");
    }

    public ServiceInvocationResult<Collection<Requirement>> all() {
        if (!this.runtime.isPresent()) {
            return this.noWay(ServiceComponentRuntime.class.getSimpleName());
        }
        if (!this.context.isPresent()) {
            return this.noWay(BundleContext.class.getSimpleName());
        }
        return new BaseServiceInvocationResult(this.resolve());
    }

    private ServiceInvocationResult<Collection<Requirement>> noWay(String resource) {
        return new BaseServiceInvocationResult(new Trouble((TroubleCode)new ServiceCannotOperate(), String.format(EquinoxMessages.ComponentRequirements_requirement_for_resource, resource)));
    }

    private Collection<Requirement> resolve() {
        return this.runtime.get().getComponentDescriptionDTOs(this.context.get().getBundles()).stream().map(component -> new RequirementFromComponent((ComponentDescriptionDTO)component, this.context.get())).map(RequirementFromComponent::get).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }
}

