/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.workbench.dialogs;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.passage.loc.internal.workbench.i18n.WorkbenchMessages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FileContentDialog
extends Dialog {
    private final String filePath;
    private Text editor;

    public FileContentDialog(Shell parentShell, String path) {
        super(parentShell);
        this.filePath = path;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(WorkbenchMessages.FileContentDialog_shell_text);
    }

    protected Control createDialogArea(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        Composite base = new Composite(parent, 2048);
        base.setLayout((Layout)new GridLayout(1, false));
        base.setLayoutData((Object)new GridData(4, 4, true, true));
        this.editor = new Text(base, 2);
        this.editor.setLayoutData((Object)new GridData(4, 4, true, true));
        this.scheduleReader();
        return parent;
    }

    private void scheduleReader() {
        Path path = Paths.get(this.filePath, new String[0]);
        try {
            byte[] readAllBytes = Files.readAllBytes(path);
            this.editor.setText(new String(readAllBytes, Charset.defaultCharset()));
        }
        catch (IOException e) {
            StringBuilder sb = new StringBuilder();
            sb.append(WorkbenchMessages.FileContentDialog_e_unable_read).append('\n');
            sb.append(e.getMessage());
            this.editor.setText(sb.toString());
        }
    }

    protected boolean isResizable() {
        return true;
    }
}

