/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.jface.dialogs.licensing;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import org.eclipse.passage.lic.api.ServiceInvocationResult;
import org.eclipse.passage.lic.api.conditions.ConditionPack;
import org.eclipse.passage.lic.base.BaseServiceInvocationResult;
import org.eclipse.passage.lic.base.SumOfCollections;
import org.eclipse.passage.lic.equinox.LicenseReadingServiceRequest;
import org.eclipse.passage.lic.internal.base.access.Libraries;
import org.eclipse.passage.lic.internal.base.conditions.LicenseConditions;

final class AllConditionsFromLicenses
implements Supplier<ServiceInvocationResult<Collection<ConditionPack>>> {
    private final List<Path> licenses;
    private final Optional<Libraries> libraries;
    private final LicenseReadingServiceRequest product;

    AllConditionsFromLicenses(List<Path> licenses, Optional<Libraries> libraries) {
        this.licenses = licenses;
        this.libraries = libraries;
        this.product = new LicenseReadingServiceRequest();
    }

    @Override
    public ServiceInvocationResult<Collection<ConditionPack>> get() {
        return this.licenses.stream().map(this::fromLicense).reduce((BinaryOperator<ServiceInvocationResult>)new BaseServiceInvocationResult.Sum((BinaryOperator)new SumOfCollections())).orElse((ServiceInvocationResult)new BaseServiceInvocationResult(Collections.emptyList()));
    }

    private ServiceInvocationResult<Collection<ConditionPack>> fromLicense(Path file) {
        return new LicenseConditions(file, (Supplier)this.product, this.libraries).get();
    }
}

