/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.emf.migration;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.passage.lic.emf.migration.EAttributeRoute;
import org.eclipse.passage.lic.emf.migration.EReferenceRoute;
import org.eclipse.passage.lic.emf.migration.MigrationRoutes;
import org.eclipse.passage.lic.emf.migration.SimpleAttributeRoute;
import org.eclipse.passage.lic.emf.migration.SimpleReferenceRoute;

public final class SimpleMigrationRoutes
implements MigrationRoutes {
    private final Map<String, EAttributeRoute> attributes = new HashMap<String, EAttributeRoute>();
    private final Map<String, EReferenceRoute> references = new HashMap<String, EReferenceRoute>();
    private final Set<String> ignored = new HashSet<String>();

    @Override
    public void define(String found, EAttributeRoute route) {
        this.attributes.put(this.key(route.destination().getEContainingClass(), found), route);
        List<EReference> list = route.path();
        while (!list.isEmpty()) {
            EStructuralFeature last = (EStructuralFeature)list.remove(list.size() - 1);
            this.attributes.put(this.key(last.getEContainingClass(), found), new SimpleAttributeRoute(route.destination(), route.path()));
        }
    }

    @Override
    public void define(String found, EReferenceRoute route) {
        this.references.put(this.key(route.destination().getEContainingClass(), found), route);
        List<EReference> list = route.path();
        while (!list.isEmpty()) {
            EStructuralFeature last = (EStructuralFeature)list.remove(list.size() - 1);
            this.references.put(this.key(last.getEContainingClass(), found), new SimpleReferenceRoute(route.destination(), route.path()));
        }
    }

    @Override
    public void ignore(String found, EClass location) {
        this.ignored.add(this.key(location, found));
    }

    private String key(EClass scope, String found) {
        return scope.getName() + "." + found;
    }

    @Override
    public Optional<EAttributeRoute> attribute(String found, EClass context) {
        Optional<EAttributeRoute> direct = Optional.ofNullable(this.attributes.get(this.key(context, found)));
        if (direct.isPresent()) {
            return direct;
        }
        return this.superAttributes(found, context);
    }

    private Optional<EAttributeRoute> superAttributes(String found, EClass context) {
        return context.getEAllSuperTypes().stream().map(t -> this.attribute(found, (EClass)t)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    @Override
    public Optional<EReferenceRoute> reference(String found, EClass context) {
        Optional<EReferenceRoute> direct = Optional.ofNullable(this.references.get(this.key(context, found)));
        if (direct.isPresent()) {
            return direct;
        }
        return this.superReferences(found, context);
    }

    private Optional<EReferenceRoute> superReferences(String found, EClass context) {
        return context.getEAllSuperTypes().stream().map(t -> this.reference(found, (EClass)t)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    @Override
    public boolean ignored(String found, EClass location) {
        return this.ignored.contains(this.key(location, found));
    }
}

