/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base.access;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.passage.lic.api.ServiceInvocationResult;
import org.eclipse.passage.lic.api.diagnostic.Diagnostic;
import org.eclipse.passage.lic.api.diagnostic.Trouble;
import org.eclipse.passage.lic.api.diagnostic.TroubleCode;
import org.eclipse.passage.lic.api.registry.Registry;
import org.eclipse.passage.lic.api.registry.StringServiceId;
import org.eclipse.passage.lic.api.requirements.Requirement;
import org.eclipse.passage.lic.api.requirements.ResolvedRequirements;
import org.eclipse.passage.lic.base.BaseServiceInvocationResult;
import org.eclipse.passage.lic.base.SumOfCollections;
import org.eclipse.passage.lic.base.diagnostic.BaseDiagnostic;
import org.eclipse.passage.lic.base.diagnostic.code.NoRequirements;
import org.eclipse.passage.lic.base.diagnostic.code.NoServicesOfType;
import org.eclipse.passage.lic.base.requirements.RequirementsFeatureFilter;
import org.eclipse.passage.lic.internal.base.i18n.BaseMessages;

public final class Requirements
implements Supplier<ServiceInvocationResult<Collection<Requirement>>> {
    private final Registry<StringServiceId, ResolvedRequirements> registry;
    private final Function<ServiceInvocationResult<Collection<Requirement>>, ServiceInvocationResult<Collection<Requirement>>> filter;
    private final Optional<String> feature;

    public Requirements(Registry<StringServiceId, ResolvedRequirements> registry, String feature) {
        this(registry, (Function<ServiceInvocationResult<Collection<Requirement>>, ServiceInvocationResult<Collection<Requirement>>>)new RequirementsFeatureFilter(feature).get(), Optional.of(feature));
    }

    public Requirements(Registry<StringServiceId, ResolvedRequirements> registry) {
        this(registry, Function.identity(), Optional.empty());
    }

    public Requirements(Registry<StringServiceId, ResolvedRequirements> registry, Function<ServiceInvocationResult<Collection<Requirement>>, ServiceInvocationResult<Collection<Requirement>>> filter, Optional<String> feature) {
        Objects.requireNonNull(registry, "Requirements::registry");
        Objects.requireNonNull(filter, "Requirements::filter");
        this.registry = registry;
        this.filter = filter;
        this.feature = feature;
    }

    @Override
    public ServiceInvocationResult<Collection<Requirement>> get() {
        if (this.registry.services().isEmpty()) {
            return this.noServices();
        }
        ServiceInvocationResult<Collection<Requirement>> result = this.filtered();
        if (this.empty(result)) {
            return this.withNoRequirementsWarning(result);
        }
        return result;
    }

    private ServiceInvocationResult<Collection<Requirement>> filtered() {
        return this.registry.services().stream().map(ResolvedRequirements::all).reduce(new BaseServiceInvocationResult.Sum(new SumOfCollections())).map(this.filter).get();
    }

    private BaseServiceInvocationResult<Collection<Requirement>> noServices() {
        return new BaseServiceInvocationResult<Trouble>(new Trouble((TroubleCode)new NoServicesOfType("requirement resolution"), BaseMessages.getString("Requirements.failed")));
    }

    private boolean empty(ServiceInvocationResult<Collection<Requirement>> result) {
        return result.data().map(Collection::isEmpty).orElse(false);
    }

    private ServiceInvocationResult<Collection<Requirement>> withNoRequirementsWarning(ServiceInvocationResult<Collection<Requirement>> original) {
        return new BaseServiceInvocationResult<Collection<Requirement>>((Diagnostic)new BaseDiagnostic(original.diagnostic().severe(), this.withNoRequirementsWarning(original.diagnostic().bearable())), original.data());
    }

    private List<Trouble> withNoRequirementsWarning(List<Trouble> original) {
        ArrayList<Trouble> more = new ArrayList<Trouble>(original);
        more.add(new Trouble((TroubleCode)new NoRequirements(), this.feature.map(fe -> String.format(BaseMessages.getString("Requirements.no_requirements_for_feature"), fe)).orElse(BaseMessages.getString("Requirements.no_requirements_for_product"))));
        return more;
    }
}

