/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base.io;

import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Objects;
import java.util.function.Supplier;
import org.eclipse.passage.lic.api.LicensedProduct;
import org.eclipse.passage.lic.api.LicensingException;
import org.eclipse.passage.lic.api.io.KeyKeeper;
import org.eclipse.passage.lic.base.io.FileNameFromLicensedProduct;
import org.eclipse.passage.lic.base.io.PassageFileExtension;
import org.eclipse.passage.lic.base.io.PathFromLicensedProduct;
import org.eclipse.passage.lic.internal.base.i18n.AccessCycleMessages;

public final class PathKeyKeeper
implements KeyKeeper {
    private final LicensedProduct product;
    private final Supplier<Path> base;

    public PathKeyKeeper(LicensedProduct product, Supplier<Path> base) {
        Objects.requireNonNull(product, "PathKeyKeeper::product");
        Objects.requireNonNull(base, "PathKeyKeeper::base");
        this.product = product;
        this.base = new PathFromLicensedProduct(base, product);
    }

    public LicensedProduct id() {
        return this.product;
    }

    public InputStream productPublicKey() throws LicensingException {
        Path path = this.base.get().resolve(this.keyFile());
        try {
            return new FileInputStream(path.toFile());
        }
        catch (Exception e) {
            throw new LicensingException(String.format(AccessCycleMessages.getString("PathKeyKeeper_input_stream_error"), this.base.get().toAbsolutePath()), (Throwable)e);
        }
    }

    private String keyFile() {
        return new FileNameFromLicensedProduct(this.product, new PassageFileExtension.PublicKey()).get();
    }
}

