/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base.diagnostic;

import org.eclipse.passage.lic.api.diagnostic.TroubleCode;
import org.eclipse.passage.lic.api.requirements.Feature;
import org.eclipse.passage.lic.api.requirements.Requirement;
import org.eclipse.passage.lic.api.restrictions.Restriction;
import org.eclipse.passage.lic.api.restrictions.RestrictionLevel;
import org.eclipse.passage.lic.internal.base.i18n.ExaminationExplanedMessages;

public final class RequirementStatus {
    private final String feature;
    private final String status;
    private final RestrictionLevel level;

    public RequirementStatus(Restriction restriction) {
        this.feature = this.explain(restriction.unsatisfiedRequirement().feature());
        this.status = this.explain(restriction.reason());
        this.level = restriction.unsatisfiedRequirement().restrictionLevel();
    }

    public RequirementStatus(Requirement requirement) {
        this.feature = this.explain(requirement.feature());
        this.status = ExaminationExplanedMessages.getString("RequirementStatus.covered");
        this.level = requirement.restrictionLevel();
    }

    private String explain(Feature functionality) {
        return String.format("%s v.%s", functionality.name(), functionality.version());
    }

    private String explain(TroubleCode trouble) {
        return String.format("%s (%d)", trouble.explanation(), trouble.code());
    }

    public String feature() {
        return this.feature;
    }

    public String status() {
        return this.status;
    }

    public RestrictionLevel level() {
        return this.level;
    }
}

