/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.hc.remote.impl;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.eclipse.passage.lic.floating.model.api.FloatingLicenseAccess;
import org.eclipse.passage.lic.internal.api.ServiceInvocationResult;
import org.eclipse.passage.lic.internal.api.diagnostic.Diagnostic;
import org.eclipse.passage.lic.internal.api.io.KeyKeeperRegistry;
import org.eclipse.passage.lic.internal.api.io.StreamCodecRegistry;
import org.eclipse.passage.lic.internal.base.BaseServiceInvocationResult;
import org.eclipse.passage.lic.internal.base.diagnostic.BaseDiagnostic;
import org.eclipse.passage.lic.internal.base.diagnostic.NoSevereErrors;
import org.eclipse.passage.lic.internal.base.diagnostic.SumOfDiagnostics;
import org.eclipse.passage.lic.internal.hc.remote.Client;
import org.eclipse.passage.lic.internal.hc.remote.Connection;
import org.eclipse.passage.lic.internal.hc.remote.impl.RemoteServiceData;
import org.eclipse.passage.lic.internal.hc.remote.impl.ServiceRemote;

public abstract class ServiceAny<C extends Connection, T, D extends RemoteServiceData>
extends ServiceRemote<C, T, D> {
    protected ServiceAny(KeyKeeperRegistry keys, StreamCodecRegistry codecs, Supplier<Client<C, T>> client, Supplier<Path> source) {
        super(keys, codecs, client, source);
    }

    @Override
    protected final ServiceInvocationResult<T> withServers(D parameters, Collection<FloatingLicenseAccess> servers) {
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        return servers.stream().map(server -> this.withServer(parameters, (FloatingLicenseAccess)server)).peek(result -> {
            boolean bl = diagnostics.add(result.diagnostic());
        }).filter(result -> new NoSevereErrors().test(result.diagnostic())).filter(result -> result.data().isPresent()).findAny().orElse((ServiceInvocationResult)new BaseServiceInvocationResult(this.sum(diagnostics)));
    }

    private Diagnostic sum(List<Diagnostic> particles) {
        return particles.stream().reduce(new SumOfDiagnostics()).orElseGet(BaseDiagnostic::new);
    }
}

