/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.equinox.requirements;

import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.osgi.util.NLS;
import org.eclipse.passage.lic.base.LicensingVersions;
import org.eclipse.passage.lic.internal.api.requirements.Feature;
import org.eclipse.passage.lic.internal.api.requirements.Requirement;
import org.eclipse.passage.lic.internal.api.restrictions.RestrictionLevel;
import org.eclipse.passage.lic.internal.base.requirements.BaseFeature;
import org.eclipse.passage.lic.internal.base.requirements.BaseRequirement;
import org.eclipse.passage.lic.internal.base.requirements.UnsatisfiableRequirement;
import org.eclipse.passage.lic.internal.base.restrictions.DefaultRestrictionLevel;
import org.eclipse.passage.lic.internal.equinox.i18n.EquinoxMessages;
import org.eclipse.passage.lic.internal.equinox.requirements.BundleName;
import org.eclipse.passage.lic.internal.equinox.requirements.BundleVendor;
import org.eclipse.passage.lic.internal.equinox.requirements.CapabilityLicFeatureId;
import org.eclipse.passage.lic.internal.equinox.requirements.CapabilityLicFeatureLevel;
import org.eclipse.passage.lic.internal.equinox.requirements.CapabilityLicFeatureName;
import org.eclipse.passage.lic.internal.equinox.requirements.CapabilityLicFeatureProvider;
import org.eclipse.passage.lic.internal.equinox.requirements.CapabilityLicFeatureVersion;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleCapability;

final class RequirementFromCapability
implements Supplier<Requirement> {
    private final Bundle bundle;
    private final BundleCapability capability;

    public RequirementFromCapability(Bundle bundle, BundleCapability capability) {
        this.bundle = bundle;
        this.capability = capability;
    }

    @Override
    public Requirement get() {
        Optional<Map> attributes = Optional.ofNullable(this.capability.getAttributes());
        if (!attributes.isPresent()) {
            return this.requirementForAttributes();
        }
        Optional feature = new CapabilityLicFeatureId(attributes.get()).get();
        if (!feature.isPresent()) {
            return this.requirementForFeatureIdentifier();
        }
        return this.requirementFromAttributes((String)feature.get(), attributes.get());
    }

    private Requirement requirementFromAttributes(String feature, Map<String, Object> attributes) {
        String version = new CapabilityLicFeatureVersion(attributes).get().map(LicensingVersions::toVersionValue).orElse("0.0.0");
        String name = new CapabilityLicFeatureName(attributes).get().orElse(feature);
        String provider = new CapabilityLicFeatureProvider(attributes).get().orElseGet(new BundleVendor(this.bundle));
        RestrictionLevel level = new CapabilityLicFeatureLevel(attributes).get().map(RestrictionLevel.Of::new).orElseGet((Supplier<RestrictionLevel>)new DefaultRestrictionLevel());
        BaseRequirement requirement = new BaseRequirement((Feature)new BaseFeature(feature, version, name, provider), level, (Object)this.capability.getResource().getBundle().getSymbolicName());
        return requirement;
    }

    private Requirement requirementForAttributes() {
        return new UnsatisfiableRequirement(NLS.bind((String)EquinoxMessages.RequirementsFromCapability_no_attributes, (Object)this.capability.getNamespace(), (Object)new BundleName(this.bundle).get()), (Object)this.bundle).get();
    }

    private Requirement requirementForFeatureIdentifier() {
        return new UnsatisfiableRequirement(NLS.bind((String)EquinoxMessages.RequirementsFromCapability_no_feature_id, (Object)this.capability.getNamespace(), (Object)new BundleName(this.bundle).get()), (Object)this.bundle).get();
    }
}

