/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.jface.dialogs;

import java.util.Objects;
import java.util.function.Supplier;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.passage.lic.jface.resource.LicensingImages;
import org.eclipse.passage.loc.internal.workbench.i18n.WorkbenchMessages;
import org.eclipse.swt.graphics.Image;

public final class Appearance {
    private final String title;
    private final Supplier<Image> image;
    private final LabelProvider labelProvider;

    public Appearance(String title) {
        this(title, () -> LicensingImages.getImageRegistry().get("IMG_DEFAULT"));
    }

    public Appearance(String title, Supplier<Image> image) {
        this(title, image, new LabelProvider());
    }

    public Appearance(String title, Supplier<Image> image, LabelProvider labels) {
        Objects.requireNonNull(title, WorkbenchMessages.Appearance_e_null_title);
        Objects.requireNonNull(image, WorkbenchMessages.Appearance_e_null_image);
        Objects.requireNonNull(labels, WorkbenchMessages.Appearance_e_null_labels);
        this.title = title;
        this.image = image;
        this.labelProvider = labels;
    }

    public String title() {
        return this.title;
    }

    public Supplier<Image> image() {
        return this.image;
    }

    public LabelProvider labelProvider() {
        return this.labelProvider;
    }
}

