/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.equinox.access;

import java.util.Map;
import org.eclipse.passage.lic.api.LicensingReporter;
import org.eclipse.passage.lic.api.access.AccessManager;
import org.eclipse.passage.lic.api.access.PermissionEmitter;
import org.eclipse.passage.lic.api.access.PermissionExaminer;
import org.eclipse.passage.lic.api.conditions.ConditionMinerRegistry;
import org.eclipse.passage.lic.api.requirements.RequirementResolver;
import org.eclipse.passage.lic.api.restrictions.RestrictionExecutor;
import org.eclipse.passage.lic.base.access.BaseAccessManager;
import org.eclipse.passage.lic.equinox.requirements.EquinoxRequirements;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@Component
public class EquinoxAccessManager
extends BaseAccessManager
implements AccessManager,
BundleListener {
    @Activate
    public void activate(BundleContext bundleContext) {
        Bundle[] bundles;
        bundleContext.addBundleListener((BundleListener)this);
        Bundle[] bundleArray = bundles = bundleContext.getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            EquinoxRequirements.extractLicensingManagementRequirements(bundle);
            ++n2;
        }
    }

    @Deactivate
    public void deactivate(BundleContext bundleContext) {
        bundleContext.removeBundleListener((BundleListener)this);
    }

    public void bundleChanged(BundleEvent event) {
        Bundle bundle = event.getBundle();
        EquinoxRequirements.extractLicensingManagementRequirements(bundle);
    }

    @Reference
    public void bindLicensingReporter(LicensingReporter reporter) {
        super.bindLicensingReporter(reporter);
    }

    public void unbindLicensingReporter(LicensingReporter reporter) {
        super.unbindLicensingReporter(reporter);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE)
    public void bindRequirementResolver(RequirementResolver configurationResolver) {
        super.bindRequirementResolver(configurationResolver);
    }

    public void unbindRequirementResolver(RequirementResolver configurationResolver) {
        super.unbindRequirementResolver(configurationResolver);
    }

    @Reference
    public void bindConditionMinerRegistry(ConditionMinerRegistry registry) {
        super.bindConditionMinerRegistry(registry);
    }

    public void unbindConditionMinerRegistry(ConditionMinerRegistry registry) {
        super.unbindConditionMinerRegistry(registry);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE)
    public void bindPermissionEmitter(PermissionEmitter emitter, Map<String, Object> properties) {
        super.bindPermissionEmitter(emitter, properties);
    }

    public void unbindPermissionEmitter(PermissionEmitter emitter, Map<String, Object> properties) {
        super.unbindPermissionEmitter(emitter, properties);
    }

    @Reference
    public void bindPermissionExaminer(PermissionExaminer permissionExaminer) {
        super.bindPermissionExaminer(permissionExaminer);
    }

    public void unbindPermissionExaminer(PermissionExaminer permissionExaminer) {
        super.unbindPermissionExaminer(permissionExaminer);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE)
    public void bindRestrictionExecutor(RestrictionExecutor restrictionExecutor) {
        super.bindRestrictionExecutor(restrictionExecutor);
    }

    public void unbindRestrictionExecutor(RestrictionExecutor restrictionExecutor) {
        super.unbindRestrictionExecutor(restrictionExecutor);
    }
}

