/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base;

import java.util.Objects;

public class LicensingVersions {
    public static final String VERSION_DEFAULT = "0.0.0";
    public static final String RULE_PERFECT = "perfect";
    public static final String RULE_EQUIVALENT = "equivalent";
    public static final String RULE_COMPATIBLE = "compatible";
    public static final String RULE_GREATER_OR_EQUAL = "greaterOrEqual";
    public static final String RULE_DEFAULT = "compatible";
    private static final String SEPARATOR_REGEX = "\\.";

    private LicensingVersions() {
    }

    public static String toVersionValue(Object object) {
        if (object instanceof String) {
            String version = (String)object;
            if ((version = version.trim()).length() == 0) {
                return VERSION_DEFAULT;
            }
            String[] split = version.split(SEPARATOR_REGEX);
            int major = LicensingVersions.extractSegment(split, 0);
            int minor = LicensingVersions.extractSegment(split, 1);
            int service = LicensingVersions.extractSegment(split, 2);
            String qualifier = "";
            if (split.length > 3 && major + minor + service > 0) {
                qualifier = split[3];
            }
            StringBuilder sb = new StringBuilder();
            sb.append(major).append('.');
            sb.append(minor).append('.');
            sb.append(service);
            if (!qualifier.isEmpty()) {
                sb.append('.');
                sb.append(qualifier);
            }
            return sb.toString();
        }
        return VERSION_DEFAULT;
    }

    private static int extractSegment(String[] split, int index) {
        if (split.length > index) {
            try {
                return Integer.parseInt(split[index]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    public static String toRuleValue(Object object) {
        if (object instanceof String) {
            String rule = (String)object;
            if (RULE_GREATER_OR_EQUAL.equalsIgnoreCase(rule)) {
                return RULE_GREATER_OR_EQUAL;
            }
            if ("compatible".equalsIgnoreCase(rule)) {
                return "compatible";
            }
            if (RULE_EQUIVALENT.equalsIgnoreCase(rule)) {
                return RULE_EQUIVALENT;
            }
            if (RULE_PERFECT.equalsIgnoreCase(rule)) {
                return RULE_PERFECT;
            }
        }
        return "compatible";
    }

    public static boolean isMatch(String required, String allowed, String match) {
        String rule = LicensingVersions.toRuleValue(match);
        if (RULE_GREATER_OR_EQUAL.equals(rule)) {
            return LicensingVersions.isGreaterOrEqual(required, allowed);
        }
        if ("compatible".equals(rule)) {
            return LicensingVersions.isCompatible(required, allowed);
        }
        if (RULE_EQUIVALENT.equals(rule)) {
            return LicensingVersions.isEquivalent(required, allowed);
        }
        if (RULE_PERFECT.equals(rule)) {
            return LicensingVersions.isPerfect(required, allowed);
        }
        if (required == null || allowed == null) {
            return false;
        }
        return Objects.equals(required, allowed);
    }

    public static boolean isGreaterOrEqual(String required, String allowed) {
        if (VERSION_DEFAULT.equals(allowed)) {
            return true;
        }
        return LicensingVersions.compare(required, allowed, 0);
    }

    public static boolean isCompatible(String required, String allowed) {
        return LicensingVersions.compare(required, allowed, 1);
    }

    public static boolean isEquivalent(String required, String allowed) {
        return LicensingVersions.compare(required, allowed, 2);
    }

    public static boolean isPerfect(String required, String allowed) {
        if (required == null || allowed == null) {
            return false;
        }
        return Objects.equals(required, allowed);
    }

    public static boolean compare(String required, String allowed, int match) {
        int as;
        if (required == null || allowed == null) {
            return false;
        }
        if (Objects.equals(required, allowed)) {
            return true;
        }
        if (VERSION_DEFAULT.equals(required)) {
            return true;
        }
        String expected = LicensingVersions.toVersionValue(allowed);
        String actual = LicensingVersions.toVersionValue(required);
        String[] esplit = expected.split(SEPARATOR_REGEX);
        String[] asplit = actual.split(SEPARATOR_REGEX);
        int i = 0;
        while (i < match) {
            int as2;
            int es = LicensingVersions.extractSegment(esplit, i);
            if (es != (as2 = LicensingVersions.extractSegment(asplit, i))) {
                return false;
            }
            ++i;
        }
        int es = LicensingVersions.extractSegment(esplit, match);
        return es <= (as = LicensingVersions.extractSegment(asplit, match));
    }
}

