/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.dashboard.ui;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.passage.lic.emf.edit.EditingDomainRegistryAccess;
import org.eclipse.passage.lic.emf.edit.SelectionCommandAdvisor;
import org.eclipse.passage.loc.workbench.LocWokbench;

public class DashboardUi {
    public static final String COMMAND_CREATE = "org.eclipse.passage.loc.dashboard.ui.command.create";
    public static final String COMMANDPARAMETER_CREATE_DOMAIN = "org.eclipse.passage.loc.dashboard.ui.commandparameter.create.domain";
    public static final String COMMANDPARAMETER_CREATE_PERSPECTIVE = "org.eclipse.passage.loc.dashboard.ui.commandparameter.create.perspective";
    public static final String COMMAND_LOAD = "org.eclipse.passage.loc.dashboard.ui.command.load";
    public static final String COMMANDPARAMETER_LOAD_DOMAIN = "org.eclipse.passage.loc.dashboard.ui.commandparameter.load.domain";
    public static final String COMMANDPARAMETER_LOAD_PERSPECTIVE = "org.eclipse.passage.loc.dashboard.ui.commandparameter.load.perspective";
    public static final String COMMAND_EDIT = "org.eclipse.passage.loc.dashboard.ui.command.edit";
    public static final String COMMANDPARAMETER_EDIT_DOMAIN = "org.eclipse.passage.loc.dashboard.ui.commandparameter.edit.domain";
    public static final String COMMANDPARAMETER_EDIT_CLASSIFIER = "org.eclipse.passage.loc.dashboard.ui.commandparameter.edit.classifier";
    public static final String COMMANDPARAMETER_EDIT_PERSPECTIVE = "org.eclipse.passage.loc.dashboard.ui.commandparameter.edit.perspective";

    public static Object executeCommand(IEclipseContext context, String commandId, String parameterId, String parameterValue) {
        HashMap<Object, Object> parameters = new HashMap<Object, Object>();
        parameters.put(parameterId, parameterValue);
        return DashboardUi.executeCommand(context, commandId, parameters);
    }

    public static Object executeCommand(IEclipseContext context, String commandId, Map<Object, Object> parameters) {
        ECommandService commandService = (ECommandService)context.get(ECommandService.class);
        Command command = commandService.getCommand(commandId);
        ParameterizedCommand parametrizedCommand = ParameterizedCommand.generateCommand((Command)command, parameters);
        EHandlerService eHandlerService = (EHandlerService)context.get(EHandlerService.class);
        return eHandlerService.executeHandler(parametrizedCommand);
    }

    public static void editDomainResource(IEclipseContext context, String domain, String classifier, String perspectiveId) {
        Iterable<?> input = DashboardUi.resolveInput(context, domain, classifier);
        String title = DashboardUi.resolveTitle(context, domain, classifier);
        Object selectedClassifier = LocWokbench.selectClassifier((IEclipseContext)context, (String)classifier, (String)title, input, null);
        if (selectedClassifier != null) {
            LocWokbench.switchPerspective((IEclipseContext)context, (String)perspectiveId);
            IEventBroker broker = (IEventBroker)context.get(IEventBroker.class);
            broker.post("ru/arsysop/passage/loc/workbench/show", selectedClassifier);
        }
    }

    private static Iterable<?> resolveInput(IEclipseContext context, String domain, String classifier) {
        EditingDomainRegistryAccess registryAccess = (EditingDomainRegistryAccess)context.get(EditingDomainRegistryAccess.class);
        SelectionCommandAdvisor advisor = registryAccess.getSelectionCommandAdvisor(domain);
        if (advisor != null) {
            return advisor.getSelectionInput(classifier);
        }
        return Collections.emptyList();
    }

    private static String resolveTitle(IEclipseContext context, String domain, String classifier) {
        EditingDomainRegistryAccess registryAccess = (EditingDomainRegistryAccess)context.get(EditingDomainRegistryAccess.class);
        SelectionCommandAdvisor advisor = registryAccess.getSelectionCommandAdvisor(domain);
        if (advisor != null) {
            return advisor.getSelectionTitle(classifier);
        }
        return null;
    }

    public static String resolvePerspectiveId(String domain) {
        if (domain == null) {
            return null;
        }
        switch (domain) {
            case "features": {
                return "org.eclipse.passage.loc.features.ui.perspective.main";
            }
            case "products": {
                return "org.eclipse.passage.loc.products.ui.perspective.main";
            }
            case "users": {
                return "org.eclipse.passage.loc.users.ui.perspective.main";
            }
            case "licenses": {
                return "org.eclipse.passage.loc.licenses.ui.perspective.main";
            }
        }
        return null;
    }

    public static void executeCreateCommand(IEclipseContext context, String domain) {
        HashMap<Object, Object> parameters = new HashMap<Object, Object>();
        parameters.put(COMMANDPARAMETER_CREATE_DOMAIN, domain);
        String perspectiveId = DashboardUi.resolvePerspectiveId(domain);
        if (perspectiveId != null) {
            parameters.put(COMMANDPARAMETER_CREATE_PERSPECTIVE, perspectiveId);
        }
        DashboardUi.executeCommand(context, COMMAND_CREATE, parameters);
    }

    public static void executeLoadCommand(IEclipseContext context, String domain) {
        HashMap<Object, Object> parameters = new HashMap<Object, Object>();
        parameters.put(COMMANDPARAMETER_LOAD_DOMAIN, domain);
        String perspectiveId = DashboardUi.resolvePerspectiveId(domain);
        if (perspectiveId != null) {
            parameters.put(COMMANDPARAMETER_LOAD_PERSPECTIVE, perspectiveId);
        }
        DashboardUi.executeCommand(context, COMMAND_LOAD, parameters);
    }

    public static void executeEditCommand(IEclipseContext context, String domain, String classifier) {
        HashMap<Object, Object> parameters = new HashMap<Object, Object>();
        parameters.put(COMMANDPARAMETER_EDIT_DOMAIN, domain);
        parameters.put(COMMANDPARAMETER_EDIT_CLASSIFIER, classifier);
        String perspectiveId = DashboardUi.resolvePerspectiveId(domain);
        if (perspectiveId != null) {
            parameters.put(COMMANDPARAMETER_EDIT_PERSPECTIVE, perspectiveId);
        }
        DashboardUi.executeCommand(context, COMMAND_EDIT, parameters);
    }
}

