/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.parser.impl;

import com.github.weisj.jsvg.parser.DomDocument;
import com.github.weisj.jsvg.parser.ElementLoader;
import com.github.weisj.jsvg.parser.impl.ExternalDocumentLoader;
import com.github.weisj.jsvg.parser.impl.ParserUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DefaultElementLoader
implements ElementLoader {
    private static final DocumentLoader DEFAULT_DOCUMENT_LOADER = new DefaultDocumentLoader();
    private final DocumentLoader documentLoader;

    DefaultElementLoader(AllowExternalResources allowExternalResources) {
        this.documentLoader = DefaultElementLoader.createDocumentLoader(allowExternalResources);
    }

    @NotNull
    private static DocumentLoader createDocumentLoader(AllowExternalResources allowExternalResources) {
        if (allowExternalResources == AllowExternalResources.DENY) {
            return DEFAULT_DOCUMENT_LOADER;
        }
        return new ExternalDocumentLoader();
    }

    @Override
    @Nullable
    public <T> T loadElement(@NotNull Class<T> type, @Nullable String value, @NotNull DomDocument document) {
        String url = ParserUtil.parseUrl(value);
        if (url == null) {
            return null;
        }
        if (url.contains("#")) {
            String[] parts = url.split("#", 2);
            DomDocument parsedDocument = this.documentLoader.resolveDocument(document, parts[0]);
            if (parsedDocument == null) {
                return null;
            }
            return parsedDocument.getElementById(type, parts[1]);
        }
        return document.getElementById(type, url);
    }

    static enum AllowExternalResources {
        DENY,
        ALLOW;

    }

    static interface DocumentLoader {
        @Nullable
        public DomDocument resolveDocument(@NotNull DomDocument var1, @NotNull String var2);
    }

    private static class DefaultDocumentLoader
    implements DocumentLoader {
        private DefaultDocumentLoader() {
        }

        @Override
        @Nullable
        public DomDocument resolveDocument(@NotNull DomDocument document, @NotNull String name) {
            if (name.isEmpty()) {
                return document;
            }
            return null;
        }
    }
}

