/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import java.util.List;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.dom.WidgetElement;
import org.eclipse.e4.ui.internal.workbench.swt.AbstractPartRenderer;
import org.eclipse.e4.ui.internal.workbench.swt.Policy;
import org.eclipse.e4.ui.internal.workbench.swt.WorkbenchSWTActivator;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.MUILabel;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.IResourceUtilities;
import org.eclipse.e4.ui.workbench.swt.util.ISWTResourceUtilities;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;

public abstract class SWTPartRenderer
extends AbstractPartRenderer {
    private static final String ADORN_ICON_IMAGE_KEY = "previouslyAdorned";
    private String pinURI = "platform:/plugin/org.eclipse.e4.ui.workbench.renderers.swt/icons/full/ovr16/pinned_ovr.png";
    private Image pinImage;
    private ISWTResourceUtilities resUtils;

    public void processContents(MElementContainer<MUIElement> container) {
        if (container == null) {
            return;
        }
        List parts = container.getChildren();
        if (parts != null) {
            IPresentationEngine renderer = (IPresentationEngine)this.context.get(IPresentationEngine.class);
            int i = 0;
            while (i < parts.size()) {
                MUIElement childME = (MUIElement)parts.get(i);
                renderer.createGui(childME);
                ++i;
            }
        }
    }

    public void styleElement(MUIElement element, boolean active) {
        if (!active) {
            element.getTags().remove("active");
        } else {
            element.getTags().add("active");
        }
        if (element.getWidget() != null) {
            this.setCSSInfo(element, element.getWidget());
        }
    }

    public void setCSSInfo(MUIElement me, Object widget) {
        Widget swtWidget;
        if (widget == null) {
            return;
        }
        if (widget instanceof Widget && (swtWidget = (Widget)widget).isDisposed()) {
            return;
        }
        IEclipseContext ctxt = this.getContext(me);
        if (ctxt == null) {
            return;
        }
        IStylingEngine engine = (IStylingEngine)ctxt.get(IStylingEngine.class);
        if (engine == null) {
            return;
        }
        EObject eObj = (EObject)me;
        StringBuilder builder = new StringBuilder("M" + eObj.eClass().getName());
        for (String tag : me.getTags()) {
            builder.append(' ').append(tag);
        }
        String id = me.getElementId();
        if (id != null) {
            id = id.replace('.', '-');
        }
        engine.setClassnameAndId(widget, builder.toString(), id);
    }

    protected void reapplyStyles(Widget widget) {
        CSSEngine engine = WidgetElement.getEngine((Widget)widget);
        if (engine != null) {
            engine.applyStyles((Object)widget, false);
        }
    }

    public void bindWidget(MUIElement me, Object widget) {
        if (widget instanceof Widget) {
            ((Widget)widget).setData("modelElement", (Object)me);
            this.setCSSInfo(me, widget);
            Widget swtWidget = (Widget)widget;
            swtWidget.addDisposeListener(e -> {
                Widget w = e.widget;
                if (w.isDisposed()) {
                    return;
                }
                MUIElement element = (MUIElement)w.getData("modelElement");
                if (element != null) {
                    SWTPartRenderer.unbindWidget(element);
                }
            });
        }
        me.setWidget(widget);
    }

    public static Object unbindWidget(MUIElement me) {
        Widget widget = (Widget)me.getWidget();
        if (widget != null) {
            me.setWidget(null);
            if (!widget.isDisposed()) {
                widget.setData("modelElement", null);
            }
        }
        me.setRenderer(null);
        return widget;
    }

    protected Widget getParentWidget(MUIElement element) {
        return (Widget)element.getParent().getWidget();
    }

    public void disposeWidget(MUIElement element) {
        block4: {
            Widget curWidget;
            this.disposeAdornedImage(element);
            if (element.getWidget() instanceof Widget && (curWidget = (Widget)element.getWidget()) != null && !curWidget.isDisposed()) {
                SWTPartRenderer.unbindWidget(element);
                try {
                    curWidget.dispose();
                }
                catch (Exception e) {
                    Logger logService = (Logger)this.context.get(Logger.class);
                    if (logService == null) break block4;
                    String msg = "Error disposing widget for : " + element.getClass().getName();
                    if (element instanceof MUILabel) {
                        msg = msg + " " + ((MUILabel)element).getLocalizedLabel();
                    }
                    logService.error((Throwable)e, msg);
                }
            }
        }
        element.setWidget(null);
    }

    public void hookControllerLogic(MUIElement me) {
        Object widget = me.getWidget();
        if (widget instanceof Control && me instanceof MUILabel) {
            ((Control)widget).getAccessible().addAccessibleListener(AccessibleListener.getNameAdapter(e -> {
                String string = e.result = ((MUILabel)me).getLocalizedLabel();
            }));
        }
    }

    public String getToolTip(MUILabel element) {
        String overrideTip = (String)((MUIElement)element).getTransientData().get("e4_override_title_tool_tip_key");
        return overrideTip == null ? element.getLocalizedTooltip() : overrideTip;
    }

    protected Image getImageFromURI(String iconURI) {
        if (iconURI == null || iconURI.length() == 0) {
            return null;
        }
        ImageRegistry registry = JFaceResources.getImageRegistry();
        Image image = registry.get(iconURI);
        if (image == null) {
            ImageDescriptor descriptor = (ImageDescriptor)this.resUtils.imageDescriptorFromURI(URI.createURI((String)iconURI));
            registry.put(iconURI, descriptor);
            image = registry.get(iconURI);
        }
        return image;
    }

    public Image getImage(MUILabel element) {
        Image image = (Image)((MUIElement)element).getTransientData().get("e4_override_icon_image_key");
        if (image == null || image.isDisposed()) {
            image = this.getImageFromURI(this.getIconURI(element));
        }
        if (image != null) {
            image = this.adornImage((MUIElement)element, image);
        }
        return image;
    }

    private String getIconURI(MUILabel element) {
        if (element instanceof MPart) {
            MPart part = (MPart)element;
            String iconURI = part.getIconURI();
            if (iconURI == null) {
                MPartDescriptor desc = this.modelService.getPartDescriptor(part.getElementId());
                iconURI = desc != null ? desc.getIconURI() : null;
            }
            return iconURI;
        }
        return element.getIconURI();
    }

    private Image adornImage(MUIElement element, Image image) {
        if (this.imageChanged()) {
            this.disposeAdornedImage(element);
        }
        if (element.getTags().contains("Pin Adornment")) {
            boolean exist;
            Image previousImage = (Image)element.getTransientData().get(ADORN_ICON_IMAGE_KEY);
            boolean bl = exist = previousImage != null && !previousImage.isDisposed();
            if (!exist) {
                Image adornedImage = this.resUtils.adornImage(image, this.pinImage);
                if (adornedImage != image) {
                    element.getTransientData().put(ADORN_ICON_IMAGE_KEY, adornedImage);
                }
                return adornedImage;
            }
            return previousImage;
        }
        return image;
    }

    protected int calcVisibleIndex(MUIElement element) {
        MElementContainer parent = element.getParent();
        int curIndex = 0;
        for (MUIElement child : parent.getChildren()) {
            if (child == element) {
                return curIndex;
            }
            if (child.getWidget() == null) continue;
            ++curIndex;
        }
        return -1;
    }

    protected int calcIndex(MUIElement element) {
        MElementContainer parent = element.getParent();
        return parent.getChildren().indexOf(element);
    }

    public void childRendered(MElementContainer<MUIElement> parentElement, MUIElement element) {
    }

    public void init(IEclipseContext context) {
        super.init(context);
        this.resUtils = (ISWTResourceUtilities)context.get(IResourceUtilities.class);
        this.pinImage = this.getImageFromURI(this.pinURI);
    }

    protected boolean requiresFocus(MPart element) {
        MUIElement focussed = SWTPartRenderer.getModelElement(Display.getDefault().getFocusControl());
        if (focussed == null) {
            return true;
        }
        do {
            if (focussed != element && focussed != element.getToolbar()) continue;
            return false;
        } while ((focussed = focussed.getParent()) != null);
        return true;
    }

    protected static MUIElement getModelElement(Control ctrl) {
        if (ctrl == null) {
            return null;
        }
        MUIElement element = (MUIElement)ctrl.getData("modelElement");
        if (element != null) {
            return element;
        }
        return SWTPartRenderer.getModelElement((Control)ctrl.getParent());
    }

    public void forceFocus(MUIElement element) {
        if (element.getWidget() instanceof Control) {
            Control ctrl = (Control)element.getWidget();
            if (!ctrl.isDisposed()) {
                if (Policy.DEBUG_FOCUS) {
                    WorkbenchSWTActivator.trace((String)"/trace/focus", (String)("Force focus for: " + String.valueOf(element)), null);
                }
                ctrl.forceFocus();
            } else if (Policy.DEBUG_FOCUS) {
                WorkbenchSWTActivator.trace((String)"/trace/focus", (String)("Trying to force focus for disposed control: " + String.valueOf(element)), (Throwable)new IllegalStateException());
            }
        } else if (Policy.DEBUG_FOCUS) {
            WorkbenchSWTActivator.trace((String)"/trace/focus", (String)("Trying to force focus for non-control element: " + String.valueOf(element)), (Throwable)new IllegalStateException());
        }
    }

    private void disposeAdornedImage(MUIElement element) {
        Image previouslyAdornedImage = (Image)element.getTransientData().get(ADORN_ICON_IMAGE_KEY);
        if (previouslyAdornedImage != null) {
            previouslyAdornedImage.dispose();
            previouslyAdornedImage = null;
        }
    }

    protected boolean imageChanged() {
        return false;
    }
}

