/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.contentassist;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtend.core.jvmmodel.IXtendJvmAssociations;
import org.eclipse.xtend.core.xtend.XtendClass;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtend.ide.codebuilder.MemberFromSuperImplementor;
import org.eclipse.xtend.ide.labeling.XtendImages;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.IImageHelper;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.ui.editor.contentassist.IProposalConflictHelper;
import org.eclipse.xtext.ui.editor.contentassist.PrefixMatcher;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.xbase.compiler.ISourceAppender;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedConstructor;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedExecutable;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedOperation;
import org.eclipse.xtext.xbase.typesystem.override.OverrideHelper;
import org.eclipse.xtext.xbase.typesystem.override.ResolvedConstructor;
import org.eclipse.xtext.xbase.typesystem.override.ResolvedFeatures;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.ContextualVisibilityHelper;
import org.eclipse.xtext.xbase.typesystem.util.IVisibilityHelper;
import org.eclipse.xtext.xbase.ui.contentassist.ImportOrganizingProposal;
import org.eclipse.xtext.xbase.ui.contentassist.ReplacingAppendable;
import org.eclipse.xtext.xbase.ui.document.DocumentSourceAppender;
import org.eclipse.xtext.xbase.ui.labeling.XbaseImageAdornments;

public class ImplementMemberFromSuperAssist {
    @Inject
    private IXtendJvmAssociations associations;
    @Inject
    private XtendImages images;
    @Inject
    private XbaseImageAdornments adornments;
    @Inject
    private MemberFromSuperImplementor implementor;
    @Inject
    private OverrideHelper overrideHelper;
    @Inject
    private IVisibilityHelper visibilityHelper;
    @Inject
    private ReplacingAppendable.Factory appendableFactory;
    @Inject
    private IImageHelper imageHelper;
    private static Pattern bodyExpressionPattern = Pattern.compile("\\{\\s*(.*?)\\s*$\\s*\\}", 40);

    protected List<IResolvedExecutable> getImplementationCandidates(XtendTypeDeclaration clazz) {
        JvmDeclaredType inferredType = this.associations.getInferredType(clazz);
        if (inferredType == null || !(inferredType instanceof JvmGenericType)) {
            return Collections.emptyList();
        }
        ResolvedFeatures resolvedFeatures = this.overrideHelper.getResolvedFeatures(inferredType);
        ArrayList result = Lists.newArrayList();
        ContextualVisibilityHelper contextualVisibilityHelper = new ContextualVisibilityHelper(this.visibilityHelper, resolvedFeatures.getType());
        this.addOperationCandidates(resolvedFeatures, (IVisibilityHelper)contextualVisibilityHelper, result);
        if (!clazz.isAnonymous()) {
            this.addConstructorCandidates(resolvedFeatures, (IVisibilityHelper)contextualVisibilityHelper, result);
        }
        return result;
    }

    protected void addOperationCandidates(ResolvedFeatures resolvedFeatures, IVisibilityHelper visibilityHelper, List<IResolvedExecutable> result) {
        List allOperations = resolvedFeatures.getAllOperations();
        LightweightTypeReference inferredType = resolvedFeatures.getType();
        for (IResolvedOperation operation : allOperations) {
            if (!this.isCandidate(inferredType, (IResolvedExecutable)operation, visibilityHelper)) continue;
            result.add((IResolvedExecutable)operation);
        }
    }

    protected void addConstructorCandidates(ResolvedFeatures resolvedFeatures, IVisibilityHelper visibilityHelper, List<IResolvedExecutable> result) {
        LightweightTypeReference typeReference = resolvedFeatures.getType();
        List superTypes = typeReference.getSuperTypes();
        for (LightweightTypeReference superType : superTypes) {
            if (superType.isInterfaceType()) continue;
            List declaredConstructors = resolvedFeatures.getDeclaredConstructors();
            HashSet erasedSignatures = Sets.newHashSet();
            for (IResolvedConstructor constructor : declaredConstructors) {
                erasedSignatures.add(constructor.getResolvedErasureSignature());
            }
            ResolvedFeatures superClass = this.overrideHelper.getResolvedFeatures(superType);
            List constructors = superClass.getDeclaredConstructors();
            for (IResolvedConstructor constructor : constructors) {
                ResolvedConstructor overriddenConstructor = new ResolvedConstructor(constructor.getDeclaration(), typeReference);
                if (!this.isCandidate(typeReference, (IResolvedExecutable)overriddenConstructor, visibilityHelper) || !erasedSignatures.add(constructor.getResolvedErasureSignature())) continue;
                result.add((IResolvedExecutable)overriddenConstructor);
            }
            return;
        }
    }

    protected boolean isCandidate(LightweightTypeReference type, IResolvedExecutable executable, IVisibilityHelper visibilityHelper) {
        if (type.getType() != executable.getDeclaration().getDeclaringType() && this.isVisible(executable, visibilityHelper)) {
            JvmExecutable rawExecutable = executable.getDeclaration();
            if (rawExecutable instanceof JvmOperation) {
                JvmOperation operation = (JvmOperation)rawExecutable;
                return !operation.isFinal() && !operation.isStatic();
            }
            return true;
        }
        return false;
    }

    protected boolean isVisible(IResolvedExecutable executable, IVisibilityHelper visibilityHelper) {
        return visibilityHelper.isVisible((JvmMember)executable.getDeclaration());
    }

    public void createOverrideProposals(XtendTypeDeclaration model, ContentAssistContext context, ICompletionProposalAcceptor acceptor, IProposalConflictHelper conflictHelper) {
        List<IResolvedExecutable> overrideables = this.getImplementationCandidates(model);
        for (IResolvedExecutable overrideable : overrideables) {
            ICompletionProposal completionProposal = this.createOverrideMethodProposal(model, overrideable, context, conflictHelper);
            if (completionProposal == null) continue;
            acceptor.accept(completionProposal);
        }
    }

    protected ICompletionProposal createOverrideMethodProposal(XtendTypeDeclaration model, IResolvedExecutable overrideable, final ContentAssistContext context, IProposalConflictHelper conflictHelper) {
        String simpleName;
        IXtextDocument document = context.getDocument();
        XtextResource resource = (XtextResource)model.eResource();
        int offset = context.getReplaceRegion().getOffset();
        int currentIndentation = this.appendableFactory.getIndentationLevelAtOffset(offset, (IDocument)document, resource);
        int indentationLevel = currentIndentation == 0 ? 1 : currentIndentation;
        ReplacingAppendable appendable = (ReplacingAppendable)this.appendableFactory.create(document, resource, offset, context.getReplaceRegion().getLength(), new DocumentSourceAppender.Factory.OptionalParameters(indentationLevel){
            {
                this.ensureEmptyLinesAround = true;
                this.baseIndentationLevel = n;
            }
        });
        JvmExecutable declaration = overrideable.getDeclaration();
        if (overrideable instanceof IResolvedOperation) {
            this.implementor.appendOverrideFunction(model, (IResolvedOperation)overrideable, (ISourceAppender)appendable);
            simpleName = overrideable.getDeclaration().getSimpleName();
        } else if (model instanceof XtendClass) {
            this.implementor.appendConstructorFromSuper((XtendClass)model, (IResolvedConstructor)overrideable, (ISourceAppender)appendable);
            simpleName = "new";
        } else {
            return null;
        }
        String code = appendable.getCode();
        if (!this.isValidProposal(code.trim(), context, conflictHelper) && !this.isValidProposal(simpleName, context, conflictHelper)) {
            return null;
        }
        ImageDescriptor imageDescriptor = this.images.forOperation(declaration.getVisibility(), this.adornments.getOverrideAdornment(declaration));
        ImportOrganizingProposal completionProposal = this.createCompletionProposal(appendable, context.getReplaceRegion(), this.getLabel(overrideable), this.imageHelper.getImage(imageDescriptor));
        Matcher matcher = bodyExpressionPattern.matcher(code);
        if (matcher.find()) {
            int bodyExpressionLength = matcher.end(1) - matcher.start(1);
            int bodyExpressionStart = matcher.start(1) + appendable.getTotalOffset() - completionProposal.getReplacementOffset();
            if (bodyExpressionLength == 0) {
                completionProposal.setCursorPosition(bodyExpressionStart);
            } else {
                completionProposal.setSelectionStart(completionProposal.getReplacementOffset() + bodyExpressionStart);
                completionProposal.setSelectionLength(bodyExpressionLength);
                completionProposal.setAutoInsertable(false);
                completionProposal.setCursorPosition(bodyExpressionStart + bodyExpressionLength);
                completionProposal.setSimpleLinkedMode(context.getViewer(), new char[]{'\t'});
            }
        }
        completionProposal.setPriority(this.getPriority(model, declaration, context));
        completionProposal.setMatcher(new PrefixMatcher(){

            public boolean isCandidateMatchingPrefix(String name, String prefix) {
                PrefixMatcher delegate = context.getMatcher();
                boolean result = delegate.isCandidateMatchingPrefix(simpleName, prefix);
                return result;
            }
        });
        return completionProposal;
    }

    protected boolean isValidProposal(String proposal, ContentAssistContext context, IProposalConflictHelper conflictHelper) {
        if (proposal == null) {
            return false;
        }
        if (!context.getMatcher().isCandidateMatchingPrefix(proposal, context.getPrefix())) {
            return false;
        }
        return !conflictHelper.existsConflict(proposal, context);
    }

    protected int getPriority(XtendTypeDeclaration model, JvmExecutable overridden, ContentAssistContext context) {
        return overridden instanceof JvmOperation && ((JvmOperation)overridden).isAbstract() ? 400 : 350;
    }

    protected ImportOrganizingProposal createCompletionProposal(ReplacingAppendable appendable, Region replaceRegion, StyledString displayString, Image image) {
        return new ImportOrganizingProposal(appendable, replaceRegion.getOffset(), replaceRegion.getLength(), replaceRegion.getOffset(), image, displayString);
    }

    protected StyledString getLabel(IResolvedExecutable executable) {
        if (executable instanceof IResolvedOperation) {
            IResolvedOperation resolvedOperation = (IResolvedOperation)executable;
            return new StyledString(resolvedOperation.getSimpleSignature()).append(" - Override method from " + resolvedOperation.getResolvedDeclarator().getHumanReadableName(), StyledString.QUALIFIER_STYLER);
        }
        return new StyledString("Add constructor 'new " + executable.getSimpleSignature() + "'");
    }
}

