/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.common.io.eclipse;

import org.eclipse.core.runtime.IPath;
import org.eclipse.m2m.internal.qvt.oml.common.io.CResource;
import org.eclipse.m2m.internal.qvt.oml.common.io.eclipse.BundleModuleRegistry;

public abstract class AbstractBundleResource
implements CResource {
    protected final IPath resourcePath;
    protected final BundleModuleRegistry resourceRegistry;

    protected AbstractBundleResource(IPath path, BundleModuleRegistry bundleRegistry) {
        if (path == null || path.isEmpty() || !path.isValidPath(path.toString())) {
            throw new IllegalArgumentException("Invalid bundle resource path: " + path);
        }
        this.resourcePath = path;
        this.resourceRegistry = bundleRegistry;
    }

    public String getBundleSymbolicName() {
        return this.resourceRegistry.getBundleSymbolicName();
    }

    protected IPath getPath() {
        return this.resourcePath;
    }

    public String getFullPath() {
        return this.resourcePath.toOSString();
    }

    public String getName() {
        String name = this.resourcePath.lastSegment();
        return name != null ? name : "";
    }

    public String toString() {
        return "platform:/plugin/" + this.resourceRegistry.getBundleSymbolicName() + "/" + this.resourcePath.toString();
    }

    public boolean equals(Object another) {
        if (another instanceof AbstractBundleResource) {
            AbstractBundleResource res = (AbstractBundleResource)another;
            return this.resourcePath.equals((Object)res.resourcePath) && this.resourceRegistry.getBundleSymbolicName().equals(res.resourceRegistry.getBundleSymbolicName());
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.resourcePath.hashCode();
        result = 37 * result + this.resourceRegistry.getBundleSymbolicName().hashCode();
        return result;
    }
}

