/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.common.ui.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;

class WorkspaceMetamodelsDelta {
    private Map<IPath, IPath> movesMap = new HashMap<IPath, IPath>();
    private List<IPath> deletions = new ArrayList<IPath>();
    private List<IPath> additions = new ArrayList<IPath>();
    private List<IPath> modifications = new ArrayList<IPath>();

    WorkspaceMetamodelsDelta() {
    }

    public boolean isEmpty() {
        return this.getAdditions().isEmpty() && this.getDeletions().isEmpty() && this.getModifications().isEmpty() && this.getMoves().isEmpty();
    }

    public List<IPath> getAdditions() {
        return this.additions != null ? Collections.unmodifiableList(this.additions) : Collections.emptyList();
    }

    public void addAddition(IPath path) {
        if (this.additions == null) {
            this.additions = new ArrayList<IPath>();
        }
        this.additions.add(path);
    }

    public List<IPath> getDeletions() {
        return this.deletions != null ? Collections.unmodifiableList(this.deletions) : Collections.emptyList();
    }

    public void addDeletion(IPath path) {
        if (this.deletions == null) {
            this.deletions = new ArrayList<IPath>();
        }
        this.deletions.add(path);
    }

    public List<IPath> getModifications() {
        return this.modifications != null ? Collections.unmodifiableList(this.modifications) : Collections.emptyList();
    }

    public void addModification(IPath path) {
        if (this.modifications == null) {
            this.modifications = new ArrayList<IPath>();
        }
        this.modifications.add(path);
    }

    public Map<IPath, IPath> getMoves() {
        return this.movesMap != null ? Collections.unmodifiableMap(this.movesMap) : Collections.emptyMap();
    }

    public void addMove(IPath source, IPath dest) {
        if (this.movesMap == null) {
            this.movesMap = new HashMap<IPath, IPath>();
        }
        this.movesMap.put(source, dest);
    }
}

