/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: EODMImplPackage.java,v 1.1 2007/03/18 08:10:11 lzhang Exp $
 */
package org.eclipse.eodm.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.eclipse.eodm.impl.EODMImplFactory
 * @model kind="package"
 * @generated
 */
public interface EODMImplPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "EODMImpl";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http:///odm 2006-04-03/org/omg/odm.ecore";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "odm 2006-04-03.org.omg.odm";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EODMImplPackage eINSTANCE = org.eclipse.eodm.impl.EODMImplPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.eodm.impl.InternalCoreImpl <em>Internal Core</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.eodm.impl.InternalCoreImpl
	 * @see org.eclipse.eodm.impl.EODMImplPackageImpl#getInternalCore()
	 * @generated
	 */
	int INTERNAL_CORE = 0;

	/**
	 * The feature id for the '<em><b>RDF Sis Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__RDF_SIS_DEFINED_BY = RDFBasePackage.BLANK_NODE__RDF_SIS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>RDF Ssee Also</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__RDF_SSEE_ALSO = RDFBasePackage.BLANK_NODE__RDF_SSEE_ALSO;

	/**
	 * The feature id for the '<em><b>RD Ftype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__RD_FTYPE = RDFBasePackage.BLANK_NODE__RD_FTYPE;

	/**
	 * The feature id for the '<em><b>RDF Smember</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__RDF_SMEMBER = RDFBasePackage.BLANK_NODE__RDF_SMEMBER;

	/**
	 * The feature id for the '<em><b>Node ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__NODE_ID = RDFBasePackage.BLANK_NODE__NODE_ID;

	/**
	 * The feature id for the '<em><b>RDF Scomment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__RDF_SCOMMENT = RDFBasePackage.BLANK_NODE__RDF_SCOMMENT;

	/**
	 * The feature id for the '<em><b>RDF Slabel</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__RDF_SLABEL = RDFBasePackage.BLANK_NODE__RDF_SLABEL;

	/**
	 * The feature id for the '<em><b>Uri Ref</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__URI_REF = RDFBasePackage.BLANK_NODE__URI_REF;

	/**
	 * The feature id for the '<em><b>Subject Statement</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__SUBJECT_STATEMENT = RDFBasePackage.BLANK_NODE__SUBJECT_STATEMENT;

	/**
	 * The feature id for the '<em><b>RDF Ssub Class Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__RDF_SSUB_CLASS_OF = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Sub Class</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__SUB_CLASS = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Property For Domain</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__PROPERTY_FOR_DOMAIN = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Property For Range</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__PROPERTY_FOR_RANGE = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Typed Resource</b></em>' reference list
	 * 
	 * @eodmext This is not ODM 2006-04-03 spec. It is added by EODM for convenient access
	 */
	int INTERNAL_CORE__TYPED_RESOURCE = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 4;
	
	/**
	 * The feature id for the '<em><b>Ontology</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__ONTOLOGY = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Is Deprecated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__IS_DEPRECATED = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Is Class Kind</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__IS_CLASS_KIND = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Has Restriction Kind</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__HAS_RESTRICTION_KIND = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Equivalent Class</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__OW_LEQUIVALENT_CLASS = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>OWL disjoint With</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__OW_LDISJOINT_WITH = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Complement Class</b></em>' reference list.
	 * It is the reverse of {@link #INTERNAL_CORE__OW_LCOMPLEMENT_OF}.
	 * 
	 * @eodmext This is not part of ODM 2006-04-03 specification. It is added by EODM for convenient access.
	 */
	int INTERNAL_CORE__COMPLEMENT_CLASS = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 11;
	
	/**
	 * The feature id for the '<em><b>Intersection Class</b></em>' reference list.
	 * It is the reverse of {@link #INTERNAL_CORE__OW_LINTERSECTION_OF}.
	 * 
	 * @eodmext This is not part of ODM 2006-04-03 specification. It is added by EODM for convenient access.
	 */
	int INTERNAL_CORE__INTERSECTION_CLASS = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 12;
	
	/**
	 * The feature id for the '<em><b>Union Class</b></em>' reference list.
	 * It is the reverse of {@link #INTERNAL_CORE__OW_LUNION_OF}.
	 * 
	 * @eodmext This is not part of ODM 2006-04-03 specification. It is added by EODM for convenient access.
	 */
	int INTERNAL_CORE__UNION_CLASS = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 13;
	
	/**
	 * The feature id for the '<em><b>Disjoint Class</b></em>' reference list.
	 * It is the reverse of {@link #INTERNAL_CORE__OW_LDISJOINT_WITH}.
	 * 
	 * @eodmext This is not part of ODM 2006-04-03 specification. It is added by EODM for convenient access.
	 */
	int INTERNAL_CORE__DISJOINT_CLASS = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 14;
	
	/**
	 * The feature id for the '<em><b>Complement Class</b></em>' reference list.
	 * It is the reverse of {@link #INTERNAL_CORE__EQUIVALENT_CLASS}.
	 * 
	 * @eodmext This is not part of ODM 2006-04-03 specification. It is added by EODM for convenient access.
	 */
	int INTERNAL_CORE__EQUIVALENT_CLASS = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 15;
	
	/**
	 * The feature id for the '<em><b>OW Lcomplement Of</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__OW_LCOMPLEMENT_OF = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>OW Ldistinct Members</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__OW_LDISTINCT_MEMBERS = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>OW Lon Property</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__OW_LON_PROPERTY = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>OW Lcardinality</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__OW_LCARDINALITY = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>OW Lmin Cardinality</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__OW_LMIN_CARDINALITY = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 20;
	
	/**
	 * The feature id for the '<em><b>Some Values From Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__SOME_VALUES_FROM_CLASS = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Some Values From Data Range</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__SOME_VALUES_FROM_DATA_RANGE = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>OW Ldifferent From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__OW_LDIFFERENT_FROM = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>OW Lsame As</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__OW_LSAME_AS = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>RD Ffirst</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__RD_FFIRST = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>RD Frest</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__RD_FREST = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>RDF Sdomain</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__RDF_SDOMAIN = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>RDF Srange</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__RDF_SRANGE = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>RDF Ssub Property Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__RDF_SSUB_PROPERTY_OF = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Sub Property</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__SUB_PROPERTY = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Is Property Deprecated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__IS_PROPERTY_DEPRECATED = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Is Functional</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__IS_FUNCTIONAL = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Is Object Property</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__IS_OBJECT_PROPERTY = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Is Datatype Property</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__IS_DATATYPE_PROPERTY = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>OW Lequivalent Property</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__OW_LEQUIVALENT_PROPERTY = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>OW Lbackward Compatible With</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__OW_LBACKWARD_COMPATIBLE_WITH = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>OW Limports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__OW_LIMPORTS = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>OW Lversion Info</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__OW_LVERSION_INFO = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>OW Lprior Version</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__OW_LPRIOR_VERSION = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>OW Lincompatible With</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__OW_LINCOMPATIBLE_WITH = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Owl RDFGraph</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__OWL_GRAPH = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Owl Statement</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__OWL_STATEMENT = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Owl Universe</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__OWL_UNIVERSE = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Graphstatement</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__GRAPHSTATEMENT = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>RDFGraph Name</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__GRAPH_NAME = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Graphontology</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__GRAPHONTOLOGY = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Owl RDFGraph Statement</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__OWL_GRAPH_STATEMENT = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Has Individual Value</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__HAS_INDIVIDUAL_VALUE = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Has Literal Value</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__HAS_LITERAL_VALUE = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>All Values From Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__ALL_VALUES_FROM_CLASS = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>All Values From Data Range</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__ALL_VALUES_FROM_DATA_RANGE = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>OW Lmax Cardinality</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__OW_LMAX_CARDINALITY = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>OW Lintersection Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__OW_LINTERSECTION_OF = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>OW Lone Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__OW_LONE_OF = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>OW Lunion Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__OW_LUNION_OF = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>OWL Data Rangeone Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__OWL_DATA_RANGEONE_OF = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Datatype</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__DATATYPE = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Document</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__DOCUMENT = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Is Reified Only</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__IS_REIFIED_ONLY = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Is Reified</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__IS_REIFIED = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 60;
	
	/**
	 * The feature id for the '<em><b>RD Fsubject</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__RD_FSUBJECT = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>RD Fobject</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__RD_FOBJECT = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>RD Fpredicate</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__RD_FPREDICATE = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Name For Reification</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__NAME_FOR_REIFICATION = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Is Inverse Functional</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__IS_INVERSE_FUNCTIONAL = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Is Symmetric</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__IS_SYMMETRIC = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>Is Transitive</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__IS_TRANSITIVE = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>OW Linverse Of</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__OW_LINVERSE_OF = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>Statement</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__STATEMENT = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Local Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__LOCAL_NAME = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Xml Base</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__XML_BASE = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 71;

	/**
	 * The feature id for the '<em><b>Namespace Definition</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE__NAMESPACE_DEFINITION = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 72;
	

	/**
	 * The number of structural features of the the '<em>Internal Core</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_CORE_FEATURE_COUNT = RDFBasePackage.BLANK_NODE_FEATURE_COUNT + 73;

	

	/**
	 * Returns the meta object for class '{@link org.eclipse.eodm.impl.InternalCore <em>Internal Core</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Internal Core</em>'.
	 * @see org.eclipse.eodm.impl.InternalCore
	 * @generated
	 */
	EClass getInternalCore();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	EODMImplFactory geteodm2Factory();

} //EODMImplPackage
