/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.stereo;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.actions.DiagramAction;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.AbstractEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.uml2.diagram.common.Messages;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;

public class ApplyProfileAction
extends DiagramAction {
    protected static final String EMPTY_NAME = Messages.ApplyProfileAction_empty_name;
    protected Package myPackage;
    private Profile myProfile;

    public ApplyProfileAction(IWorkbenchPage workbenchPage, Package package_, Profile profile) {
        super(workbenchPage);
        this.myPackage = package_;
        this.myProfile = profile;
    }

    protected Request createTargetRequest() {
        return null;
    }

    protected boolean isSelectionListener() {
        return true;
    }

    protected Command getCommand() {
        boolean toApply;
        DiagramEditPart packageEditPart = this.getDiagramEditPart();
        if (packageEditPart == null) {
            return UnexecutableCommand.INSTANCE;
        }
        TransactionalEditingDomain editingDomain = packageEditPart.getEditingDomain();
        AbstractEditCommandRequest request = new AbstractEditCommandRequest(editingDomain){

            public Object getEditHelperContext() {
                return null;
            }
        };
        boolean bl = toApply = !this.isProfileAppliedTo(this.myPackage, this.myProfile);
        if (toApply) {
            return new ICommandProxy((ICommand)this.getApplyProfileCommand((IEditCommandRequest)request));
        }
        return new ICommandProxy((ICommand)new UnapplyProfileCommand(Messages.ApplyProfileAction_unapply_profile_command, this.myPackage, this.myProfile, (IEditCommandRequest)request));
    }

    protected ApplyProfileCommand getApplyProfileCommand(IEditCommandRequest request) {
        return new ApplyProfileCommand(Messages.ApplyProfileAction_apply_profile_command, this.myPackage, this.myProfile, request);
    }

    public boolean isEnabled() {
        return this.getPackageEditPart() != null;
    }

    public void refresh() {
        super.refresh();
        this.setText(this.calculateText());
        this.setChecked(this.calculateChecked());
    }

    protected String calculateText() {
        String name = this.myProfile.getName();
        return name != null ? name : EMPTY_NAME;
    }

    protected boolean calculateChecked() {
        return this.isProfileAppliedTo(this.myPackage, this.myProfile);
    }

    private DiagramEditPart getPackageEditPart() {
        for (Object next : this.getSelectedObjects()) {
            if (!(next instanceof DiagramEditPart)) continue;
            DiagramEditPart packageEditPart = (DiagramEditPart)next;
            return packageEditPart;
        }
        return null;
    }

    private boolean isProfileAppliedTo(Package package_, Profile profile) {
        ProfileApplication profileApplication = package_.getProfileApplication(profile);
        return profileApplication != null && profileApplication.getAppliedDefinition() == profile.getDefinition();
    }

    protected class ApplyProfileCommand
    extends EditElementCommand {
        Package myPackage;
        private Profile myProfile;

        protected ApplyProfileCommand(String label, Package package_, Profile profile, IEditCommandRequest request) {
            super(label, (EObject)package_, request);
            this.myPackage = package_;
            this.myProfile = profile;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.myPackage.applyProfile(this.myProfile);
            return CommandResult.newOKCommandResult((Object)this.myProfile);
        }
    }

    private class UnapplyProfileCommand
    extends EditElementCommand {
        Package myPackage;
        private Profile myProfile;

        protected UnapplyProfileCommand(String label, Package package_, Profile profile, IEditCommandRequest request) {
            super(label, (EObject)package_, request);
            this.myPackage = package_;
            this.myProfile = profile;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.myPackage.unapplyProfile(this.myProfile);
            return CommandResult.newOKCommandResult((Object)this.myProfile);
        }
    }
}

