/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.internal.operations;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageKind;
import org.eclipse.uml2.uml.MessageSort;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.UMLPlugin;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.internal.operations.NamedElementOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageOperations
extends NamedElementOperations {
    protected MessageOperations() {
    }

    public static boolean validateSendingReceivingMessageEvent(Message message, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public static boolean validateSignatureReferTo(Message message, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public static boolean validateSignatureIsOperation(Message message, DiagnosticChain diagnostics, Map<Object, Object> context) {
        EList<ValueSpecification> arguments;
        boolean result = true;
        NamedElement signature = message.getSignature();
        if (signature instanceof Operation && !(arguments = message.getArguments()).isEmpty()) {
            UniqueEList.FastCompare parameters = new UniqueEList.FastCompare(((Operation)signature).getOwnedParameters());
            if (message.getMessageSort() == MessageSort.REPLY_LITERAL) {
                Iterator p = parameters.iterator();
                while (p.hasNext()) {
                    if (((Parameter)p.next()).getDirection() != ParameterDirectionKind.IN_LITERAL) continue;
                    p.remove();
                }
            }
            if (arguments.size() != parameters.size()) {
                result = false;
            } else {
                Iterator a = arguments.iterator();
                Iterator p = parameters.iterator();
                while (a.hasNext() && p.hasNext()) {
                    Type argumentType = ((ValueSpecification)a.next()).getType();
                    Type parameterType = ((Parameter)p.next()).getType();
                    if (!(argumentType == null ? parameterType != null : !argumentType.conformsTo(parameterType))) continue;
                    result = false;
                    break;
                }
            }
        }
        if (!result && diagnostics != null) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 205, UMLPlugin.INSTANCE.getString("_UI_Message_SignatureIsOperation_diagnostic", MessageOperations.getMessageSubstitutions(context, (Object)message)), new Object[]{message}));
        }
        return result;
    }

    public static boolean validateSignatureIsSignal(Message message, DiagnosticChain diagnostics, Map<Object, Object> context) {
        EList<ValueSpecification> arguments;
        boolean result = true;
        NamedElement signature = message.getSignature();
        if (signature instanceof Signal && !(arguments = message.getArguments()).isEmpty()) {
            EList<Property> attributes = ((Signal)signature).getAttributes();
            if (arguments.size() != attributes.size()) {
                result = false;
            } else {
                Iterator ma = arguments.iterator();
                Iterator sa = attributes.iterator();
                while (ma.hasNext() && sa.hasNext()) {
                    Type argumentType = ((ValueSpecification)ma.next()).getType();
                    Type attributeType = ((Property)sa.next()).getType();
                    if (!(argumentType == null ? attributeType != null : !argumentType.conformsTo(attributeType))) continue;
                    result = false;
                    break;
                }
            }
        }
        if (!result && diagnostics != null) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 204, UMLPlugin.INSTANCE.getString("_UI_Message_SignatureIsSignal_diagnostic", MessageOperations.getMessageSubstitutions(context, (Object)message)), new Object[]{message}));
        }
        return result;
    }

    public static boolean validateArguments(Message message, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public static boolean validateCannotCrossBoundaries(Message message, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public static boolean validateOccurrenceSpecifications(Message message, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public static MessageKind getMessageKind(Message message) {
        return message.eGet((EStructuralFeature)UMLPackage.Literals.MESSAGE__SEND_EVENT, false) == null ? (message.eGet((EStructuralFeature)UMLPackage.Literals.MESSAGE__RECEIVE_EVENT, false) == null ? MessageKind.UNKNOWN_LITERAL : MessageKind.FOUND_LITERAL) : (message.eGet((EStructuralFeature)UMLPackage.Literals.MESSAGE__RECEIVE_EVENT, false) == null ? MessageKind.LOST_LITERAL : MessageKind.COMPLETE_LITERAL);
    }
}

